package ctscore.web.vo;


import activities.dto.modeldto.ActivityGoodsDto;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;

public class ActivityProductDetailsVo implements Serializable {

    /*----------------------FIELD----------------------*/

    //倒计时初始时间
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date initTime;

    //活动是否开始
    private Boolean begin = false;

    //活动是否结束
    private Boolean end = false;

    //活动开始时间
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date beginTime;

    //活动结束时间
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endTime;

    //活动商品是否检查单品每人限购
    private Boolean checkGoodsLimited = false;

    //活动商品单品每人限购数量
    private Integer goodsLimitedCount = 1;

    //活动商品是否检查配置库存状态
    private Boolean checkStockLimited = false;

    //活动商品配置库存状态 无库存 true 有库存：false
    private Boolean stockLimited = false;

    //是否检查场次限购
    private Boolean checkActivityLimited = false;

    //活动场次限购状态 超限：true 未超限：false
    private Boolean activityLimited = false;

    /*----------------------CONSTRUCTOR----------------------*/

    public ActivityProductDetailsVo() {}

    public ActivityProductDetailsVo(ActivityGoodsDto activityGoods) {
        this.beginTime = activityGoods.getActivityDefinition().getBeginTime();
        this.endTime = activityGoods.getActivityDefinition().getEndTime();
        Date now = new Date();
        this.initTime = beginTime;
        if (now.after(endTime)) {
            begin = true;
            end = true;
        } else if (now.after(beginTime)) {
            begin = true;
            initTime = endTime;
        }
    }

    /*----------------------GETTER & SETTER----------------------*/

    public Date getInitTime() {
        return initTime;
    }

    public void setInitTime(Date initTime) {
        this.initTime = initTime;
    }

    public Boolean getBegin() {
        return begin;
    }

    public void setBegin(Boolean begin) {
        this.begin = begin;
    }

    public Boolean getEnd() {
        return end;
    }

    public void setEnd(Boolean end) {
        this.end = end;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Boolean getCheckGoodsLimited() {
        return checkGoodsLimited;
    }

    public void setCheckGoodsLimited(Boolean checkGoodsLimited) {
        this.checkGoodsLimited = checkGoodsLimited;
    }

    public Integer getGoodsLimitedCount() {
        return goodsLimitedCount;
    }

    public void setGoodsLimitedCount(Integer goodsLimitedCount) {
        this.goodsLimitedCount = goodsLimitedCount;
    }

    public Boolean getCheckStockLimited() {
        return checkStockLimited;
    }

    public void setCheckStockLimited(Boolean checkStockLimited) {
        this.checkStockLimited = checkStockLimited;
    }

    public Boolean getStockLimited() {
        return stockLimited;
    }

    public void setStockLimited(Boolean stockLimited) {
        this.stockLimited = stockLimited;
    }

    public Boolean getCheckActivityLimited() {
        return checkActivityLimited;
    }

    public void setCheckActivityLimited(Boolean checkActivityLimited) {
        this.checkActivityLimited = checkActivityLimited;
    }

    public Boolean getActivityLimited() {
        return activityLimited;
    }

    public void setActivityLimited(Boolean activityLimited) {
        this.activityLimited = activityLimited;
    }
}
