<!DOCTYPE html>
<html lang="en">
<head>
    <#include "/include/meta.ftl">
    <#include "/include/head.ftl">
    <#include "/include/ie8fix.ftl">
    <!-- 样式 -->
    <link rel="stylesheet" href="${p_static}${_v('/cart/public/css/global.css" type="text/css')}"/>
    <link rel="stylesheet" href="${p_static}${_v('/cart/cart/css/shopCar.css" type="text/css')}"/>
    <title>购物车</title>
</head>
<body>
<#include "/include/header.ftl">

<div class="pageWidth scrollTopH">
    <div class="shoppingTit clearfix">
        <div class="pull-left">
            <span class="icon iconfont"> &#xe60b;</span>
            <span >购物车</span>
            <span class="shopNum">全部商品：</span>
            <span id="sum-goods-count" sumNum = "${(sumGoodsCount!0)}">${(sumGoodsCount!0)?string(",##0")}</span>
        </div>
        <div class="pull-right"  >
            <span class="select-area-title">配送至：</span>
            <input class="area-select-plugin" id="areaCode" type="hidden" name="areaCode"
                   data-def-area="<#if provoiceId??>${provoiceId}<#if cityId??>,${cityId}<#if areaId??>,${areaId}<#if townId??>,${townId}</#if></#if></#if></#if>" value="${townId!areaId!cityId!provoiceId!}" />
        </div>
    </div>
    <#--购物车为空-->
    <#if (sumGoodsCount!0)==0>
        <div class="nullCart pageWidth">
            <div class="nullCartCon clearfix">
                <div class="null-cart-img fl">
                    <img src="${p_static}${_v('/cart/cart/images/nullCart.png')}">
                </div>
                <div class="null-cart-con fr">
                    <p>您的购物车空空如也，赶紧去挑选吧~</p>
                    <div class="cart-con-btn">
                        <a href="/score" class="add-product">去购物</a>
                        <a href="/score/order/myOrder.html" class="check-odder">查看订单</a>
                    </div>
                </div>
            </div>
        </div>
    </#if>
   <#--购物车为空 end-->
    <#--购物车不为空-->
<#if (sumGoodsCount!0)!=0>
    <!-- 购物车为空提示 -->
    <div class="nullCart pageWidth f-hide" id="cartEmptyView">
        <div class="nullCartCon clearfix">
            <div class="null-cart-img fl">
                <img src="${p_static}${_v('/cart/cart/images/nullCart.png')}">
            </div>
            <div class="null-cart-con fr">
                <p>您的购物车空空如也，赶紧去挑选吧~</p>
                <div class="cart-con-btn">
                    <a href="/score" class="add-product">去购物</a>
                    <a href="/score/order/myOrder.html" class="check-odder">查看订单</a>
                </div>
            </div>
        </div>
    </div>
    <div class="row modelList modelTitle modelTitlePadding cart-show-view-modals">
        <div class="col-xs-2 modelItem text-left">
              <span class="newCheckbox totalAllChoose">
                  <#--<input type="checkbox" <#if validCounts gt 0>checked="checked"</#if> />-->
                  <input type="checkbox" />
                  <label class="glyphicon glyphicon-ok"></label>
              </span>
            <span>全部</span>
        </div>
        <div class="col-xs-4 modelItem text-left" >
            <span>商品</span>
        </div>
        <div class="col-xs-1 modelItem">
            <#--<span>单价（元）</span>-->
            <span>单价</span>
        </div>
        <div class="col-xs-2 modelItem">
            <span>数量</span>
        </div>
        <div class="col-xs-2 modelItem">
            <#--<span>小计（元）</span>-->
            <span>小计</span>
        </div>
        <div class="col-xs-1 modelItem" style="text-align: left">
            <span>操作</span>
        </div>
    </div>
<#if cartItemGroups??>
    <#list cartItemGroups as group>
        <#if group.store??>
            <#if group.store.storeExt??>
                <#if group.displayCounts gt 0>
                    <div class="orderStore cart-show-view-modals" data-group-id="${group.storeId!group.store.id!}">
                            <#--
                                积分商城暂无店铺概念
                              <div class="row modelList">
                                <div class="col-xs-2 modelItem text-left">
                                    <span class="newCheckbox allChoose">
                                      <input type="checkbox" class="group-select-cb" <#if group.validCounts gt 0> checked="checked"</#if>/>
                                      <label class="glyphicon glyphicon-ok"></label>
                                    </span>
                                    <span class="shopName">${group.groupName!group.store.storeExt.storeName!}</span>
                                </div>
                                <div class="col-xs-4 modelItem text-left">

                                </div>
                                <div class="col-xs-1 modelItem">

                                </div>
                                <div class="col-xs-2 modelItem">
                                </div>
                                <div class="col-xs-1 modelItem">
                                    <span class="totalMoney">${(group.sumPrice!0)?string(',##0.00')}</span>
                                </div>
                                <div class="col-xs-2 modelItem">
                                </div>
                            </div>-->
                        <div class="orderList">
                            <#if group.cartItems??>
                                <#list group.cartItems as cartItem>
                                    <#if cartItem??>
                                        <#if !cartItem.isDelete?exists || cartItem.isDelete != true>
                                            <#if cartItem.productFashion??>
                                                <div class="row modelList <#if cartItem.status == '2'>invalidList</#if>" data-cart-item-id="${cartItem.id}">
                                                    <div class="col-xs-2 modelItem text-left">
                                                        <span class="newCheckbox " style="<#if cartItem.status == '2'>display:none;</#if>">
                                                            <input type="checkbox" class="cart-item-cb" <#if cartItem.status == '0'>checked="checked"<#elseif cartItem.status == '2'>disabled="disabled"</#if> value="${cartItem.id}"/>
                                                            <label class="glyphicon glyphicon-ok"></label>
                                                        </span>
                                                        <a class="shopImg" href="/score/goodsdetails/list?productId=${cartItem.productId!}&goodsId=${cartItem.goodsId!}" <#if cartItem.status == '2'>style="margin-left: 39px" </#if>>
                                                            <img src="${cartItem.productFashion.fashionPic!"/imgNotFound.gif"}" width="88" height="88" border="0">
                                                        </a>
                                                    </div>
                                                    <div class="col-xs-4 modelItem text-left" >
                                                        <#if cartItem.product??>
                                                            <div class="modelItemCon row">
                                                                <span class="col-xs-8">
                                                                    <a class="goodsType showName" href="/score/goodsdetails/list?productId=${cartItem.productId!}&goodsId=${cartItem.goodsId!}">
                                                                    ${(cartItem.productFashion.fashionTitle!)?if_exists?html}</a>
                                                                </span>
                                                                <#if specificationsMap ??>
                                                                    <#if specificationsMap[cartItem.goodsId] ??>
                                                                        <div class="productFashionSpecifications">
                                                                            <#list specificationsMap[cartItem.goodsId] as specification>
                                                                                <span class="productFashionSpecification" title="${specification.name!}：${specification.value!}">${specification.name!}：${specification.value!}</span>
                                                                            </#list>
                                                                        </div>
                                                                    </#if>
                                                                </#if>
                                                            </div>
                                                        </#if>
                                                    </div>
                                                    <div class="col-xs-1 modelItem">
                                                        <div class="modelItemCon">
                                                            <#if cartItem.productFashion??>
                                                                <#--<#if cartItem.productFashion.marketPrice?? &&  cartItem.productFashion.salePrice??>-->
                                                                <#if cartItem.productFashion.salePrice??>
                                                                    <#--<#if cartItem.productFashion.marketPrice <= cartItem.productFashion.salePrice>-->
                                                                        <#--<p>￥${(((cartItem.productFashion.salePrice!0))?ceiling)?string(',##0.00')}</p>-->
                                                                    <#--<#else>-->
                                                                        <#--<p class="originalPrice">${(cartItem.productFashion.marketPrice!0)?string(',##0.00')}</p>-->
                                                                        <#--<p class="originalPrice">${(((cartItem.productFashion.marketPrice!0))?ceiling)?string(',##0Ct')}</p>-->
                                                                        <#--<p>${(cartItem.productFashion.salePrice!0)?string('0.00')}</p>-->
                                                                        <p>￥${(((cartItem.productFashion.salePrice!)))?string(',##0.00')}</p>
                                                                    <#--</#if>-->
                                                                </#if>
                                                            </#if>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-2 modelItem">
                                                        <div class="modelItemCon">
                                                            <p>
                                                                <span class="numChoose">
                                                                    <span class="numReduce">-</span>
                                                                    <#--<span class="numShow">${cartItem.count!0}</span>-->
                                                                    <#--<span class="numShow "></span>-->
                                                                    <input type="input" name="" value="${cartItem.count!0}"
                                                                           oninput="if(parseInt(this.value)==0||isNaN(parseInt(this.value))){this.value=this.value.replace(/[^1-9]/g,1)}"
                                                                        <#if cartItem.status == '2'>disabled="disabled" readonly="readonly"</#if>
                                                                           class="numShow numEdit" />
                                                                    <span class="numAdd">+</span>
                                                                    <input type="hidden" name="counts" value="${cartItem.count!0}" class="cart-item-counts" />
                                                                </span>
                                                            </p>

                                                            <#if cartItem.productFashion??>
                                                                <#if cartItem.productFashion.stockCount??>
                                                                <#--test-> cartItem.productFashion.stockCount:${cartItem.productFashion.stockCount!0}, cartItem.count: ${cartItem.count}, cartItem.status: ${cartItem.status}-->
                                                                    <#if cartItem.productFashion.stockCount! lte 0 || cartItem.productFashion.stockCount! lt cartItem.count || cartItem.status  != '0'>
                                                                        <p class="textWarning lack-flag">无货</p>
                                                                    <#elseif (cartItem?if_exists.productFashion?if_exists.lackRemind!0) gt 0>
                                                                        <#if (cartItem?if_exists.productFashion?if_exists.stockCount!0) - (cartItem?if_exists.count!0) gt cartItem.productFashion.lackRemind>
                                                                            <p class="lack-flag">有货</p>
                                                                        <#else>
                                                                            <p class="textWarning lack-flag">库存紧张</p>
                                                                        </#if>
                                                                    <#else>
                                                                        <p class="lack-flag">有货</p>
                                                                    </#if>
                                                                </#if>
                                                            </#if>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-2 modelItem">
                                                        <div class="modelItemCon">
                                                            <#if cartItem.productFashion??>
                                                                <#if cartItem.productFashion.salePrice??>
                                                                    <#--<span class="totalMoneyItem">${(cartItem.count * cartItem.productFashion.salePrice!)?string(',##0.00')}</span>-->
                                                                    <span class="totalMoneyItem">
                                                                        <#--￥${(cartItem.count * (((cartItem.productFashion.salePrice!0))?ceiling))?string(',##0.00')}-->
                                                                        <#--${(cartItem.count * cartItem.productFashion.salePrice!0)?string(',##0.00')}-->
                                                                    </span>
                                                                </#if>
                                                            </#if>
                                                            <p></p>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-1 modelItem">
                                                        <div class="modelItemCon goodsOperation">
                                                            <p class="text-left"><a class="delItem" rel="${cartItem.id}">删除</a></p>
                                                            <p class="text-left"><a class="removeItem removeOneItem" rel="${cartItem.id}">移入收藏夹</a></p>
                                                        </div>
                                                    </div>
                                                    <#if cartItem.status == '2'>
                                                        <span class="invalidTips">
                                                        失效
                                                    </span>
                                                    </#if>

                                                </div>
                                            </#if>
                                        </#if>
                                    </#if>
                                </#list>
                            </#if>
                        </div>
                    </div>
                </#if>
            </#if>
        </#if>
    </#list>
</#if>

    <!--合计-->
    <div class="row modelList  cart-show-view-modals">
        <div class="col-xs-2 modelItem text-left">
              <span class="newCheckbox totalAllChoose">
                  <#--<input type="checkbox" <#if validCounts gt 0>checked="checked"</#if> />-->
                  <input type="checkbox" />
                  <label class="glyphicon glyphicon-ok"></label>
              </span>
            <span>全部</span>
            <span class="deletBtn">删除</span>
        </div>
        <div class="col-xs-2 modelItem text-left" >
            <span class="removeItem removeBatchItem">加入我的收藏夹</span>
        </div>
        <div class="col-xs-2 modelItem text-left">
            <span class="clearGoods">清除下架商品   </span>
        </div>
    </div>

    <div class="accountsBox pageWidth  cart-show-view-modals">
        <div class="row modelList">
            <div class="col-xs-12 modelItem text-right">
                <span class="productNum">商品件数<span class="color01" id="sum-cart-item-counts">${sumCartItemCounts!0}</span>件 </span>
                <#--<span class="productScore">消费积分：<i class="color01" id="sum-itaiping">${sumScore!0}</i><i>Ct</i></span>-->
                <#--<span class="productScore">应付金额：<i class="color01" id="sum-cart-price">${(sumCartPrice!0.00)?string(',##0.00')}</i><i>元</i></span>-->
                <#--<span class="productScore">应付金额：<i class="color01" id="sum-cart-price">${((sumCartPrice!0.00) * 100)?string(',##0')}</i><i>Ct</i></span>-->
                <span class="productScore">应付金额：<i class="color01" id="sum-cart-price"><#--<i>￥</i>${(((sumCartPrice!0.00) )?ceiling)?string(',##0.00')}--></i></span>

            </div>
            <#--<div class="col-xs-12 modelItem moneyList text-right">-->
                <#--<span class="productScore" style="display: none;">应付金额：<span class="color01"></span><span class="color01" id="sum-cart-price">${(sumCartPrice!0.00)?string(',##0.00')}</span>元</span>-->
                <#--<span class="productScore" style="display: none;">应付金额：<span class="color01"></span><span class="color01" id="sum-cart-price">${(((sumCartPrice!0.00) )?ceiling)?string(',##0')}</span>Ct</span>-->
            <#--没有节省金额这个概念-->
                 <#--<p class="text-right" style="display: none">节省：<span class="color01">￥</span><span class="color01" id="sum-cart-price-save">${((sumMarketCartPrice!0.00) - (sumCartPrice!0.00))?string(',##0.00')}</span></p>-->
            <#--</div>-->
            <div class="col-xs-12 modelItem text-right">
         <#--       <span style="display: none;">

                    <i>还需支付</i>
                    <i class="payMoneyNum" id="sum-cart-needPay">${(needPayPrice!0.00)?string(',##0.00')}</i>
                    <i>元</i>
                </span>-->
                <#--<a class="accountsBtn" id="go-order-comfirm">去 结 算</a>-->
                <a class="accountsBtn" id="go-order-comfirm">提交订单</a>
            </div>
        </div>
    </div>
</#if>
    <#--购物车不为空 end-->
</div>
<!--删除弹窗-->
<div class="coverLayer delLayer deletLayer">
    <div class="coverCon">
        <header>
            删除提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon iconfont">&#xe660;</span></span>
                <div class="col-xs-9">
                    <span class="insuredInfo">删除商品？</span>
                    <p class="insuredTips">您可以删除商品或者移到收藏夹</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn01 doCartItemDel">删除</span>
            <span class="btn02 doCartItemMove">移到我的收藏</span>
        </div>
        <span class="msg msg-info" style="display:none;">删除成功</span>
        <span class="msg msg-error" style="display:none;">删除失败，请稍后再试！</span>
    </div>
</div>
<#--删除多个-->
<div class="coverLayer delLayer deletAllLayer">
    <div class="coverCon">
        <header>
            删除提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon">&#xe611;</span></span>
                <div class="col-xs-9">
                    <span class="insuredInfo">删除商品？</span>
                    <p class="insuredTips">您可以删除商品或者移到收藏夹</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn01 doCartItemDel">删除</span>
            <span class="btn02 doCartItemMove" >移到我的收藏</span>
        </div>
        <span class="msg msg-info" style="display:none;">删除成功</span>
        <span class="msg msg-error" style="display:none;">删除失败，请稍后再试！</span>
    </div>
</div>

<!--移入收藏夹-->
<div class="coverLayer delLayer removeLayer">
    <div class="coverCon">
        <header>
            收藏提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon iconfont">&#xe660;</span></span>
                <div class="col-xs-9">
                    <span class="insuredInfo">移到收藏</span>
                    <p class="insuredTips">移动后选中商品将不在购物车列表中显示。</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02 doMoveToFav">确定</span>
            <span class="btn01" rel="close">取消</span>
        </div>
        <span class="msg msg-info" style="display:none;">移入收藏夹成功</span>
        <span class="msg msg-error" style="display:none;">处理失败，请稍后再试！</span>
    </div>
</div>

<!--下架提示-->
<div class="coverLayer delLayer invalidLayer" id="stockInvalidLayer">
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox orders-gap"> <span class="iconfont icon tipsIcon">&#xe60f;</span></span>
                <div class="col-xs-9 orders-gap">
                    <span class="insuredTips">下手慢了，有商品被抢空了</span>
                    <p class="insuredTips">请确认您的购物清单！</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02" rel="close">确定</span>

        </div>
    </div>
</div>
<!--购物车只包含无效商品-->
<div class="coverLayer delLayer" id="allInvalidLayer" >
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <#--<span class="col-xs-4 text-right tipsIconBox"> <span class="iconfont icon tipsIcon">&#xe611;</span></span>-->
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon iconfont">&#xe660;</span></span>
                <div class="col-xs-9">
                    <p class="insuredTips">
                        <span class="one-line-tip">您购物车中的商品已失效...请返回选购其它商品</span>
                    </p>

                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02" rel="close">确定</span>

        </div>
    </div>
</div>
<!--至少选一种商品-->
<div class="coverLayer delLayer leastLayer" >
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <#--<span class="col-xs-4 text-right tipsIconBox"> <span class="iconfont icon tipsIcon">&#xe611;</span></span>-->
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon iconfont">&#xe660;</span></span>
                <div class="col-xs-9">
                    <p class="insuredTips">请至少选择一件商品！</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02" rel="close">确定</span>

        </div>
    </div>
</div>
<!--提示信息-->
<div class="coverLayer delLayer alertLayer" >
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <#--<span class="col-xs-4 text-right tipsIconBox"> <span class="iconfont icon tipsIcon">&#xe611;</span></span>-->
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon iconfont">&#xe660;</span></span>
                <div class="col-xs-9">
                    <p class="insuredTips"></p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02" rel="close">确定</span>
        </div>
    </div>
</div>
<#include "/include/footer.ftl">
<#include "/include/rightNav.ftl">
<#--<footer>-->
    <#--<!--# include file="/caigou/footer" &ndash;&gt;-->
<#--</footer>-->
<#include "../include/resource.ftl">
<script type="text/javascript" src="${p_static}${_v('/cart/cart/js/commonSearch1.js')}"></script>
<script type="text/javascript" src="${p_static}${_v('/plugins/jQuery/validation/jquery.validate.js')}"></script>
<script type="text/javascript" src="${p_static}${_v('/plugins/artTemplate/template.js')}"></script>
<script type="text/javascript" src="${p_static}${_v('/plugins/fastJson/FastJson-1.0.min.js')}"></script>
<script type="text/javascript" src="${p_static}${_v('/plugins/accounting/accounting.js')}"></script>
<script type="text/javascript" src="${p_static}${_v('/cart/cart/js/shopCar.js')}"></script>
<#--使ie8支持CSS3伪类和属性选择器-->
<script type="text/javascript" src="${p_static}${_v('/cart/cart/js/selectivizr-min.js')}"></script>
</body>
</html>