<!DOCTYPE html>
<html lang="en">
<head>
    <#include "/include/meta.ftl">
    <#include "/include/head.ftl">
    <#include "/include/ie8fix.ftl">

    <link rel="stylesheet" href="${p_static}${_v('/public/css/global.css" type="text/css')}"/>
    <link href="${p_static}${_v('/orderPublicity/css/orderPublicity.css')}" rel="stylesheet" type="text/css"/>
        <script type="text/javascript" src="${c_static}${_v('/plugins/My97DatePicker/WdatePicker.js')}"></script>
    <style>
        .productInfoList > div {
            height: 60px;
            line-height: 20px;
            padding: 0;
        }
    </style>
</head>

<body>
<#include "/include/header.ftl">
<#--<header>-->
    <#--<!--# include file="/caigou/top" &ndash;&gt;-->
<#--</header>-->
<div class="pageWidth">
    <ul class="breadcrumb navItem">
        <li>
            <a>首页</a> <span class="divider">&gt;</span>
        </li>
        <li>
            <a>订单公示</a> <span class="divider">&gt;</span>
        </li>
        <li><a>公示详情</a></li>
    </ul>
    <div class="bannerBg"><img src="${p_static}${_v('/image/banner.png')}">
    </div>
    <p class="caption detailsTitle"> 公示详情</p>
    <div class="detailsContent">
        <p class="tableTitle">订单信息</p>
        <table class="infoTable">
            <tr>
                <th>订单号</th>
                <td>${orderMain.id!}</td>
                <th>下单时间</th>
                <td>${orderMain.createTime?string("yyyy-MM-dd HH:mm:ss")!}</td>
            </tr>
            <tr>
                <th>下单人</th>
                <td>${memberName}</td>
                <th>组织机构</th>
                <td>${realCompany}</td>
            </tr>
            <tr>
                <th>订单状态</th>
                <td>${orderMain.status!}</td>
                <th>商品总额</th>
                <td>￥${orderMain.sumNofreightPrice!}</td>
            </tr>
            <tr>
                <th>运费</th>
                <td>￥${orderMain.freight!}</td>
                <th>应支付总额</th>
                <td>￥${(orderMain.sumPrice)!}</td>
            </tr>
        </table>
        <p class="tableTitle">收货人信息</p>
        <table class="infoTable">
            <tr>
                <th>收货人</th>
                <td>${memberAddress.username!}</td>
                <th>收货人电话</th>
                <td>${memberAddress.phone!}</td>
            </tr>
            <tr>
                <th>收货人地址</th>
                <td colspan="3">${memberAddress.provinceName!}${memberAddress.cityName!}${memberAddress.countryName!}${memberAddress.townName!}${memberAddress.addressDetail!}</td>
            </tr>
        </table>
        <p class="tableTitle">发票信息</p>
        <table class="infoTable">
            <tr>
                <th>发票类型</th>
                <td>${memberInVoice.type!}</td>
                <th>已开立发票</th>
                <td><#--<#if memberInVoice.isSetUpVoice!>是</#if>-->${memberInVoice.isSetup?string("是","否")}</td>
            </tr>
            <tr>
                <th>纳税人识别号</th>
                <td>${memberInVoice.identificationCode!}</td>
                <th>名称</th>
                <td>${memberInVoice.name!}</td>
            </tr>
            <tr>
                <th>开户行及账号</th>
                <td colspan="3">${memberInVoice.bankAccount!}</td>

            </tr>
            <tr>
                <th>地址、电话</th>
                <td colspan="3">${memberInVoice.voiceAdPhone!}</td>

            </tr>
            <tr>
                <th>发票收件人</th>
                <td>${memberInVoice.recivePName!}</td>
                <th>发票收件人电话</th>
                <td>${memberInVoice.phoneNumber!}</td>
            </tr>
            <tr>
                <th>发票收件地址</th>
                <td colspan="3">${memberInVoice.address!}</td>
            </tr>
            <tr>
                <th>发票明细</th>
                <td colspan="3">${memberInVoice.invoiceDetail!}</td>
            </tr>
        </table>
        <p class="tableTitle">发票信息</p>




    <#if orderNos??>
        <#if (orderNos?size>0)>
            <#list orderNos as orderNo>
                <div class="productInfo">
                    <#if isSub>
                        <p class="infoTitle clearfix">
                            <i>子订单号：</i>
                            <i>${orderNo}</i>
                            <i class="sendAddress">${warehouses[orderNo_index]} </i>
                            <span>${litleCount[orderNo_index]}元</span>
                            <span>小计：</span>
                        </p>
                    </#if>
                    <#list items[orderNo_index] as item>
                        <div class="row productInfoList">
                            <div class="col-xs-2">
                        <span class="proImgBox">
                            <img src="${pictrues[orderNo_index][item_index].picturePath!}">
                        </span>
                            </div>
                            <div class="col-xs-3 text-left productName">
                        <span>
                        ${item.productName!}
                        </span>
                            </div>
                            <div class="col-xs-2">
                                <span>单价：</span>
                                <span>${item.salePrice!}元</span>
                            </div>
                            <div class="col-xs-3">
                                <span>数量：</span>
                                <span>×${item.count}</span>
                            </div>
                            <#--<div class="col-xs-2">-->
                                <#--<a-->
                                        <#--href="http://localhost:6060/members/salesApply?orderMainId=${orderMain.id!}&jdOrderId=${orderNo!}&addressId=${memberAddress.id!}&goodsId=${item.goodsId!}&skuName=${item.productName!}&skuPrice=${item.salePrice!}&skuNum=1&url=${pictrues[orderNo_index][item_index].picturePath!}"><span-->
                                        <#--class="applyService"-->
                                        <#--class="fontora litilesum"> <#if isCanReturn[orderNo_index][item_index]>-->
                                    <#--申请售后</#if> </span></a>-->
                            <#--</div>-->
                        </div>
                    </#list>
                </div>
                <#if orderTrackResp??>
                    <p class="tableTitle">物流进度</p>
                    <#if orderTrackResp[orderNo]??>
                        <ul class="logisticsProgress">
                            <#list orderTrackResp[orderNo]  as orderTrack>
                                <#if orderTrack_index==0>
                                    <li class="active">
                                        <i class="iconfont icon">
                                            &#xe625;</i>   <#if orderTrack.msgTime??> ${(orderTrack.msgTime)?string('yyyy-MM-dd HH:mm:ss')}</#if>
                                    ${(orderTrack.content)!}
                                    </li>
                                <#else >
                                    <li>
                                        <i class="iconfont icon">
                                            &#xe625;</i>   <#if orderTrack.msgTime??> ${(orderTrack.msgTime)?string('yyyy-MM-dd HH:mm:ss')}</#if>
                                    ${(orderTrack.content)!}
                                    </li>
                                </#if>
                            </#list>
                        </ul>
                    <#else>
                    <#--苏宁不拆单，只拆分包裹-->
                        <#list orderTrackResp as k, package>
                            <ul class="logisticsProgress">
                                <li >包裹：[${k}]</li>
                                <#list package as orderTrack>
                                    <#if orderTrack_index==0>
                                        <li class="active">
                                            <i class="iconfont icon">
                                                &#xe625;</i>   <#if orderTrack.msgTime??> ${(orderTrack.msgTime)?string('yyyy-MM-dd HH:mm:ss')}</#if>
                                        ${(orderTrack.content)!}
                                        </li>
                                    <#else >
                                        <li>
                                            <i class="iconfont icon">
                                                &#xe625;</i>   <#if orderTrack.msgTime??> ${(orderTrack.msgTime)?string('yyyy-MM-dd HH:mm:ss')}</#if>
                                        ${(orderTrack.content)!}
                                        </li>
                                    </#if>
                                </#list>
                            </ul>
                        </#list>
                    </#if>
                </#if>

            </#list>
        </#if>
    </#if>
        <div class="backBtn">
            <span onclick="window.location.href='queryTransactionDataUI'">返回</span>
        </div>
    </div>
</div>
<#include "/include/footer.ftl">
<#--<footer>-->
    <#--<!--# include file="/caigou/footer" &ndash;&gt;-->
<#--</footer>-->


</body>
<#include "/include/resource.ftl">


</html>