<!DOCTYPE html>
<html lang="en">
<head>
<#include "/include/meta.ftl">
<#include "/include/head.ftl">
<#include "/include/ie8fix.ftl">
    <link rel="stylesheet" type="text/css" href="${p_static}${_v('/cms/css/global.css')}">
    <link rel="stylesheet" type="text/css" href="${p_static}${_v('/cms/css/notice.css')}">


    <title>公告</title>
</head>
<body>
<#include "/include/header.ftl">
<#--<header>-->
    <#--<!--# include file="/score/top" &ndash;&gt;-->
<#--</header>-->
<div class="pageWidth">
    <div class="span6">
        <ul class="breadcrumb navItem">
            <li>
                <a href="/score/">首页</a> <span class="divider">></span>
            </li>
            <li><a href="#">公告</a></li>
        </ul>
    </div>
    <div class="noticeBg">
        <img src="${p_static}${_v('/cms/image/noticeBg.png')}">
    </div>
    <div class="noticeCon clearfix">
        <form class="queryList">
            <input type="text" placeholder="请输入查询关键字" class="queryValue" id="title"/>
            <input type="button" value="查询" class="queryBtn" id="queryBtn"/>
        </form>
        <table class="table table-striped noticeList">
            <thead>
            <tr>
                <th>序号</th>
                <th>标题</th>
                <th>发布者</th>
                <th>发布时间</th>
            </tr>
            </thead>
            <tbody id="noticeId">
            </tbody>
        </table>
        <div id="divId" align="center" style="color: #FF2F2F"></div>
        <ul class="pagination paging fr" id="noticePage">
    </div>
</div>
<#include "/include/footer.ftl">
<#--<footer>-->
    <#--<!--# include file="/score/footer" &ndash;&gt;-->
<#--</footer>-->
</body>
<#include "/include/resource.ftl">
<script src="${p_static}${_v('/cms/js/notice.js')}"></script>
<script>

    function getNotices(current) {
        var title =$("#title").val();
        var page=1;
        if(current){
            page=current;
        }else{
            page=1;
        }
        $.ajax({
                url: "${ctx}/notice/list",
                type: "POST",
                data: {
                    title :title,
                    page:  page,
                    size: 20
                },
                success: function(res) {
                    var noticeContent="";
                    if(res.data.length==0){
                        $("#divId").text("很抱歉，系统找不到您的记录，换个词试试");
                    }else{
                        noticeContent=convertNotice(res.data,res.title);  //拼装显示的页面代码
                        $("#divId").text("");
                    }
                    document.getElementById('noticeId').innerHTML = noticeContent;
                    //显示分页
                    laypage({
                        cont: 'noticePage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
                        pages: res.totalPages, //通过后台拿到的总页数
                        curr: current || 1, //当前页
                        skin: '#AF0000',//皮肤
                        jump: function(obj, first){ //触发分页后的回调
                            if(!first){ //点击跳页触发函数自身，并传递当前页：obj.curr
                                getNotices(obj.curr);
                            }
                        }
                    });
                }
            });
    }

    getNotices();

    //点击查询按钮增
    $("#queryBtn").click(function () {
        var title =$("#title").val();
        if(title==undefined || title==null || title==""){
            $("#divId").text("请输入您的查询条件");
            document.getElementById('noticeId').innerHTML = "";
        }else{
            $("#divId").text("");
            getNotices();
        }
    });

    //转化文章列表
    function convertNotice(content,queryKey){
        var length =0;
        var noticeTable="";
        if(content!=undefined&&content!=""){
            length =content.length;
            for(var i=0;i<length;i++){
                var fullTitle =content[i].TITLE;
                if(queryKey!=undefined&&queryKey!=null&&queryKey!=""){
                    var index =content[i].TITLE.indexOf(queryKey);
                    if(index>-1){
                        var prefix =fullTitle.substr(0,index);
                        var suffix =fullTitle.substr(index+queryKey.length);
                        fullTitle = prefix+"<span style='color:red'>"+queryKey+"</span>"+suffix;
                    }
                }
                noticeTable+="<tr><td>"+(i+1)+"</td>";
                if(content[i].IS_READ_ANNOUNCEMENT==1){
                    noticeTable+="<td><span class='icon iconfont msgIcon'>&#xe60d;</span><a href='${ctx}/notice/detail?noticeId="+content[i].AID+"'>";
                }else{
                    noticeTable+="<td class='unread read'><span class='icon iconfont msgIcon'>&#xe60d;</span><a href='${ctx}/notice/detail?noticeId="+content[i].AID+"'>";
                }
                noticeTable+=fullTitle+"</a></td>";
                noticeTable+="<td>"+(content[i].USERNAME)+"</td>";
                noticeTable+="<td>"+timeFormat(content[i].PUSH_DATE)+"</td></tr>";
            }
        }
        return noticeTable;
    }
</script>
</html>