<!DOCTYPE html>
<html lang="en">
<head>

<#include "../include/meta.ftl" />
<#include "../include/head.ftl" />
<#include "../include/ie8fix.ftl" />
<#include "../include/resource.ftl" />


    <title>订单明细查询</title>
</head>
<body class="bodyBgGray">
<!--页头-->
<header>
    <#include "/include/header.ftl">
</header>
<!--页头end-->
<div class="myMsgCon center scrollTopH">
    <div class="conNav MemberCrumbs">
        管理员操作><em class="myMsg"><em>订单查询</em></em>
    </div>

<#include "../common/imgCon.ftl">
    <div class="conNav h clearfix">

    <#include "../include/left.ftl">
        <div class="conNavR fr">
            <div class="conBox">
                <h2 class="conTitle">订单查询</h2>
                <div class="conMain clearfix">
                    <form class="searchInfo clearfix">
                        <div class="formInput fl rel clearfix">
                            <label class="fl pl-12">下单人：</label>
                            <div class="itemInput fl">
                                <input type="text" id="orderName" maxlength="50"/>
                            </div>
                        </div>
                        <div class="formInput fl rel clearfix">
                            <label class="fl">订单号：</label>
                            <div class="itemInput fl">
                                <input type="text" id="orderNo" maxlength="20"/>
                            </div>
                        </div>
                        <div class="formInput fl rel clearfix rel">
                            <label class="fl">订单状态：</label>
                            <div class="itemInput fl">
                                <input id="orderStatus" type="text" readonly value="全部" UNSELECTABLE ='on'/>
                                <i class="iconfont abs" id="iconOrderStatus">&#xe628;</i>
                            </div>
                            <ul id="orderDropDownStatus" class="abs">
                                <li class="orderDropDownStatusList">全部</li>
                                <li class="orderDropDownStatusList">待付款</li>
                                <li class="orderDropDownStatusList">待收货</li>
                                <li class="orderDropDownStatusList">已完成</li>
                                <li class="orderDropDownStatusList">拒收</li>
                                <li class="orderDropDownStatusList">已取消</li>
                            </ul>
                            <input type="hidden" id="status"/>
                        </div>
                        <div class="formInput fl rel clearfix">
                            <label class="fl">下单时间：</label>
                            <div class="itemInput rel fl">
                                <input id="dateStart" type="text" readonly UNSELECTABLE ='on'/>
                                <i class="abs iconDateStart iconfont">&#xe609;</i>
                            </div>
                        </div>
                        <div class="formInput fl rel clearfix">
                            <label class="gred fl">——</label>
                            <div class="itemInput rel fl">
                                <input id="dateEnd" type="text" readonly UNSELECTABLE ='on'/>
                                <i class="abs iconDateEnd iconfont">&#xe609;</i>
                            </div>
                        </div>
                    </form>
                    <div class="searchInfoBtn">
                        <a href="javascript:void(0)" class="queryBtn" onclick="getOrder(false);">查询</a>
                        <a href="javascript:void(0)" class="exportBtn" onclick="exportOrder();">导出</a>
                    </div>
                </div>
                <div class="conMain">
                    <div class="searchResult conTable">
                        <!-- 搜索结果-->
                        <table class="resultTable" id="orderContent">
                        </table>
                        <div id="noReturnData" style='margin-top: 15px;width: 100%;text-align: center;display: none;'>
                            很抱歉，系统找不到您的记录，换个条件试试
                        </div>

                    </div>
                </div>
            </div>
            <ul class="pagination paging fr" id="orderPage">
            </ul>
        </div>
    </div>
</div>
<#include "/member/include/footer.ftl" />
<#include "/include/rightNav.ftl" />
<#include "/include/footer.ftl" />
<script>

    currentMemberPage("12");

    var currentPage = 0;

    function exportOrder() {
        var form = $("<form>");
        form.attr('style', 'display:none');
        form.attr('target', '_blank');
        form.attr('method', 'post');
        form.attr('action', '${ctx}/orderQuery/exportOrder.do');

        var orderName = $('<input>');
        orderName.attr('type', 'hidden');
        orderName.attr('name', 'orderName');
        orderName.attr('value', $("#orderName").val());
        form.append(orderName);

        var orderNo = $('<input>');
        orderNo.attr('type', 'hidden');
        orderNo.attr('name', 'orderNo');
        orderNo.attr('value', $("#orderNo").val());
        form.append(orderNo);

        var status = $('<input>');
        status.attr('type', 'hidden');
        status.attr('name', 'status');
        status.attr('value', $("#orderStatus").val());
        form.append(status);

        var startTime = $('<input>');
        startTime.attr('type', 'hidden');
        startTime.attr('name', 'dateStart');
        startTime.attr('value', $("#dateStart").val());
        form.append(startTime);

        var endTime = $('<input>');
        endTime.attr('type', 'hidden');
        endTime.attr('name', 'endTime');
        endTime.attr('value', $("#dateEnd").val());
        form.append(endTime);

        $('body').append(form);
        form.submit();
        /*location.href = "${ctx}/orderQuery/exportOrder.do?orderName=" + $("#orderName").val() + "&orderNo=" + $("#orderNo").val() +
                "&status=" + $("#orderStatus").val() + "&startTime=" + $("#dateStart").val() + "&endTime=" + $("#dateEnd").val() +
                "&page=" + currentPage + "&size=10";*/
    }
    //    查询前的最终校验
    function CheckPost() {
        if (!CM.checkUserName($("#orderName"))) {
            return;
        } else if(!CM.checkOrderNo($("#orderNo"))){
            return;
        } else {
            if ($("#dateStart").val() == "" && $("#dateEnd").val() != "") {
                CM.clearErrorMsg($("#dateStart")[0]);
                CM.clearErrorMsg($("#dateEnd")[0]);
                CM.showErrorMsg($("#dateStart")[0], '请填写开始时间！');
                return;
//                addForm.username.focus();
            } else if ($("#dateStart").val() != "" && $("#dateEnd").val() == "") {
                CM.clearErrorMsg($("#dateStart")[0]);
                CM.clearErrorMsg($("#dateEnd")[0]);
                CM.showErrorMsg($("#dateEnd")[0], '请填写结束时间！');
                return;
            } else if ($("#dateStart").val() > $("#dateEnd").val()) {
                CM.clearErrorMsg($("#dateStart")[0]);
                CM.clearErrorMsg($("#dateEnd")[0]);
                CM.showErrorMsg($("#dateStart")[0], '开始时间不能大于结束时间！');
                return;
            } else {
//                    全部正确
                CM.clearErrorMsg($("#dateStart")[0]);
                CM.clearErrorMsg($("#dateEnd")[0]);
                return true;
            }
        }
    }
    function getOrder(current) {
        if (CheckPost()) {
            var page = 0;
            if (current) {
                page = current - 1;
            } else {
                page = 0;
            }

            $.ajax({
                url: "${ctx}/orderQuery/getOrder.do",
                type: "POST",
                data: {
                    orderName: $("#orderName").val(),
                    orderNo: $("#orderNo").val(),
                    status: $("#orderStatus").val(),
                    startTime: $("#dateStart").val(),
                    endTime: $("#dateEnd").val(),
                    page: page,
                    size: 10
                },
                success: function (res) {
                    var orderContent = convertOrderData(res.data);  //拼装显示的页面代码
                    $('#orderContent').html(orderContent);
                    //显示分页
                    laypage({
                        cont: 'orderPage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
                        pages: res.totalPages, //通过后台拿到的总页数
                        curr: current || 1, //当前页
                        skin: '#AF0000',//皮肤
                        jump: function (obj, first) { //触发分页后的回调
                            if (!first) { //点击跳页触发函数自身，并传递当前页：obj.curr
                                currentPage = obj.curr;
                                getOrder(obj.curr, true);
                            }
                        }
                    });
                }
            });
        }

    }
    getOrder();
    var orderIds = new Array();
    function convertOrderData(responseData) {
        if (responseData == undefined || responseData.length == 0) {
            $('#noReturnData').show();
        } else {
            $('#noReturnData').hide();
        }
        responseData.sort(function (a, b) {
            return new Date(b.orderTime).getTime() - new Date(a.orderTime).getTime();
        });
        //console.log(responseData);
        var responseDatalen = responseData.length;
        var returnStr = "";
        returnStr = returnStr + '<tr class="trfirst">' +
                ' <th width="10%" align="center">下单人</th>' +
                '<th width="20%" align="center">公司</th>' +
                '<th width="12%" align="center">订单号</th>' +
                '<th width="11%" align="center">下单积分(Ct)</th>' +
                '<th width="11%" align="center">下单金额(元)</th>' +
                '<th width="10%" align="center">订单状态</th>' +
                '<th width="15%" align="center">下单日期</th>' +
                '<th width="11%" align="center">操作</th>' +
                '</tr>';
        for (var i = 0; i < responseDatalen; i++) {
            orderIds.push(responseData[i].orderId);
            var orderNo = responseData[i].orderNo;

            if(i%2==0){
                returnStr = returnStr + '<tr>' +
                        '<td>' + getResponseDataString(responseData[i].orderName) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orgName) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderNo) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderScore) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderPrice) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderStatus) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderTime) + '</td>' +
                        '<td class="editdet">' +
                        '<span onclick="orderDetail(\'' + orderNo + '\')">查看</span>' +
                        '</td>' +
                        '</tr>';
            }else{
                returnStr = returnStr + '<tr class="oddNum">' +
                        '<td>' + getResponseDataString(responseData[i].orderName) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orgName) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderNo) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderScore) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderPrice) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderStatus) + '</td>' +
                        '<td>' + getResponseDataString(responseData[i].orderTime) + '</td>' +
                        '<td class="editdet">' +
                        '<span onclick="orderDetail(\'' + orderNo + '\')">查看</span>' +
                        '</td>' +
                        '</tr>';
            }
        }
        return returnStr;
    }

    function getResponseDataString(value) {
        if (value == undefined) {
            return "";
        } else {
            return value + "";
        }
    }

    function orderDetail(orderNo) {
        location.href = "${ctx}/orderQuery/orderDetail/" + orderNo;
    }

</script>
</body>
</html>