<!DOCTYPE html>
<html lang="en">
<head>

	<#include "../include/meta.ftl" />
	<#include "../include/head.ftl" />
	<#include "../include/ie8fix.ftl" />
	<#include "../include/resource.ftl">

	<title>订单详情</title>
    <style>

        .order-msg-detail-list{
            height:100px;
            border-top:1px solid #eee;
            display:  table;
            width: 100%;
        }

        .productFashionSpecification {
            display: block;
            width: 150px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .productFashionSpecification:hover {
            color: cornflowerblue;
        }

        .aa {
            display: table-cell;
            width: 15%;
            text-align: center;
            vertical-align: middle;
        }

        .order-msg-detail-price-wrap, .order-msg-detail-amount-wrap{
            margin-left: 0;
        }
    </style>
</head>
<body class="bodyBgGray">
<!--页头-->
<header>
<#--<div class="headerTopBox">-->
    <#--</div>-->
    <#--<div class="headerCon">-->

    <#--</div>-->
    <#include "/include/header.ftl">
</header>
<!--页头end-->
<div class="myMsgCon center scrollTopH">
	<div class="conNav MemberCrumbs">
		管理员操作><em class="myMsg"><em>我的订单</em></em>
	</div>
    <input type="hidden" id="scorePortion" value="${scorePortion!}">
	<#--<#include "imgCon.ftl">-->
	<#--<div class="imgCon"></div>-->
	<#include "../common/imgCon.ftl">
	<div class="conNav h clearfix">

		<#--<#include "leftCon.ftl">-->
		<#--<div class="leftCon fl"></div>-->
        <#include "../include/left.ftl">
		<#--<#include "../common/leftCon.ftl">-->
		<div class="conNavR fr">
			<!--<p class="myChoice"><em>我的资料</em> </p>-->
			<div class="conBox order-box">
				<div class="order-wrap">
					<!--订单明细标题-->
					<div class="order-title">
						<span class="order-titleText">订单明细</span>
					</div>
					<!--订单明细内容-->
					<div class="order-body clearfix">
						<!--订单信息-->
						<div class="order-message">
							<p class="order-message-title">订单信息</p>
							<table class="table-order-message table table-bordered">
								<tr>
									<td>订单号</td>
									<td>${orderInfo.orderMain.orderNo!}</td>
									<td>下单时间</td>
									<td>
										<#if (orderInfo.orderMain.createTime)??>
									${orderInfo.orderMain.createTime?string("yyyy-MM-dd HH:mm:ss")}
										</#if>
									</td>
								</tr>
								<tr>
									<td>订单状态</td>
									<td>
									<#if orderInfo.orderMain.status=='1'>待付款

									    <#elseif orderInfo.orderMain.status=='3' || orderInfo.orderMain.status=='2'>待收货
									    <#elseif orderInfo.orderMain.status=='4'>待评价
									    <#elseif orderInfo.orderMain.status=='5'>已完成
									    <#elseif orderInfo.orderMain.status=='6'>已取消
                                    <#elseif orderInfo.orderMain.status=='7'>拒收
                                    <#elseif orderInfo.orderMain.status=='8'>已取消
									</#if>
									</td>
									<td>订单总额</td>
									<td>
										<#if orderInfo.score??>
											${orderInfo.score!}积分
										</#if>
										<#if orderInfo.payMoney??>
                                            + ${orderInfo.payMoney!}元
										</#if>
										</td>
								</tr>
							</table>
						</div>

						<!--收货人信息-->
						<div class="deliver-message">
							<p class="deliver-message-title">收货人信息</p>
							<table class="table-deliver-message table table-bordered">
								<tr class="deliver-details">
									<td>收货人</td>
									<td>${(orderInfo.buyer.USERNAME)!}</td>
									<td>收货人电话</td>
									<td>${(orderInfo.buyer.PHONE)!}</td>
								</tr>
								<tr class="address">
									<td>收货人地址</td>
									<td colspan="3">${(orderInfo.buyer.PROVINCE_NAME)!}  ${(orderInfo.buyer.CITY_NAME)!}  ${(orderInfo.buyer.AREA_NAME)!}  ${(orderInfo.buyer.ADDRESS_DETAIL)!}</td>
								</tr>
							</table>
						</div>
                        <p class="goods-message-title">商品信息</p>
						<!--订单概要信息-->
                        <div class="order-message-wrap clearfix">
                            <div class="order-num-wrap fl">订单号：<span class="order-num" id="myOrderNo">${orderInfo.orderMain.orderNo!}</span></div>
                            <div class="order-location fl"></div>
                            <div class="order-sumUp-wrap fl">小计：<span class="order-sumUp">
							<#--<#if orderInfo.orderMain.score??>-->
								<#--${orderInfo.orderMain.score!}积分-->
							<#--</#if>-->
							<#if orderInfo.nofreightPrice??>
                                 ${orderInfo.nofreightPrice!}元
							</#if></span></div>
                        </div>
                        <!--订单详细信息-->
                       <#-- <div class="order-message-detail-wrap clearfix">
                            <ul class="order-msg-detail-body clearfix">
							<#if orderInfo.picList??>


								<#list orderInfo.picList as  picList>
                                    <li class="order-msg-detail-list clearfix">
									<a class="order-msg-detail-img fl">
										<img onclick="goToDetail('${picList.ITEM.goodsId!}')" style="width: 60px;height: 60px;" src="${picList.IMG!}" alt=""/>
									</a>
									<span class="order-msg-detail-desc fl">
										<a onclick="goToDetail('${picList.ITEM.goodsId!}')">${picList.ITEM.productName!}</a>
									</span>
									<span class="order-msg-detail-price-wrap fl">
										单价：<span class="order-detail-price">${picList.ITEM.salePrice!}</span>积分
									</span>
									<span class="order-msg-detail-amount-wrap fl">
										数量：×<span class="order-detail-amount">${picList.ITEM.count!}</span>
									</span>
                                    </li>
								</#list>
							</#if>

                            </ul>
                        </div>-->
                        <!--订单详细信息-->
                        <div class="order-message-detail-wrap clearfix" id="orderItems">

                        </div>


					</div>
				</div>
			</div>

            <ul class="pagination paging fr" id="orderItemsListPage">
            </ul>

		</div>
	</div>
</div>


<!--页脚-->
<#--<div class="footer"> </div><div class="rightNav">-->
<#--</div>-->
<#include "/member/include/footer.ftl" />
<#include "/include/rightNav.ftl" />
<!--页脚 end-->
<#include "/include/footer.ftl" />

<script type="text/javascript">

    currentMemberPage("12");
</script>



<script>
    var currentPage  = 1;
    var pageSize     = 10;
    var orderNo      = "";

    $(function () {

        orderNo = $("#myOrderNo").html();
        //console.log("orderNo:"+orderNo);
        var postData = {
            pageIndex: currentPage,
            pageSize: pageSize,
            orderNo:orderNo
        };
        queryOrderItems(postData);
    });

    var specificationsMap = null;

    function queryOrderItems(postData) {
        var page=0;
        if(postData.pageIndex){
            page=postData.pageIndex-1;
        }else{
            page=0;
        }
        postData.pageIndex = page;

        $.post("${ctx}/order/myOrder/detail/items/page",postData,function (data) {
            //console.log(data);
            if(data.code = "0"){

                var totalPage = data.totalPage;
                var pageNum   = data.pageNum;
                specificationsMap = data.specificationsMap;
                var listData = data.picList;
                var html = convertData(listData);
                $("#orderItems").html(html);


                //显示分页
                laypage({
                    cont: 'orderItemsListPage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
                    pages: totalPage, //通过后台拿到的总页数
                    curr: (postData.pageIndex+1) || 1, //当前页
                    skin: '#AF0000',//皮肤
                    jump: function(obj, first){ //触发分页后的回调
                        if(!first){ //点击跳页触发函数自身，并传递当前页：obj.curr
                            currentPage = obj.curr;
                            console.log("当前页:"+currentPage);
                            var postData = {
                                orderNo: orderNo,
                                pageIndex: currentPage,
                                pageSize: pageSize
                            };
                            queryOrderItems(postData);
                        }
                    }
                });

            }
        });

    }

    function  convertData(orderItemsData) {
        if (orderItemsData == undefined || orderItemsData.length == 0){
            return "<div style='margin-top: 15px;width: 100%;text-align: center'>很抱歉，系统找不到您的记录</div>";
        }
        var ul = "";
        ul = '<ul class="order-msg-detail-body clearfix">';

        var scorePortion = $("#scorePortion").val();

        jQuery.each(orderItemsData,function (n,value) {
            var score = value.ITEM.salePrice;
            var score0 = Math.ceil(score * scorePortion);
            var goodsId = value.ITEM.goodsId;

            // 规格
            var specifications = '';
            // === 类型比较 == 值比较
            if(specificationsMap[goodsId] !== null && specificationsMap[goodsId] !== undefined) {
                var specificationsArray = specificationsMap[goodsId];
                specifications += '<div class="aa">';
                for (var index = 0; index < specificationsArray.length; index++) {
                    specifications += '<span class="productFashionSpecification" title="' + specificationsArray[index].name + ':' + specificationsArray[index].value + '">' + specificationsArray[index].name + ':' + specificationsArray[index].value + '</span>';
                }
                specifications += '</div>';
            }

            ul += '<li class="order-msg-detail-list clearfix">' +
                    '<a class="order-msg-detail-img fl">' +
                    '<img onclick="goToDetail(\''+goodsId+'\')" style="width: 60px;height: 60px;" src="'+value.IMG+'" alt=""/>' +
                    '</a>' +
                    '<span class="order-msg-detail-desc fl">' +
                    '<a onclick="goToDetail(\''+goodsId+'\')">'+value.ITEM.productName+'</a>' +
                    '</span>' + specifications +
                    '<span class="order-msg-detail-price-wrap fl">' +
                    '单价：<span class="order-detail-price">'+score+'</span>元' +
                    '</span>' +
                    '<span class="order-msg-detail-amount-wrap fl">' +
                    '数量：×<span class="order-detail-amount">'+ value.ITEM.count +'</span>' +
                    '</span>' +
                    '</li>';
        });
        ul += '</ul>';

        return ul;
    }


    function goToDetail(goodsId) {
        window.location.href = "../../../../score/goodsdetails?goodsId="+goodsId;
    }



</script>




</body>
</html>