<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/html">
<head>
<#include "../include/meta.ftl">
<#include "../include/head.ftl">
<#include "../include/ie8fix.ftl">
<#include "../include/resource.ftl">
    <title>积分概览查询</title>
</head>
<body class="bodyBgGray">
<!--页头-->
<header>
    <#--<div class="headerTopBox">-->
    <#--</div>-->
    <#--<div class="headerCon">-->

    <#--</div>-->
    <#include "/include/header.ftl">
</header>
<!--页头end-->
<div class="myMsgCon center scrollTopH">
    <div class="conNav MemberCrumbs">
        管理员操作><em class="myMsg"><em>积分概览查询</em></em>
    </div>

    <#--<div class="imgCon">-->
        <#--<img src="/score/member/image/comBg.png" alt="">-->
    <#--</div>-->
    <#include "../common/imgCon.ftl">
    <div class="conNav h clearfix">

    <#include "../include/left.ftl">
    <#--<#include "../common/leftCon.ftl">-->
        <div class="conNavR fr">
            <!--<p class="myChoice"><em>我的资料</em> </p>-->
            <div class="conBox">
                <h2 class="conTitle">积分概览</h2>
                <#--<p class="infoOfScore">当前可用积分：<span>210000Ct</span></p>-->
                <div class="conMain clearfix infoForm">
                    <form class="searchInfo clearfix">
                        <div class="formInput rel fl clearfix">
                            <label class="fl">姓  名：</label>
                            <div class="itemInput fl">
                                <input type="text" id="username" maxlength="50" value="${username!''}"/>
                            </div>
                        </div>
                        <div class="formInput rel fl clearfix">
                            <label class="fl">手机号：</label>
                            <div class="itemInput fl">
                                <input type="text" id="phone" value="${phone!''}"/>
                            </div>
                        </div>
                        <div class="formInput rel fl clearfix">
                            <label class="fl">邮  箱：</label>
                            <div class="itemInput fl">
                                <input type="text" id="email" value="${email!''}"/>
                            </div>
                        </div>
                    </form>
                    <div class="searchInfoBtn infoFormBtn">
                        <a href="javascript:void(0)" class="queryBtn" onclick="getMember()">查询</a>
                        <a href="javascript:void(0)" class="exportBtn" onclick="exportMember()">导出</a>
                    </div>
                </div>
                <div class="conMain">
                    <div class="searchResult conTable">
                        <!-- 搜索结果-->
                        <table class="resultTable" id="memberContent">
                        </table>

                        <div id="noReturnData" style='margin-top: 15px;width: 100%;text-align: center;display: none;'>
                            很抱歉，系统找不到您的记录，换个条件试试
                        </div>

                    </div>
                </div>
            </div>
            <ul class="pagination paging fr" id="memberPage">
            </ul>
        </div>
    </div>
</div>
<div class="importPopup coverLayer">
    <div class="importPopupCon logOffConResult">
        <span class="iconfont cancelPopup" onclick="closePopup(this)">&#xe637;</span>
        <div class="logOffText">
            <h3>注销用户成功</h3>
        </div>
        <div class="popupBtn">
            <span class="sureBtn" onclick="closePopup(this)">确认</span>
        </div>
    </div>
    <div class="importPopupCon logOffCon">
        <span class="iconfont cancelPopup" onclick="closePopup(this)">&#xe637;</span>
        <div class="logOffText">
            <h3>注销用户</h3>
            <p>注销的用户积分将被清零，并无法再登录积分商城，是否确认注销用户？</p>
        </div>
        <div class="popupBtn">
            <span class="sureBtn">确认注销</span>
        </div>
    </div>
</div>
<#include "/include/footer.ftl" />
<#include "/include/rightNav.ftl" />
<#include "/member/include/footer.ftl" />
<script>

    currentMemberPage("10");

    var currentPage = 1;
    var currentPageBack = '${currentPage!''}';
    if(currentPageBack.length > 0) {
        currentPage = currentPageBack;
    }

    var numberOfElements;

    function exportMember(){
        var form = $("<form>");
        form.attr('style', 'display:none');
        form.attr('target', '_blank');
        form.attr('method', 'post');
        form.attr('action', '${ctx}/memberCreditsCheck/listExport');

        var username = $('<input>');
        username.attr('type', 'hidden');
        username.attr('name', 'username');
        username.attr('value', $("#username").val());
        form.append(username);

        var phone = $('<input>');
        phone.attr('type', 'hidden');
        phone.attr('name', 'phone');
        phone.attr('value', $("#phone").val());
        form.append(phone);

        var email = $('<input>');
        email.attr('type', 'hidden');
        email.attr('name', 'email');
        email.attr('value', $("#email").val());
        form.append(email);

        $('body').append(form);
        form.submit();
    }

    function getMember(current) {
        if(CheckPost()) {
            var page=0;
            if(current){
                currentPage = current;
                page=current-1;
            }else{
                page=0;
            }

            $.ajax({
                url: "${ctx}/memberCreditsCheck/list",
                type: "POST",
                data: {
                    username:$("#username").val(),
                    phone:$("#phone").val(),
                    email:$("#email").val(),
                    page:  page,
                    size: 10
                },
                success: function(res) {
                    numberOfElements = res.data.numberOfElements;
                    var memberContent=convertMemberData(res.data.content,res.orgName);  //拼装显示的页面代码
                    $('#memberContent').html(memberContent);
                    //显示分页
                    laypage({
                        cont: 'memberPage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
                        pages: res.totalPages, //通过后台拿到的总页数
                        curr: current || 1, //当前页
                        skin: '#AF0000',//皮肤
                        jump: function(obj, first){ //触发分页后的回调
                            if(!first){ //点击跳页触发函数自身，并传递当前页：obj.curr
                                currentPage = obj.curr;
                                getMember(obj.curr);
                            }
                        }
                    });
                }
            });
        }

        function CheckPost () {
            if(!CM.checkUserName($("#username"))){
                return;
            }else if(!CM.checkPhoneNum($("#phone"))){
                return;
            }else if(!CM.checkEmail($("#email"))){
                return;
            }else{
                return true;
            }
        }
    }
    getMember(currentPage);
    var memberIds = new Array();
    function  convertMemberData(responseData,orgName) {
        if (responseData == undefined || responseData.length == 0) {
            $('#noReturnData').show();
        } else {
            $('#noReturnData').hide();
        }
        var responseDatalen=responseData.length;
        var returnStr="";
        returnStr = returnStr + '<tr class="trfirst">' +
                '<th width="10%" align="center">姓名</th> ' +
                '<th width="16%" align="center">公司</th>' +
                '<th width="10%" align="center">手机号</th> ' +
                '<th width="9%" align="center">邮箱</th>' +
                '<th width="9%" align="center">身份证</th>' +
                '<th width="13%" align="center">变动时间</th>' +
                '<th width="11.5%" align="center">可用积分(Ct)</th>' +
                '<th width="11.5%" align="center">消费积分(Ct)</th>' +
                '<th width="10%" align="center">操作</th> </tr>';
        memberIds.length = 0;
        for(var i=0;i<responseDatalen;i++) {
            memberIds.push(responseData[i].memberId);
            if (i % 2 == 1) {
                returnStr = returnStr + '<tr class="oddNum">';
            } else {
                returnStr = returnStr + '<tr>';
            }
            returnStr = returnStr + '<td title="' + responseData[i].userName + '">' + getResponseDataString(responseData[i].userName) + '</td>' +
                    '<td title="' + responseData[i].organizationName + '">' + getResponseDataString(responseData[i].organizationName) + '</td>' +
                    '<td title="' + responseData[i].phone + '">' + getResponseDataString(responseData[i].phone) + '</td>' +
                    '<td title="' + responseData[i].email + '">' + getResponseDataString(responseData[i].email) + '</td>' +
                    '<td title="' + responseData[i].idCard + '">' + getResponseDataString(responseData[i].idCard) + '</td>' +
                    '<td title="' + responseData[i].lastUpdated + '">' + getResponseDataString(responseData[i].lastUpdated) + '</td>' +
                    '<td title="' + responseData[i].score + '">' + getResponseDataString(responseData[i].score) + '</td>' +
                    '<td title="' + responseData[i].scoreSpent + '">' + getResponseDataString(responseData[i].scoreSpent) + '</td>' +
                    '<td class="editdet">';
            if (responseData[i].admin) {
                returnStr = returnStr + '<span onclick="memberDetail(' + i + ')">查看</span>';
            } else {
                returnStr = returnStr + '<span onclick="memberDetail(' + i + ')">查看</span> | ' +
                        '<span onclick="logOffUser(' + i + ')">注销</span>';
            }
            returnStr = returnStr + '</tr>';
        }

        return returnStr;
    }

    function logOffUser(value) {
        $('.importPopup').show();
        $(".logOffCon").show();
        $(".logOffConResult").hide();
        var deleteStr = '<span class="sureBtn" onclick="deleteMember(' + value + ')">确认注销</span>'
        $('.logOffCon .popupBtn').html(deleteStr);
    }

    function deleteMember(value) {
        var memberId = memberIds[value];
        location.href = "${ctx}/memberImport/memberDelete.do?memberId=" + memberId + "&numberOfElements=" + numberOfElements + "&currentPage=" + currentPage + "&username=" + $("#username").val() + "&phone="+$("#phone").val() + "&email="+$("#email").val();
        //location.href = "${ctx}/memberImport/memberDelete.do?currentPage" + currentPage;
    }

    function memberDetail(value){
        var memberId = memberIds[value];
        location.href="${ctx}/memberCreditsCheck/memberDetail.do?memberId="+memberId;
    }

    function getResponseDataString (value){
        if(value == undefined){
            return "";
        }else {
            if(value.length > 19) {
                value = value.substring(0, 18) + "...";
            }
            return value + "";
        }
    }

    function showImportInfo(){
        $(".importPopup").show();
        $(".importInfo").show();
    }

    function showImportResult(){
        $(".importPopup").show();
        $(".importResult").show();
    }

    function closePopup(obj){
        $(obj).parent('.importPopupCon').hide();
        $(obj).parents('.importPopup').hide();
    }

    function showDeleteResult(){
        $(".importPopup").show();
        $(".logOffConResult").show();
    }
    <#if isImportSuccess?? && isImportSuccess == true >
    showImportResult();
    </#if>

    <#if isDeleteSuccess?? && isDeleteSuccess == true >
    showDeleteResult();
    </#if>

</script>
</body>
</html>