<!DOCTYPE html>
<html lang="en">
<head>

    <#include "../include/meta.ftl" />
    <#include "../include/head.ftl" />
    <#include "../include/ie8fix.ftl" />
    <#include "../include/resource.ftl">
    <title>积分概览查询详情</title>
    <style>

    </style>
</head>
<body class="bodyBgGray">
<!--页头-->
<header>
    <#include "/include/header.ftl">
</header>
<!--页头end-->
<div class="myMsgCon center scrollTopH">
    <div class="conNav MemberCrumbs">
        管理员操作><em class="myMsg"><em >积分概览查询</em> </em>
    </div>

<#include "../common/imgCon.ftl">
    <div class="conNav h clearfix">

    <#include "../include/left.ftl">
        <div class="conNavR fr">
            <div class="myInfor adOpearInfor">
                <h2 class="myInForTit">积分概览查询详情</h2>
                <div class="myInforCon clearfix">
                    <p><span class="justifyText">姓名</span>：<#if adminScoreOverViewVo??>${adminScoreOverViewVo.userName!}</#if></p>
                    <p><span class="justifyText">手机号</span>：<#if adminScoreOverViewVo??>${adminScoreOverViewVo.phone!}</#if></p>
                    <p><span class="justifyText">公司</span>：<#if adminScoreOverViewVo??>${adminScoreOverViewVo.organizationName!}</#if></p>
                    <p><span class="justifyText">邮箱</span>：<#if adminScoreOverViewVo??>${adminScoreOverViewVo.email!}</#if></p>
                </div>
                <div class="conMain clearfix adOpearScoreText">
                    <div class="fl overviewText">
                        <p class="radioText">
                            <span>
                                可用积分总值
                                <span class="points"><#if adminScoreOverViewVo??>${adminScoreOverViewVo.score!}</#if></span>
                            </span>
                        </p>
                    </div>
                    <div class="fl overviewText secondMain">
                        <p class="radioText">
                            <span>
                                赠送积分总值
                                 <span class="points"><#if adminScoreOverViewVo??>${adminScoreOverViewVo.scoreGiveAll!}</#if></span>
                            </span>

                        </p>
                    </div>
                    <div class="fl overviewText secondMain">
                        <p class="radioText">
                            <span>
                                获取积分总值
                                 <span class="points"><#if adminScoreOverViewVo??>${adminScoreOverViewVo.scoreGetAll!}</#if></span>
                            </span>

                        </p>
                    </div>
                    <div class="fl overviewText secondMain">
                        <p class="radioText">
                            <span>
                                消费积分总值
                                 <span class="points"><#if adminScoreOverViewVo??>${adminScoreOverViewVo.scoreSpent!}</#if></span>
                            </span>

                        </p>
                    </div>
                    <div class="fl overviewText secondMain">
                        <p class="radioText">
                            <span>
                                授予积分总值
                                 <span class="points"><#if adminScoreOverViewVo??>${adminScoreOverViewVo.scoreGrant!}</#if></span>
                            </span>

                        </p>
                    </div>
                </div>
            </div>
            <div class="conBox pointOverview">
                <div class="searchResult conTable">
                    <!-- 搜索结果-->
                    <table class="resultTable" id="memberContent">
                    </table>
                </div>
            </div>
            <ul class="pagination paging fr" id="memberPage">
            </ul>
            <div class="detailGoBackBtn">
                <a href="javascript:history.go(-1)">返回</a>
            </div>
        </div>
    </div>
</div>

<#include "/member/include/footer.ftl" />
<#include "/include/rightNav.ftl" />
<#include "/include/footer.ftl" />
<script>

    currentMemberPage("10");

    function getMember(current) {
        var page=0;
        if(current){
            page=current-1;
        }else{
            page=0;
        }
        $.ajax({
            url: "${ctx}/memberCreditsCheck/detailList",
            type: "POST",
            data: {
                scoreAccountId:"${adminScoreOverViewVo.memberId!}",
                page:  page,
                size: 10
            },
            success: function(res) {
                    console.log(res);
                var memberContent=convertMemberData(res.data.content,res.orgName);  //拼装显示的页面代码
                $('#memberContent').html(memberContent);
//                    document.getElementById('memberContent').innerHTML = memberContent;
                //显示分页
                laypage({
                    cont: 'memberPage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
                    pages: res.totalPages, //通过后台拿到的总页数
                    curr: current || 1, //当前页
                    skin: '#AF0000',//皮肤
                    jump: function(obj, first){ //触发分页后的回调
                        if(!first){ //点击跳页触发函数自身，并传递当前页：obj.curr
                            currentPage = obj.curr;
                            getMember(obj.curr);
                        }
                    }
                });
            }
        });
    }
    getMember();
    var memberIds = new Array();
    function  convertMemberData(responseData) {
        console.log(responseData);
        var responseDatalen=responseData.length;
        var returnStr="";
        returnStr = returnStr +
                '<tr class="trfirst">' +
                '<th width="5%" align="center">序号</th> ' +
                '<th width="20%" align="center">时间</th>' +
                '<th width="20%" align="center">变动原因</th> ' +
                '<th width="20%" align="center">变动值</th>' +
                '<th width="35%" align="center">备注</th>' +
                '</tr>';
        memberIds.length = 0;
        for(var i=0;i<responseDatalen;i++){
            if(responseData[i].useScore != '0') {
                memberIds.push(responseData[i].id);
                if(i % 2 == 1) {
                    returnStr = returnStr + '<tr class="oddNum">';
                } else {
                    returnStr = returnStr + '<tr>';
                }
                returnStr = returnStr +' <td>' + (i + 1) + '</td>' +
                                        '<td>' + getResponseDataString(responseData[i].transaTime) + '</td>' +
                                        '<td>' + getResponseDataString(responseData[i].busiSource) + '</td>' +
                                        '<td>' + getResponseDataString(responseData[i].scoreVal) + '</td>' +
                                        '<td>' + getResponseDataString(responseData[i].memo) + '</td>' +
                                        '</tr>';
            }
        }
        return returnStr;
    }

    function getResponseDataString (value){
        if(value == undefined){
            return "";
        }else {
            return value+"";
        }
    }

    function changeSendType (value){
        if(value == undefined){
            return "";
        }else if(value == "1" ){
            return "授予";
        }else if(value == "2" ){
            return "赠送";
        }else if(value == "3" ){
            return "获赠";
        }else if(value == "4" ){
            return "消费";
        }else if(value == "5" ){
            return "企业增加积分";
        }else {
            return "企业扣除积分";
        }
    }

    function changeUseScore (value,useScore){
        if(value == undefined){
            return "";
        }else if(value == "1" ){
            return "+"+getResponseDataString(useScore);
        }else if(value == "2" ){
            return "-"+getResponseDataString(useScore);
        }else if(value == "3" ){
            return "+"+getResponseDataString(useScore);
        }else if(value == "4" ){
            return "-"+getResponseDataString(useScore);
        }else if(value == "5" ){
            return "+"+getResponseDataString(useScore);
        }else {
            return "-"+getResponseDataString(useScore);
        }
    }

    function changeRemark (value,data){
        if(value == "1" ){
            return getResponseDataString(data.description);
        }else if(value == "2" ){
            return getResponseDataString(data.sendName);
        }else if(value == "3" ){
            return getResponseDataString(data.targetName);
        }else if(value == "4" ){
            return "";
        }else if(value == "5" ){
            return getResponseDataString(data.remark);
        }else {
            return getResponseDataString(data.remark);
        }
    }
    
</script>
</body>
</html>