/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.config;

import exception.mapping.GlobalSimpleMappingExceptionResolver;
import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.core.StringRedisTemplate;
import utils.kaptcha.CheckUtils;

@Configuration
public class SpringMvcConfig {
    @Bean
    CheckUtils checkUtils(StringRedisTemplate redisTemplate) {
        CheckUtils checkUtils = new CheckUtils();
        checkUtils.setRedisTemplate(redisTemplate);
        return checkUtils;
    }

    @Bean(name={"simpleMappingExceptionResolver"})
    @ConditionalOnProperty(value={"exception.enable"})
    @Profile(value={"test"})
    public GlobalSimpleMappingExceptionResolver createSimpleMappingExceptionResolver() {
        GlobalSimpleMappingExceptionResolver r = new GlobalSimpleMappingExceptionResolver();
        Properties mappings = new Properties();
        mappings.setProperty("DatabaseException", "defaultErrorPage");
        mappings.setProperty("InvalidCreditCardException", "defaultErrorPage");
        mappings.setProperty("CustomException", "defaultErrorPage");
        mappings.setProperty("MotanServiceException", "defaultErrorPage");
        mappings.setProperty("NullPointerException", "defaultErrorPage");
        mappings.setProperty("SpelEvaluationException", "defaultErrorPage");
        r.setExceptionMappings(mappings);
        r.setDefaultErrorView("error");
        r.setExceptionAttribute("ex");
        r.setWarnLogCategory("error");
        return r;
    }
}

