/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.activity;

import activities.api.ActivityConfigurationApi;
import activities.vo.ActivityConfigurationVo;
import activities.vo.ActivityVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.data.Jsons;

@Controller
@RequestMapping(value={"activity"})
public class activityController {
    static final Logger logger = LoggerFactory.getLogger(activityController.class);
    @Value(value="${secKillActivity.activityCode}")
    private String secKillActivityCode;
    @Value(value="${secKillStore.code}")
    private String secKillStoreCode;
    @Value(value="${tuanGouActivity.activityCode}")
    private String tuanGouActivityCode;
    @Value(value="${tuanGouStore.code}")
    private String tuanGouStoreCode;
    @Value(value="${ctscore.organization.code}")
    private String organizationCode;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;

    @RequestMapping(value={"/activityPage"})
    public String activityPage(Map<String, Object> map, Integer activityIndex, String activitySign) {
        if (activityIndex == null) {
            activityIndex = 0;
        }
        ActivityConfigurationVo activityConfigurationTuanGou = this.activityConfigurationApi.getActivityByCode(this.organizationCode, this.tuanGouActivityCode);
        ActivityConfigurationVo activityConfigurationSecKill = this.activityConfigurationApi.getActivityByCode(this.organizationCode, this.secKillActivityCode);
        map.put("activityIndex", activityIndex);
        map.put("activitySign", activitySign);
        map.put("activityConfigurationTuanGou", activityConfigurationTuanGou);
        map.put("activityConfigurationSecKill", activityConfigurationSecKill);
        if ("seckill".equals(activitySign)) {
            return "index/activity/activitySecKillGoods";
        }
        return "index/activity/activityTuanGouGoods";
    }

    @RequestMapping(value={"/getGoodsListByActivityId"})
    @ResponseBody
    public List<ActivityVo> getGoodsListByActivityId(String activityDefinitionId, String activityCode) {
        List activityVoList = null;
        String stockPercent = null;
        String storeCode = null;
        if (!Lang.isEmpty((Object)activityDefinitionId) && !Lang.isEmpty((Object)activityCode)) {
            if (this.secKillActivityCode.equals(activityCode)) {
                storeCode = this.secKillStoreCode;
            } else if (this.tuanGouActivityCode.equals(activityCode)) {
                storeCode = this.tuanGouStoreCode;
            }
            activityVoList = this.activityConfigurationApi.getGoodsListByActivityId(this.organizationCode, activityDefinitionId, activityCode, storeCode);
        }
        if (!Lang.isEmpty(activityVoList) && activityVoList.size() > 0 && this.secKillActivityCode.equals(activityCode)) {
            for (ActivityVo activityVo : activityVoList) {
                stockPercent = this.activityConfigurationApi.getStockPercent(activityDefinitionId, activityVo.getGoodsPicture().getGoods().getId());
                activityVo.setStockPercent(stockPercent);
            }
        }
        return activityVoList;
    }

    @RequestMapping(value={"/getSystemTime"})
    @ResponseBody
    public Map<String, Object> getSystemTime(Integer activityIndex, String activityCode) {
        Map map = this.activityConfigurationApi.getSystemTime(activityIndex, this.organizationCode, activityCode);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/getCurrentActivityId"})
    public String getCurrentActivityId(String activityCode) {
        String currentId = null;
        if (!Lang.isEmpty((Object)activityCode)) {
            currentId = this.activityConfigurationApi.getCurrentActivityId(this.organizationCode, activityCode);
        }
        return currentId;
    }

    @ResponseBody
    @RequestMapping(value={"/reload"})
    public String reload() {
        ArrayList<String> activityCodes = new ArrayList<String>();
        activityCodes.add(this.secKillActivityCode);
        activityCodes.add(this.tuanGouActivityCode);
        String result = this.activityConfigurationApi.reload(this.organizationCode, activityCodes);
        return result;
    }

    @RequestMapping(value={"/viewStock"}, method={RequestMethod.GET})
    public String viewStock() {
        return "goods/viewStock";
    }

    @RequestMapping(value={"/viewStock"}, method={RequestMethod.POST})
    @ResponseBody
    public String showStock() {
        Map seckill = this.activityConfigurationApi.getStockFromRedis(this.organizationCode, this.secKillActivityCode);
        Map tuangou = this.activityConfigurationApi.getStockFromRedis(this.organizationCode, this.tuanGouActivityCode);
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("seckill", seckill);
        map.put("tuangou", tuangou);
        String json = Jsons.map2json(map);
        logger.info(json);
        return json;
    }
}

