/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.cart;

import cart.api.CartApi;
import cart.api.CartItemApi;
import cart.api.dto.cart.CartDto;
import cart.api.dto.cart.CartItemDto;
import cart.api.vo.CartItemGroupVo;
import cart.api.vo.CartItemVo;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.cart.service.CartWebService;
import ctscore.web.service.cart.service.OrderWebService;
import ctscore.web.service.login.LoginService;
import ctscore.web.vo.SpecificationsVo;
import goods.api.GoodsConfigApi;
import goods.api.ProductApi;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductFashionDto;
import goods.model.Goods;
import goods.model.ProductFashion;
import goods.model.ProductFashionSpecification;
import goods.model.ProductStandard;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductFashionRepos;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.MemberFavoriteApi;
import member.api.dto.common.AddressDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import store.api.StoreApi;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.AddressUtils;
import utils.web.Webs;

@Controller
@RequestMapping(value={"/myCart"})
public class MyCartController {
    private static final Log log = Logs.getLog((String)MyCartController.class.getName());
    @MotanReferer
    CartApi cartApi;
    @Autowired
    LoginService loginService;
    @MotanReferer
    CartItemApi cartItemApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @Autowired
    CartWebService cartWebService;
    @Autowired
    OrderWebService orderWebService;
    @MotanReferer
    MemberFavoriteApi memberFavoriteApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @Autowired
    ProductFashionRepos productFashionRepos;
    @MotanReferer
    ProductApi productApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    OutsideProductApi outsideProductApi;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    AreaService areaService;
    @Autowired
    MapperFacade mapperFacade;
    @Value(value="${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @Value(value="${ctscore.organization.code}")
    private String organizationCode;

    @RequestMapping(value={"", "index", "index.html"})
    public String index(Map model, HttpServletRequest request, HttpServletResponse response) {
        List cartItemGroups;
        long methodStart = System.currentTimeMillis();
        log.info((Object)"### \u5f00\u59cb\u52a0\u8f7d\u8d2d\u7269\u8f66\u6570\u636e... ###");
        long memeberVoTime = System.currentTimeMillis();
        MemberVo memberVo = this.loginService.findMemberVo(request);
        log.info((Object)"\u83b7\u53d6 memberVo \u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - memeberVoTime});
        long defaultAddrTime = System.currentTimeMillis();
        Map defaultAddr = this.getIpAddressIds(request, response);
        log.info((Object)"\u83b7\u53d6\u9ed8\u8ba4\u5730\u5740\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - defaultAddrTime});
        long cartTime = System.currentTimeMillis();
        CartDto cart = this.cartApi.getUserCart(memberVo.getUser().getId());
        log.info((Object)"\u83b7\u53d6\u7528\u6237\u8d2d\u7269\u8f66\u6570\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartTime});
        Long cartItemGroupsTimer = System.currentTimeMillis();
        if (!Lang.isEmpty((Object)defaultAddr)) {
            String areaCode = (String)defaultAddr.get("townId");
            areaCode = Lang.isEmpty((Object)areaCode) ? (String)defaultAddr.get("areaId") : areaCode;
            areaCode = Lang.isEmpty((Object)areaCode) ? (String)defaultAddr.get("cityId") : areaCode;
            areaCode = Lang.isEmpty((Object)areaCode) ? (String)defaultAddr.get("provoiceId") : areaCode;
            cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(true), Boolean.valueOf(true), areaCode, null);
        } else {
            cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        }
        log.info((Object)"\u83b7\u53d6\u8d2d\u7269\u8f66\u5206\u7ec4\u6570\u636e\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemGroupsTimer});
        long cartItemGroupsSortTime = System.currentTimeMillis();
        cartItemGroups = this.cartApi.cartItemGroupsSort(cartItemGroups);
        log.info((Object)"\u8d2d\u7269\u8f66\u6392\u5e8f\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemGroupsSortTime});
        Long specificationTime = System.currentTimeMillis();
        HashMap specificationsMap = new HashMap();
        for (CartItemGroupVo cartItemGroupVo : cartItemGroups) {
            for (CartItemVo cartItemVo : cartItemGroupVo.getCartItems()) {
                Goods goodsPO = (Goods)this.goodsRepos.findOne((Serializable)((Object)cartItemVo.getGoodsId()));
                if (Lang.isEmpty((Object)goodsPO.getProductFashion()) || Lang.isEmpty((Object)goodsPO.getProductFashion().getProductFashionSpecifications())) continue;
                ArrayList<SpecificationsVo> specificationsVos = new ArrayList<SpecificationsVo>();
                if (Lang.isEmpty((Object)goodsPO.getProduct()) || Lang.isEmpty((Object)goodsPO.getProduct().getProductStandards())) continue;
                goodsPO.getProduct().getProductStandards().sort((productStandard1, productStandard2) -> {
                    if (Lang.isEmpty((Object)productStandard1) || Lang.isEmpty((Object)productStandard1.getShowIndex())) {
                        return -1;
                    }
                    if (Lang.isEmpty((Object)productStandard2) || Lang.isEmpty((Object)productStandard2.getShowIndex())) {
                        return 1;
                    }
                    return productStandard1.getShowIndex() > productStandard2.getShowIndex() ? 1 : -1;
                });
                block2: for (ProductStandard productStandard : goodsPO.getProduct().getProductStandards()) {
                    for (ProductFashionSpecification productFashionSpecification : goodsPO.getProductFashion().getProductFashionSpecifications()) {
                        if (productStandard.getIsDelete().booleanValue() || !productFashionSpecification.getStandardCode().equals(productStandard.getStandardCode())) continue;
                        SpecificationsVo specificationsVo = new SpecificationsVo(productStandard.getName(), productFashionSpecification.getValue());
                        specificationsVos.add(specificationsVo);
                        continue block2;
                    }
                }
                specificationsMap.put(cartItemVo.getGoodsId(), specificationsVos);
            }
        }
        model.put("specificationsMap", specificationsMap);
        log.info((Object)"\u89c4\u683c\u5904\u7406\u8017\u65f6\uff1a{} ms", new Object[]{System.currentTimeMillis() - specificationTime});
        long generatePriceResMapTime = System.currentTimeMillis();
        model = this.generatePriceResMap(request, cartItemGroups, null, model);
        log.info((Object)"\u6dfb\u52a0\u5404\u9879\u91d1\u989d\u5408\u8ba1\u5230\u8fd4\u56de\u6570\u636e\u96c6\u5408\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - generatePriceResMapTime});
        long addressMapTime = System.currentTimeMillis();
        Map addressMap = this.getIpAddressIds(request, response);
        log.info((Object)"\u83b7\u53d6\u5730\u5740\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - addressMapTime});
        model.putAll(addressMap);
        if (request.getProtocol().compareTo("HTTP/1.0") == 0) {
            response.setHeader("Pragma", "no-cache");
        } else if (request.getProtocol().compareTo("HTTP/1.1") == 0) {
            response.setHeader("Cache-Control", "no-cache");
        }
        model.put("itaipingUserCenterGoods", this.itaipingUserCenterGoods);
        log.info((Object)"### \u52a0\u8f7d\u8d2d\u7269\u8f66\u6570\u636e\u603b\u8017\u65f6 {} ms ###", new Object[]{System.currentTimeMillis() - methodStart});
        return "cart/myCart/index";
    }

    @RequestMapping(value={"testAddCartItemApi"})
    public String testAddCartItemApi(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        return "myCart/testCartItemAdd";
    }

    @RequestMapping(value={"add", "add.json"})
    @ResponseBody
    public Map add(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>(6);
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("error", 0);
        rsMap.put("message", "suc");
        MemberVo memberVo = this.loginService.findMemberVo(request);
        params.put("userId", memberVo.getUser().getId());
        if (Lang.isEmpty((Object)params.get("counts"))) {
            params.put("counts", 1);
        } else {
            String countsStr = params.get("counts").toString();
            if (Lang.isEmpty((Object)countsStr)) {
                params.put("counts", 1);
            } else {
                try {
                    params.put("counts", Integer.parseInt(countsStr));
                }
                catch (NumberFormatException nfe) {
                    params.put("counts", 1);
                }
            }
        }
        boolean isUp = this.goodsConfigApi.isUpGoodsId((String)params.get("goodsId"), this.organizationCode);
        if (!isUp) {
            rsMap.put("status", "error");
            rsMap.put("data", null);
            rsMap.put("error", "DOWN");
            rsMap.put("message", "\u5546\u54c1\u5df2\u4e0b\u67b6");
            rsMap.put("carts", this.cartApi.getCartSize((String)request.getSession().getAttribute("user_id_itaiping")));
            return rsMap;
        }
        long addGoodsToCartTimer = System.currentTimeMillis();
        Map addRs = this.cartApi.addGoods(params);
        log.info((Object)"\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66\u8017\u65f6 {} \u79d2", new Object[]{(double)(System.currentTimeMillis() - addGoodsToCartTimer) / 1000.0});
        Integer addGoodsErr = (Integer)addRs.get("error");
        CartItemDto addResData = (CartItemDto)addRs.get("data");
        HashMap<String, Object> rsData = new HashMap<String, Object>(2);
        if (addResData != null) {
            rsData.put("carItemId", addResData.getId());
            rsData.put("count", addResData.getCount());
        }
        if (addGoodsErr == null || addGoodsErr != 0) {
            rsMap.put("status", "error");
            rsMap.put("data", null);
            rsMap.put("error", addGoodsErr);
            switch (addGoodsErr) {
                case 1: {
                    rsMap.put("message", "\u4ea7\u54c1\u89c4\u683c\u4e0d\u5b58\u5728");
                    break;
                }
                case 2: {
                    rsMap.put("message", "\u4ea7\u54c1\u4e0d\u5b58\u5728");
                    break;
                }
                case 3: {
                    rsMap.put("message", "\u8d85\u51fa\u5e93\u5b58");
                }
            }
            rsMap.put("message", "suc");
        }
        rsMap.put("data", rsData);
        rsMap.put("carts", this.cartApi.getCartSize((String)request.getSession().getAttribute("user_id_itaiping")));
        return rsMap;
    }

    @RequestMapping(value={"refresh", "refresh.json"})
    @ResponseBody
    public Map refreshCart(String cartId, String areaCode, Boolean getShippingFee, String addressId, Boolean refreshStock, @RequestParam(value="cartItemIds[]", required=false) ArrayList<String> cartItemIds, @RequestParam Map<String, Object> params, HttpServletRequest request, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info((Object)"### \u5f00\u59cb\u5237\u65b0\u8d2d\u7269\u8f66 ... ###");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        String userId = (String)request.getSession().getAttribute("user_id_itaiping");
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("message", "success");
        refreshStock = refreshStock == null ? true : refreshStock;
        long cartTime = System.currentTimeMillis();
        CartDto cart = this.cartApi.getUserCart(userId);
        log.info((Object)"\u67e5\u8be2\u8d2d\u7269\u8f66\u5bf9\u8c61\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartTime});
        if (cart != null) {
            Map<String, Double> resData = new HashMap<String, Double>();
            long cartItemGroupsTime = System.currentTimeMillis();
            List cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(true), refreshStock, areaCode, cartItemIds);
            log.info((Object)"\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u5206\u7ec4\u6570\u636e\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemGroupsTime});
            if (getShippingFee != null && getShippingFee.booleanValue() && !Lang.isEmpty((Object)addressId)) {
                Double shippingFee = 0.0;
                for (CartItemGroupVo group : cartItemGroups) {
                    if (Lang.isEmpty((Object)addressId)) continue;
                    long feeTime = System.currentTimeMillis();
                    BigDecimal fee = this.orderWebService.queryCartShippingFee(group.getStoreId(), group.getCartItems(), addressId);
                    log.info((Object)"\u67e5\u8be2\u8fd0\u8d39\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - feeTime});
                    if (fee != null) {
                        shippingFee = shippingFee + fee.doubleValue();
                    }
                    group.setShippingFee(fee);
                }
                resData.put("shippingFee", shippingFee);
            }
            long cartItemGroupsSortTime = System.currentTimeMillis();
            cartItemGroups = this.cartApi.cartItemGroupsSort(cartItemGroups);
            log.info((Object)"\u8d2d\u7269\u8f66\u5546\u54c1\u5206\u7ec4\u6392\u5e8f\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemGroupsSortTime});
            long generatePriceTime = System.currentTimeMillis();
            resData = this.generatePriceResMap(request, cartItemGroups, null, resData);
            log.info((Object)"\u8d2d\u7269\u8f66\u751f\u6210\u4ef7\u683c\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - generatePriceTime});
            for (CartItemGroupVo cartItemGroup : cartItemGroups) {
                for (CartItemVo cartItemVo : cartItemGroup.getCartItems()) {
                    ProductFashionDto productFashion = (ProductFashionDto)this.mapperFacade.map((Object)cartItemVo.getProductFashion(), ProductFashionDto.class);
                    productFashion.setSalePrice(productFashion.getSalePrice().setScale(2, 0));
                }
            }
            rsMap.put("data", resData);
        }
        log.info((Object)"\u5237\u65b0\u8d2d\u7269\u8f66\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
        return rsMap;
    }

    @RequestMapping(value={"refreshFashion", "refreshFashion.json"})
    @ResponseBody
    public Map refreshFashionState(String fashionId, String productId, String areaCode, Integer counts, @RequestParam Map<String, Object> params, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> rsMap = new HashMap<String, String>(4);
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("message", "success");
        ProductFashion fashion = (ProductFashion)this.productFashionRepos.findOne((Serializable)((Object)fashionId));
        if (fashion != null) {
            FashionStockStateVo vo;
            Map areaNodeList = this.addressCommonApi.areaCodeNodeList(areaCode);
            FashionStatusRequetVo fashionStatusRequetVo = new FashionStatusRequetVo();
            fashionStatusRequetVo.setProvinceCode((String)areaNodeList.get(1));
            fashionStatusRequetVo.setCityCode((String)areaNodeList.get(2));
            fashionStatusRequetVo.setCountyCode((String)areaNodeList.get(3));
            fashionStatusRequetVo.setTownCode((String)areaNodeList.get(4));
            fashionStatusRequetVo.setFashionNums(new ArrayList());
            fashionStatusRequetVo.getFashionNums().add(new FashionNumsVo(fashion.getId(), fashion.getProductCode(), new Long(counts.intValue())));
            HandlerRespVo stateRes = this.outsideProductApi.getFashionStockState(this.storeApi.getStoreInfo(fashion.getProduct().getStoreId()), fashionStatusRequetVo);
            if (!Lang.isEmpty((Object)stateRes.getData()) && !(vo = (FashionStockStateVo)((List)stateRes.getData()).get(0)).getOnSale().booleanValue()) {
                log.info((Object)"\u5546\u54c1\u5df2\u4e0b\u67b6");
                vo.setStockFlag(Integer.valueOf(0));
            }
            rsMap.put("data", (String)stateRes);
        }
        return rsMap;
    }

    @RequestMapping(value={"itemDel", "itemDel.json"})
    @ResponseBody
    public Map deleteFromCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("message", "suc");
        String cartItemId = (String)params.get("cartItemId");
        String cartItemIdsStr = (String)params.get("cartItemId");
        Object[] cartItemIds = cartItemIdsStr.split(",");
        MemberVo memberVo = this.loginService.findMemberVo(request);
        CartDto cart = this.cartApi.getUserCart(memberVo.getUser().getId());
        CartItemDto cartItem = this.cartItemApi.findById(cartItemId);
        Map apiRes = this.cartApi.deleteItem(cart.getId(), (String[])cartItemIds);
        cart = this.cartApi.getUserCart(memberVo.getUser().getId());
        List cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        cartItemGroups = this.cartApi.cartItemGroupsSort(cartItemGroups);
        List deletedItemIds = Lang.isEmpty((Object)cartItemIds) ? new ArrayList() : Lang.newList((Object[])cartItemIds);
        for (CartItemGroupVo group : cartItemGroups) {
            if (group == null) continue;
            for (CartItemVo item : group.getCartItems()) {
                if (!deletedItemIds.contains(item.getId())) continue;
                deletedItemIds.remove(item.getId());
            }
        }
        HashMap rsData = new HashMap();
        HashMap returnData = new HashMap();
        returnData.put("deletedItemIds", deletedItemIds);
        returnData.putAll(apiRes);
        rsMap.put("data", this.generatePriceResMap(request, cartItemGroups, cartItemIds.length > 1 ? null : cartItem.getStoreId(), returnData));
        return rsMap;
    }

    @RequestMapping(value={"invalidDel", "invalidDel.json"})
    @ResponseBody
    public Map<String, Object> deleteInvalidFromCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("message", "success");
        MemberVo memberVo = this.loginService.findMemberVo(request);
        CartDto cart = this.cartApi.getUserCart(memberVo.getUser().getId());
        Map apiRes = this.cartWebService.deleteInvalidItems(memberVo.getUser().getId());
        cart = this.cartApi.getUserCart(memberVo.getUser().getId());
        List cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        cartItemGroups = this.cartApi.cartItemGroupsSort(cartItemGroups);
        ArrayList<String> deletedItemIds = new ArrayList<String>();
        if (!Lang.isEmpty((Object)apiRes) && !Lang.isEmpty(apiRes.get("detials"))) {
            List details = (List)apiRes.get("detials");
            for (Map m : details) {
                deletedItemIds.add((String)m.get("id"));
            }
        }
        HashMap rsData = new HashMap();
        HashMap<String, ArrayList<String>> returnData = new HashMap<String, ArrayList<String>>();
        returnData.put("deletedItemIds", deletedItemIds);
        if (!Lang.isEmpty((Object)apiRes)) {
            returnData.putAll(apiRes);
        }
        rsMap.put("data", this.generatePriceResMap(request, cartItemGroups, null, returnData));
        return rsMap;
    }

    @RequestMapping(value={"/cartList.json"})
    @ResponseBody
    public Map userCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, String> rsMap = new HashMap<String, String>();
        rsMap.put("status", "0");
        rsMap.put("data", null);
        rsMap.put("msg", "suc");
        MemberVo memberVo = this.loginService.findMemberVo(request);
        rsMap.put("data", (String)memberVo);
        System.out.println("memberVo" + memberVo);
        return rsMap;
    }

    @RequestMapping(value={"/carItem/changeCounts.json"})
    @ResponseBody
    public Map cartItemCountsChg(Long counts, String cartItemId, String areaCode, @RequestParam(value="cartItemIds[]", required=false) ArrayList<String> cartItemIds, String debug, HttpServletRequest request) {
        long methodStartTime = System.currentTimeMillis();
        log.info((Object)"### \u5f00\u59cb\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf ... ###");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("message", "suc");
        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = this.loginService.findMemberVo(request);
        log.info((Object)"\u83b7\u53d6 memberVo \u8017\u65f6 ms", new Object[]{System.currentTimeMillis() - memberVoTime});
        long cartTime = System.currentTimeMillis();
        CartDto cart = this.cartApi.getUserCart(memberVo.getUser().getId());
        log.info((Object)"\u83b7\u53d6\u8d2d\u7269\u8f66\u5bf9\u8c61\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartTime});
        long cartItemTime = System.currentTimeMillis();
        CartItemDto cartItem = this.cartItemApi.findById(cartItemId);
        log.info((Object)"\u83b7\u53d6\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u636e\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemTime});
        if (cart != null && cartItem != null) {
            counts = counts <= 0L ? 1L : counts;
            Long changeCountTimer = System.currentTimeMillis();
            Map apiRes = this.cartApi.cartItemCountsChg(cartItemId, counts, areaCode);
            log.info((Object)"\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u8017\u65f6 {} \u79d2", new Object[]{(double)(System.currentTimeMillis() - changeCountTimer) / 1000.0});
            if ("success".equals(apiRes.get("status").toString())) {
                cartTime = System.currentTimeMillis();
                cart = this.cartApi.getUserCart(memberVo.getUser().getId());
                log.info((Object)"\u91cd\u65b0\u83b7\u53d6\u8d2d\u7269\u8f66\u5bf9\u8c61\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemTime});
                long cartItemGroupsTime = System.currentTimeMillis();
                List cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(false), Boolean.valueOf(true), areaCode, cartItemIds);
                log.info((Object)"\u83b7\u53d6\u6309\u5e97\u94fa\u5206\u7ec4\u7684\u8d2d\u7269\u8f66\u5546\u54c1\u5217\u8868\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemGroupsTime});
                long cartItemGroupsSortTime = System.currentTimeMillis();
                cartItemGroups = this.cartApi.cartItemGroupsSort(cartItemGroups);
                log.info((Object)"\u8d2d\u7269\u8f66\u5546\u54c1\u5217\u8868\u6392\u5e8f\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - cartItemGroupsSortTime});
                CartItemVo cartItemVo = null;
                for (CartItemGroupVo groupVo : cartItemGroups) {
                    for (CartItemVo item : groupVo.getCartItems()) {
                        if (!item.getId().equals(cartItemId)) continue;
                        cartItemVo = item;
                    }
                }
                HashMap<String, Number> returnDataMap = new HashMap<String, Number>();
                if (cartItemVo != null) {
                    returnDataMap.put("cartItemSumPrice", cartItemVo.getProductFashion().getSalePrice().setScale(0, 2).multiply(new BigDecimal(cartItemVo.getCount())));
                    returnDataMap.put("itemCounts", cartItemVo.getCount());
                }
                rsMap.put("status", "success");
                rsMap.put("data", this.generatePriceResMap(request, cartItemGroups, cartItem.getStoreId(), returnDataMap));
                rsMap.put("message", "Success");
            } else {
                rsMap.put("status", "error");
                rsMap.put("error", apiRes.get("error"));
                rsMap.put("data", null);
                rsMap.put("message", apiRes.get("message"));
            }
        } else {
            rsMap.put("status", "error");
            rsMap.put("error", 4);
            rsMap.put("data", null);
            rsMap.put("message", "\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u8d2d\u7269\u8f66\u4fe1\u606f\uff01");
        }
        log.info((Object)"### \u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
        return rsMap;
    }

    @RequestMapping(value={"/carItem/favAdd", "/carItem/favAdd.json"})
    @ResponseBody
    public Map addCartItemToFav(String cartItemId, String debug, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("msg", "suc");
        String[] cartItemIds = cartItemId.split(",");
        ArrayList<String> idsForDel = new ArrayList<String>();
        String emptyCheck = this.makeFeildEmptyMsg(new String[]{"cartItemId"}, new Object[]{cartItemId});
        if (emptyCheck != null) {
            rsMap.put("status", "error");
            rsMap.put("error", 1);
            rsMap.put("data", null);
            rsMap.put("message", emptyCheck);
        } else {
            MemberVo memberVo = this.loginService.findMemberVo(request);
            CartDto cart = this.cartApi.getUserCart(memberVo.getUser().getId());
            for (String cid : cartItemIds) {
                Object favorite;
                CartItemDto cartItem = this.cartItemApi.findById(cid);
                if (cartItem == null || (favorite = this.memberFavoriteApi.addFavorite(memberVo.getMember().getId(), "PRODUCT_ID", cartItem.getProductId())) == null) continue;
                idsForDel.add(cid);
            }
            Map apiRes = this.cartApi.deleteItem(cart.getId(), idsForDel.toArray(new String[idsForDel.size()]));
            cart = this.cartApi.getUserCart(memberVo.getUser().getId());
            List cartItemGroups = this.cartWebService.findCartItemGroups(request, cart, "1", Boolean.valueOf(false), Boolean.valueOf(false), null, null);
            cartItemGroups = this.cartApi.cartItemGroupsSort(cartItemGroups);
            ArrayList<String> deletedItemIds = new ArrayList<String>();
            if (!Lang.isEmpty((Object)apiRes) && !Lang.isEmpty(apiRes.get("detials"))) {
                List details = (List)apiRes.get("detials");
                for (Map m : details) {
                    deletedItemIds.add((String)m.get("id"));
                }
            }
            HashMap rsData = new HashMap();
            HashMap<String, ArrayList<String>> returnData = new HashMap<String, ArrayList<String>>();
            returnData.put("deletedItemIds", deletedItemIds);
            returnData.putAll(apiRes);
            rsMap.put("data", this.generatePriceResMap(request, cartItemGroups, null, returnData));
        }
        return rsMap;
    }

    private String makeFeildEmptyMsg(String[] fields, Object[] values) {
        StringBuilder sb = new StringBuilder();
        sb.append("Required fields: ");
        boolean isEmpty = false;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                isEmpty = true;
            } else if (values[i] instanceof String) {
                isEmpty = StringUtils.isBlank((CharSequence)((String)values[i]));
            }
            if (!isEmpty) continue;
            sb.append(fields[i]);
            if (i >= values.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" Redjected Empty Value");
        return isEmpty ? sb.toString() : null;
    }

    private Map<String, Object> generatePriceResMap(HttpServletRequest request, List<CartItemGroupVo> cartItemGroups, String storeId) {
        return this.generatePriceResMap(request, cartItemGroups, storeId, null);
    }

    private Map<String, Object> generatePriceResMap(HttpServletRequest request, List<CartItemGroupVo> cartItemGroups, String storeId, Map<String, Object> resMap) {
        HashMap<String, Object> hashMap = resMap = resMap == null ? new HashMap<String, Object>() : resMap;
        if (StringUtils.isNotBlank((CharSequence)storeId)) {
            resMap.put("storeSumPrice", this.cartWebService.findStoreSumPrice(cartItemGroups, storeId));
        }
        int validCounts = 0;
        for (CartItemGroupVo g : cartItemGroups) {
            if (Lang.isEmpty((Object)g)) continue;
            validCounts += g.getValidCounts().intValue();
        }
        Double sumPrice = this.cartWebService.calSumCartPrice(cartItemGroups);
        resMap.put("validCounts", validCounts);
        resMap.put("sumCartPrice", sumPrice);
        resMap.put("sumMarketCartPrice", this.cartWebService.calSumMarketCartPrice(cartItemGroups));
        resMap.put("sumGoodsCount", this.cartWebService.calSumGoodsCount(cartItemGroups));
        resMap.put("sumCartItemCounts", this.cartWebService.calSumCartItemCounts(cartItemGroups));
        resMap.put("cartItemGroups", cartItemGroups);
        return resMap;
    }

    public void setAddressId(String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        String cityId = (String)request.getSession().getAttribute("AREA_LEVEL_CITY_ID");
        String areaId = (String)request.getSession().getAttribute("AREA_LEVEL_AREA_ID");
        if (!Lang.isEmpty((Object)sessionProvoiceId)) {
            if (!provoiceId.equals(sessionProvoiceId)) {
                returnProvoiceId = provoiceId;
                request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
            } else {
                returnProvoiceId = sessionProvoiceId;
            }
        } else {
            returnProvoiceId = provoiceId;
            request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
            request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
            request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
        }
        Map addressMap = this.areaService.getAddressIdSByParams(request, returnProvoiceId);
        returnCityId = (String)addressMap.get("cityId");
        returnAreaId = (String)addressMap.get("areaId");
        String returnTownId = (String)addressMap.get("townId");
        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, returnAddressIdMap);
    }

    public Map getIpAddressIds(HttpServletRequest request, HttpServletResponse response) {
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        Map returnMap = this.areaService.getAddressIdSByParams(request, sessionProvoiceId);
        return returnMap;
    }

    public void setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if (Lang.isEmpty((Object)areaId)) {
            throw new NullPointerException("areaId not null");
        }
        HashMap addressMap = Maps.newHashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = areaId;
        String returnTownId = null;
        AddressDto address = this.addressCommonApi.findById(returnAreaId);
        AddressDto parent = null;
        if (!Lang.isEmpty((Object)address)) {
            parent = address.getParent();
            if (address.getLevelType().equals("4")) {
                returnTownId = address.getId();
                returnAreaId = parent.getId();
                parent = parent.getParent();
            }
            if (!Lang.isEmpty((Object)parent)) {
                returnCityId = parent.getId();
                if (!Lang.isEmpty((Object)parent.getParent())) {
                    returnProvoiceId = parent.getParent().getId();
                }
            }
        }
        addressMap.put("provoiceId", returnProvoiceId);
        addressMap.put("cityId", returnCityId);
        addressMap.put("areaId", returnAreaId);
        addressMap.put("townId", returnTownId);
        AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, (Map)addressMap);
    }

    public Map getCityAndAreaId(String provoiceId) {
        AddressDto addr;
        AddressDto c;
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        AddressDto a = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(true));
        if (a != null && (c = this.addressCommonApi.findFirstChild(returnAreaId = (addr = this.addressCommonApi.findFirstChild(returnCityId = a.getId(), Boolean.valueOf(false))).getId(), Boolean.valueOf(true))) != null) {
            returnTownId = c.getId();
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp((HttpServletRequest)request);
        if (!Lang.isEmpty((Object)remoteIp)) {
            Long ipL = IPtoLong.ipToLong((String)remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty((Object)cityId) && Lang.isEmpty((Object)areaId)) {
                currentAaddress = this.addressCommonApi.findAreaByIp(ipL, 3);
                if (Lang.isEmpty((Object)currentAaddress)) {
                    currentAaddress = this.addressCommonApi.findAreaByIp(ipL, 2);
                    if (Lang.isEmpty((Object)currentAaddress)) {
                        returnCityId = (String)this.getCityAndAreaId(provoiceId).get("cityId");
                        returnAreaId = (String)this.getCityAndAreaId(provoiceId).get("areaId");
                    } else {
                        AddressDto c;
                        returnCityId = currentAaddress.getId();
                        AddressDto a = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(false));
                        if (a != null && !Lang.isEmpty((Object)(returnAreaId = a.getId())) && (c = this.addressCommonApi.findFirstChild(returnAreaId, Boolean.valueOf(false))) != null) {
                            returnTownId = c.getId();
                        }
                    }
                } else {
                    returnAreaId = currentAaddress.getId();
                    returnCityId = currentAaddress.getParent().getId();
                }
            } else if (!Lang.isEmpty((Object)cityId) && !Lang.isEmpty((Object)areaId)) {
                returnAreaId = areaId;
                returnCityId = cityId;
            } else if (!Lang.isEmpty((Object)cityId) && Lang.isEmpty((Object)areaId)) {
                returnCityId = cityId;
                AddressDto a = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(false));
                if (a != null) {
                    returnAreaId = a.getId();
                }
            } else if (Lang.isEmpty((Object)cityId) && !Lang.isEmpty((Object)areaId)) {
                returnAreaId = areaId;
                AddressDto address = this.addressCommonApi.findById(areaId);
                if (!Lang.isEmpty((Object)address)) {
                    returnCityId = address.getParent().getId();
                }
            }
        } else {
            returnCityId = (String)this.getCityAndAreaId(provoiceId).get("cityId");
            returnAreaId = (String)this.getCityAndAreaId(provoiceId).get("areaId");
            returnTownId = (String)this.getCityAndAreaId(provoiceId).get("townId");
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }
}

