/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.cart;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.goods.GoodsDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import cart.api.CartApi;
import cart.api.CartItemApi;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentConfigDto;
import cart.api.dto.payment.PaymentDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.OrderSubmitVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.api.CtScoreApi;
import ctscore.web.config.BaseAction;
import ctscore.web.service.cart.service.CartWebService;
import ctscore.web.service.cart.service.OrderWebService;
import ctscore.web.service.login.LoginService;
import ctscore.web.service.member.ScoreUserService;
import ctscore.web.vo.SpecificationsVo;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductFashionApi;
import goods.model.ProductFashion;
import goods.model.ProductFashionSpecification;
import goods.model.ProductStandard;
import goods.model.repository.ProductFashionRepos;
import goods.vo.FashionIdAndCountVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.MemberInvoinceApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import message.api.Dto.VerifyCodeDto;
import message.api.sms.SmsApi;
import message.api.sms.vo.SmsReq;
import message.api.sms.vo.SmsRsp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import sinomall.config.api.base.BaseResponse;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.Jsons;
import utils.date.DateUtils;
import utils.lock.RedisLockUtil;
import utils.rpc.motan.ApiResponseVo;
import utils.string.StringUtils;

@Controller
@RequestMapping(value={"/order"})
public class OrderController
extends BaseAction {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    RedisLockUtil redisLockUtil;
    @Value(value="${ctscore.storeCode:}")
    String storeCode;
    @Value(value="${spring.profiles.active:}")
    private String activeEnv;
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Autowired
    ScoreUserService scoreUserService;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    ActivityApi activityApi;
    @MotanReferer
    ScoreApi scoreApi;
    @Autowired
    LoginService loginService;
    @MotanReferer
    CtScoreApi ctScoreApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Value(value="${moon-festival.activityCode}")
    String moonFestivalActivityCode;
    @Value(value="${secKillActivity.activityCode}")
    String secKillActivityCode;
    @Value(value="${tuanGouActivity.activityCode}")
    String tuanGouActivityCode;
    @Value(value="${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;
    @Value(value="${itaiping.usercenter.order}")
    private String itaipingUserCenterOrder;
    @Value(value="${ctscore.score.proportion}")
    private String itaipingScoreProportion;
    public static final String MOBILE_SERVICE_ID = "ChengTong_SubmitOrder";
    @MotanReferer
    private GoodsConfigApi goodsConfigApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    CartWebService cartWebService;
    @Autowired
    OrderWebService orderWebService;
    @MotanReferer
    CartItemApi cartItemApi;
    @MotanReferer
    CartApi cartApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    PaymentApi paymentApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @Autowired
    ProductFashionRepos productFashionRepos;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    SmsApi smsApi;

    @RequestMapping(value={"/newOrder", "/newOrder.json", "/newOrder.html"}, method={RequestMethod.POST})
    @ResponseBody
    public Map newOrder(Map model, HttpServletRequest request) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u8ba2\u5355 ... ###");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("message", "suc");
        String cartItemIdsStr = request.getParameter("cartItemIds");
        String productFashionIdStr = request.getParameter("productFashionIds");
        String countsStr = request.getParameter("counts");
        String areaCode = request.getParameter("areaCode");
        String goodsId = request.getParameter("goodsId");
        long organizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
        TempOrderVo tempOrder = null;
        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = this.loginService.findMemberVo(request);
        log.info("\u83b7\u53d6 memberVo \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - memberVoTime));
        if (!Lang.isEmpty((Object)productFashionIdStr) && !Lang.isEmpty((Object)countsStr)) {
            boolean isUp;
            String[] productFashionIds = productFashionIdStr.split(",");
            String[] buyCounts = countsStr.split(",");
            String[] goodsIds = goodsId.split(",");
            if (!Lang.isEmpty((Object)goodsId) && !(isUp = this.goodsConfigApi.isUpGoodsIds(Arrays.asList(goodsIds), this.organizationCode))) {
                rsMap.put("status", "error");
                rsMap.put("error", "DOWN");
                rsMap.put("message", "\u5546\u54c1\u5df2\u4e0b\u67b6");
                return rsMap;
            }
            ArrayList<FashionDetailVo> fashionDetailVoList = new ArrayList<FashionDetailVo>();
            ArrayList<String> fashionIdList = new ArrayList<String>();
            ArrayList<Integer> fashionCountList = new ArrayList<Integer>();
            for (int i = 0; i < productFashionIds.length; ++i) {
                if (Lang.isEmpty((Object)productFashionIds[i])) continue;
                fashionIdList.add(productFashionIds[i].trim());
                fashionCountList.add(Integer.parseInt(buyCounts[i]));
                fashionDetailVoList.add(new FashionDetailVo(productFashionIds[i].trim(), goodsIds[i].trim(), Integer.valueOf(Integer.parseInt(buyCounts[i]))));
            }
            Long checkItemStockStatusTimer = System.currentTimeMillis();
            Map stockQueyrRes = this.productFashionApi.queryFashionStockStatus(this.mapperFacade.mapAsList(fashionDetailVoList, FashionIdAndCountVo.class), areaCode, organizationId);
            log.info("\u68c0\u67e5\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - checkItemStockStatusTimer));
            boolean noStockFlag = true;
            if ("success".equals((String)stockQueyrRes.get("status"))) {
                noStockFlag = noStockFlag && (Boolean)((Map)stockQueyrRes.get("data")).get("noStockFlag") != false;
            } else {
                if (noStockFlag) {
                    // empty if block
                }
                noStockFlag = false;
            }
            boolean activityStockCheck = true;
            if (!noStockFlag) {
                Long newTempOrderByCartItemsTimer = System.currentTimeMillis();
                tempOrder = this.orderMainApi.newTempOrderByFasions(fashionDetailVoList, this.organizationCode, areaCode);
                log.info("\u751f\u6210\u4e34\u65f6\u8ba2\u5355\u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - newTempOrderByCartItemsTimer) / 1000.0));
                block1: for (TempOrderStoreVo tempOrderStoreVo : tempOrder.getStoreList()) {
                    for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                        if (Lang.isEmpty((Object)tempOrderItemVo.getActivityId())) continue;
                        long activityDefinitionTime = System.currentTimeMillis();
                        ActivityDefinitionDto activityDefinition = this.activityApi.findById(tempOrderItemVo.getActivityId());
                        if (this.moonFestivalActivityCode.equals(activityDefinition.getActivityCode())) {
                            tempOrderItemVo.setActivityId(null);
                            continue;
                        }
                        log.info("\u67e5\u8be2\u6d3b\u52a8\u573a\u6b21\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - activityDefinitionTime));
                        int stock = this.activityGoodsApi.getCurrentActivityGoodsStockFromCache(this.organizationCode, tempOrderItemVo.getGoodsId(), tempOrderItemVo.getActivityId(), activityDefinition.getActivityCode());
                        Date now = new Date();
                        if (now.before(activityDefinition.getBeginTime()) || now.after(activityDefinition.getEndTime())) {
                            request.getSession().removeAttribute("ORDER_TEMP_ID");
                            rsMap.put("status", "error");
                            rsMap.put("error", 5);
                            rsMap.put("message", "\u4e0d\u5728\u6d3b\u52a8\u65f6\u9650\u5185!");
                            return rsMap;
                        }
                        if (this.secKillActivityCode.equals(activityDefinition.getActivityCode()) && tempOrderItemVo.getCount() > 1) {
                            request.getSession().removeAttribute("ORDER_TEMP_ID");
                            rsMap.put("status", "error");
                            rsMap.put("error", 6);
                            rsMap.put("message", "\u5bf9\u4e0d\u8d77\uff0c\u8be5\u5546\u54c1\u9650\u8d2d1\u4ef6\uff0c\u8bf7\u8c03\u6574\u60a8\u7684\u8d2d\u4e70\u6570\u91cf\uff0c\u8c22\u8c22!");
                            return rsMap;
                        }
                        if (stock - tempOrderItemVo.getCount() >= 0) continue;
                        activityStockCheck = false;
                        continue block1;
                    }
                }
            }
            if (activityStockCheck && !noStockFlag) {
                tempOrder.setRealOrganizationId(organizationId);
                request.getSession().setAttribute("TEMP_ORDER_ID:" + tempOrder.getTmpOrderNo(), (Object)JSON.toJSONString((Object)tempOrder));
                request.getSession().setAttribute("ORDER_TEMP_ID", (Object)tempOrder.getTmpOrderNo());
                HashMap<String, String> resData = new HashMap<String, String>();
                resData.put("orderTmpId", tempOrder.getTmpOrderNo());
                rsMap.put("data", resData);
            } else {
                request.getSession().removeAttribute("ORDER_TEMP_ID");
                rsMap.put("status", "error");
                rsMap.put("error", 3);
                rsMap.put("message", "Overed Stock!");
            }
        } else if (!Lang.isEmpty((Object)cartItemIdsStr)) {
            if (memberVo != null) {
                String[] cartItemIdsArr = cartItemIdsStr.split(",");
                List<String> cartItemIds = null;
                if (!Lang.isEmpty((Object)cartItemIdsArr)) {
                    cartItemIds = Arrays.asList(cartItemIdsArr);
                }
                Long checkItemStockStatusTimer = System.currentTimeMillis();
                Map apiRes = this.cartApi.cartItemStockStatus(cartItemIds, areaCode);
                log.info("\u68c0\u67e5\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - checkItemStockStatusTimer));
                boolean stockFlag = true;
                if ("success".equals((String)apiRes.get("status"))) {
                    List dataList = (List)apiRes.get("data");
                    for (Map d : dataList) {
                        if (Lang.isEmpty(d.get("onSale"))) {
                            d.put("onSale", false);
                        }
                        if (Lang.isEmpty(d.get("stockFlag"))) {
                            d.put("stockFlag", 0);
                        }
                        if (((Boolean)d.get("onSale")).booleanValue() && (Integer)d.get("stockFlag") == 1) continue;
                        stockFlag = false;
                    }
                } else {
                    stockFlag = false;
                }
                if (stockFlag) {
                    Long newTempOrderByCartItemsTimer = System.currentTimeMillis();
                    tempOrder = this.orderMainApi.newTempOrderByCartItems(cartItemIds, memberVo.getUser().getId(), this.organizationCode, areaCode);
                    log.info("\u751f\u6210\u4e34\u65f6\u8ba2\u5355\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - newTempOrderByCartItemsTimer));
                    tempOrder.setRealOrganizationId(organizationId);
                    request.getSession().setAttribute("TEMP_ORDER_ID:" + tempOrder.getTmpOrderNo(), (Object)JSON.toJSONString((Object)tempOrder));
                    request.getSession().setAttribute("ORDER_TEMP_ID", (Object)tempOrder.getTmpOrderNo());
                    HashMap<String, String> resData = new HashMap<String, String>();
                    resData.put("orderTmpId", tempOrder.getTmpOrderNo());
                    rsMap.put("data", resData);
                } else {
                    request.getSession().removeAttribute("ORDER_TEMP_ID");
                    rsMap.put("status", "error");
                    rsMap.put("error", 3);
                    rsMap.put("message", "Overed Stock!");
                }
            } else {
                rsMap.put("status", "error");
                rsMap.put("error", 2);
                rsMap.put("message", "Member Not Found!");
            }
        } else {
            rsMap.put("status", "error");
            rsMap.put("error", 1);
            rsMap.put("message", "Required Paramter cartItemIds Is Empty!");
        }
        log.info("### \u521b\u5efa\u4e34\u65f6\u8ba2\u5355\u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStartTime));
        return rsMap;
    }

    private Map<String, List<SpecificationsVo>> getSpecificationMap(TempOrderVo tempOrder) {
        HashMap<String, List<SpecificationsVo>> specificationsMap = new HashMap<String, List<SpecificationsVo>>();
        for (TempOrderStoreVo tempOrderStoreVo : tempOrder.getStoreList()) {
            for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                ProductFashion productFashion = (ProductFashion)this.productFashionRepos.findOne((Serializable)((Object)tempOrderItemVo.getProductFashionId()));
                if (Lang.isEmpty((Object)productFashion.getProductFashionSpecifications())) continue;
                ArrayList<SpecificationsVo> specificationsVos = new ArrayList<SpecificationsVo>();
                if (!Lang.isEmpty((Object)productFashion.getProduct().getProductStandards())) {
                    productFashion.getProduct().getProductStandards().sort((productStandard1, productStandard2) -> {
                        if (Lang.isEmpty((Object)productStandard1) || Lang.isEmpty((Object)productStandard1.getShowIndex())) {
                            return -1;
                        }
                        if (Lang.isEmpty((Object)productStandard2) || Lang.isEmpty((Object)productStandard2.getShowIndex())) {
                            return 1;
                        }
                        return productStandard1.getShowIndex() > productStandard2.getShowIndex() ? 1 : -1;
                    });
                    block2: for (ProductStandard productStandard : productFashion.getProduct().getProductStandards()) {
                        for (ProductFashionSpecification productFashionSpecification : productFashion.getProductFashionSpecifications()) {
                            if (Lang.isEmpty((Object)productFashion.getProduct()) || Lang.isEmpty((Object)productFashion.getProduct().getProductStandards()) || Lang.isEmpty((Object)productFashionSpecification.getIsDelete()) || productFashionSpecification.getIsDelete().booleanValue() || productStandard.getIsDelete().booleanValue() || !productStandard.getStandardCode().equals(productFashionSpecification.getStandardCode())) continue;
                            SpecificationsVo specificationsVo = new SpecificationsVo(productStandard.getName(), productFashionSpecification.getValue());
                            specificationsVos.add(specificationsVo);
                            continue block2;
                        }
                    }
                }
                specificationsMap.put(tempOrderItemVo.getGoodsId(), specificationsVos);
            }
        }
        return specificationsMap;
    }

    @RequestMapping(value={"/orderInfo", "/orderInfo.action", "/orderInfo.html"})
    public String orderInfo(Map model, HttpServletRequest request, HttpServletResponse response) {
        String orderTmpId = request.getParameter("rid");
        String callBack = request.getParameter("callBack");
        MemberVo memberVo = this.loginService.findMemberVo(request);
        model.put("error", 1);
        Object tmpCartItems = null;
        boolean toOrderFlag = false;
        if (memberVo != null) {
            String tempOrderSessionKey = "TEMP_ORDER_ID:" + orderTmpId;
            String tempOrderJson = (String)request.getSession().getAttribute(tempOrderSessionKey);
            if (Lang.isEmpty((Object)tempOrderJson)) {
                model.put("error", 1);
                model.put("message", "REC_NOT_FOUND");
            } else {
                TempOrderVo tempOrderVo = (TempOrderVo)JSON.parseObject((String)tempOrderJson, TempOrderVo.class);
                List memberAddressList = this.memberAddressApi.list(memberVo.getMember().getId());
                model.put("memberAddressList", memberAddressList);
                Double sumCartPrice = 0.0;
                Integer sumCartItemCount = 0;
                MemberAddressDto defAddr = null;
                if (memberAddressList != null) {
                    for (MemberAddressDto memberAddress : memberAddressList) {
                        if (memberAddress == null || memberAddress.getIsDefault() == null || !memberAddress.getIsDefault().booleanValue()) continue;
                        defAddr = memberAddress;
                    }
                    defAddr = defAddr == null ? (memberAddressList.size() >= 1 ? (MemberAddressDto)memberAddressList.get(0) : null) : defAddr;
                }
                Double shippingFee = 0.0;
                for (TempOrderStoreVo group : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo item : group.getOrderItems()) {
                        Object goods;
                        Map activityPrice;
                        if (this.activityConfigurationApi.isInActivity(this.organizationCode).booleanValue() && ((Boolean)(activityPrice = this.activityGoodsApi.isActivityGoodsAndGetActivityPrice((GoodsDto)this.mapperFacade.map(goods = this.goodsApi.findById(item.getGoodsId()), GoodsDto.class), this.organizationCode)).get("isActivityGoods")).booleanValue()) {
                            item.setSalePrice((BigDecimal)activityPrice.get("activityPrice"));
                        }
                        item.setSalePrice(item.getSalePrice().setScale(2, 0));
                        sumCartPrice = sumCartPrice + item.getSalePrice().multiply(BigDecimal.valueOf(item.getCount().intValue())).doubleValue();
                        goods = sumCartItemCount;
                        Integer n = sumCartItemCount = Integer.valueOf(sumCartItemCount + 1);
                        if (!Lang.isEmpty((Object)item.getActivityId())) {
                            ActivityDefinitionDto activityDefinition = this.activityApi.findById(item.getActivityId());
                            if (Lang.isEmpty((Object)activityDefinition)) continue;
                            if (this.secKillActivityCode.equals(activityDefinition.getActivityCode())) {
                                log.info("___\u79d2\u6740\u6d3b\u52a8\u5546\u54c1___ \u573a\u6b21ID: {}", (Object)item.getActivityId());
                                tempOrderVo.setFreeShippingFee(Boolean.valueOf(true));
                            }
                            if (!this.tuanGouActivityCode.equals(activityDefinition.getActivityCode())) continue;
                            log.info("___\u56e2\u8d2d\u6d3b\u52a8\u5546\u54c1___ \u573a\u6b21ID: {}", (Object)item.getActivityId());
                            tempOrderVo.setFreeShippingFee(Boolean.valueOf(true));
                            continue;
                        }
                        log.info("___\u975e\u6d3b\u52a8\u5546\u54c1___");
                    }
                    BigDecimal fee = BigDecimal.ZERO;
                    fee = defAddr != null ? this.orderWebService.queryShippingFee(group.getStoreId(), group.getOrderItems(), defAddr.getId()) : this.orderWebService.queryShippingFee(group.getStoreId(), group.getOrderItems(), tempOrderVo.getAreaCode());
                    if (fee != null) {
                        shippingFee = shippingFee + fee.doubleValue();
                    }
                    group.setShippingFee(fee);
                }
                tempOrderVo.setSumShippingFee(new BigDecimal(shippingFee));
                try {
                    this.calculateOrderScorePriceInfo(request, tempOrderSessionKey, tempOrderVo, new BigDecimal(shippingFee), new BigDecimal(sumCartPrice));
                    model.put("needPayPrice", tempOrderVo.getNeedPayPrice());
                    model.put("sumCartPrice", tempOrderVo.getSumPrice());
                    model.put("sumScore", tempOrderVo.getSumScore());
                    model.put("socrePrice", tempOrderVo.getSocrePrice());
                    if (tempOrderVo.getFreeShippingFee().booleanValue()) {
                        model.put("shippingFee", 0);
                    } else {
                        model.put("shippingFee", tempOrderVo.getSumShippingFee());
                    }
                    model.put("userType", memberVo.getUser().getUserType());
                    model.put("USER_TYPE_BUYER", CoreUserDto.USER_TYPE_BUYER);
                    model.put("USER_TYPE_MEMBER", CoreUserDto.USER_TYPE_MEMBER);
                    if (tempOrderVo.getStoreList().size() <= 0 || sumCartItemCount <= 0) {
                        model.put("error", 3);
                        model.put("message", "CART_ITEMS_NOT_FOUND");
                    } else {
                        model.put("error", 0);
                    }
                    model.put("sumCartPrice", sumCartPrice);
                    model.put("sumGoodsCount", tempOrderVo.getSumGoodsCount());
                    model.put("sumCartItemCounts", tempOrderVo.getSumGoodsBuyCount());
                    model.put("tempOrderVo", tempOrderVo);
                    model.put("rid", orderTmpId);
                    model.put("scorePortion", this.scorePortion);
                    Long getSpecificationTime = System.currentTimeMillis();
                    try {
                        Map specificationsMap = this.getSpecificationMap(tempOrderVo);
                        model.put("specificationsMap", specificationsMap);
                    }
                    catch (Exception e) {
                        log.error("\u52a0\u8f7d\u89c4\u683c\u53c2\u6570\u5f02\u5e38", (Object)e, (Object)tempOrderVo);
                    }
                    log.info("\u52a0\u8f7d\u89c4\u683c\u53c2\u6570\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getSpecificationTime));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            model.put("error", 2);
            model.put("message", "Member_Not_Found");
        }
        if (Lang.isEmpty((Object)orderTmpId)) {
            model.put("error", 1);
            model.put("message", "REC_NOT_FOUND");
        }
        if (memberVo != null && memberVo.getUser() != null && !Lang.isEmpty((Object)memberVo.getUser().getPhone())) {
            String phoneMask = memberVo.getUser().getPhone().substring(0, 3) + "****" + memberVo.getUser().getPhone().substring(7);
            model.put("phoneMask", phoneMask);
        }
        String email = memberVo.getUser().getEmail();
        model.put("email", email);
        model.put("callBack", callBack);
        return "cart/order/insuredOrderInfo";
    }

    public void calculateOrderScorePriceInfo(HttpServletRequest request, String tempOrderSessionKey, TempOrderVo tempOrderVo, BigDecimal shippingFee, BigDecimal sumCartPrice) {
        BigDecimal proportion = new BigDecimal(this.itaipingScoreProportion);
        try {
            CoreUserDto coreUser = this.loginService.getSessionCoreUser(request);
            BigDecimal sumScore = this.scoreUserService.getUsebleScore(coreUser);
            BigDecimal totalPriceBigDecimal = sumCartPrice;
            if (!tempOrderVo.getFreeShippingFee().booleanValue()) {
                totalPriceBigDecimal = sumCartPrice.add(shippingFee);
            }
            BigDecimal scorePrice = this.scoreUserService.roundScore(this.goodsApi.scorePriceTransform(sumScore, proportion, 4));
            BigDecimal userSumScore = this.scoreUserService.roundScore(this.goodsApi.priceScoreTransform(totalPriceBigDecimal, proportion, 4));
            BigDecimal needPayPrice = new BigDecimal(0);
            if (scorePrice.compareTo(totalPriceBigDecimal) < 0) {
                needPayPrice = totalPriceBigDecimal.subtract(scorePrice);
                userSumScore = sumScore;
            } else {
                scorePrice = totalPriceBigDecimal;
            }
            tempOrderVo.setSocrePrice(scorePrice);
            tempOrderVo.setNeedPayPrice(needPayPrice);
            tempOrderVo.setSumScore(userSumScore);
            tempOrderVo.setSumShippingFee(shippingFee);
            tempOrderVo.setSumPrice(sumCartPrice);
            request.getSession().setAttribute(tempOrderSessionKey, (Object)JSON.toJSONString((Object)tempOrderVo));
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u8ba2\u5355\u4fe1\u606f\u51fa\u9519\uff0ctempOrderVo={}", (Object)JSON.toJSONString((Object)tempOrderVo), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/orderSubmit", "/orderSubmit.action", "/orderSubmit.html"}, method={RequestMethod.POST})
    public String orderSubmit(OrderSubmitVo orderSubmitVo, Map model, HttpServletRequest request, RedirectAttributes attr) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u63d0\u4ea4\u8ba2\u5355 ... ###");
        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = this.loginService.findMemberVo(request);
        log.info("\u83b7\u53d6 memberVo \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - memberVoTime));
        try {
            this.redisLockUtil.lock(memberVo.getMember().getId());
            String orderTmpId = orderSubmitVo.getRid();
            String useScorePay = request.getParameter("useScorePay");
            String USE_SCORE_FOR_PAY = "1";
            String NO_USE_SCORE_FOR_PAY = "0";
            useScorePay = Lang.isEmpty((Object)useScorePay) ? NO_USE_SCORE_FOR_PAY : useScorePay;
            String errorCode = "1";
            String rid = (String)request.getSession().getAttribute("ORDER_TEMP_ID");
            log.info("rid is {}", (Object)rid);
            log.info("orderTmpId is {}", (Object)orderTmpId);
            log.info("session id{}", (Object)request.getSession().getId());
            if (Lang.isEmpty((Object)rid) || !rid.equals(orderTmpId)) {
                attr.addAttribute("error", (Object)errorCode);
                attr.addAttribute("message", (Object)"\u8ba2\u5355\u63d0\u4ea4\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
                String string = "redirect:/order/orderSubmitResult";
                return string;
            }
            log.info("before remove rid{}", (Object)((String)request.getSession().getAttribute("ORDER_TEMP_ID")));
            request.getSession().removeAttribute("ORDER_TEMP_ID");
            log.info("after  remove rid{}", (Object)((String)request.getSession().getAttribute("ORDER_TEMP_ID")));
            log.info("imcome submit order");
            Map resMap = null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderTmpId)) {
                TempOrderVo tempOrderVo = (TempOrderVo)JSON.parseObject((String)((String)request.getSession().getAttribute("TEMP_ORDER_ID:" + rid)), TempOrderVo.class);
                ArrayList<String> cartItemIds = new ArrayList<String>();
                for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                        if (!Lang.isEmpty((Object)itemVo.getActivityId())) {
                            long activityDefinitionTime = System.currentTimeMillis();
                            ActivityDefinitionDto activityDefinition = this.activityApi.findById(itemVo.getActivityId());
                            log.info("\u67e5\u8be2\u6d3b\u52a8\u573a\u6b21\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - activityDefinitionTime));
                            if (!Lang.isEmpty((Object)activityDefinition) && this.secKillActivityCode.equals(activityDefinition.getActivityCode())) {
                                long activityLimitedTime = System.currentTimeMillis();
                                boolean activityLimited = this.activityGoodsApi.isActivityLimited(memberVo.getMember().getId(), itemVo.getActivityId(), 1);
                                log.info("\u79d2\u6740\u5546\u54c1\u8d85\u9650\u68c0\u67e5\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - activityLimitedTime));
                                if (itemVo.getCount() > 1 || activityLimited) {
                                    model.put("error", "ACTIVITY_LIMITED");
                                    attr.addAttribute("error", (Object)"ACTIVITY_LIMITED");
                                    attr.addAttribute("message", (Object)"\u60a8\u5df2\u8d85\u9650");
                                    String string = "redirect:/order/orderSubmitResult";
                                    return string;
                                }
                            }
                        }
                        if (Lang.isEmpty((Object)itemVo.getCartItemId())) continue;
                        cartItemIds.add(itemVo.getCartItemId());
                    }
                }
                ArrayList orderMainsPaiedIds = new ArrayList();
                if (tempOrderVo != null) {
                    tempOrderVo.setUseScore(useScorePay);
                    if (tempOrderVo.getOrderAttrs() == null) {
                        tempOrderVo.setOrderAttrs(new ArrayList());
                    }
                    if (orderSubmitVo.getOrderAttrs() != null) {
                        tempOrderVo.setOrderAttrs(orderSubmitVo.getOrderAttrs());
                    }
                    tempOrderVo.setBuyType(request);
                    orderSubmitVo.setPayMethodCode(PaymentConfigDto.PAYMENT_CONFIG_CODE_ONLINE);
                    long createOrderTimer = System.currentTimeMillis();
                    resMap = this.orderMainApi.createOrder(tempOrderVo, this.memberAddressApi.findById(orderSubmitVo.getAddressId()).getId(), memberVo.getUser().getId(), memberVo.getMember().getId(), orderSubmitVo.getPayMethodCode());
                    log.info("\u521b\u5efa\u6b63\u5f0f\u8ba2\u5355\u8017\u65f6 {} ms, memberId {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - createOrderTimer, memberVo.getMember().getId(), JSON.toJSONString((Object)resMap)});
                    if (!resMap.get("status").equals("error")) {
                        HashMap returnMap;
                        OrganizationDto organization;
                        BigDecimal usableScore;
                        boolean isNeePay;
                        StringBuilder orderNos;
                        List sucOrders;
                        BigDecimal consumeeScore;
                        block66: {
                            block67: {
                                block68: {
                                    consumeeScore = this.scoreUserService.roundScore(new BigDecimal(0));
                                    model.putAll(resMap);
                                    Map resData = (Map)resMap.get("data");
                                    if (Lang.isEmpty((Object)resData)) {
                                        attr.addAttribute("error", (Object)"NEW_ORDER_FAIL");
                                        attr.addAttribute("message", (Object)"\u4e0b\u5355\u5931\u8d25");
                                        String string = "redirect:/order/orderSubmitResult";
                                        return string;
                                    }
                                    sucOrders = (List)resData.get("sucOrderList");
                                    orderNos = new StringBuilder();
                                    if (!Lang.isEmpty((Object)sucOrders)) {
                                        for (int i = 0; i < sucOrders.size(); ++i) {
                                            orderNos.append(((OrderMainDto)sucOrders.get(i)).getOrderNo());
                                            if (i >= sucOrders.size() - 1) continue;
                                            orderNos.append(",");
                                        }
                                        attr.addAttribute("orderNo", (Object)orderNos.toString());
                                    }
                                    long makeOrderStatusNewTime = System.currentTimeMillis();
                                    log.info("\u6b63\u5728\u66f4\u65b0\u8ba2\u5355 {} \u72b6\u6001 ---> \u65b0\u5efa", (Object)orderNos);
                                    sucOrders.forEach(orderMainDto -> this.orderMainApi.updateOrderStatus(orderMainDto.getId(), "0"));
                                    log.info("\u66f4\u65b0\u8ba2\u5355 {} \u72b6\u6001\u8017\u65f6 {} ms", (Object)orderNos, (Object)(System.currentTimeMillis() - makeOrderStatusNewTime));
                                    isNeePay = true;
                                    usableScore = null;
                                    if (USE_SCORE_FOR_PAY.equals(useScorePay)) {
                                        block65: {
                                            CoreUserDto coreUser = this.loginService.getSessionCoreUser(request);
                                            long usableScoreTime = System.currentTimeMillis();
                                            usableScore = this.scoreUserService.getUsebleScore(coreUser);
                                            log.info("\u83b7\u53d6\u7528\u6237\u53ef\u7528\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u7528\u6237\u79ef\u5206 {}", new Object[]{System.currentTimeMillis() - usableScoreTime, orderNos, usableScore});
                                            consumeeScore = this.scoreUserService.roundScore(tempOrderVo.getSumScore());
                                            if (usableScore.compareTo(consumeeScore) >= 0) break block65;
                                            log.info("\u79ef\u5206\u4e0d\u8db3 \u8ba2\u5355\u53f7 {}, \u7528\u6237\u79ef\u5206 {}, \u8ba2\u5355\u79ef\u5206 {} ", new Object[]{orderNos, usableScore, tempOrderVo.getSumScore()});
                                            attr.addAttribute("error", (Object)"SCORE_NO_ENOUGH");
                                            attr.addAttribute("message", (Object)"\u5269\u4f59\u79ef\u5206\u4e0d\u8db3");
                                            for (int i = 0; i < sucOrders.size(); ++i) {
                                                long updateOrderStatus = System.currentTimeMillis();
                                                this.orderMainApi.updateOrderStatus(((OrderMainDto)sucOrders.get(i)).getId(), "9");
                                                log.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u72b6\u6001 {} ", new Object[]{System.currentTimeMillis() - updateOrderStatus, sucOrders.get(i), OrderMainDto.order_status.get("9")});
                                            }
                                            String i = "redirect:/order/orderSubmitResult";
                                            return i;
                                        }
                                        try {
                                            if (tempOrderVo.getNeedPayPrice().compareTo(new BigDecimal(0)) == 0) {
                                                isNeePay = false;
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    long organizationTime = System.currentTimeMillis();
                                    organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
                                    log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
                                    if (organization.getOrgScore().compareTo(consumeeScore) < 0) {
                                        log.info("\u8bda\u901a\u4f01\u4e1a\u79ef\u5206\u4f59\u989d\u4e0d\u8db3");
                                        attr.addAttribute("error", (Object)"ORG_SCORE_NOT_ENOUHG");
                                        attr.addAttribute("message", (Object)"\u4f01\u4e1a\u79ef\u5206\u4e0d\u8db3");
                                        for (int i = 0; i < sucOrders.size(); ++i) {
                                            long updateOrderStatus = System.currentTimeMillis();
                                            this.orderMainApi.updateOrderStatus(((OrderMainDto)sucOrders.get(i)).getId(), "9");
                                            log.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u72b6\u6001 {} ", new Object[]{System.currentTimeMillis() - updateOrderStatus, sucOrders.get(i), OrderMainDto.order_status.get("9")});
                                        }
                                        String i = "redirect:/order/orderSubmitResult";
                                        return i;
                                    }
                                    for (OrderMainDto orderMain : sucOrders) {
                                        long storeTime = System.currentTimeMillis();
                                        StoreDto store = this.storeApi.findByStoreId(orderMain.getStoreId());
                                        log.info("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - storeTime));
                                        StoreExtDto storeExt = store.getStoreExt();
                                        if (this.storeCode.equals(storeExt.getCode())) continue;
                                        log.error("\u4e0b\u5355\u51fa\u9519,\u82cf\u5b81\u5546\u54c1\u4e0d\u80fd\u4e0b\u5355");
                                        attr.addAttribute("error", (Object)"NEW_ORDER_FAIL");
                                        for (int i = 0; i < sucOrders.size(); ++i) {
                                            long updateOrderStatus = System.currentTimeMillis();
                                            this.orderMainApi.updateOrderStatus(((OrderMainDto)sucOrders.get(i)).getId(), "9");
                                            log.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u72b6\u6001 {} ", new Object[]{System.currentTimeMillis() - updateOrderStatus, sucOrders.get(i), OrderMainDto.order_status.get("9")});
                                        }
                                        String i = "redirect:/order/orderSubmitResult";
                                        return i;
                                    }
                                    log.info("\u4e0b\u5355\u8ba2\u5355\u6570\u636e\uff1aorders={},tempOrderVo={},isNeePay={},useScorePay={}", new Object[]{JSON.toJSONString((Object)sucOrders), JSON.toJSONString((Object)tempOrderVo), isNeePay, useScorePay});
                                    try {
                                        if (!isNeePay) break block66;
                                        returnMap = new HashMap();
                                        log.info("\u6b63\u5728\u9884\u5360\u5e93\u5b58, \u8ba2\u5355\u53f7 {}", (Object)orderNos);
                                        long takeOrderTime = System.currentTimeMillis();
                                        boolean takeOrderFlag = this.occupyStockInAdvance(sucOrders, returnMap);
                                        log.info("\u9884\u5360\u5e93\u5b58\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - takeOrderTime, orderNos, takeOrderFlag});
                                        if (!takeOrderFlag) break block67;
                                        long stockStatusTime = System.currentTimeMillis();
                                        boolean stockStatus = this.changeActivityGoodsStock(sucOrders);
                                        log.info("\u6d3b\u52a8\u5546\u54c1\u5e93\u5b58\u68c0\u67e5\u6263\u51cf\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - stockStatusTime, orderNos, stockStatus});
                                        if (stockStatus) break block68;
                                        log.info("=========\u6d3b\u52a8\u5546\u54c1\u4e0b\u5355\u51cf\u5e93\u5b58\u5931\u8d25\uff0c\u5e93\u5b58\u4e0d\u8db3========memberId={},orderNos={}", (Object)memberVo.getMember().getId(), (Object)orderNos);
                                        long cancelOrdersTime = System.currentTimeMillis();
                                        this.cancelOrders(cartItemIds, sucOrders);
                                        log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                                        model.put("error", "NO_STOCK");
                                        attr.addAttribute("error", (Object)"NO_STOCK");
                                        attr.addAttribute("message", (Object)"\u5546\u54c1\u5df2\u62a2\u5149");
                                        String string = "redirect:/order/orderSubmitResult";
                                        return string;
                                    }
                                    catch (Exception e) {
                                        log.error("\u4e0b\u5355\u51fa\u9519", (Throwable)e);
                                        attr.addAttribute("error", (Object)"NEW_ORDER_FAIL");
                                        String string = "redirect:/order/orderSubmitResult";
                                        return string;
                                    }
                                }
                                log.info("\u73b0\u91d1\u652f\u4ed8orderNos={}\u9884\u5360\u5e93\u5b58\u6210\u529f\uff0cuseScorePay={}", (Object)orderNos, (Object)useScorePay);
                                if (USE_SCORE_FOR_PAY.equals(useScorePay) && consumeeScore.compareTo(new BigDecimal(0)) > 0) {
                                    long expenseOrgScoreTime = System.currentTimeMillis();
                                    boolean expenseOrgScore = this.expenseOrgScore(attr, consumeeScore, orderNos, organization.getId());
                                    log.info("\u6263\u51cf\u4f01\u4e1a\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - expenseOrgScoreTime), (Object)orderNos);
                                    if (!expenseOrgScore) {
                                        long backSolcNumTime = System.currentTimeMillis();
                                        this.backActivityGoodsStockAndSolcNum(sucOrders, this.organizationCode);
                                        log.info("\u6d3b\u52a8\u5546\u54c1\u8fd4\u8fd8\u5e93\u5b58\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - backSolcNumTime), (Object)orderNos);
                                        long cancelOrdersTime = System.currentTimeMillis();
                                        this.cancelOrders(cartItemIds, sucOrders);
                                        log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                                        String string = "redirect:/order/orderSubmitResult";
                                        return string;
                                    }
                                    long payScoreTime = System.currentTimeMillis();
                                    boolean isSuccessPayScore = this.payScore(request, attr, sucOrders, orderMainsPaiedIds, usableScore, isNeePay);
                                    log.info("\u6263\u51cf\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - payScoreTime), (Object)orderNos);
                                    if (!isSuccessPayScore) {
                                        long backSolcNumTime = System.currentTimeMillis();
                                        this.backActivityGoodsStockAndSolcNum(sucOrders, this.organizationCode);
                                        log.info("\u6d3b\u52a8\u5546\u54c1\u8fd4\u8fd8\u5e93\u5b58\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - backSolcNumTime), (Object)orderNos);
                                        long payBackScoreTime = System.currentTimeMillis();
                                        BigDecimal orgNeedPayBackScore = this.payBackScore(sucOrders, orderMainsPaiedIds);
                                        log.info("\u8fd4\u8fd8\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - payBackScoreTime), (Object)orderNos);
                                        if (orgNeedPayBackScore.compareTo(new BigDecimal(0)) > 0) {
                                            long refundOrgScoreTime = System.currentTimeMillis();
                                            this.refundOrgScore(organization.getId(), orgNeedPayBackScore, orderNos);
                                            log.info("\u8fd4\u56de\u4f01\u4e1a\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - refundOrgScoreTime), (Object)orderNos);
                                        }
                                        long cancelOrdersTime = System.currentTimeMillis();
                                        this.cancelOrders(cartItemIds, sucOrders);
                                        log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                                        String string = "redirect:/order/orderSubmitResult";
                                        return string;
                                    }
                                    log.info("\u73b0\u91d1\u652f\u4ed8orderNos={},\u79ef\u5206\u62b5\u6263\u6210\u529f", (Object)orderNos);
                                }
                                log.info("\u73b0\u91d1\u652f\u4ed8orderNos={},\u8df3\u8f6c\u73b0\u91d1\u652f\u4ed8\u9875", (Object)orderNos);
                                long makeOrderStatusNeedPayTime = System.currentTimeMillis();
                                log.info("\u6b63\u5728\u66f4\u65b0\u8ba2\u5355 {} \u72b6\u6001 ---> \u5f85\u4ed8\u6b3e", (Object)orderNos);
                                sucOrders.forEach(orderMainDto -> this.orderMainApi.updateOrderStatus(orderMainDto.getId(), "1"));
                                log.info("\u66f4\u65b0\u8ba2\u5355 {} \u72b6\u6001\u8017\u65f6 {} ms", (Object)orderNos, (Object)(System.currentTimeMillis() - makeOrderStatusNeedPayTime));
                                String expenseOrgScore = "redirect:/showPayGateWay";
                                return expenseOrgScore;
                            }
                            long cancelOrdersTime = System.currentTimeMillis();
                            this.cancelOrders(cartItemIds, sucOrders);
                            log.info("\u9884\u5360\u5e93\u5b58\u5931\u8d25, \u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                            errorCode = (String)returnMap.get("returnCode");
                            attr.addAttribute("resultCode", returnMap.get("returnCode"));
                            attr.addAttribute("message", returnMap.get("returnMsg"));
                            attr.addAttribute("error", (Object)(Lang.isEmpty((Object)errorCode) ? "OCCUPY_STOCK_FAIL" : errorCode));
                            String stockStatus = "redirect:/order/orderSubmitResult";
                            return stockStatus;
                        }
                        log.info("\u8ba2\u5355\u53f7 {}, \u7eaf\u79ef\u5206\u652f\u4ed8", (Object)orderNos);
                        returnMap = new HashMap();
                        long takeOrderTime = System.currentTimeMillis();
                        boolean takeOrderFlag = this.occupyStockInAdvance(sucOrders, returnMap);
                        log.info("\u9884\u5360\u5e93\u5b58\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - takeOrderTime, orderNos, takeOrderFlag});
                        if (takeOrderFlag) {
                            long stockStatusTime = System.currentTimeMillis();
                            boolean stockStatus = this.changeActivityGoodsStock(sucOrders);
                            log.info("\u6d3b\u52a8\u5546\u54c1\u5e93\u5b58\u68c0\u67e5\u6263\u51cf\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - stockStatusTime, orderNos, stockStatus});
                            if (!stockStatus) {
                                long cancelOrdersTime = System.currentTimeMillis();
                                this.cancelOrders(cartItemIds, sucOrders);
                                log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                                model.put("error", "NO_STOCK");
                                attr.addAttribute("error", (Object)"NO_STOCK");
                                attr.addAttribute("message", (Object)"\u5546\u54c1\u5df2\u62a2\u5149");
                                String expenseOrgScore = "redirect:/order/orderSubmitResult";
                                return expenseOrgScore;
                            }
                            log.info("\u7eaf\u79ef\u5206\u652f\u4ed8orderNos={}\u9884\u5360\u5e93\u5b58\u6210\u529f", (Object)orderNos);
                            long expenseOrgScoreTime = System.currentTimeMillis();
                            boolean expenseOrgScore = this.expenseOrgScore(attr, consumeeScore, orderNos, organization.getId());
                            log.info("\u6263\u51cf\u4f01\u4e1a\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - expenseOrgScoreTime), (Object)orderNos);
                            if (!expenseOrgScore) {
                                long backSolcNumTime = System.currentTimeMillis();
                                this.backActivityGoodsStockAndSolcNum(sucOrders, this.organizationCode);
                                log.info("\u6d3b\u52a8\u5546\u54c1\u8fd4\u8fd8\u5e93\u5b58\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - backSolcNumTime), (Object)orderNos);
                                long cancelOrdersTime = System.currentTimeMillis();
                                this.cancelOrders(cartItemIds, sucOrders);
                                log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                                String string = "redirect:/order/orderSubmitResult";
                                return string;
                            }
                            long payScoreTime = System.currentTimeMillis();
                            boolean isSuccessPayScore = this.payScore(request, attr, sucOrders, orderMainsPaiedIds, usableScore, isNeePay);
                            log.info("\u6263\u51cf\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - payScoreTime), (Object)orderNos);
                            if (!isSuccessPayScore) {
                                long backSolcNumTime = System.currentTimeMillis();
                                this.backActivityGoodsStockAndSolcNum(sucOrders, this.organizationCode);
                                log.info("\u6d3b\u52a8\u5546\u54c1\u8fd4\u8fd8\u5e93\u5b58\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - backSolcNumTime), (Object)orderNos);
                                long payBackScoreTime = System.currentTimeMillis();
                                BigDecimal orgNeedPayBackScore = this.payBackScore(sucOrders, orderMainsPaiedIds);
                                log.info("\u8fd4\u8fd8\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - payBackScoreTime), (Object)orderNos);
                                if (orgNeedPayBackScore.compareTo(new BigDecimal(0)) > 0) {
                                    long refundOrgScoreTime = System.currentTimeMillis();
                                    this.refundOrgScore(organization.getId(), orgNeedPayBackScore, orderNos);
                                    log.info("\u8fd4\u56de\u4f01\u4e1a\u79ef\u5206\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - refundOrgScoreTime), (Object)orderNos);
                                }
                                long cancelOrdersTime = System.currentTimeMillis();
                                this.cancelOrders(cartItemIds, sucOrders);
                                log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - cancelOrdersTime), (Object)orderNos);
                                model.put("error", "NO_STOCK");
                                attr.addAttribute("error", (Object)"NO_STOCK");
                                attr.addAttribute("message", (Object)"\u5546\u54c1\u5df2\u62a2\u5149");
                                String string = "redirect:/order/orderSubmitResult";
                                return string;
                            }
                            log.info("\u7eaf\u79ef\u5206\u652f\u4ed8orderNos={},\u79ef\u5206\u62b5\u6263\u6210\u529f", (Object)orderNos);
                            try {
                                for (OrderMainDto orderMain : sucOrders) {
                                    long confirmOrderTime = System.currentTimeMillis();
                                    this.orderMainApi.confirmOrder(orderMain.getOrderNo());
                                    log.info("\u786e\u8ba4\u8ba2\u5355\u8017\u65f6 {} ms, \u8ba2\u5355\u53f7 {}", (Object)(System.currentTimeMillis() - confirmOrderTime), (Object)orderNos);
                                    log.info("\u7eaf\u79ef\u5206\u652f\u4ed8orderNo={},\u786e\u8ba4\u4e0b\u5355\u6210\u529f", (Object)orderMain.getOrderNo());
                                }
                            }
                            catch (Exception e) {
                                log.error("\u786e\u8ba4\u9884\u5360\u5e93\u5b58\u51fa\u9519\uff0csucOrders={}", (Object)JSON.toJSONString((Object)sucOrders), (Object)e);
                            }
                        } else {
                            long cancelOrdersTime = System.currentTimeMillis();
                            this.cancelOrders(cartItemIds, sucOrders);
                            log.info("\u53d6\u6d88\u8ba2\u5355\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - cancelOrdersTime));
                            attr.addAttribute("error", (Object)"OCCUPY_STOCK_FAIL");
                            String string = "redirect:/order/orderSubmitResult";
                            return string;
                        }
                        attr.addAttribute("orderNos", (Object)orderNos.toString());
                        String string = "redirect:/order/orderSubmitResult";
                        return string;
                    }
                    long reduceDeledCartItemsTime = System.currentTimeMillis();
                    this.cartApi.reduceDeledCartItems(cartItemIds);
                    log.info("\u5220\u9664\u8d2d\u7269\u8f66\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - reduceDeledCartItemsTime));
                    if ("1".equals(resMap.get("error").toString())) {
                        model.put("error", "ORDER_PRICE_ERROR");
                        attr.addAttribute("error", (Object)"ORDER_PRICE_ERROR");
                        String string = "redirect:/order/orderSubmitResult";
                        return string;
                    }
                    model.put("error", "NEW_ORDER_FAIL");
                    attr.addAttribute("error", (Object)"NEW_ORDER_FAIL");
                    String string = "redirect:/order/orderSubmitResult";
                    return string;
                }
                attr.addAttribute("error", (Object)"OVER_TIME");
                String string = "redirect:/order/orderSubmitResult";
                return string;
            }
            String string = "redirect:/order/orderSubmitResult";
            return string;
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            attr.addAttribute("error", (Object)"NEW_ORDER_FAIL");
        }
        finally {
            this.redisLockUtil.unlock(memberVo.getMember().getId());
        }
        model.put("error", "NEW_ORDER_FAIL");
        return "redirect:/order/orderSubmitResult";
    }

    private void backActivityGoodsStockAndSolcNum(List<OrderMainDto> orderMains, String organizationCode) {
        for (OrderMainDto orderMain : orderMains) {
            for (OrderItemDto orderItem : orderMain.getOrderItems()) {
                if (Lang.isEmpty((Object)orderItem.getActivityId())) continue;
                this.activityGoodsApi.backActivityGoodsStockAndSolcNum(orderItem.getGoodsId(), orderItem.getActivityId(), orderItem.getCount(), organizationCode);
            }
        }
    }

    private boolean refundOrgScore(String orgId, BigDecimal consumeeScore, StringBuilder orderNos) {
        try {
            ApiResponseVo apiResponseVo = this.organizationApi.refundOrganizationScore(orgId, consumeeScore, orderNos.toString());
            if (!"success".equals(apiResponseVo.getStatus())) {
                log.error("\u4f01\u4e1a\u8fd4\u8fd8\u79ef\u5206\u5931\u8d25,orderNos={}", (Object)orderNos, (Object)new RuntimeException("\u4f01\u4e1a\u8fd4\u8fd8\u79ef\u5206\u5931\u8d25"));
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u4f01\u4e1a\u8fd4\u8fd8\u79ef\u5206\u5931\u8d25,orderNos={}", (Object)orderNos, (Object)e);
        }
        return true;
    }

    private boolean expenseOrgScore(RedirectAttributes attr, BigDecimal consumeeScore, StringBuilder orderNos, String orgId) {
        try {
            ApiResponseVo apiResponseVo = this.organizationApi.expenseOrgScore(orgId, consumeeScore, orderNos.toString());
            if (!"success".equals(apiResponseVo.getStatus())) {
                log.error("\u4f01\u4e1a\u79ef\u5206\u6263\u51cf\u5931\u8d25\uff0corderNos={}", (Object)orderNos.toString(), (Object)new RuntimeException("\u4f01\u4e1a\u79ef\u5206\u6263\u51cf\u5931\u8d25"));
                attr.addAttribute("error", (Object)"ORG_SCORE_EXPENSE_ERROR");
                attr.addAttribute("message", (Object)"\u4f01\u4e1a\u79ef\u5206\u6263\u51cf\u5931\u8d25");
                return false;
            }
        }
        catch (Exception e) {
            attr.addAttribute("error", (Object)"ORG_SCORE_EXPENSE_ERROR");
            attr.addAttribute("message", (Object)"\u4f01\u4e1a\u79ef\u5206\u6263\u51cf\u5931\u8d25");
            log.error("\u4f01\u4e1a\u6263\u51cf\u79ef\u5206\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean occupyStockInAdvance(List<OrderMainDto> sucOrders, Map<String, Object> returnMap) {
        for (OrderMainDto orderMain : sucOrders) {
            returnMap.putAll(this.orderMainApi.occupyStock(orderMain));
            log.info("======{}", returnMap);
            String returnCode = returnMap.get("returnCode").toString();
            if (returnCode.equals("success")) continue;
            return false;
        }
        return true;
    }

    private boolean changeActivityGoodsStock(List<OrderMainDto> sucOrders) {
        for (OrderMainDto om : sucOrders) {
            for (OrderItemDto oi : om.getOrderItems()) {
                if (Lang.isEmpty((Object)oi.getActivityId())) continue;
                log.info("=======================\u6d3b\u52a8\u5546\u54c1\u51cf\u5e93\u5b58order_item={}", (Object)JSON.toJSONString((Object)om));
                if (!this.activityGoodsApi.changeActivityGoodsStock(oi.getGoodsId(), oi.getActivityId(), oi.getCount().intValue())) {
                    log.info("=======================\u6d3b\u52a8\u5546\u54c1\u51cf\u5e93\u5b58\u5931\u8d25order_item={}", (Object)JSON.toJSONString((Object)om));
                    return false;
                }
                log.info("=======================\u6d3b\u52a8\u5546\u54c1\u51cf\u5e93\u5b58\u6210\u529forder_item={}", (Object)JSON.toJSONString((Object)om));
            }
        }
        return true;
    }

    public void cancelOrders(List<String> cartItemIds, List<OrderMainDto> sucOrders) {
        try {
            this.cartApi.reduceDeledCartItems(cartItemIds);
            for (OrderMainDto orderMain : sucOrders) {
                this.orderMainApi.cancelOrder(orderMain.getOrderNo(), OrderMainApi.CancelOrderType.ERROR);
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25 ,sucOrders={}", (Object)JSON.toJSONString(sucOrders), (Object)e);
        }
    }

    @RequestMapping(value={"/orderSubmitResult"})
    public String orderSubmit(String orderNos, String error, String message, HttpServletResponse response, Map model) {
        if (!Lang.isEmpty((Object)orderNos)) {
            String[] orderNosArray = orderNos.split(",");
            LinkedList<OrderMainDto> list = new LinkedList<OrderMainDto>();
            for (String no : orderNosArray) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)no)) continue;
                OrderMainDto orderMain = this.orderMainApi.findByOrderNo(no);
                list.add(orderMain);
                model.put("data", list);
            }
        }
        log.info("=====================error={}", (Object)error);
        model.put("error", error);
        model.put("message", message);
        model.put("CREATE_ORDER_ERROR_PRICE_ERROE", "ORDER_PRICE_ERROR");
        model.put("CREATE_ORDER_ERROR_NEW_ORDER_FAIL", "NEW_ORDER_FAIL");
        model.put("CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL", "OCCUPY_STOCK_FAIL");
        model.put("CREATE_ORDER_ERROR_OVER_TIME", "OVER_TIME");
        model.put("CREATE_ORDER_COST_CHANGED", "COST_CHANGED");
        model.put("CREATE_ORDER_ADDRESS_NOTFOUND", "ADDRESS_NOTFOUND");
        model.put("CREATE_ORDER_ERROR_PAY_SCORE", "PAY_SCORE");
        model.put("CREATE_ORDER_ERROR_SCORE_NO_ENOUGH", "SCORE_NO_ENOUGH");
        model.put("CREATE_ORDER_ERROR_ORG_SCORE_NOT_ENOUHG", "ORG_SCORE_NOT_ENOUHG");
        model.put("CREATE_ORDER_ERROR_ORG_SCORE_EXPENSE_ERROR", "ORG_SCORE_EXPENSE_ERROR");
        model.put("CREATE_ORDER_ERROR_NO_STOCK", "NO_STOCK");
        model.put("CREATE_ORDER_ERROR_ACTIVITY_LIMITED", "ACTIVITY_LIMITED");
        model.put("itaipingUserCenterOrder", this.itaipingUserCenterOrder);
        model.put("itaipingUserCenterGoods", this.itaipingUserCenterGoods);
        return "cart/order/orderSubmitResult";
    }

    @RequestMapping(value={"/test/cancelOrder"})
    @ResponseBody
    public String cancelOrderTest(String orderNo, HttpServletResponse response, Map model) {
        this.orderMainApi.cancelOrder(orderNo, OrderMainApi.CancelOrderType.USER);
        return "suc";
    }

    @RequestMapping(value={"/refreshTmpOrder", "/refreshTmpOrder.json"})
    @ResponseBody
    public Map refreshTempOrder(String rid, String addressId, Boolean getShippingFee, HttpServletRequest request, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u5237\u65b0\u4e34\u65f6\u8ba2\u5355 ... ###");
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("status", "success");
        returnMap.put("message", "SUCCESS");
        String tempOrderSessionKey = "TEMP_ORDER_ID:" + rid;
        String tempOrderJson = (String)request.getSession().getAttribute(tempOrderSessionKey);
        if (Lang.isEmpty((Object)tempOrderJson)) {
            returnMap.put("status", "error");
            returnMap.put("message", "REC_NOT_FOUND");
        } else {
            TempOrderVo tempOrderVo = (TempOrderVo)JSON.parseObject((String)tempOrderJson, TempOrderVo.class);
            ArrayList<FashionDetailVo> fashionDetailVoList = new ArrayList<FashionDetailVo>();
            long defAddrTime = System.currentTimeMillis();
            MemberAddressDto defAddr = this.memberAddressApi.findById(addressId);
            log.info("\u67e5\u8be2\u5730\u5740\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - defAddrTime));
            for (Object storeVo : tempOrderVo.getStoreList()) {
                for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                    fashionDetailVoList.add(new FashionDetailVo(itemVo.getProductFashionId(), itemVo.getGoodsId(), itemVo.getCount()));
                }
            }
            BigDecimal sumShippingFee = BigDecimal.valueOf(0L);
            if (getShippingFee.booleanValue()) {
                tempOrderVo.setSumShippingFee(sumShippingFee);
                for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                    long shippingFeeTime = System.currentTimeMillis();
                    BigDecimal shippingFee = this.orderWebService.queryShippingFee(storeVo.getStoreId(), storeVo.getOrderItems(), addressId);
                    log.info("\u67e5\u8be2\u8fd0\u8d39\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - shippingFeeTime));
                    storeVo.setShippingFee(shippingFee == null ? BigDecimal.valueOf(0L) : shippingFee);
                    sumShippingFee = tempOrderVo.getSumShippingFee().add(storeVo.getShippingFee());
                    for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                        fashionDetailVoList.add(new FashionDetailVo(itemVo.getProductFashionId(), itemVo.getGoodsId(), itemVo.getCount()));
                    }
                }
            }
            long calculateOrderScorePriceInfoTime = System.currentTimeMillis();
            this.calculateOrderScorePriceInfo(request, tempOrderSessionKey, tempOrderVo, sumShippingFee, tempOrderVo.getSumPrice());
            log.info("\u8ba1\u7b97\u8ba2\u5355\u79ef\u5206\u91d1\u989d\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - calculateOrderScorePriceInfoTime));
            long organizationIdTime = System.currentTimeMillis();
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
            log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationIdTime));
            long stockStatusTime = System.currentTimeMillis();
            Map stockStatusRes = this.productFashionApi.queryFashionStockStatus(this.mapperFacade.mapAsList(fashionDetailVoList, FashionIdAndCountVo.class), defAddr.getAreaCode(), organizationId);
            log.info("\u67e5\u8be2\u5e93\u5b58\u72b6\u6001\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - stockStatusTime));
            if (stockStatusRes.get("status").equals("success")) {
                List stockStatusDetails = (List)((Map)stockStatusRes.get("data")).get("details");
                for (TempOrderStoreVo s : tempOrderVo.getStoreList()) {
                    block5: for (TempOrderItemVo i : s.getOrderItems()) {
                        for (Map sRes : stockStatusDetails) {
                            if (!i.getProductFashionId().equals(sRes.get("fashionId"))) continue;
                            i.setStockCount(new Long(((Integer)sRes.get("stockCount")).intValue()));
                            if (!((Boolean)sRes.get("onSale")).booleanValue()) {
                                i.setStatus("2");
                                continue block5;
                            }
                            Integer stockFlag = (Integer)sRes.get("stockFlag");
                            i.setStatus(stockFlag == 0 ? "2" : "1");
                            continue block5;
                        }
                    }
                }
            } else {
                for (TempOrderStoreVo s : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo i : s.getOrderItems()) {
                        i.setStockCount(Long.valueOf(0L));
                        i.setStatus("2");
                    }
                }
            }
            returnMap.put("data", (String)tempOrderVo);
        }
        log.info("### \u5237\u65b0\u4e34\u65f6\u8ba2\u5355\u603b\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStartTime));
        return returnMap;
    }

    @RequestMapping(value={"/testOrgAccountCtrl", "/testOrgAccountCtrl"})
    @ResponseBody
    public String testOrganizationAccountCtrl(Integer ts, String r) {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < ts) {
            int finalI = i++;
            String finalR = r;
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        return "suc";
    }

    public boolean payScore(HttpServletRequest request, RedirectAttributes attr, List<OrderMainDto> orderMains, List<String> orderMainPaiedIds, BigDecimal usableScore, boolean isNeedPay) {
        BigDecimal proportion = new BigDecimal(this.itaipingScoreProportion);
        try {
            for (OrderMainDto orderMain : orderMains) {
                PaymentDto payment = this.paymentApi.findPaymentById(orderMain.getPaymentId());
                BigDecimal orderScore = this.scoreUserService.roundScore(this.goodsApi.priceScoreTransform(orderMain.getSumPrice(), proportion, 4));
                if (usableScore.compareTo(orderScore) >= 0) {
                    payment.setScore(orderScore);
                    payment.setMoney(BigDecimal.ZERO);
                    usableScore = usableScore.subtract(orderScore);
                } else {
                    payment.setScore(usableScore);
                    payment.setMoney(orderMain.getSumPrice().subtract(this.scoreUserService.roundScore(this.goodsApi.scorePriceTransform(usableScore, proportion, 4))));
                    usableScore = BigDecimal.ZERO;
                }
                this.paymentApi.updatePaymentScoreAndMoney(payment.getId(), payment.getScore(), payment.getMoney());
                if (payment.getScore().compareTo(BigDecimal.ZERO) <= 0) continue;
                ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO = new ScoreExpenseDetailRequestDTO();
                CoreUserDto coreUser = this.loginService.getSessionCoreUser(request);
                ScoreAccountDTO scoreAccount = this.scoreUserService.getScoreAccount(coreUser);
                scoreExpenseDetailRequestDTO.setScoreAccountId(scoreAccount.getId());
                scoreExpenseDetailRequestDTO.setScoreVal(payment.getScore());
                scoreExpenseDetailRequestDTO.setTransaTime(new Date());
                scoreExpenseDetailRequestDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_ENTITY_GOODS.getBusinessCode());
                scoreExpenseDetailRequestDTO.setBusiSource(ScoreBusinessType.BUSI_EXPENSE_ENTITY_GOODS.getBusinessSource());
                scoreExpenseDetailRequestDTO.setTransactionNo(orderMain.getOrderNo());
                scoreExpenseDetailRequestDTO.setMemo("\u8bda\u901a\u5546\u57ce\u8ba2\u5355" + orderMain.getOrderNo() + "\u6d88\u8d39" + payment.getScore() + "\u79ef\u5206");
                this.scoreApi.expenseScore(scoreExpenseDetailRequestDTO);
                if (!isNeedPay) {
                    this.paymentApi.updatePaymentStatus(payment.getId(), "1");
                }
                orderMainPaiedIds.add(orderMain.getId());
            }
        }
        catch (Exception e) {
            log.error("\u79ef\u5206\u5e73\u53f0\u6263\u51cf\u79ef\u5206\u5931\u8d25 error", (Throwable)e);
            attr.addAttribute("error", (Object)"PAY_SCORE");
            attr.addAttribute("message", (Object)"\u79ef\u5206\u5e73\u53f0\u6263\u51cf\u79ef\u5206\u5931\u8d25");
            return false;
        }
        return true;
    }

    public BigDecimal payBackScore(List<OrderMainDto> sucOrders, List<String> orderMainsPaiedIds) {
        BigDecimal orgNeedPayBackScore = new BigDecimal(0);
        for (OrderMainDto orderMain : sucOrders) {
            try {
                OrderMainDto orderMainRecentest = this.orderMainApi.findById(orderMain.getId());
                if (!orderMainRecentest.getStatus().equals("2")) {
                    this.orderMainApi.updateOrderStatus(orderMain.getId(), "9");
                }
                if (orderMainsPaiedIds == null || orderMainsPaiedIds.isEmpty() || !orderMainsPaiedIds.contains(orderMain.getId())) continue;
                BaseResponse baseResponse = this.ctScoreApi.refundScore(orderMain.getOrderNo());
                if ("success".equals(baseResponse.getStatus())) {
                    this.paymentApi.updatePaymentStatus(orderMain.getPaymentId(), "2");
                    orgNeedPayBackScore.add(this.paymentApi.findPaymentById(orderMain.getPaymentId()).getScore());
                    continue;
                }
                log.error("=========================\u79ef\u5206\u8fd4\u8fd8\u51fa\u9519,orderNo={}", (Object)orderMain.getOrderNo(), (Object)new RuntimeException("\u79ef\u5206\u8fd4\u8fd8\u51fa\u9519"));
            }
            catch (Exception e1) {
                log.error("=========================\u79ef\u5206\u8fd4\u8fd8\u51fa\u9519", (Throwable)e1);
            }
        }
        return orgNeedPayBackScore;
    }

    @RequestMapping(value={"/sendVerifyCode"})
    public void sendVerifyCode(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        HashMap<String, Integer> map = null;
        try {
            MemberVo memberVo = this.loginService.findMemberVo(request);
            String phone = memberVo.getUser().getPhone();
            String verifyCodeType = request.getParameter("verifyCodeType");
            map = new HashMap();
            VerifyCodeDto verifyCode = new VerifyCodeDto();
            String securityCode = StringUtils.getSecurityCode();
            log.info("securityCode:{}", (Object)securityCode);
            int count = this.smsApi.sendVerifyCodeTimes(phone, verifyCodeType);
            String sendResultShort = "";
            if (count > 50) {
                sendResultShort = "0";
            } else {
                boolean sendResult = this.sendMsg(phone, securityCode, verifyCodeType);
                log.info("\u624b\u673a\u9a8c\u8bc1\u7801\u53d1\u9001\u7ed3\u679c", (Object)sendResult);
                sendResultShort = sendResult ? "1" : "0";
            }
            verifyCode.setType(verifyCodeType);
            String memo = "\u8bda\u901a\u5546\u57ce\u5b9e\u7269\u8ba2\u5355";
            verifyCode.setMemo(memo);
            verifyCode.setObjId(phone);
            verifyCode.setSendResult(sendResultShort);
            verifyCode.setVerifyCode(securityCode.trim());
            VerifyCodeDto verifyCodeDto = (VerifyCodeDto)BeanMapper.map((Object)verifyCode, VerifyCodeDto.class);
            this.saveVerifyCode(verifyCodeDto);
            map.put("result", (Integer)((Object)sendResultShort));
        }
        catch (Exception e) {
            if (map == null) {
                map = new HashMap<String, Integer>();
            }
            map.put("result", 2);
        }
        String json = Jsons.map2json(map);
        this.ajaxHtml(json, response);
    }

    public boolean sendMsg(String objId, String verifyCode, String verifyCodeType) {
        boolean successFalg = false;
        SmsReq smsReq = new SmsReq();
        String content = "\u8bda\u610f\u901a\u63d0\u793a\u60a8\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u662f " + verifyCode + " \uff08\u6709\u6548\u671f5\u5206\u949f\uff09\uff0c\u5982\u975e\u672c\u4eba\u64cd\u4f5c\u8bf7\u5ffd\u7565\u672c\u77ed\u4fe1\u3002";
        smsReq.setContent(content);
        smsReq.setTos(Arrays.asList(objId));
        smsReq.setMobileServiceId(MOBILE_SERVICE_ID);
        smsReq.setSendTime(new Date());
        try {
            SmsRsp smsRsp = this.smsApi.sendSms(smsReq);
            successFalg = smsRsp.isSuccessFalg();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return successFalg;
    }

    @ResponseBody
    @RequestMapping(value={"/checkekVerifyCode"})
    public String checkekVerifyCode(String userName, String verifyCode, HttpServletRequest request) {
        if (!this.activeEnv.contains("prod")) {
            return "1";
        }
        MemberVo memberVo = this.loginService.findMemberVo(request);
        String phone = memberVo.getUser().getPhone();
        String verifyCodeType = "6";
        String result = this.checkCode(phone, verifyCode, verifyCodeType);
        return result;
    }

    public String checkCode(String userName, String verifyCode, String verifyCodeType) {
        String result = "1";
        VerifyCodeDto verifyCodes = this.findByObjIdAndType(userName, verifyCodeType);
        if (verifyCode.equals(verifyCodes.getVerifyCode())) {
            Date time = verifyCodes.getDateCreated();
            long minute = DateUtils.differMinute((Date)time);
            if (userName.contains("@")) {
                if (minute > 30L) {
                    result = "2";
                }
            } else if (minute > 5L) {
                result = "2";
            }
        } else {
            result = "0";
        }
        return result;
    }

    public VerifyCodeDto findByObjIdAndType(String objId, String type) {
        Date date = DateUtils.getNowDateShort();
        VerifyCodeDto verifyCode = this.smsApi.findVerifyCode(objId, type, date);
        return verifyCode;
    }

    public void saveVerifyCode(VerifyCodeDto verifyCode) {
        this.smsApi.saveVerifyCode(verifyCode);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

