/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.cms;

import cms.api.AnnouncementApi;
import cms.api.MemberReadAnnouncementApi;
import cms.api.dto.AnnouncementDto;
import cms.api.dto.MemberReadAnnouncementDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.sql.PageVo;

@Controller
@RequestMapping(value={"notice"})
public class AnnouncementController {
    private static final Log log = Logs.getLog((String)AnnouncementController.class.getName());
    @MotanReferer(basicReferer="motanClientBasicConfig")
    AnnouncementApi announcementApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberReadAnnouncementApi memberReadAnnouncementApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;

    @RequestMapping(value={"", "list"}, method={RequestMethod.GET})
    public String index() {
        return "notice/notice";
    }

    @RequestMapping(value={"", "list"}, method={RequestMethod.POST})
    @ResponseBody
    public Map query(String title, Pageable pageable, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("user_id_itaiping");
        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, new String[]{"publishDate"}));
        HashMap<String, Object> returnModel = new HashMap<String, Object>();
        PageVo pageVo = this.announcementApi.getUserZAnnouncement(pageable, memberId, title, this.organizationCode);
        returnModel.put("title", title == null ? "" : title.trim());
        returnModel.put("data", pageVo.getResult());
        returnModel.put("totalPages", pageVo.getPageNum());
        returnModel.put("size", pageVo.getPageSize());
        return returnModel;
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET})
    public String articleDetail(@RequestParam(value="noticeId") String noticeId, Map model, HttpServletRequest request) {
        AnnouncementDto notice = new AnnouncementDto();
        String memberId = (String)request.getSession().getAttribute("user_id_itaiping");
        if (!Lang.isEmpty((Object)noticeId)) {
            MemberReadAnnouncementDto m = this.memberReadAnnouncementApi.getReadAnnounceByReadId(noticeId);
            notice = this.announcementApi.getAnnouncement(noticeId);
            if (!Lang.isEmpty((Object)m)) {
                if (!m.getReadAnnouncement().booleanValue()) {
                    m.setReadAnnouncement(Boolean.valueOf(true));
                    this.memberReadAnnouncementApi.updateIsRead(m);
                }
            } else {
                MemberReadAnnouncementDto memberReadAnnouncement = new MemberReadAnnouncementDto();
                memberReadAnnouncement.setReadAnnouncement(Boolean.valueOf(true));
                memberReadAnnouncement.setAnnouncementId(noticeId);
                memberReadAnnouncement.setMemberId(memberId);
                this.memberReadAnnouncementApi.updateIsRead(memberReadAnnouncement);
            }
            if (notice.getJumpUrl() != null || notice.getJumpUrl() == "") {
                model.put("notice", notice);
                return "redirect:" + notice.getJumpUrl();
            }
            model.put("notice", notice);
            return "notice/noticeDetails";
        }
        return "notice/notice";
    }
}

