/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.cms;

import cms.api.ArticleApi;
import cms.api.ChannelApi;
import cms.api.dto.ArticleDto;
import cms.api.dto.ChannelDto;
import cms.api.vo.ArticleVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.data.Beans;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={"channelArticle"})
public class ChannelArticleController {
    private static final Log log = Logs.getLog((String)ChannelArticleController.class.getName());
    @MotanReferer
    ChannelApi channelApi;
    @MotanReferer
    ArticleApi articleApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;

    @RequestMapping(value={"", "list.do"}, method={RequestMethod.GET})
    public String index(@RequestParam(value="channelId") String channelId, String key, Map model) {
        ChannelDto channel = this.channelApi.findByChannelId(channelId);
        String channelName = channel.getName();
        model.put("channelId", channelId);
        model.put("channelName", channelName);
        model.put("queryKey", key);
        return "cms/article/articles";
    }

    @RequestMapping(value={"getArticles.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getChannelArticle(@RequestParam(value="channelId") String channelId, String title, Pageable pageable) {
        HashMap<String, Object> articleMap = new HashMap<String, Object>();
        ArrayList<ArticleVo> articleVoList = new ArrayList<ArticleVo>();
        Page articlePage = this.articleApi.findArticleByChannel(channelId, title, this.organizationCode, pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, new String[]{"publishDate"})));
        if (!Lang.isEmpty((Object)articlePage.getContent())) {
            for (ArticleDto article : articlePage.getContent()) {
                ArticleVo articleVo = new ArticleVo();
                Beans.from((Object)article).to(new Object[]{articleVo});
                articleVoList.add(articleVo);
            }
        }
        articleMap.put("title", title == null ? "" : title.trim());
        articleMap.put("data", articleVoList);
        articleMap.put("totalPages", articlePage.getTotalPages());
        articleMap.put("size", articlePage.getSize());
        return articleMap;
    }

    @RequestMapping(value={"detail.do"}, method={RequestMethod.GET})
    public String articleDetail(@RequestParam(value="articleId") String articleId, String key, Map model) {
        ArticleDto article = new ArticleDto();
        if (!Lang.isEmpty((Object)articleId)) {
            article = this.articleApi.findArticleById(articleId);
        }
        model.put("article", article);
        model.put("queryKey", key);
        return "cms/article/article-detail";
    }
}

