/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.goods;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.GoodsPictureApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsConfigDto;
import goods.dto.goods.GoodsDto;
import goods.dto.goods.GoodsPictureDto;
import goods.dto.product.ProductCategoryDto;
import goods.vo.SalesPriceQueryVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jd.api.service.product.JdProductApi;
import jd.dto.StockStateDto;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import suning.api.SnCommonConvertApi;
import utils.Lang;

@Controller
@RequestMapping(value={"addGoods"})
public class AddGoodsControlleer {
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @MotanReferer
    StoreApi storeApi;
    @MotanReferer
    GoodsPictureApi goodsPictureApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @MotanReferer
    JdProductApi jdProductApi;
    @MotanReferer
    SnCommonConvertApi snCommonConvertApi;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String getOrgnization(Map model) {
        List organizationAll = this.organizationApi.findOrganizationAll();
        model.put("orgnizations", organizationAll);
        return "goods/addGoods";
    }

    @RequestMapping(value={"addGoods.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map addGoodsForSkuAndOrg(String sku, String orgCode) {
        List stockStates;
        HashMap<String, String> returnMap = new HashMap<String, String>();
        HashSet<Long> productNoSet = new HashSet<Long>();
        if (sku.isEmpty()) {
            returnMap.put("result", "0");
            returnMap.put("message", "\u8bf7\u8f93\u5165sku");
            return returnMap;
        }
        productNoSet.add(Long.parseLong(sku));
        ArrayList productNosList = new ArrayList(productNoSet);
        int totalNum = productNosList.size();
        this.jdProductApi.executorsPoolAdd(productNosList, totalNum, Boolean.valueOf(false), Integer.valueOf(50));
        this.snCommonConvertApi.addProdBySkus(null, sku, null, null, null);
        if (productNosList.size() == 0) {
            returnMap.put("result", "0");
            returnMap.put("message", "\u5546\u54c1\u6c60\u4e0d\u5b58\u5728\u8be5sku");
            return returnMap;
        }
        List goods = this.goodsApi.findBySku(sku);
        if (goods.size() == 0) {
            returnMap.put("result", "0");
            returnMap.put("message", "\u5546\u54c1\u6c60\u4e0d\u5b58\u5728\u8be5sku");
            return returnMap;
        }
        for (Object good : goods) {
            if (!good.getState().equals("0")) continue;
            this.goodsApi.updateGoods(good.getId());
        }
        List goodsConfigs = this.goodsConfigApi.findBySkuAndOrganizationCode(sku, orgCode);
        if (!Lang.isEmpty((Object)goodsConfigs)) {
            for (GoodsConfigDto gc : goodsConfigs) {
                if (gc.getIsUp().booleanValue()) continue;
                gc.setIsUp(Boolean.valueOf(true));
            }
        } else {
            GoodsConfigDto goodsConfig = new GoodsConfigDto();
            GoodsDto good = (GoodsDto)goods.get(0);
            String category = "";
            String CategoryTextIndex = "";
            ProductCategoryDto productCategory = good.getProduct().getProductCategory();
            category = productCategory.getId();
            CategoryTextIndex = productCategory.getName();
            ProductCategoryDto parent = productCategory.getParent();
            if (parent != null) {
                category = category + "," + parent.getId();
                ProductCategoryDto parent1 = parent.getParent();
                if (parent1 != null) {
                    category = category + "," + parent1.getId();
                    ProductCategoryDto parent2 = parent1.getParent();
                    if (parent2 != null) {
                        category = category + "," + parent2.getId();
                        ProductCategoryDto parent3 = parent2.getParent();
                        if (parent3 != null) {
                            category = category + "," + parent3.getId();
                            ProductCategoryDto parent4 = parent3.getParent();
                            if (parent4 != null) {
                                category = category + "," + parent4.getId();
                            }
                        }
                    }
                }
            }
            String storeId = good.getStoreId();
            StoreDto store = this.storeApi.findByStoreId(storeId);
            goodsConfig.setCategory(category);
            goodsConfig.setCreateDate(Long.valueOf(System.currentTimeMillis()));
            goodsConfig.setGoodsId(good.getId());
            goodsConfig.setIsUp(Boolean.valueOf(true));
            GoodsPictureDto goodsPicture = this.goodsPictureApi.findGoodsPicture(good.getId());
            goodsConfig.setLogoUrl(goodsPicture.getBigPicturePath());
            OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(orgCode);
            goodsConfig.setOrganizationId(organization.getId());
            SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(orgCode, store.getStoreExt().getCode(), good);
            List mapList = this.salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
            if (!Lang.isEmpty((Object)mapList) && mapList.size() == 1) {
                BigDecimal salePrice = (BigDecimal)((Map)mapList.get(0)).get("salePrice");
                goodsConfig.setPrice(salePrice);
            }
            goodsConfig.setSku(sku);
            goodsConfig.setStoreLevel("1");
            goodsConfig.setStoreName(store.getStoreExt().getStoreName());
            goodsConfig.setTitle(good.getName());
            goodsConfig.setCategoryTextIndex(CategoryTextIndex);
            goodsConfig.setType("product");
            goodsConfig.setUserId(storeId);
            goodsConfig.setUpTime(new Date());
            goodsConfig.setOrganizationCode(orgCode);
            goodsConfig.setParam(good.getParam());
            goodsConfig.setLastUpdated(new Date());
            this.goodsConfigApi.save(goodsConfig);
        }
        if ("chengtongrenli".equals(orgCode) && (stockStates = this.jdProductApi.findBySku(sku)).size() == 0) {
            StockStateDto stock = new StockStateDto();
            stock.setSkuId(Long.valueOf(Long.parseLong(sku)));
            stock.setAreaId("1_2802_2821_0");
            this.jdProductApi.save(stock);
        }
        returnMap.put("result", "1");
        returnMap.put("message", "\u5904\u7406\u6210\u529f");
        return returnMap;
    }
}

