/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.goods;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.vo.ActivityVo;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.goods.GoodWebService;
import ctscore.web.utils.AddressUtil;
import ctscore.web.vo.ActivityProductDetailsVo;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.PriceParityApi;
import goods.api.ProductApi;
import goods.api.ProductFashionApi;
import goods.api.ProductSpecigicationsApi;
import goods.api.ProductTaxRateApi;
import goods.api.SalesPriceRateApi;
import goods.api.SalesPriceRateQueryApi;
import goods.api.ShareApi;
import goods.dto.goods.GoodsConfigDto;
import goods.dto.goods.GoodsDto;
import goods.dto.product.ProductCategoryDto;
import goods.dto.product.ProductDto;
import goods.dto.product.ProductFashionDto;
import goods.model.Goods;
import goods.model.Product;
import goods.model.ProductCategory;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductRepos;
import goods.vo.GoodsDetailsVo;
import goods.vo.ProductSpecificationsVo;
import goods.vo.ProductTaxInfoVo;
import goods.vo.SalesPriceCalVo;
import goods.vo.SalesPriceQueryVo;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.AddressCommonApi;
import member.api.MemberFavoriteApi;
import member.api.QueryFootprintsApi;
import member.api.ViewHistoryApi;
import member.api.dto.common.AddressCodeDTO;
import member.api.dto.shop.MemberDto;
import member.api.dto.shop.MemberViewHisDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.HandlerRespVo;
import search.api.SearchApi;
import search.vo.SearchQueryVo;
import search.vo.SearchResultVo;
import store.api.StoreApi;
import sysmg.api.SystemConfigApi;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.Jsons;
import utils.lang.Copys;
import utils.web.ResponseMapUtils;

@Controller
@RequestMapping(value={"goodsdetails"})
public class GoodsDetailsController {
    private static final Logger log = LoggerFactory.getLogger(GoodsDetailsController.class);
    @Autowired
    GoodWebService getGoodWebService;
    @MotanReferer
    ShareApi shareApi;
    @MotanReferer
    QueryFootprintsApi queryFootprintsApi;
    @Autowired
    GoodWebService goodWebService;
    @MotanReferer
    ViewHistoryApi viewHistoryApi;
    @MotanReferer
    OutsideProductApi outsideProductApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    PriceParityApi priceParityApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @MotanReferer
    MemberFavoriteApi memberFavoriteApi;
    @MotanReferer
    StoreApi storeApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    SearchApi searchApi;
    @MotanReferer
    ProductTaxRateApi productTaxRateApi;
    @MotanReferer
    ProductApi productApi;
    @Autowired
    ProductRepos productRepos;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;
    @MotanReferer
    ActivityApi activityApi;
    @MotanReferer
    ProductSpecigicationsApi productSpecigicationsApi;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    static final String GOODS_DETAILS_VO_KEY = "goodsDetailsVo";
    @Autowired
    AreaService areaService;
    @Value(value="${secKillActivity.activityCode}")
    String secKillActivityCode;
    @Value(value="${tuanGouActivity.activityCode}")
    String tuanGouActivityCode;

    @ResponseBody
    @RequestMapping(value={"/getSystemTime"})
    public Map<String, Object> getSystemTime() {
        Date systemTime = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("systemTime", systemTime);
        return map;
    }

    private void base(String goodsId, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        if (log.isInfoEnabled()) {
            log.info("\u5546\u54c1goodsId={}", (Object)goodsId);
        }
        Boolean hasCollect = false;
        long getIpAddressIdsTime = System.currentTimeMillis();
        AddressCodeDTO addressCodeDTO = AddressUtil.getAddressCode((HttpServletRequest)request, (AddressCommonApi)this.addressCommonApi);
        Map addressMap = addressCodeDTO.getAddressCodeMap();
        log.info("\u83b7\u53d6\u5730\u5740\u7701\u5e02\u533a\u9547\u4ee3\u7801\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getIpAddressIdsTime));
        if (Lang.isEmpty((Object)goodsId)) {
            model.put((String)"message", (Object)"\u4ea7\u54c1id\u6216\u8005\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Object memberId;
            if (!Lang.isEmpty((Object)goodsId)) {
                long time = System.currentTimeMillis();
                Goods goodsPO = (Goods)this.goodsRepos.findOne((Serializable)((Object)goodsId));
                GoodsDto goods = new GoodsDto();
                Copys.create().from((Object)goodsPO).excludes(new String[]{"product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion"}).to(new Object[]{goods});
                ProductDto productDTO = new ProductDto();
                Copys.create().from((Object)goodsPO.getProduct()).excludes(new String[]{"productCategory", "productStandards", "goodses", "productAttrs", "productFashions", "productParameters"}).to(new Object[]{productDTO});
                ProductCategory productCategoryPO = goodsPO.getProduct().getProductCategory();
                ProductCategoryDto lastProductCategory = null;
                for (int maxLoop = 5; !Lang.isEmpty((Object)productCategoryPO) && maxLoop > 0; --maxLoop) {
                    ProductCategoryDto productCategoryDTO = new ProductCategoryDto();
                    Copys.create().from((Object)productCategoryPO).excludes(new String[]{"parent", "child", "productModel", "productBrands", "productStandards", "productExtendPropertys"}).to(new Object[]{productCategoryDTO});
                    if (!Lang.isEmpty(lastProductCategory)) {
                        lastProductCategory.setParent(productCategoryDTO);
                    }
                    lastProductCategory = productCategoryDTO;
                    if (Lang.isEmpty((Object)productDTO.getProductCategory())) {
                        productDTO.setProductCategory(productCategoryDTO);
                    }
                    productCategoryPO = productCategoryPO.getParent();
                }
                goods.setProduct(productDTO);
                log.info("\u67e5\u8be2 goods \u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - time) / 1000.0));
                if (!Lang.isEmpty((Object)goods)) {
                    model.put((String)"goods", (Object)goods);
                    if (Lang.isEmpty((Object)goods.getProduct())) {
                        model.put((String)"message", (Object)"\u5546\u54c1ID\u672a\u5173\u8054\u4ea7\u54c1\uff0c\u65e0\u6cd5\u786e\u5b9a\u5206\u7c7b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    } else {
                        model = this.getGoodsDetails(model, goods, request);
                    }
                }
            }
            if (!Lang.isEmpty((Object)(memberId = request.getSession().getAttribute("member_id_itaiping")))) {
                String collectProductId = model.get("productId").toString();
                List memberFavorites = this.memberFavoriteApi.listHasFavoriteProducts(memberId.toString(), collectProductId);
                if (!Lang.isEmpty((Object)memberFavorites) && memberFavorites.size() > 0) {
                    hasCollect = true;
                }
            }
            model.put((String)"memberId", (Object)memberId);
        }
        GoodsDetailsVo goodsDetailsVo = (GoodsDetailsVo)model.get(GOODS_DETAILS_VO_KEY);
        if (goodsDetailsVo.getGoodsVo().getProduct() != null) {
            ArrayList<ProductDto> productList = new ArrayList<ProductDto>();
            productList.add(goodsDetailsVo.getGoodsVo().getProduct());
            List productTaxInfoVos = this.productTaxRateApi.getProductTaxInfo(productList);
            if (productTaxInfoVos != null && productTaxInfoVos.size() >= 1) {
                ProductTaxInfoVo productTaxInfoVo = (ProductTaxInfoVo)productTaxInfoVos.get(0);
                if (productTaxInfoVo != null && productTaxInfoVo.getTaxRate() != null) {
                    BigDecimal taxRate = new BigDecimal(productTaxInfoVo.getTaxRate());
                    BigDecimal taxPrice = goodsDetailsVo.getGoodsVo().getSalePrice().divide(BigDecimal.ONE.add(taxRate), 2, 4).multiply(taxRate);
                    model.put((String)"taxPrice", (Object)taxPrice);
                } else {
                    model.put((String)"taxPrice", (Object)BigDecimal.ZERO);
                }
                model.put((String)"taxRate", (Object)(productTaxInfoVo == null ? null : productTaxInfoVo.getTaxRate()));
            }
        }
        String trdPriceSwitch = this.systemConfigApi.getConfigValue("COMMON", "TRD_PRICE_SHOW_ID_PD_SWITCH", "STORE_" + (Lang.isEmpty((Object)this.storeCode) ? "" : this.storeCode).toUpperCase(), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        String showPrice = "1";
        if (!Lang.isEmpty((Object)trdPriceSwitch) && showPrice.equals(trdPriceSwitch)) {
            model.put((String)"showPrice", true);
        } else {
            model.put((String)"showPrice", false);
        }
        String pdPageConfigs = this.systemConfigApi.getConfigValue("COMMON", "STORE_PAGE_CONFIGS", "STORE_PD_PAGE_CONFIGS", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        String pdPageUrl = "javascript:void(0)";
        if (!Lang.isEmpty((Object)pdPageConfigs)) {
            try {
                Map pdPageConfigMap = (Map)JSON.parseObject((String)pdPageConfigs, HashMap.class);
                pdPageUrl = (String)pdPageConfigMap.get(this.storeCode);
                if (!Lang.isEmpty((Object)pdPageUrl)) {
                    pdPageUrl = pdPageUrl.replace("{sku}", goodsDetailsVo.getGoodsVo().getSku());
                }
            }
            catch (Exception e) {
                log.error("STORE_PAGE_CONFIGS:STORE_PD_PAGE_CONFIGS\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", (Throwable)e);
            }
        }
        model.put((String)"pdPageUrl", (Object)pdPageUrl);
        String returnProvoiceId = (String)addressMap.get("provoiceId");
        String returnCityId = (String)addressMap.get("cityId");
        String returnAreaId = (String)addressMap.get("areaId");
        String returnTownId = (String)addressMap.get("townId");
        String fromStore = request.getParameter("from");
        model.put((String)"provoiceId", (Object)returnProvoiceId);
        model.put((String)"cityId", (Object)returnCityId);
        model.put((String)"areaId", (Object)returnAreaId);
        model.put((String)"townId", (Object)returnTownId);
        model.put((String)"fromStore", (Object)fromStore);
        model.put((String)"hasCollect", (Object)hasCollect);
    }

    @RequestMapping(value={"", "list"}, method={RequestMethod.GET})
    public String index(String goodsId, String productId, Map model, HttpServletRequest request, HttpServletResponse response) {
        String currentSecKillActivityId;
        Long startTime = System.currentTimeMillis();
        if (goodsId == null) {
            Product productPO = (Product)this.productRepos.findOne((Serializable)((Object)productId));
            if (!Lang.isEmpty((Object)productPO)) {
                if (Lang.isEmpty((Object)productPO.getGoodses())) {
                    log.error("productId {} \u4e0b\u6ca1\u6709\u5546\u54c1\u6570\u636e");
                    return "redirect:500";
                }
            } else {
                return "redirect:500";
            }
            goodsId = ((Goods)productPO.getGoodses().get(0)).getId();
            log.info("\u67e5\u8be2product\u8017\u65f6{}\u79d2", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        }
        if (!Lang.isEmpty((Object)(currentSecKillActivityId = this.activityConfigurationApi.getCurrentActivityId(this.organizationCode, goodsId, this.secKillActivityCode)))) {
            return "redirect:/goodsdetails/secKill?goodsId=" + goodsId + "&activityId=" + currentSecKillActivityId;
        }
        String currentTuanGouActivityId = this.activityConfigurationApi.getCurrentActivityId(this.organizationCode, goodsId, this.tuanGouActivityCode);
        if (!Lang.isEmpty((Object)currentTuanGouActivityId)) {
            return "redirect:/goodsdetails/tuanGou?goodsId=" + goodsId + "&activityId=" + currentTuanGouActivityId;
        }
        this.base(goodsId, model, request, response);
        GoodsDetailsVo goodsDetailsVo = (GoodsDetailsVo)model.get(GOODS_DETAILS_VO_KEY);
        if (goodsDetailsVo == null && goodsDetailsVo.getGoodsVo().getState() == 0) {
            return "redirect:500";
        }
        log.info("\u52a0\u8f7d productDetails \u9875\u9762 \u603b\u8017\u65f6\uff1a{} \u79d2", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        return "goods/productDetails";
    }

    @RequestMapping(value={"secKill", "seckill"}, method={RequestMethod.GET})
    public String secKill(String goodsId, String activityId, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        Long startTime = System.currentTimeMillis();
        this.base(goodsId, model, request, response);
        if (model.containsKey(GOODS_DETAILS_VO_KEY)) {
            List activityGoodsList = this.activityGoodsApi.findActivityGoodsByGoodsIdAndActivityId(goodsId, activityId);
            if (activityGoodsList.size() == 1) {
                ActivityGoodsDto activityGoods = (ActivityGoodsDto)activityGoodsList.get(0);
                if (this.secKillActivityCode.equals(activityGoods.getActivityDefinition().getActivityCode())) {
                    ActivityProductDetailsVo activityProductDetailsVo = new ActivityProductDetailsVo(activityGoods);
                    activityProductDetailsVo.setCheckGoodsLimited(Boolean.valueOf(true));
                    activityProductDetailsVo.setGoodsLimitedCount(Integer.valueOf(1));
                    activityProductDetailsVo.setCheckStockLimited(Boolean.valueOf(true));
                    int activityStock = this.activityGoodsApi.getCurrentActivityGoodsStockFromCache(this.organizationCode, goodsId, activityId, this.secKillActivityCode);
                    activityProductDetailsVo.setStockLimited(Boolean.valueOf(activityStock <= 0));
                    activityProductDetailsVo.setCheckActivityLimited(Boolean.valueOf(true));
                    int activityLimitedCount = 1;
                    BigDecimal effectiveOrderCount = this.activityGoodsApi.getEffectiveOrderCount(request.getSession().getAttribute("member_id_itaiping") + "", activityId);
                    activityProductDetailsVo.setActivityLimited(Boolean.valueOf(effectiveOrderCount.intValue() >= activityLimitedCount));
                    model.put("activityProductDetailsVo", activityProductDetailsVo);
                } else {
                    log.error("\u6839\u636e\u5546\u54c1ID {} \u4e0e\u573a\u6b21ID {} \u627e\u5230\u6570\u636e\u4e0d\u5c5e\u4e8e\u79d2\u6740\u6d3b\u52a8\u5546\u54c1", new Object[]{goodsId, activityId, activityGoodsList.size()});
                }
            } else {
                log.error("\u6839\u636e\u5546\u54c1ID {} \u4e0e\u573a\u6b21ID {} \u627e\u5230\u6570\u636e\u96c6\u5408\u5927\u5c0f\u4e0d\u662f\u671f\u671b\u503c[1]\u5b9e\u9645\u5927\u5c0f[{}]", new Object[]{goodsId, activityId, activityGoodsList.size()});
            }
        }
        model.put("goodsId", goodsId);
        model.put("activityId", activityId);
        model.put("activityCode", this.secKillActivityCode);
        log.info("\u52a0\u8f7d productDetailsSecKill \u9875\u9762 \u603b\u8017\u65f6\uff1a{} \u79d2", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        return "goods/productDetailsSecKill";
    }

    @RequestMapping(value={"tuanGou", "tuangou"}, method={RequestMethod.GET})
    public String tuanGou(String goodsId, String activityId, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        Long startTime = System.currentTimeMillis();
        this.base(goodsId, model, request, response);
        if (model.containsKey(GOODS_DETAILS_VO_KEY)) {
            List activityGoodsList = this.activityGoodsApi.findActivityGoodsByGoodsIdAndActivityId(goodsId, activityId);
            if (activityGoodsList.size() == 1) {
                ActivityGoodsDto activityGoods = (ActivityGoodsDto)activityGoodsList.get(0);
                if (this.tuanGouActivityCode.equals(activityGoods.getActivityDefinition().getActivityCode())) {
                    ActivityProductDetailsVo activityProductDetailsVo = new ActivityProductDetailsVo(activityGoods);
                    activityProductDetailsVo.setCheckStockLimited(Boolean.valueOf(true));
                    int activityStock = this.activityGoodsApi.getCurrentActivityGoodsStockFromCache(this.organizationCode, goodsId, activityId, this.tuanGouActivityCode);
                    activityProductDetailsVo.setStockLimited(Boolean.valueOf(activityStock <= 0));
                    model.put("activityProductDetailsVo", activityProductDetailsVo);
                } else {
                    log.error("\u6839\u636e\u5546\u54c1ID {} \u4e0e\u573a\u6b21ID {} \u627e\u5230\u6570\u636e\u4e0d\u5c5e\u4e8e\u56e2\u8d2d\u6d3b\u52a8\u5546\u54c1", new Object[]{goodsId, activityId, activityGoodsList.size()});
                }
            } else {
                log.error("\u6839\u636e\u5546\u54c1ID {} \u4e0e\u573a\u6b21ID {} \u627e\u5230\u6570\u636e\u96c6\u5408\u5927\u5c0f\u4e0d\u662f\u671f\u671b\u503c[1]\u5b9e\u9645\u5927\u5c0f[{}]", new Object[]{goodsId, activityId, activityGoodsList.size()});
            }
        }
        model.put("goodsId", goodsId);
        model.put("activityId", activityId);
        model.put("activityCode", this.tuanGouActivityCode);
        log.info("\u52a0\u8f7d productDetailsTuanGou \u9875\u9762 \u603b\u8017\u65f6\uff1a{} \u79d2", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        return "goods/productDetailsTuanGou";
    }

    @RequestMapping(value={"queryFashionPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> queryFashionPrice(String factionId, String storeCode, String productCode, String provinceCode, String cityCode, String countyCode, String townCode, Integer count) {
        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
        fashionPriceRequestVo.setProvinceCode(provinceCode);
        fashionPriceRequestVo.setCityCode(cityCode);
        fashionPriceRequestVo.setCountyCode(countyCode);
        fashionPriceRequestVo.setTownCode(townCode);
        ArrayList<FashionPriceParamVo> fashionPriceParamVos = new ArrayList<FashionPriceParamVo>();
        FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
        fashionPriceParamVo.setFactionId(factionId);
        fashionPriceParamVo.setProductCode(productCode);
        fashionPriceParamVos.add(fashionPriceParamVo);
        fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);
        HandlerRespVo outsideApiRes = this.outsideProductApi.queryFashionPrice(storeCode, fashionPriceRequestVo);
        HashMap<String, Object> model = new HashMap<String, Object>();
        ProductFashionDto productFashion = this.productFashionApi.findById(factionId);
        if (outsideApiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
            model.put("status", "success");
            if (Lang.isEmpty((Object)outsideApiRes.getData())) {
                model.put("priceFlag", 0);
            } else {
                BigDecimal rateCalRs;
                OrganizationDto organization;
                model.put("priceFlag", 1);
                model.put("data", ((List)outsideApiRes.getData()).get(0));
                FashionPriceVo data = (FashionPriceVo)model.get("data");
                productFashion.setSalePrice(data.getSalePrice());
                productFashion.setMarketPrice(data.getMarketPrice());
                productFashion.setCostPrice(data.getCostPrice());
                if (!Lang.isEmpty((Object)this.organizationCode) && (organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode)) != null && productFashion != null && (rateCalRs = this.salesPriceRateApi.calSalesPrice(new SalesPriceCalVo(factionId, productFashion.getProduct().getStoreId(), this.storeApi.getStoreCode(productFashion.getProduct().getStoreId()), organization.getId(), productFashion.getSalePrice(), productFashion.getCostPrice(), productFashion.getMarketPrice(), productFashion.getCostPrice(), count, this.organizationCode))) != null && !Lang.isEmpty((Object)data)) {
                    data.setSalePrice(rateCalRs);
                    ArrayList<ProductDto> productList = new ArrayList<ProductDto>();
                    productList.add(productFashion.getProduct());
                    List productTaxInfoVos = this.productTaxRateApi.getProductTaxInfo(productList);
                    if (productTaxInfoVos != null && productTaxInfoVos.size() >= 1) {
                        ProductTaxInfoVo productTaxInfoVo = (ProductTaxInfoVo)productTaxInfoVos.get(0);
                        if (productTaxInfoVo != null && productTaxInfoVo.getTaxRate() != null) {
                            BigDecimal taxRate = new BigDecimal(productTaxInfoVo.getTaxRate());
                            BigDecimal taxPrice = data.getSalePrice().divide(BigDecimal.ONE.add(taxRate), 2, 4).multiply(taxRate);
                            data.setTaxPrice(taxPrice);
                        } else {
                            data.setTaxPrice(BigDecimal.ZERO);
                        }
                    }
                    model.put("data", data);
                }
            }
        } else {
            model.put("status", "error");
            model.put("message", outsideApiRes.getMessage());
        }
        return model;
    }

    @RequestMapping(value={"trdSalePrice"}, method={RequestMethod.GET})
    @ResponseBody
    public Map queryTrdSalePrice(String goodsId, String fashionId, String areaCode) throws IOException {
        Map respMap = null;
        String sku = null;
        String storeId = null;
        if (Lang.isEmpty((Object)fashionId)) {
            if (!Lang.isEmpty((Object)goodsId)) {
                GoodsDto goods = this.goodsApi.findById(goodsId);
                sku = goods.getSku();
                storeId = goods.getStoreId();
            }
        } else {
            ProductFashionDto fashion = this.productFashionApi.findById(fashionId);
            sku = fashion.getProduct().getCode();
            storeId = fashion.getProduct().getStoreId();
        }
        if (!Lang.isEmpty(sku) && !Lang.isEmpty(storeId)) {
            FashionPriceParamVo priceParamVo = new FashionPriceParamVo();
            priceParamVo.setProductCode(sku);
            HandlerRespVo respVo = this.outsideProductApi.runPriceSpider(storeId, priceParamVo, areaCode, "PD", Boolean.valueOf(false));
            respMap = respVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) ? ResponseMapUtils.success((Object)respVo.getData()) : ResponseMapUtils.error((String)respVo.getMessage());
        }
        return respMap;
    }

    @RequestMapping(value={"parityGoods"}, method={RequestMethod.GET})
    @ResponseBody
    public Map parityGoods(String goodsId, String provoiceId, String cityId, String areaId) {
        Map rtnMap = null;
        HashMap rtnData = new HashMap();
        GoodsDto goods = this.goodsApi.findById(goodsId);
        HashMap<String, String> addrMap = new HashMap<String, String>();
        addrMap.put("provoiceId", provoiceId);
        addrMap.put("cityId", cityId);
        addrMap.put("areaId", areaId);
        rtnMap = ResponseMapUtils.error((String)"NO_PRICE");
        if (goods != null) {
            List parityPriceGoodsVos = this.priceParityApi.parityPrice(goods, this.organizationCode, addrMap);
            rtnMap = ResponseMapUtils.success((Object)parityPriceGoodsVos);
        }
        return rtnMap;
    }

    @RequestMapping(value={"goodsPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getSnPrice(String goodsId, String provinceCode, String cityCode, String countyCode, String townCode) {
        String storeCode;
        Map rtnMap = null;
        HashMap<String, BigDecimal> rtnData = new HashMap<String, BigDecimal>();
        GoodsDto goods = this.goodsApi.findById(goodsId);
        rtnMap = ResponseMapUtils.error((String)"NO_PRICE");
        if (goods != null && !Lang.isEmpty((Object)(storeCode = this.storeApi.getStoreCode(goods.getStoreId())))) {
            List productFashions;
            OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
            ProductDto product = this.productApi.findById(goods.getProduct().getId());
            if (product != null && (productFashions = product.getProductFashions()).size() > 0) {
                BigDecimal rateCalRs;
                FashionPriceVo data;
                String fashionId = ((ProductFashionDto)productFashions.get(0)).getId();
                FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
                fashionPriceRequestVo.setProvinceCode(provinceCode);
                fashionPriceRequestVo.setCityCode(cityCode);
                fashionPriceRequestVo.setCountyCode(countyCode);
                fashionPriceRequestVo.setTownCode(townCode);
                FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                fashionPriceParamVo.setFactionId(fashionId);
                fashionPriceParamVo.setProductCode(goods.getProduct().getCode());
                ArrayList<FashionPriceParamVo> fashionPriceParamVos = new ArrayList<FashionPriceParamVo>();
                fashionPriceParamVos.add(fashionPriceParamVo);
                fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);
                HandlerRespVo outsideApiRes = this.outsideProductApi.queryFashionPrice(storeCode, fashionPriceRequestVo);
                if (!(outsideApiRes.getStatus() != HandlerRespVo.RESPONSE_STATUS_SUCCESS || Lang.isEmpty((Object)outsideApiRes.getData()) || Lang.isEmpty((Object)(data = (FashionPriceVo)((List)outsideApiRes.getData()).get(0))) || Lang.isEmpty((Object)(rateCalRs = this.salesPriceRateApi.calSalesPrice(new SalesPriceCalVo(fashionId, goods.getStoreId(), storeCode, organization.getId(), data.getSalePrice(), data.getCostPrice(), data.getMarketPrice(), data.getCostPrice(), Integer.valueOf(1), this.organizationCode)))))) {
                    BigDecimal salePrice;
                    rtnData.put("salePrice", rateCalRs);
                    rtnData.put("costPrice", data.getCostPrice());
                    rtnData.put("marketPrice", data.getMarketPrice());
                    SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(this.organizationCode, storeCode, goods);
                    List mapList = this.salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                    if (!Lang.isEmpty((Object)mapList) && mapList.size() == 1 && !Lang.isEmpty((Object)(salePrice = (BigDecimal)((Map)mapList.get(0)).get("salePrice")))) {
                        rtnData.put("salePrice", salePrice);
                    }
                    rtnMap = ResponseMapUtils.success(rtnData);
                }
            }
        }
        return rtnMap;
    }

    @RequestMapping(value={"updateGoodsPrice"}, method={RequestMethod.GET})
    @ResponseBody
    private Map updateGoodsPrice(String storeCode, String goodsId, String activityId, String factionId, String productCode, String provinceCode, String cityCode, String countyCode, String townCode, Integer count) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        BigDecimal oldCostPrice = null;
        BigDecimal oldMarketPrice = null;
        List activityVoList = null;
        String key = null;
        if (!Lang.isEmpty((Object)goodsId)) {
            if (!Lang.isEmpty((Object)activityId)) {
                ActivityDefinitionDto activityDefinition = this.activityApi.findById(activityId);
                activityVoList = this.activityConfigurationApi.getGoodsListByActivityId(this.organizationCode, activityId, activityDefinition.getActivityCode(), storeCode);
                if (!Lang.isEmpty((Object)activityVoList) && activityVoList.size() > 0) {
                    for (ActivityVo activityVo : activityVoList) {
                        if (!goodsId.equals(activityVo.getGoodsPicture().getGoods().getId())) continue;
                        key = this.activityConfigurationApi.buildKeyForActivityGoods(this.organizationCode, activityId, activityDefinition.getActivityCode());
                        oldCostPrice = activityVo.getGoodsPicture().getGoods().getCostPrice();
                        oldMarketPrice = activityVo.getGoodsPicture().getGoods().getMarketPrice();
                        break;
                    }
                }
            } else {
                Goods goods = (Goods)this.goodsRepos.findOne((Serializable)((Object)goodsId));
                oldCostPrice = goods.getCostPrice();
                oldMarketPrice = goods.getMarketPrice();
            }
            Long queryFashionPriceTimer = System.currentTimeMillis();
            this.goodsApi.queryFashionPrice(this.organizationCode, factionId, storeCode, productCode, provinceCode, cityCode, countyCode, townCode, count);
            log.info("queryFashionPrice \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionPriceTimer));
            Goods newGoods = (Goods)this.goodsRepos.findOne((Serializable)((Object)goodsId));
            BigDecimal newCostPrice = newGoods.getCostPrice();
            BigDecimal newMarketPrice = newGoods.getMarketPrice();
            if (!(oldMarketPrice == null || oldCostPrice == null || newMarketPrice == null || newCostPrice == null || oldMarketPrice.toString().equals(newMarketPrice.toString()) && oldCostPrice.toString().equals(newCostPrice.toString()))) {
                if (!Lang.isEmpty((Object)key)) {
                    this.activityConfigurationApi.deleteRedisKey(key);
                }
                model.put("update", true);
            }
            model.put("success", "success");
        }
        return model;
    }

    private void createViewHistory(String goodsId, HttpServletRequest request) {
        MemberVo memberVo = this.goodWebService.findMemberVo(request);
        if (memberVo != null) {
            Boolean isAddViewHisFlag = true;
            List memberViewHises = this.viewHistoryApi.getViewHisByMemberId(memberVo.getMember().getId());
            if (!Lang.isEmpty((Object)memberViewHises)) {
                for (MemberViewHisDto memberViewHis : memberViewHises) {
                    if (!memberViewHis.getTargetId().equals(goodsId)) continue;
                    memberViewHis.setDateCreated(new Date());
                    this.viewHistoryApi.saveViewHis(memberViewHis);
                    isAddViewHisFlag = false;
                    break;
                }
            }
            if (isAddViewHisFlag.booleanValue()) {
                MemberViewHisDto memberViewHis = new MemberViewHisDto(memberVo.getMember(), "PRODUCT_ID", goodsId);
                MemberViewHisDto memberViewHis1 = this.viewHistoryApi.saveViewHis(memberViewHis);
                int maxSize = 50;
                if (memberViewHises.size() == maxSize && !Lang.isEmpty((Object)memberViewHis1)) {
                    try {
                        this.viewHistoryApi.deleteById(((MemberViewHisDto)memberViewHises.get(0)).getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private Map<String, Object> getIpAddressIds(HttpServletRequest request) {
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        return this.areaService.getAddressIdSByParams(request, sessionProvoiceId);
    }

    private Map<String, Object> getGoodsDetails(Map<String, Object> model, GoodsDto goods, HttpServletRequest request) {
        long methodStart = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u5c01\u88c5 model ... ###");
        ProductDto product = goods.getProduct();
        ProductCategoryDto productCategory = product.getProductCategory();
        long storeCodeTime = System.currentTimeMillis();
        String storeCode = this.storeApi.findStoreCodeById(goods.getStoreId());
        log.info("\u67e5\u8be2 storeCode \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - storeCodeTime));
        List<HashMap> categoryList = new ArrayList<HashMap>();
        HashMap map = Maps.newHashMap();
        map.put(productCategory.getId(), productCategory.getName());
        categoryList.add(map);
        while (productCategory.getParent() != null && !productCategory.getParent().getId().equals(productCategory.getId())) {
            productCategory = productCategory.getParent();
            HashMap mapt = Maps.newHashMap();
            mapt.put(productCategory.getId(), productCategory.getName());
            categoryList.add(mapt);
        }
        categoryList = Lists.reverse(categoryList);
        model.put("categoryList", categoryList);
        model.put("productCategory", productCategory);
        Long goodsDetailsVoTime = System.currentTimeMillis();
        GoodsDetailsVo goodsDetailsVo = null;
        if (Lang.isEmpty((Object)goods)) {
            model.put("message", "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\u4e86\uff0c\u8bf7\u8fd4\u56de\u9996\u9875\u91cd\u65b0\u8d2d\u4e70");
        } else {
            goodsDetailsVo = this.shareApi.getGoodsDetails(goods.getId());
        }
        model.put(GOODS_DETAILS_VO_KEY, goodsDetailsVo);
        log.info("\u83b7\u53d6 GoodsDetailsVo \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - goodsDetailsVoTime));
        long salePriceTime = System.currentTimeMillis();
        BigDecimal salePrice = this.activityGoodsApi.getActivityPrice(goods.getId(), this.organizationCode, storeCode).setScale(2, 0);
        goodsDetailsVo.getGoodsVo().setSalePrice(salePrice);
        log.info("\u83b7\u53d6\u552e\u4ef7\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - salePriceTime));
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        if (memberJson != null) {
            MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
            Sort.Order order = new Sort.Order(Sort.Direction.DESC, "dateCreated");
            ArrayList<Sort.Order> sortList = new ArrayList<Sort.Order>();
            sortList.add(order);
            Sort sort = new Sort(sortList);
            PageRequest pageable = new PageRequest(0, 2, sort);
            long memberViewHisesTime = System.currentTimeMillis();
            List memberViewHises = this.queryFootprintsApi.getMemberViewHis(member, "PRODUCT_ID", (Pageable)pageable);
            log.info("\u67e5\u8be2\u7528\u6237\u6d4f\u89c8\u5386\u53f2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - memberViewHisesTime));
            ArrayList<String> goodsIds = new ArrayList<String>();
            if (!Lang.isEmpty((Object)memberViewHises)) {
                for (MemberViewHisDto memberViewHis : memberViewHises) {
                    goodsIds.add(memberViewHis.getTargetId());
                }
            }
            long commonDocListTime = System.currentTimeMillis();
            List commonDocList = this.getGoodWebService.setCommonDocList(goodsIds);
            model.put("commonDocList", commonDocList);
            log.info("\u67e5\u8be2\u6211\u7684\u8db3\u8ff9\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - commonDocListTime));
        }
        long hotSalesTime = System.currentTimeMillis();
        SearchQueryVo searchQueryVo = new SearchQueryVo();
        searchQueryVo.setType("product");
        searchQueryVo.putQueryArgs("category", productCategory.getId());
        SearchQueryVo hotq = (SearchQueryVo)BeanMapper.map((Object)searchQueryVo, SearchQueryVo.class);
        hotq.setSale(Boolean.valueOf(true));
        if (!StringUtils.isEmpty((CharSequence)goods.getStoreId())) {
            hotq.putQueryArgs("userId", goods.getStoreId());
        }
        hotq.setOrganizationCode(this.organizationCode);
        SearchResultVo hotSales = this.searchApi.query(hotq, Integer.valueOf(6), Integer.valueOf(0));
        log.info("\u67e5\u8be2\u70ed\u5356\u5546\u54c1\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - hotSalesTime));
        model.put("hotSales", hotSales);
        model.put("storeCode", storeCode);
        model.put("productId", product.getId());
        model.put("storeId", goods.getStoreId());
        model.put("goodsId", goods.getId());
        long productFasionIdTime = System.currentTimeMillis();
        String productFasionId = this.productFashionApi.findIdByGoodsId(goods.getId());
        if (Lang.isEmpty((Object)productFasionId)) {
            List productFashionIds = this.productFashionApi.findIdsByProductId(product.getId());
            log.info("\u67e5\u8be2 ProductFashionIds \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - productFasionIdTime));
            productFasionId = (String)productFashionIds.get(0);
        }
        model.put("productFashId", productFasionId);
        long goodsConfigCheckTime = System.currentTimeMillis();
        ArrayList<GoodsConfigDto> goodsConfigs = new ArrayList<GoodsConfigDto>();
        List goodsConfigsTemp = this.goodsConfigApi.findBySkuAndOrganizationCode(goods.getSku(), this.organizationCode);
        if (!Lang.isEmpty((Object)goodsConfigsTemp)) {
            for (GoodsConfigDto goodsConfig : goodsConfigsTemp) {
                if (!Lang.isEmpty((Object)goodsConfig.getIsDelete()) && goodsConfig.getIsDelete().booleanValue()) continue;
                goodsConfigs.add(goodsConfig);
            }
        }
        if (Lang.isEmpty(goodsConfigs)) {
            model.put("isDown", "\u975e\u5f53\u524d\u6e20\u9053\u5546\u54c1");
            log.info("\u975e\u5f53\u524d\u6e20\u9053\u5546\u54c1\u3002 \u6e20\u9053\u4ee3\u7801: {}, SKU: {}", (Object)this.organizationCode, (Object)goods.getSku());
        } else {
            GoodsConfigDto goodsConfig = (GoodsConfigDto)goodsConfigs.get(0);
            if (!goodsConfig.getUp().booleanValue()) {
                model.put("isDown", "\u6e20\u9053\u5546\u54c1\u5df2\u4e0b\u67b6");
                log.info("\u6e20\u9053\u5546\u54c1\u5df2\u4e0b\u67b6\u3002 \u6e20\u9053\u4ee3\u7801: {}, SKU: {}", (Object)this.organizationCode, (Object)goods.getSku());
            }
        }
        log.info("\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u6821\u9a8c\u8017\u65f6 {} ms ", (Object)(System.currentTimeMillis() - goodsConfigCheckTime));
        long createViewHistoryTime = System.currentTimeMillis();
        this.createViewHistory(goodsDetailsVo.getGoodsVo().getId(), request);
        log.info("\u521b\u5efa\u5386\u53f2\u6d4f\u89c8\u8bb0\u5f55\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - createViewHistoryTime));
        log.info("### \u5c01\u88c5 model \u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStart));
        return model;
    }

    @ResponseBody
    @RequestMapping(value={"loadProductSpecifications"}, method={RequestMethod.POST})
    public String loadPproductSpecifications(String goodsId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long start = System.currentTimeMillis();
        ProductSpecificationsVo productSpecificationsVo = this.productSpecigicationsApi.getProductSpecificationsVo(goodsId, this.organizationCode);
        log.info("\u67e5\u8be2\u5546\u54c1\u89c4\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - start));
        map.put("productSpecificationsVo", productSpecificationsVo);
        map.put("status", "success");
        return Jsons.map2json(map);
    }
}

