/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.goods;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.goods.CategroyService;
import ctscore.web.service.goods.GoodWebService;
import goods.api.GoodsApi;
import goods.api.ProductBrandApi;
import goods.api.ProductCategoryApi;
import goods.api.SalesPriceRateQueryApi;
import goods.api.SearchKeyWordsApi;
import goods.api.ShareApi;
import goods.dto.GoodsStateDto;
import goods.dto.product.ProductBrandDto;
import goods.dto.product.ProductCategoryDto;
import goods.model.repository.ProductCategoryRepos;
import goods.utils.HttpHeaderUtils;
import goods.vo.SearchKeywordsHisDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import jd.api.request.product.StockForOrderEntity;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.StockNewResultVo;
import jd.api.vo.product.StockVO;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.CoreCompDepartUserApi;
import member.api.CoreCompanyApi;
import member.api.CoreUserApi;
import member.api.MemberAddressApi;
import member.api.dto.common.AddressDto;
import member.api.dto.core.CoreCompDepartUserDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.CoreCompDepartUserVo;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.HandlerRespVo;
import search.api.SearchApi;
import search.vo.CommonDoc;
import search.vo.CommonDocVo;
import search.vo.SearchQueryVo;
import search.vo.SearchResultVo;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.lang.Copys;
import utils.web.Webs;

@Controller
@RequestMapping(value={"search"})
public class SearchController {
    private static final Logger logger = LoggerFactory.getLogger(SearchController.class);
    @MotanReferer
    SearchApi searchApi;
    @Autowired
    GoodWebService goodWebService;
    @MotanReferer
    SearchKeyWordsApi searchKeyWordsApi;
    @Autowired
    CategroyService categroyService;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    StoreApi storeApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreCompanyApi coreCompanyApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreUserApi coreUserApi;
    @MotanReferer
    ProductBrandApi productBrandApi;
    @MotanReferer
    JdProductApi jdProductApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    OutsideProductApi outsideProductApi;
    @Value(value="${ctscore.score.proportion}")
    String scorePortion;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @Autowired
    MapperFacade mapperFacade;
    private static final String countSaleSql = "SELECT * FROM (SELECT A.*, ROWNUM RN FROM (SELECT COUNT(oi.id) total, oi.goods_id FROM order_main om , order_item oi, goods g WHERE oi.order_id=om.id AND om.status IN(1,2,3,4,5,7) AND oi.goods_id IS NOT NULL and g.id=oi.goods_id and instr(g.sku, 'JDE') <=0 GROUP BY oi.goods_id ORDER BY total DESC )A ) WHERE RN BETWEEN 1 AND 6 ";
    private static final String randomNumSql = "SELECT * FROM ( SELECT A.*, ROWNUM RN FROM ( select g.id from goods g)A) WHERE RN BETWEEN ? AND ? ";
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    AreaService areaService;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @MotanReferer
    CoreCompDepartUserApi compDepartUserApi;
    @MotanReferer
    ShareApi shareApi;
    @MotanReferer
    ProductCategoryApi productCategoryApi;
    @Autowired
    ProductCategoryRepos productCategoryRepos;
    @MotanReferer
    GoodsApi goodsApi;

    @RequestMapping(method={RequestMethod.GET}, value={"/", ""})
    public String index(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        this.search(request, null, model);
        logger.info("###############index\u65b9\u6cd5\u5411\u670d\u52a1\u5668\u8bf7\u6c42\u603b\u7528\u65f6##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        return "goods/goodsSearch";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{category}", "/{category}/"})
    public String category(HttpServletRequest request, @PathVariable String category, Map model) {
        Long startTime = System.currentTimeMillis();
        this.search(request, category, model);
        logger.info("###############index\u65b9\u6cd5\u5411\u670d\u52a1\u5668\u8bf7\u6c42\u603b\u7528\u65f6##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        return "goods/goodsSearch";
    }

    private void search(HttpServletRequest request, String category, Map model) {
        String queryStr;
        String keyWord;
        String brandStr;
        Long startTime = System.currentTimeMillis();
        String userid = (String)request.getSession().getAttribute("user_id_itaiping");
        SearchQueryVo searchQueryVo = new SearchQueryVo();
        model.put("searchQueryVo", searchQueryVo);
        if (!StringUtils.isEmpty((CharSequence)this.storeCode)) {
            String[] storeCodes;
            String storeIds = "";
            for (String code : storeCodes = this.storeCode.split(",")) {
                if (StringUtils.isEmpty((CharSequence)code)) continue;
                StoreDto store = this.storeApi.findByCode(code);
                String storeId = store.getId();
                storeIds = storeIds + storeId + "-";
            }
            if (!StringUtils.isEmpty((CharSequence)storeIds)) {
                storeIds = storeIds.substring(0, storeIds.length() - 1);
                searchQueryVo.putQueryArgs("userId", storeIds);
            }
        }
        if (StringUtils.isBlank((CharSequence)category) || StringUtils.isNotBlank((CharSequence)request.getParameter("category"))) {
            category = request.getParameter("category");
        }
        String def = request.getParameter("default");
        if (StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("price"))) {
            searchQueryVo.setPrice(Boolean.valueOf(true));
        } else if (StringUtils.equals((CharSequence)"false", (CharSequence)request.getParameter("price"))) {
            searchQueryVo.setPrice(Boolean.valueOf(false));
        } else if (StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("sale"))) {
            searchQueryVo.setSale(Boolean.valueOf(true));
        } else if (StringUtils.equals((CharSequence)"false", (CharSequence)request.getParameter("sale")) || !Lang.isEmpty((Object)def)) {
            searchQueryVo.setSale(Boolean.valueOf(false));
        } else if (StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("newProduct"))) {
            searchQueryVo.setNewProduct(Boolean.valueOf(true));
        } else if (StringUtils.equals((CharSequence)"false", (CharSequence)request.getParameter("newProduct"))) {
            searchQueryVo.setNewProduct(Boolean.valueOf(false));
        } else if (StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("new"))) {
            searchQueryVo.setNewProduct(Boolean.valueOf(true));
        } else if (StringUtils.equals((CharSequence)"false", (CharSequence)request.getParameter("new"))) {
            searchQueryVo.setNewProduct(Boolean.valueOf(false));
        } else if (StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("comments"))) {
            searchQueryVo.setComments(Boolean.valueOf(true));
        } else if (StringUtils.equals((CharSequence)"false", (CharSequence)request.getParameter("comments"))) {
            searchQueryVo.setComments(Boolean.valueOf(false));
        } else if (StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("view"))) {
            searchQueryVo.setView(Boolean.valueOf(true));
        } else if (StringUtils.equals((CharSequence)"false", (CharSequence)request.getParameter("view"))) {
            searchQueryVo.setView(Boolean.valueOf(false));
        } else {
            searchQueryVo.setDefaultSort(Boolean.valueOf(true));
            def = "true";
        }
        searchQueryVo.setHasStock(request.getParameter("hasStock"));
        ArrayList list = Lists.newArrayList();
        StringBuilder storeIds = new StringBuilder();
        StringBuffer brandIds = new StringBuffer();
        for (Map.Entry stringEntry : request.getParameterMap().entrySet()) {
            int i;
            String[] arrayStr;
            String str;
            if ("price|sale|newProduct|new|comments|view|start|pagesize|pageSize|_time|category|default|hasStock".indexOf((String)stringEntry.getKey()) >= 0) continue;
            HashMap map = Maps.newHashMap();
            if (list.size() < 5 && ((String)stringEntry.getKey()).toLowerCase().indexOf("keyword") < 0 && stringEntry.getValue() != null) {
                String valueStr = null;
                if (((String[])stringEntry.getValue()).length > 1) {
                    for (String s : (String[])stringEntry.getValue()) {
                        valueStr = valueStr + s + "|";
                    }
                } else {
                    valueStr = ((String[])stringEntry.getValue())[0];
                }
                if (valueStr.length() > 20) {
                    valueStr = valueStr.substring(0, 17) + "...";
                }
                map.put(stringEntry.getKey(), valueStr);
                if (!StringUtils.equals((CharSequence)"brand", (CharSequence)((CharSequence)stringEntry.getKey())) && ((String)stringEntry.getKey()).indexOf("store") < 0) {
                    list.add(map);
                }
            }
            if (StringUtils.isBlank((CharSequence)(str = request.getParameter((String)stringEntry.getKey())))) continue;
            if (StringUtils.equals((CharSequence)"priceRange", (CharSequence)((CharSequence)stringEntry.getKey()))) {
                if (str.indexOf("\u4ee5\u4e0a") >= 0) {
                    searchQueryVo.putQueryArgs("price", str.replaceAll("\u4ee5\u4e0a", "") + "-" + 99999999);
                    model.put("pricestart", str.replaceAll("\u4ee5\u4e0a", ""));
                    model.put("priceend", "99999999");
                    continue;
                }
                if (str.indexOf("-") <= 0) continue;
                searchQueryVo.putQueryArgs("price", str);
                String[] temps = str.split("-");
                model.put("pricestart", temps[0]);
                model.put("priceend", temps[1]);
                continue;
            }
            if (((String)stringEntry.getKey()).indexOf("store") >= 0) {
                if (str.indexOf(",") >= 0) {
                    arrayStr = str.split(",");
                    StringBuffer sbStr = new StringBuffer();
                    for (i = 0; i < arrayStr.length; ++i) {
                        StoreDto store = this.storeApi.findByStoreId(arrayStr[i]);
                        if (!Lang.isEmpty((Object)store)) {
                            if (i == 0) {
                                sbStr.append(store.getStoreExt().getShortName());
                            } else {
                                sbStr.append("\u3001").append(store.getStoreExt().getShortName());
                            }
                        }
                        storeIds.append(arrayStr[i] + "|");
                    }
                    map.put(stringEntry.getKey(), sbStr.toString());
                    list.add(map);
                    continue;
                }
                StoreDto store = this.storeApi.findByStoreId(str);
                if (!Lang.isEmpty((Object)store)) {
                    map.put(stringEntry.getKey(), store.getStoreExt().getShortName());
                    list.add(map);
                }
                storeIds.append(str + "|");
                continue;
            }
            if (((String)stringEntry.getKey()).indexOf("brand") >= 0) {
                if (str.indexOf(",") >= 0) {
                    arrayStr = str.split(",");
                    StringBuffer sbStr = new StringBuffer();
                    for (i = 0; i < arrayStr.length; ++i) {
                        ProductBrandDto productBrand = this.productBrandApi.findDataById(arrayStr[i]);
                        if (!Lang.isEmpty((Object)productBrand)) {
                            if (i == 0) {
                                sbStr.append(productBrand.getName());
                            } else {
                                sbStr.append("\u3001").append(productBrand.getName());
                            }
                        }
                        brandIds.append(arrayStr[i] + "|");
                    }
                    map.put(stringEntry.getKey(), sbStr.toString());
                    list.add(map);
                    continue;
                }
                ProductBrandDto productBrand = this.productBrandApi.findDataById(str);
                if (!Lang.isEmpty((Object)productBrand)) {
                    map.put(stringEntry.getKey(), productBrand.getName());
                    list.add(map);
                }
                brandIds.append(str + "|");
                continue;
            }
            if (((String)stringEntry.getKey()).toLowerCase().indexOf("keyword") >= 0) continue;
            searchQueryVo.putQueryArgs((String)stringEntry.getKey(), str);
        }
        String storeStr = storeIds.toString();
        if (StringUtils.isNotBlank((CharSequence)storeStr) && storeStr.length() > 1) {
            if (storeStr.endsWith("|")) {
                searchQueryVo.putQueryArgs("userId", storeStr.substring(0, storeStr.length() - 1));
            } else {
                searchQueryVo.putQueryArgs("userId", storeStr);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(brandStr = brandIds.toString())) && brandStr.length() > 1) {
            if (brandStr.endsWith("|")) {
                searchQueryVo.putQueryArgs("brand", brandStr.substring(0, brandStr.length() - 1).replaceAll("\\/", ","));
            } else {
                searchQueryVo.putQueryArgs("brand", brandStr);
            }
        }
        model.put("queryKeyword", list);
        searchQueryVo.setType("product");
        ProductCategoryDto productCategory = null;
        ProductCategoryDto productCategoryBrand = null;
        if (!Lang.isEmpty((Object)category)) {
            productCategoryBrand = productCategory = this.categroyService.findCategory(category);
            if (!Lang.isEmpty((Object)productCategory)) {
                List<HashMap> categoryList = new ArrayList<HashMap>();
                HashMap map = Maps.newHashMap();
                map.put(productCategory.getId(), productCategory.getName());
                categoryList.add(map);
                while (productCategory.getParent() != null && !productCategory.getParent().getId().equals(productCategory.getId())) {
                    productCategory = productCategory.getParent();
                    HashMap mapt = Maps.newHashMap();
                    mapt.put(productCategory.getId(), productCategory.getName());
                    categoryList.add(mapt);
                }
                categoryList = Lists.reverse(categoryList);
                model.put("categoryList", categoryList);
                model.put("productCategory", productCategory);
                searchQueryVo.putQueryArgs("category", category);
            }
        }
        if (Strings.isNullOrEmpty((String)(keyWord = request.getParameter("keyWord")))) {
            keyWord = request.getParameter("keyword");
        }
        if (!Strings.isNullOrEmpty((String)keyWord)) {
            keyWord = keyWord.trim();
            searchQueryVo.setKeyWord(keyWord);
            if (this.checkWordLength(keyWord).booleanValue()) {
                this.goodWebService.putKeyWords("SEARCH_KEYWORD_CT", keyWord);
            }
        }
        Integer pageSize = 20;
        if (request.getParameter("pageSize") != null && StringUtils.isNumeric((CharSequence)request.getParameter("pageSize"))) {
            pageSize = Integer.parseInt(request.getParameter("pageSize"));
        }
        Integer start = 0;
        if (request.getParameter("start") != null && StringUtils.isNumeric((CharSequence)request.getParameter("start"))) {
            start = Integer.parseInt(request.getParameter("start"));
        }
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            CoreCompanyDto company;
            CoreUserDto coreUsers = this.coreUserApi.findById(userid);
            CoreCompDepartUserDto examp = new CoreCompDepartUserDto();
            examp.setUserId(userid);
            List relatedVoList = this.compDepartUserApi.findRelatedVoByExample(examp);
            if (Lang.isEmpty((Object)relatedVoList) || (company = ((CoreCompDepartUserVo)relatedVoList.get(0)).getCoreCompany()) != null) {
                // empty if block
            }
            company = null;
        }
        if (StringUtils.isNotBlank((CharSequence)(queryStr = request.getParameter("query")))) {
            String[] querys = queryStr.split("[,|;]");
            for (String query : querys) {
                String[] keywords;
                if (query == null || (keywords = query.split(":")) == null || keywords.length != 2) continue;
                searchQueryVo.putQueryArgs(keywords[0], keywords[1]);
            }
        }
        SearchQueryVo hotq = new SearchQueryVo();
        try {
            BeanUtils.copyProperties((Object)hotq, (Object)searchQueryVo);
            hotq.setQueryMap((Map)Maps.newHashMap());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)hotq.getKeyWord()) && (hotq.getQueryMap() == null || hotq.getQueryMap().size() == 0)) {
            hotq.putQueryArgs("price", "0-9999999");
        }
        if (searchQueryVo.getQueryMap().containsKey("userId")) {
            hotq.putQueryArgs("userId", (String)searchQueryVo.getQueryMap().get("userId"));
        }
        hotq.setPrice(null);
        hotq.setSale(Boolean.valueOf(false));
        hotq.setNewProduct(null);
        hotq.setView(null);
        hotq.setOrganizationCode(this.organizationCode);
        SearchResultVo hotSales = this.searchApi.query(hotq, Integer.valueOf(6), Integer.valueOf(0));
        logger.info("###############hotSales\u65b9\u6cd5\u5411\u670d\u52a1\u5668\u8bf7\u6c42\u603b\u7528\u65f6##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        if (!Lang.isEmpty((Object)hotSales) && hotSales.getResult().size() == 0) {
            List rows = this.jdbcTemplate.queryForList(countSaleSql);
            ArrayList resultList = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            if (!Lang.isEmpty((Object)rows) && rows.size() > 0) {
                for (Map rowMap : rows) {
                    String goodsId = (String)rowMap.get("goods_id");
                    logger.info("goodsId{}", (Object)goodsId);
                    idList.add(goodsId);
                }
                List commonDocs = this.shareApi.setCommonDocList(idList);
                hotSales.setResult(this.mapperFacade.mapAsList((Iterable)commonDocs, CommonDoc.class));
            } else {
                int max = 13000;
                int min = 0;
                Random random = new Random();
                int pageStart = random.nextInt(max) % (max - min + 1) + min;
                int pageEnd = pageStart + 5;
                List rondomRows = this.jdbcTemplate.queryForList(randomNumSql, new Object[]{pageStart, pageEnd});
                if (!Lang.isEmpty((Object)rondomRows) && rondomRows.size() > 0) {
                    for (Map rowMap : rondomRows) {
                        String goodsId = (String)rowMap.get("id");
                        logger.info("goodsId{}", (Object)goodsId);
                        idList.add(goodsId);
                    }
                    List commonDocs = this.shareApi.setCommonDocList(idList);
                    hotSales.setResult(this.mapperFacade.mapAsList((Iterable)commonDocs, CommonDoc.class));
                }
            }
        }
        model.put("hotSales", hotSales);
        this.transformPicture(hotSales);
        logger.info("###############hotsale##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)searchQueryVo.getKeyWord()) && (searchQueryVo.getQueryMap() == null || searchQueryVo.getQueryMap().size() == 0)) {
            searchQueryVo.putQueryArgs("price", "0-9999999");
        }
        searchQueryVo.setOrganizationCode(this.organizationCode);
        SearchResultVo searchResultVo = this.searchApi.query(searchQueryVo, Integer.valueOf(200), Integer.valueOf(0));
        List commonDocsCheck = searchResultVo.getResult();
        if (StringUtils.equals((CharSequence)"1", (CharSequence)searchQueryVo.getHasStock())) {
            List resultVos;
            String area = "";
            String storeId = this.storeApi.findStoreIdByCode(this.storeCode);
            Map addressMap = this.areaService.getAddressIdSByParams(request, (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID"));
            String proviceId = (String)addressMap.get("provoiceId");
            String cityId = (String)addressMap.get("cityId");
            String areaId = (String)addressMap.get("areaId");
            String townId = (String)addressMap.get("townId");
            HashMap<Integer, String> comAddrMap = new HashMap<Integer, String>();
            comAddrMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), proviceId);
            comAddrMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), cityId);
            comAddrMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), areaId);
            comAddrMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), townId);
            HandlerRespVo jdAddrResp = this.outsideProductApi.transAreaCodeMap(storeId, comAddrMap);
            if (!Lang.isEmpty((Object)jdAddrResp.getData())) {
                StringBuilder areaTemp = new StringBuilder();
                for (int i = 1; i <= 4; ++i) {
                    areaTemp.append((String)((Map)jdAddrResp.getData()).get(i));
                    if (i == 4) continue;
                    areaTemp.append("_");
                }
                area = areaTemp.toString();
            }
            long t = System.currentTimeMillis();
            HashMap<String, CommonDoc> skuMap = new HashMap<String, CommonDoc>();
            if (!Lang.isEmpty((Object)area)) {
                logger.info("\u8f6c\u6362\u5730\u5740: {}", (Object)area);
                ArrayList<String> skus = new ArrayList<String>();
                for (CommonDoc commonDoc : commonDocsCheck) {
                    if (!Lang.isEmpty((Object)commonDoc.getSku())) {
                        skuMap.put(commonDoc.getSku(), commonDoc);
                        skus.add(commonDoc.getSku());
                        continue;
                    }
                    logger.error("\u7d22\u5f15\u6587\u4ef6 SKU \u4e3a\u7a7a DATA : {}", (Object)JSON.toJSONString((Object)commonDoc));
                }
                resultVos = this.stockState(skus, area);
            } else {
                resultVos = new ArrayList();
                logger.info("\u8f6c\u6362\u5730\u5740\u4e3a\u7a7a");
            }
            logger.info("\u5e93\u5b58\u8fc7\u6ee4\u8017\u8d39\u65f6\u95f4 {} ms", (Object)(System.currentTimeMillis() - t));
            Iterator newResult = new ArrayList();
            block15: for (CommonDoc commonDoc : commonDocsCheck) {
                for (StockNewResultVo resultVo : resultVos) {
                    if (Lang.isEmpty((Object)commonDoc.getSku()) || !resultVo.hasStock().booleanValue() || !commonDoc.getSku().equals(resultVo.getSkuId() + "")) continue;
                    newResult.add(skuMap.get(resultVo.getSkuId() + ""));
                    continue block15;
                }
            }
            searchResultVo.setStart(start);
            searchResultVo.setPageSize(pageSize);
            searchResultVo.setTotal(Integer.valueOf(newResult.size()));
            int l = pageSize * start;
            int r = l + pageSize;
            ArrayList commonDocPage = new ArrayList();
            for (int i = l; i < r && i < newResult.size(); ++i) {
                commonDocPage.add(newResult.get(i));
            }
            searchResultVo.setResult(commonDocPage);
        } else {
            searchResultVo = this.searchApi.query(searchQueryVo, pageSize, start);
        }
        if (searchResultVo.getTotal() > 200) {
            searchResultVo.setTotal(Integer.valueOf(200));
        }
        this.transformPicture(searchResultVo);
        model.put("searchResultVo", searchResultVo);
        logger.info("###############searchResult##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        List brands = Lists.newArrayList();
        List standards = Lists.newArrayList();
        Double maxPrice = 0.0;
        searchQueryVo.setOrganizationCode(this.organizationCode);
        SearchResultVo searchResultVoTemp = this.searchApi.query(searchQueryVo, Integer.valueOf(100), Integer.valueOf(0));
        if (searchResultVoTemp != null && searchResultVoTemp.getResult() != null && searchResultVoTemp.getResult().size() > 0) {
            List commonDocs = searchResultVoTemp.getResult();
            HashMap map = Maps.newHashMap();
            ArrayList<String> brandIdList = new ArrayList<String>();
            ArrayList<String> goodsIdList = new ArrayList<String>();
            for (CommonDoc commonDoc : commonDocs) {
                if (commonDoc.getPrice() != null && maxPrice < commonDoc.getPrice()) {
                    maxPrice = commonDoc.getPrice();
                }
                if (!Lang.isEmpty((Object)commonDoc.getBrand())) {
                    brandIdList.add(commonDoc.getBrand());
                    continue;
                }
                goodsIdList.add(commonDoc.getGoodsId());
            }
            brands = this.setBrandsByIds(brandIdList);
            if (Lang.isEmpty((Object)brands)) {
                brands = this.setBrandsByGoodsIds(goodsIdList);
            }
            if (!Lang.isEmpty((Object)productCategoryBrand)) {
                brands = productCategoryBrand.getProductBrands();
                if (Lang.isEmpty(brands) && brands.size() == 0) {
                    ArrayList brands1 = Lists.newArrayList();
                    ArrayList brands2 = Lists.newArrayList();
                    ArrayList productCategoryBrandChild = new ArrayList();
                    List productCategoryBrandChildPO = this.productCategoryRepos.findByParentIdAndIsDeleteOrderByShowIndexAsc(productCategoryBrand.getId(), Boolean.valueOf(false));
                    Copys copys = Copys.create();
                    productCategoryBrandChildPO.forEach(productCategoryPO -> {
                        ProductCategoryDto productCategoryDTO = new ProductCategoryDto();
                        copys.from(productCategoryPO).excludes(new String[]{"parent", "child", "productModel", "productBrands", "productStandards", "productExtendPropertys"}).to(new Object[]{productCategoryDTO}).clear();
                        ArrayList productBrandDTOs = new ArrayList();
                        productCategoryPO.getProductBrands().forEach(productBrandPO -> {
                            ProductBrandDto productBrandDTO = new ProductBrandDto();
                            copys.from(productBrandPO).excludes(new String[]{"parent", "child"}).to(new Object[]{productBrandDTO}).clear();
                            productBrandDTOs.add(productBrandDTO);
                        });
                        productCategoryDTO.setProductBrands(productBrandDTOs);
                        productCategoryBrandChild.add(productCategoryDTO);
                    });
                    if (!Lang.isEmpty(productCategoryBrandChild)) {
                        for (ProductCategoryDto productCategoryChild : productCategoryBrandChild) {
                            brands1.addAll(productCategoryChild.getProductBrands());
                        }
                    }
                    if (Lang.isEmpty((Object)brands1)) {
                        for (ProductCategoryDto productCategoryChild : productCategoryBrand.getChild()) {
                            ArrayList productCategoryChildChilds = new ArrayList();
                            List productCategoryChildChildsPO = this.productCategoryRepos.findByParentIdAndIsDeleteOrderByShowIndexAsc(productCategoryChild.getId(), Boolean.valueOf(false));
                            productCategoryBrandChildPO.forEach(productCategoryPO -> {
                                ProductCategoryDto productCategoryDTO = new ProductCategoryDto();
                                copys.from(productCategoryPO).excludes(new String[]{"parent", "child", "productModel", "productBrands", "productStandards", "productExtendPropertys"}).to(new Object[]{productCategoryDTO}).clear();
                                ArrayList productBrandDTOs = new ArrayList();
                                productCategoryPO.getProductBrands().forEach(productBrandPO -> {
                                    ProductBrandDto productBrandDTO = new ProductBrandDto();
                                    copys.from(productBrandPO).excludes(new String[]{"parent", "child"}).to(new Object[]{productBrandDTO}).clear();
                                    productBrandDTOs.add(productBrandDTO);
                                });
                                productCategoryDTO.setProductBrands(productBrandDTOs);
                                productCategoryBrandChild.add(productCategoryDTO);
                            });
                            if (Lang.isEmpty(productCategoryChildChilds)) continue;
                            for (ProductCategoryDto productCategoryChildChild : productCategoryChildChilds) {
                                brands2.addAll(productCategoryChildChild.getProductBrands());
                            }
                        }
                        if (Lang.isEmpty((Object)brands2)) {
                            PageRequest pageable = new PageRequest(0, 20);
                            brands = this.productBrandApi.listAllBrands((Pageable)pageable).getContent();
                        } else {
                            brands = brands2;
                        }
                    } else {
                        brands = brands1;
                    }
                }
                ArrayList newList = new ArrayList(new HashSet(brands));
                brands = newList;
                standards = productCategoryBrand.getProductStandards();
            } else {
                String categoryId = null;
                Integer max = -1;
                for (Map.Entry entry : map.entrySet()) {
                    if ((Integer)entry.getValue() <= max) continue;
                    max = (Integer)entry.getValue();
                    categoryId = (String)entry.getKey();
                }
                if (categoryId != null) {
                    logger.info("categoryId=" + categoryId);
                    if (categoryId.indexOf(",") >= 0) {
                        String[] arrayCategory = categoryId.split(",");
                        ArrayList<String> categoryIdList = new ArrayList<String>();
                        for (int i = 0; i < arrayCategory.length; ++i) {
                            categoryIdList.add(arrayCategory[i]);
                        }
                        List productCategorys = this.setProductCategoryList(categoryIdList);
                        for (ProductCategoryDto category1 : productCategorys) {
                            if (category1 == null) continue;
                            brands.addAll(category1.getProductBrands());
                            standards.addAll(category1.getProductStandards());
                        }
                    } else {
                        ProductCategoryDto category1 = this.productCategoryApi.findOne(categoryId);
                        if (category1 != null) {
                            brands.addAll(category1.getProductBrands());
                            standards.addAll(category1.getProductStandards());
                        }
                    }
                }
                if (Lang.isEmpty(brands)) {
                    for (String cstr : map.keySet()) {
                        logger.info("categoryId cstr  =" + cstr);
                        if (cstr.equals(categoryId)) continue;
                        if (cstr.indexOf(",") >= 0) {
                            String[] arrayCategory = cstr.split(",");
                            ArrayList<String> categoryIdList = new ArrayList<String>();
                            for (int i = 0; i < arrayCategory.length; ++i) {
                                categoryIdList.add(arrayCategory[i]);
                            }
                            List productCategorys = this.setProductCategoryList(categoryIdList);
                            for (ProductCategoryDto category1 : productCategorys) {
                                if (category1 == null) continue;
                                brands.addAll(category1.getProductBrands());
                                standards.addAll(category1.getProductStandards());
                            }
                            continue;
                        }
                        ProductCategoryDto category1 = this.productCategoryApi.findOne(cstr);
                        if (category1 == null) continue;
                        brands.addAll(category1.getProductBrands());
                        standards.addAll(category1.getProductStandards());
                    }
                }
            }
        }
        logger.info("###############queryParams##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        if (maxPrice > 10.0 && searchResultVo.getResult().size() != 1 && Lang.isEmpty((Object)request.getParameter("priceRange"))) {
            Double tem = maxPrice / 6.0;
            ArrayList<String> priceRange = new ArrayList<String>();
            for (int i = 0; i < 6; ++i) {
                if (i == 0) {
                    priceRange.add(0 + i * tem.intValue() + "-" + (tem.intValue() + i * tem.intValue()));
                    continue;
                }
                if (i < 5) {
                    priceRange.add(1 + i * tem.intValue() + "-" + (tem.intValue() + i * tem.intValue()));
                    continue;
                }
                priceRange.add(i * tem.intValue() + "\u4ee5\u4e0a");
            }
            model.put("priceRange", priceRange);
        }
        if (!Lang.isEmpty((Object)searchResultVo) && !Lang.isEmpty((Object)searchResultVo.getResult()) && Lang.isEmpty((Object)brands)) {
            List commonDocs = searchResultVo.getResult();
            ArrayList<String> brandIdList = new ArrayList<String>();
            ArrayList<String> goodsIdList = new ArrayList<String>();
            for (CommonDoc commonDoc : commonDocs) {
                if (!Lang.isEmpty((Object)commonDoc.getBrand())) {
                    brandIdList.add(commonDoc.getBrand());
                    continue;
                }
                goodsIdList.add(commonDoc.getGoodsId());
            }
            brands = this.setBrandsByIds(brandIdList);
            if (Lang.isEmpty(brands)) {
                brands = this.setBrandsByGoodsIds(goodsIdList);
            }
            logger.info("###############keywords##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            startTime = System.currentTimeMillis();
            try {
                if (Lang.isEmpty(brands)) {
                    PageRequest pageable = new PageRequest(0, 20);
                    brands = this.productBrandApi.listAllBrands((Pageable)pageable).getContent();
                }
            }
            catch (Exception ex) {
                logger.error("ex:{}", (Throwable)ex);
            }
        }
        if (brands != null) {
            ArrayList newList = new ArrayList(new HashSet(brands));
            brands = newList;
        }
        if (!Lang.isEmpty((Object)request.getParameter("brand")) || Lang.isEmpty((Object)searchResultVo) || !Lang.isEmpty((Object)searchResultVo) && searchResultVo.getResult().size() == 0) {
            brands = Lists.newArrayList();
        }
        if (!Lang.isEmpty((Object)def)) {
            searchQueryVo.setSale(null);
            searchQueryVo.setDefaultSort(Boolean.valueOf(true));
        }
        SearchKeywordsHisDto searchKeywordsHisDto = new SearchKeywordsHisDto();
        searchKeywordsHisDto.setSearchId(userid);
        searchKeywordsHisDto.setKeyWord(keyWord);
        searchKeywordsHisDto.setOrganizationCode(this.organizationCode);
        searchKeywordsHisDto.setHttpHeaderInfo(HttpHeaderUtils.getHeaderInfo((HttpServletRequest)request));
        this.searchKeyWordsApi.saveHis(searchKeywordsHisDto);
        model.put("brands", brands);
        model.put("standards", standards);
    }

    public Map getCityAndAreaId(String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        AddressDto a = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(true));
        if (a != null) {
            returnCityId = a.getId();
            if (!Lang.isEmpty((Object)a.getChild())) {
                returnAreaId = ((AddressDto)a.getChild().get(0)).getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp((HttpServletRequest)request);
        if (!Lang.isEmpty((Object)remoteIp)) {
            Long ipL = IPtoLong.ipToLong((String)remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty((Object)areaId) && !Lang.isEmpty((Object)(currentAaddress = this.addressCommonApi.findAreaByIp(ipL, 3)))) {
                returnAreaId = currentAaddress.getId();
                returnCityId = currentAaddress.getParent().getId();
            }
        }
        if (Lang.isEmpty(returnAreaId)) {
            AddressDto cityAddress = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(true));
            returnCityId = "110100";
            returnAreaId = "110101";
            returnTownId = "d8a15c70-9c8a-44b6-bc34-06b457ecfaaf";
        }
        request.getSession().setAttribute("AREA_LEVEL_CITY_ID", returnCityId);
        request.getSession().setAttribute("AREA_LEVEL_AREA_ID", returnAreaId);
        request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", (Object)returnTownId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    private String getDefaultProvinceId(HttpServletRequest request) {
        String provinceId = null;
        Object memberId = request.getSession().getAttribute("member_id");
        MemberAddressDto defaultAddress = null;
        if (!Lang.isEmpty((Object)memberId)) {
            defaultAddress = this.memberAddressApi.defaultAddress(memberId.toString());
        }
        if (!Lang.isEmpty(defaultAddress)) {
            provinceId = defaultAddress.getProvinceCode();
        }
        return provinceId;
    }

    private List<StockNewResultVo> stockState(List<String> skus, String area) {
        ArrayList<StockNewResultVo> result = new ArrayList<StockNewResultVo>();
        int count = 0;
        ArrayList<StockVO> skuNums = new ArrayList<StockVO>();
        ArrayList<Long> longSkus = new ArrayList<Long>();
        for (String sku : skus) {
            skuNums.add(new StockVO(Long.valueOf(Long.parseLong(sku)), Integer.valueOf(1)));
            longSkus.add(Long.parseLong(sku));
            if (++count % 100 != 0 && count != skus.size()) continue;
            StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
            stockForOrderEntity.setSkuNums(skuNums);
            stockForOrderEntity.setArea(area);
            List stockNewResultVos = this.jdProductApi.getStockForOrder(stockForOrderEntity);
            long startTime = System.currentTimeMillis();
            List productStateVOS = this.jdProductApi.getProductState(longSkus);
            HashSet<Long> saleOutSkus = new HashSet<Long>();
            for (ProductStateVO productStateVO : productStateVOS) {
                if (productStateVO.getState() != 0) continue;
                saleOutSkus.add(productStateVO.getSku());
            }
            List goodsStateDtos = this.goodsApi.queryGoodsState(skus);
            if (goodsStateDtos != null && !goodsStateDtos.isEmpty()) {
                for (GoodsStateDto goodsStateDto : goodsStateDtos) {
                    if (goodsStateDto.getDelete() == null || goodsStateDto.getState() == null || !goodsStateDto.getDelete().booleanValue() && !"0".equals(goodsStateDto.getState())) continue;
                    saleOutSkus.add(Long.parseLong(goodsStateDto.getSku()));
                }
            }
            logger.info("\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
            if (!saleOutSkus.isEmpty()) {
                for (StockNewResultVo stockNewResultVo : stockNewResultVos) {
                    if (saleOutSkus.contains(stockNewResultVo.getSkuId())) continue;
                    result.add(stockNewResultVo);
                }
            } else if (!Lang.isEmpty((Object)stockNewResultVos)) {
                result.addAll(stockNewResultVos);
            }
            longSkus.clear();
            skuNums.clear();
        }
        return result;
    }

    public void transformPicture(SearchResultVo searchResultVo) {
        if (searchResultVo != null && searchResultVo.getResult() != null && !searchResultVo.getResult().isEmpty()) {
            for (CommonDoc commonDoc : searchResultVo.getResult()) {
                if (StringUtils.isEmpty((CharSequence)commonDoc.getLogoUrl())) continue;
                commonDoc.setLogoUrl(commonDoc.getLogoUrl().replace("vc", "n7"));
            }
        }
    }

    private List<ProductCategoryDto> setProductCategoryList(List<String> categoryIdList) {
        ArrayList<ProductCategoryDto> returnProductCategorys = new ArrayList();
        returnProductCategorys = this.productCategoryApi.findByIdIn(categoryIdList);
        return returnProductCategorys;
    }

    private List<ProductBrandDto> setBrandsByGoodsIds(List<String> goodsIdList) {
        ArrayList<ProductBrandDto> returnBrands = new ArrayList();
        List brandsName = this.goodsApi.findByBrandNameByIds(goodsIdList);
        returnBrands = this.productBrandApi.findByNameIn(brandsName);
        return returnBrands;
    }

    private List<ProductBrandDto> setBrandsByIds(List<String> brandIdList) {
        ArrayList<ProductBrandDto> returnBrands = new ArrayList();
        returnBrands = this.productBrandApi.findByIdIn(brandIdList);
        return returnBrands;
    }

    public void listSort(List<CommonDocVo> resultList) {
        Collections.sort(resultList, new /* Unavailable Anonymous Inner Class!! */);
    }

    private Boolean checkWordLength(String keyWord) {
        Boolean canAdd = false;
        String chinese = "[\u4e00-\u9fa5]";
        Integer length = 0;
        if (keyWord.length() <= 12) {
            for (int i = 0; i < keyWord.length(); ++i) {
                String temp = keyWord.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    length = length + 2;
                    continue;
                }
                Integer n = length;
                Integer n2 = length = Integer.valueOf(length + 1);
            }
        }
        if (length <= 12) {
            canAdd = true;
        }
        return canAdd;
    }
}

