/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.goods;

import aftersale.api.DiscussApi;
import cart.api.OrderItemApi;
import cart.api.dto.order.OrderItemDto;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.goods.GoodWebService;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductFashionDto;
import goods.vo.BuyHistoryVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.MemberFavoriteApi;
import member.api.dto.shop.MemberFavoriteDto;
import member.api.vo.MemberVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

@Controller
@RequestMapping(value={"share"})
public class ShareController {
    private static final Logger logger = LoggerFactory.getLogger(ShareController.class);
    @Autowired
    GoodWebService goodWebService;
    @MotanReferer
    MemberFavoriteApi memberFavoriteApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    DiscussApi discussApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrderItemApi orderItemApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;

    @RequestMapping(value={"addFavorite.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map addFavorite(@RequestParam String productId, Map model, HttpServletRequest request) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        MemberVo memberVo = this.goodWebService.findMemberVo(request);
        Boolean isAddFavoriteFlag = true;
        List memberFavorites = this.memberFavoriteApi.list(memberVo.getMember().getId());
        if (!Lang.isEmpty((Object)memberFavorites)) {
            for (MemberFavoriteDto memberFavorite : memberFavorites) {
                if (!memberFavorite.getTargetId().equals(productId)) continue;
                isAddFavoriteFlag = false;
                break;
            }
        }
        String responseMessage = null;
        if (!isAddFavoriteFlag.booleanValue()) {
            responseMessage = "\u60a8\u5df2\u7ecf\u6536\u85cf\u6211\u5566\uff01";
            returnMap.put("status", "success");
            returnMap.put("message", responseMessage);
        } else {
            MemberFavoriteDto favorite = this.memberFavoriteApi.addFavorite(memberVo.getMember().getId(), "PRODUCT_ID", productId);
            responseMessage = "\u60a8\u7684\u5546\u54c1\u5df2\u7ecf\u6536\u85cf\u6210\u529f\uff01";
            returnMap.put("status", "success");
            returnMap.put("message", responseMessage);
        }
        return returnMap;
    }

    @RequestMapping(value={"getDiscuss.do"})
    @ResponseBody
    public Map getDiscussPage(String goodsId, Pageable pageable) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Page discussPage = this.discussApi.findDiscussByValidFlagAndIsDeleteAndParamsPage(goodsId, Integer.valueOf(1), Boolean.valueOf(false), pageable);
        returnMap.put("data", discussPage);
        returnMap.put("totalPages", this.getTotalPages((int)discussPage.getTotalElements(), pageable.getPageSize()));
        return returnMap;
    }

    @RequestMapping(value={"buyHistory.do"})
    @ResponseBody
    public Map buyHistory(String goodsId, Pageable pageable) {
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("5");
        ArrayList<BuyHistoryVo> list = new ArrayList<BuyHistoryVo>();
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
        if (Lang.isEmpty((Object)organization)) {
            returnMap.put("data", null);
            returnMap.put("totalPages", null);
            returnMap.put("size", null);
            return returnMap;
        }
        Sort.Order order = new Sort.Order(Sort.Direction.DESC, "order.dateCreated");
        ArrayList<Sort.Order> sortList = new ArrayList<Sort.Order>();
        sortList.add(order);
        Sort sort = new Sort(sortList);
        PageRequest pageableQuery = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), sort);
        Page orderItems = this.orderItemApi.findOrderItemByGoodsIdAndStatusAndIsDelete(goodsId, statusList, Boolean.valueOf(false), organization.getId(), (Pageable)pageableQuery);
        for (int i = 0; i < orderItems.getContent().size(); ++i) {
            BuyHistoryVo buyHistoryVo = new BuyHistoryVo();
            MemberVo memberVo = this.memberApi.getMemberInfo(((OrderItemDto)orderItems.getContent().get(i)).getOrder().getMemberId());
            ProductFashionDto productFashion = this.productFashionApi.findById(((OrderItemDto)orderItems.getContent().get(i)).getProductFashId());
            String memberName = memberVo.getMember().getRealName();
            if (!Lang.isEmpty((Object)memberName)) {
                Integer num = memberName.length() / 2;
                memberName = memberName.substring(0, num);
                for (int a = 0; a < num; ++a) {
                    memberName = memberName + "*";
                }
            }
            if (Lang.isEmpty((Object)memberName) && !Lang.isEmpty((Object)(memberName = memberVo.getUser().getPhone()))) {
                memberName = memberName.substring(0, 3) + "****" + memberName.substring(memberName.length() - 4);
            }
            if (Lang.isEmpty((Object)memberName) && !Lang.isEmpty((Object)(memberName = memberVo.getUser().getEmail()))) {
                if (memberName.indexOf("@") > 2) {
                    memberName = memberName.substring(0, 3) + "****" + memberName.substring(memberName.indexOf("@"));
                } else if (memberName.indexOf("@") > 0) {
                    memberName = memberName.substring(0, memberName.indexOf("@")) + "****" + memberName.substring(memberName.indexOf("@"));
                }
            }
            buyHistoryVo.setMemberName(memberName);
            buyHistoryVo.setStyleName(productFashion.getFieldName());
            buyHistoryVo.setSalePrice(((OrderItemDto)orderItems.getContent().get(i)).getFinalPrice());
            buyHistoryVo.setCount(((OrderItemDto)orderItems.getContent().get(i)).getCount());
            buyHistoryVo.setCreateTime(((OrderItemDto)orderItems.getContent().get(i)).getOrder().getCreateTime());
            list.add(buyHistoryVo);
        }
        returnMap.put("data", list);
        returnMap.put("totalPages", Integer.valueOf(this.getTotalPages((int)orderItems.getTotalElements(), pageable.getPageSize())));
        returnMap.put("size", Integer.valueOf(orderItems.getSize()));
        return returnMap;
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }
}

