/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.index;

import activities.api.ActivityConfigurationApi;
import cms.api.AnnouncementApi;
import cms.api.BannerApi;
import cms.api.FloorApi;
import cms.api.MemberReadAnnouncementApi;
import cms.api.dto.FloorContentDto;
import cms.api.dto.FloorDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductCategoryApi;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import member.api.CoreCompanyApi;
import member.api.CoreUserApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import store.api.StoreExtApi;
import utils.Lang;
import utils.freemarker.FreeMarkers;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={""})
public class IndexController {
    private static final Log log = Logs.getLog((String)IndexController.class.getName());
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private ProductCategoryApi productCategoryApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private AnnouncementApi announcementApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private MemberReadAnnouncementApi memberReadAnnouncementApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private BannerApi bannerApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private FloorApi floorApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private StoreExtApi storeExtApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private CoreCompanyApi coreCompanyApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private CoreUserApi coreUserApi;
    private static final Integer ANNOUNCEMENTSHOWNUM = 6;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @Value(value="${secKillOrganization.code}")
    private String secKillOrganizationCode;
    @Value(value="${secKillActivity.activityCode}")
    private String secKillActivityCode;
    @Value(value="${secKillStore.code}")
    private String secKillStoreCode;
    @Value(value="${tuanGouOrganization.code}")
    private String tuanGouOrganizationCode;
    @Value(value="${tuanGouActivity.activityCode}")
    private String tuanGouActivityCode;
    @Value(value="${tuanGouStore.code}")
    private String tuanGouStoreCode;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;

    @RequestMapping(value={"", "/", "index.html", "index.htm"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, Map model) {
        long methodStart = System.currentTimeMillis();
        log.info((Object)"### \u5f00\u59cb\u52a0\u8f7d INDEX ... ###");
        long bannerTime = System.currentTimeMillis();
        List bannerList = this.bannerApi.findBannerListByType(Integer.valueOf(1), null, this.organizationCode);
        log.info((Object)"\u67e5\u8be2 banner \u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - bannerTime});
        long floorTimr = System.currentTimeMillis();
        List floorList = this.floorApi.findFloorList(Integer.valueOf(1), null, this.organizationCode);
        log.info((Object)"\u67e5\u8be2 floor \u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - floorTimr});
        String floorString = this.getFloorList(floorList);
        model.put("bannerList", bannerList);
        model.put("floorString", floorString);
        model.put("floorList", floorList);
        long activityTime = System.currentTimeMillis();
        try {
            this.activityConfigurationApi.getActivityByCode(this.tuanGouOrganizationCode, this.tuanGouActivityCode);
            this.activityConfigurationApi.getActivityByCode(this.secKillOrganizationCode, this.secKillActivityCode);
            model.put("secKillActivityCode", this.secKillActivityCode);
            model.put("tuanGouActivityCode", this.tuanGouActivityCode);
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u6d3b\u52a8\u5f02\u5e38", new Object[]{e});
        }
        log.info((Object)"\u6d3b\u52a8\u521d\u59cb\u5316\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - activityTime});
        log.info((Object)"### \u52a0\u8f7d INDEX \u603b\u8017\u65f6 {} ms ###", new Object[]{System.currentTimeMillis() - methodStart});
        return "index/index";
    }

    private String getFloorList(List<FloorDto> floorList) {
        StringBuilder floorStringBuffer = new StringBuilder();
        if (!Lang.isEmpty(floorList)) {
            for (int i = 0; i < floorList.size(); ++i) {
                FloorDto floor = floorList.get(i);
                HashMap<String, Object> floorContentMap = new HashMap<String, Object>();
                floorContentMap.put("floorName", floor.getName());
                floorContentMap.put("floorIndex", i);
                if (!Lang.isEmpty((Object)floor.getFloorContents())) {
                    List sortFloorContents = floor.getFloorContents().stream().filter(floorContentDto -> floorContentDto.getIsDelete() == false).sorted(Comparator.comparing(FloorContentDto::getShowIndex)).collect(Collectors.toList());
                    for (int j = 0; j < sortFloorContents.size(); ++j) {
                        FloorContentDto content = (FloorContentDto)sortFloorContents.get(j);
                        floorContentMap.put("image" + (j + 1), content.getContentImageUrl());
                        floorContentMap.put("path" + (j + 1), content.getLinkUrl());
                    }
                }
                if (Lang.isEmpty((Object)floor.getFloorTemplate())) continue;
                String turnResult = FreeMarkers.renderString((String)floor.getFloorTemplate().getTemplateContent(), floorContentMap);
                floorStringBuffer.append(turnResult);
                floorStringBuffer.append("\n");
            }
        }
        return floorStringBuffer.toString();
    }

    @RequestMapping(value={"upGrade"}, method={RequestMethod.GET})
    public String upGrade(Map model) {
        return "index/upGrade";
    }

    @RequestMapping(value={"upGrade2"}, method={RequestMethod.GET})
    public String upGrade2(Map model) {
        return "index/upGrade2";
    }

    @RequestMapping(value={"getCategory"}, method={RequestMethod.GET})
    @Profile(value={"local"})
    @ResponseBody
    public Map testGetCategory(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        HashMap<String, List> returnModel = new HashMap<String, List>();
        List categoryList = this.productCategoryApi.findCategoryByLayerLessThanEqual(Integer.valueOf(3), this.organizationCode, Boolean.valueOf(true));
        returnModel.put("categoryList", categoryList);
        log.info((Object)("###############\u65b9\u6cd5\u5411\u670d\u52a1\u5668\u8bf7\u6c42\u603b\u7528\u65f6##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        return returnModel;
    }

    @RequestMapping(value={"getCacheCategory"}, method={RequestMethod.GET})
    @Profile(value={"local"})
    @ResponseBody
    public Map testCacheGetCategory(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        HashMap<String, List> returnModel = new HashMap<String, List>();
        List categoryList = this.productCategoryApi.findCategoryByLayerLessThanEqual(Integer.valueOf(3), this.organizationCode, Boolean.valueOf(true));
        returnModel.put("categoryList", categoryList);
        log.info((Object)("###############\u65b9\u6cd5\u5411\u670d\u52a1\u5668\u8bf7\u6c42\u603b\u7528\u65f6##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        return returnModel;
    }

    @RequestMapping(value={"getBrand"}, method={RequestMethod.GET})
    @Profile(value={"local"})
    @ResponseBody
    public Map getBrand(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        HashMap<String, List> returnModel = new HashMap<String, List>();
        List categoryList = this.productCategoryApi.findCategoryByLayerLessThanEqual(Integer.valueOf(3), this.organizationCode, Boolean.valueOf(true));
        returnModel.put("categoryList", categoryList);
        log.info((Object)("###############\u65b9\u6cd5\u5411\u670d\u52a1\u5668\u8bf7\u6c42\u603b\u7528\u65f6##############\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        return returnModel;
    }
}

