/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.index;

import cart.api.CartApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.member.ScoreUserService;
import ctscore.web.utils.AddressUtil;
import goods.api.ProductCategoryApi;
import goods.vo.ProductCategoryVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.AddressCommonApi;
import member.api.MemberApi;
import member.api.dto.common.AddressCodeDTO;
import member.api.dto.common.AddressDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import sysmg.api.SystemConfigApi;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.web.AddressUtils;

@Controller
@RequestMapping(value={"top"})
public class MallTopController {
    private static final Log log = Logs.getLog((String)MallTopController.class.getName());
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private AddressCommonApi addressCommonApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private CartApi cartApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private MemberApi memberApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private ProductCategoryApi productCategoryApi;
    @MotanReferer
    private SystemConfigApi systemConfigApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @Value(value="${itaiping.usercenter.index}")
    private String itaipingUserCenterIndex;
    @Value(value="${itaiping.usercenter.luckyDou}")
    private String itaipingUserCenterLuckyDou;
    @Value(value="${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;
    @Value(value="${itaiping.companyHome}")
    private String itaipingCompanyHome;
    @Value(value="${itaiping.contacts}")
    private String itaipingContacts;
    @Autowired
    AreaService areaService;
    @Autowired
    ScoreUserService scoreUserService;
    @Resource(name="redisTemplate")
    private ZSetOperations<String, String> zSetOperations;
    @Autowired
    RedisTemplate redisTemplate;

    @RequestMapping(value={"", "/"})
    public String index(HttpServletRequest request, Map<String, Object> model) {
        List categoryList;
        String categoryRedisKey;
        BoundValueOperations categoryOperations;
        Object category;
        long methodStart = System.currentTimeMillis();
        log.info((Object)"### \u5f00\u59cb\u52a0\u8f7d INDEX TOP ... ###");
        Object memberObj = request.getSession().getAttribute("member_json_itaiping");
        Object coreUserObj = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto sessionCoreUser = (CoreUserDto)JSON.parseObject((String)coreUserObj.toString(), CoreUserDto.class);
        MemberDto sessionMember = (MemberDto)JSON.parseObject((String)memberObj.toString(), MemberDto.class);
        long addressTime = System.currentTimeMillis();
        List addresses = this.addressCommonApi.addressList(AddressCommonApi.AddressLevel.PROVINCE, null, Boolean.valueOf(false));
        log.info((Object)"\u67e5\u8be2\u5730\u5740\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - addressTime});
        String provinceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        String currentPage = request.getParameter("currentPage");
        if (!Lang.isEmpty((Object)currentPage) && "index".equals(currentPage)) {
            model.put("currentPage", currentPage);
        }
        if ((category = (categoryOperations = this.redisTemplate.boundValueOps((Object)(categoryRedisKey = this.organizationCode + ":index:category"))).get()) == null) {
            long categoryTime = System.currentTimeMillis();
            categoryList = this.productCategoryApi.findCategoryByLayerLessThanEqual(Integer.valueOf(3), this.organizationCode, Boolean.valueOf(true));
            log.info((Object)"\u67e5\u8be2\u5206\u7c7b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - categoryTime});
            categoryOperations.set((Object)categoryList);
        } else {
            categoryList = (List)category;
        }
        Map firstCategoryMap = new LinkedHashMap();
        Map secondLayerMap = new HashMap();
        Map thirdLayerMap = new HashMap();
        String categoryMapRedisKey = this.organizationCode + ":index:categoryMap";
        BoundValueOperations categoryMapOperations = this.redisTemplate.boundValueOps((Object)categoryMapRedisKey);
        Object categoryMap = categoryMapOperations.get();
        Map map = null;
        if (categoryMap == null) {
            long getProductCategoryTime = System.currentTimeMillis();
            map = this.getProductCategory(categoryList);
            log.info((Object)"\u5c01\u88c5\u5546\u54c1\u5206\u7c7b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - getProductCategoryTime});
            categoryMapOperations.set((Object)map);
        } else {
            map = (Map)categoryMap;
        }
        if (!Lang.isEmpty((Object)map)) {
            firstCategoryMap = (Map)map.get("firstCategoryMap");
            secondLayerMap = (Map)map.get("secondLayerMap");
            thirdLayerMap = (Map)map.get("thirdLayerMap");
        }
        long userScoreTime = System.currentTimeMillis();
        BigDecimal usebleScore = this.scoreUserService.getUsebleScore(sessionCoreUser);
        log.info((Object)"\u67e5\u8be2\u7528\u6237\u79ef\u5206\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - userScoreTime});
        model.put("firstCategoryMap", firstCategoryMap);
        model.put("secondLayer", secondLayerMap);
        model.put("thirdLayer", thirdLayerMap);
        model.put("provinceId", provinceId);
        model.put("addresses", addresses);
        model.put("itaipingUserCenterIndex", this.itaipingUserCenterIndex);
        model.put("itaipingUserCenterLuckyDou", this.itaipingUserCenterLuckyDou);
        model.put("itaipingUserCenterGoods", this.itaipingUserCenterGoods);
        model.put("itaipingCompanyHome", this.itaipingCompanyHome);
        model.put("itaipingContacts", this.itaipingContacts);
        model.put("score", usebleScore);
        model.put("isAdmin", sessionMember.getAdmin());
        log.info((Object)"### \u52a0\u8f7d INDEX TOP \u603b\u8017\u65f6 {} ms ###", new Object[]{System.currentTimeMillis() - methodStart});
        return "index/top";
    }

    @RequestMapping(value={"info"}, method={RequestMethod.GET})
    @ResponseBody
    public Map loadTopInfo(HttpServletRequest request, HttpServletResponse response) {
        HashMap model = Maps.newHashMap();
        String userId = (String)request.getSession().getAttribute("user_id_itaiping");
        String provinceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        long addressCodeDTOTime = System.currentTimeMillis();
        AddressCodeDTO addressCodeDTO = AddressUtil.getAddressCode((HttpServletRequest)request, (AddressCommonApi)this.addressCommonApi);
        log.info((Object)"\u83b7\u53d6\u5730\u5740\u4ee3\u7801\u8017\u65f6 {} ms ", new Object[]{System.currentTimeMillis() - addressCodeDTOTime});
        if (StringUtils.isBlank((CharSequence)provinceId)) {
            response.addCookie(new Cookie("AREA_LEVEL_PROVINCE_ID", addressCodeDTO.getProviceCode()));
        }
        model.put("provinceId", addressCodeDTO.getProviceCode());
        ArrayList<String> hotKeyWords = new ArrayList<String>();
        String isOpen = this.systemConfigApi.getConfigValue(this.organizationCode, "OPENCONFIGHOTWORDS", "OPENHOTWORDS", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)isOpen)) {
            if (isOpen.equals("true")) {
                String valus = this.systemConfigApi.getConfigValue(this.organizationCode, "HOTWORDS", "HOTWORDS", Boolean.valueOf(true), Boolean.valueOf(true));
                JSONArray jsonArray = JSON.parseArray((String)valus);
                for (Object aJsonArray : jsonArray) {
                    JSONObject obj = (JSONObject)aJsonArray;
                    hotKeyWords.add((String)obj.get((Object)"name"));
                }
            } else {
                Set keywords = this.zSetOperations.reverseRangeByScore((Object)"SEARCH_KEYWORD_CT", Double.MIN_VALUE, Double.MAX_VALUE, 0L, 3L);
                hotKeyWords.addAll(keywords);
            }
        } else {
            Set keywords = this.zSetOperations.reverseRangeByScore((Object)"SEARCH_KEYWORD_CT", Double.MIN_VALUE, Double.MAX_VALUE, 0L, 3L);
            hotKeyWords.addAll(keywords);
        }
        model.put("hotKeyWords", hotKeyWords);
        String username = this.memberApi.findRealNameByCoreUserId(userId);
        model.put("username", username);
        Integer carts = 0;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            carts = this.cartApi.getCartSize(userId);
        }
        model.put("carts", carts);
        return model;
    }

    @RequestMapping(value={"changeProvince/{provoiceId}"})
    @ResponseBody
    public Map changeProvince(@PathVariable(value="provoiceId") String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        HashMap map = Maps.newHashMap();
        map.put("result", "success");
        this.setProvinceId(provoiceId, request, response);
        return map;
    }

    @RequestMapping(value={"changeArea/{areaId}"})
    @ResponseBody
    public Map changeArea(@PathVariable(value="areaId") String areaId, HttpServletRequest request, HttpServletResponse response) {
        HashMap map = Maps.newHashMap();
        map.put("result", "success");
        this.setAddressIdSByParams(request, response, areaId);
        return map;
    }

    public void setProvinceId(String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        if (Lang.isEmpty((Object)sessionProvoiceId) || !sessionProvoiceId.equals(provoiceId)) {
            Map areas = this.getCityAndAreaId(provoiceId);
            areas.put("provoiceId", provoiceId);
            AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, (Map)areas);
        }
    }

    private Map<String, Object> setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if (Lang.isEmpty((Object)areaId)) {
            throw new NullPointerException("areaId not null");
        }
        HashMap addressMap = Maps.newHashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = areaId;
        String returnTownId = null;
        Map areaNodeList = this.addressCommonApi.areaCodeNodeList(areaId);
        if (!Lang.isEmpty((Object)areaNodeList)) {
            returnProvoiceId = (String)areaNodeList.get(1);
            returnCityId = (String)areaNodeList.get(2);
            returnAreaId = (String)areaNodeList.get(3);
            returnTownId = (String)areaNodeList.get(4);
            log.info((Object)("ChangeArea areaNodeList -> returnProvoiceId:" + returnProvoiceId + ",returnCityId" + returnCityId + ",returnAreaId:" + returnAreaId + ",returnTownId:" + returnTownId));
        }
        addressMap.put("provoiceId", returnProvoiceId);
        addressMap.put("cityId", returnCityId);
        addressMap.put("areaId", returnAreaId);
        addressMap.put("townId", returnTownId);
        AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, (Map)addressMap);
        log.info((Object)("reseted session addressId -> proviceId: " + request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID") + "cityId: " + request.getSession().getAttribute("AREA_LEVEL_CITY_ID") + "areaId: " + request.getSession().getAttribute("AREA_LEVEL_AREA_ID") + "townId: " + request.getSession().getAttribute("AREA_LEVEL_TOWN_ID")));
        return addressMap;
    }

    private Map<String, Object> getCityAndAreaId(String provoiceId) {
        HashMap<String, Object> returnAddressIdMap = new HashMap<String, Object>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        AddressDto a = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(false));
        if (a != null) {
            AddressDto c;
            returnCityId = a.getId();
            AddressDto addr = this.addressCommonApi.findFirstChild(returnCityId, Boolean.valueOf(false));
            if (Lang.isEmpty((Object)addr)) {
                returnAreaId = addr.getId();
            }
            if ((c = this.addressCommonApi.findFirstChild(returnAreaId, Boolean.valueOf(false))) != null) {
                returnTownId = c.getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    private Map<String, Object> getProductCategory(List<Map<String, Object>> categoryList) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("category:map" + this.organizationCode));
        HashMap<String, Object> returnMap = new HashMap();
        long configTime = System.currentTimeMillis();
        String isOpen = this.systemConfigApi.getConfigValue(this.organizationCode, "OPENCACHE", "CACHECATEGORYVO", Boolean.valueOf(true), Boolean.valueOf(true));
        log.info((Object)"\u83b7\u53d6\u914d\u7f6e\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - configTime});
        Boolean isOpenFlag = false;
        if (!Lang.isEmpty((Object)isOpen) && isOpen.equals("true")) {
            isOpenFlag = true;
        }
        if (isOpenFlag.booleanValue() && !Lang.isEmpty((Object)boundValueOperations) && !Lang.isEmpty((Object)boundValueOperations.get())) {
            returnMap = (Map)boundValueOperations.get();
            return returnMap;
        }
        LinkedHashMap firstCategoryMap = new LinkedHashMap();
        HashMap secondLayerMap = new HashMap();
        HashMap thirdLayerMap = new HashMap();
        ArrayList<ProductCategoryVo> firstLayer = new ArrayList<ProductCategoryVo>();
        ArrayList<ProductCategoryVo> secondLayer = new ArrayList<ProductCategoryVo>();
        ArrayList<ProductCategoryVo> thirdLayer = new ArrayList<ProductCategoryVo>();
        if (!Lang.isEmpty(categoryList) && categoryList.size() > 0) {
            for (Map<String, Object> category : categoryList) {
                String layer;
                String string = layer = category.get("layer_index") == null ? "" : category.get("layer_index").toString();
                if (layer.equals("1")) {
                    ProductCategoryVo firstVo = new ProductCategoryVo();
                    firstVo.setId(category.get("id") + "");
                    firstVo.setName(category.get("name") + "");
                    firstVo.setCategoryType(category.get("category_type") + "");
                    firstLayer.add(firstVo);
                    if (!Lang.isEmpty(firstCategoryMap.get(firstVo.getCategoryType()))) {
                        ((List)firstCategoryMap.get(firstVo.getCategoryType())).add(firstVo);
                        continue;
                    }
                    ArrayList<ProductCategoryVo> categoryVoList = new ArrayList<ProductCategoryVo>();
                    categoryVoList.add(firstVo);
                    firstCategoryMap.put(firstVo.getCategoryType(), categoryVoList);
                    continue;
                }
                if (layer.equals("2")) {
                    ProductCategoryVo secondVo = new ProductCategoryVo();
                    secondVo.setId(category.get("id") + "");
                    secondVo.setName(category.get("name") + "");
                    secondVo.setParentId(category.get("parent_id") + "");
                    secondVo.setParentName(category.get("parent_name") + "");
                    secondLayer.add(secondVo);
                    continue;
                }
                if (!layer.equals("3")) continue;
                ProductCategoryVo thirdVo = new ProductCategoryVo();
                thirdVo.setId(category.get("id") + "");
                thirdVo.setName(category.get("name") + "");
                thirdVo.setParentId(category.get("parent_id") + "");
                thirdVo.setParentName(category.get("parent_name") + "");
                thirdLayer.add(thirdVo);
            }
            for (ProductCategoryVo first : firstLayer) {
                String firstId = first.getId();
                if (Lang.isEmpty(secondLayer) || secondLayer.size() <= 0) continue;
                ArrayList<ProductCategoryVo> secondLayerList = new ArrayList<ProductCategoryVo>();
                for (ProductCategoryVo second : secondLayer) {
                    String secondId = second.getId();
                    String parentId = second.getParentId();
                    if (!Lang.isEmpty((Object)parentId) && parentId.equals(firstId)) {
                        ProductCategoryVo secondItem = new ProductCategoryVo();
                        secondItem.setId(second.getId());
                        secondItem.setName(second.getName());
                        secondLayerList.add(secondItem);
                    }
                    if (Lang.isEmpty(thirdLayer) || thirdLayer.size() <= 0) continue;
                    ArrayList<ProductCategoryVo> thirdLayerList = new ArrayList<ProductCategoryVo>();
                    for (ProductCategoryVo third : thirdLayer) {
                        if (!third.getParentId().equals(secondId)) continue;
                        ProductCategoryVo thirdItem = new ProductCategoryVo();
                        thirdItem.setId(third.getId());
                        thirdItem.setName(third.getName());
                        thirdLayerList.add(thirdItem);
                    }
                    if (thirdLayerList.size() <= 0) continue;
                    thirdLayerMap.put(secondId, thirdLayerList);
                }
                if (secondLayerList.size() <= 0) continue;
                secondLayerMap.put(firstId, secondLayerList);
            }
        }
        LinkedHashMap firstCategoryRepMap = new LinkedHashMap();
        int count = 0;
        for (String key : firstCategoryMap.keySet()) {
            if (++count > 12) continue;
            firstCategoryRepMap.put(key, firstCategoryMap.get(key));
        }
        returnMap.put("firstCategoryMap", firstCategoryRepMap);
        returnMap.put("secondLayerMap", secondLayerMap);
        returnMap.put("thirdLayerMap", thirdLayerMap);
        if (!Lang.isEmpty(returnMap)) {
            boundValueOperations.set(returnMap);
        }
        return returnMap;
    }
}

