/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.index;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductSalesApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsDto;
import goods.vo.GoodsVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import utils.Lang;

@Controller
@RequestMapping(value={"salesRanking"})
public class SalesRankingController {
    private static final Logger log = LoggerFactory.getLogger(SalesRankingController.class);
    @MotanReferer(basicReferer="motanClientBasicConfig")
    ProductSalesApi productSalesApi;
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @Autowired
    MapperFacade mapperFacade;
    static final String HOT_SALE_WEEK = "week";
    static final String HOT_SALE_MONTH = "month";
    static final String HOT_SALE_TOTAL = "total";

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String index(Map<String, Object> model, String type) {
        List list;
        long methodStart = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u52a0\u8f7d\u6392\u884c\u699c... ###");
        long organizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
        long goodsListTime = System.currentTimeMillis();
        if (HOT_SALE_WEEK.equals(type)) {
            list = this.productSalesApi.findHotSalesLastWeek(this.organizationCode);
        } else if (HOT_SALE_MONTH.equals(type)) {
            list = this.productSalesApi.findHotSalesLastMonth(this.organizationCode);
        } else {
            list = this.productSalesApi.findHotSalesTotal(this.organizationCode);
            type = HOT_SALE_TOTAL;
        }
        log.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868\u7c7b\u578b\u4e3a {} \u8017\u65f6 {} ms", (Object)type, (Object)(System.currentTimeMillis() - goodsListTime));
        long getSalePriceTimer = System.currentTimeMillis();
        List listVo = new ArrayList();
        if (!Lang.isEmpty((Object)list)) {
            Map salePriceMap = this.salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsList(list, this.storeCode, organizationId);
            for (GoodsDto goodsDTO : list) {
                BigDecimal salePrice = ((BigDecimal)salePriceMap.get(goodsDTO.getId())).setScale(2, 0);
                goodsDTO.setSalePrice(salePrice);
            }
            listVo = this.mapperFacade.mapAsList((Iterable)list, GoodsVo.class);
        }
        log.info("\u6279\u91cf\u67e5\u8be2\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getSalePriceTimer));
        model.put("salesRanking", listVo);
        model.put("type", type);
        model.put("scorePortion", 1);
        log.info("### \u52a0\u8f7d\u6392\u884c\u699c\u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStart));
        return "index/sales/ranking";
    }
}

