/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.index.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;

public class HttpUtilslwl {
    public String httpdoPostBodyHeader(String strUrl, String body, Map<String, String> headers, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringBuilder builder = null;
        try {
            int responseCode;
            URL url = new URL(strUrl);
            HttpURLConnection httpURLConn = (HttpURLConnection)url.openConnection();
            httpURLConn.addRequestProperty("encoding", encoding);
            httpURLConn.setDoInput(true);
            httpURLConn.setDoOutput(true);
            httpURLConn.setRequestMethod("POST");
            if (headers != null) {
                for (String header : headers.keySet()) {
                    httpURLConn.addRequestProperty(header, headers.get(header));
                }
            }
            if (body != null) {
                OutputStream outStream = httpURLConn.getOutputStream();
                this.writeStrToOutputStream(body, outStream);
            }
            if ((responseCode = httpURLConn.getResponseCode()) != 200) {
                String responseMessage = httpURLConn.getResponseMessage();
                Logger.getLogger("lwl").info("responseCode: " + responseCode + ", message: " + responseMessage);
                return responseCode + "";
            }
            InputStream inStream = httpURLConn.getInputStream();
            builder = this.readSrtFromInputStream(inStream, encoding);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStrToOutputStream(String body, OutputStream outStream) {
        OutputStreamWriter outWriter = null;
        BufferedWriter bufWriter = null;
        try {
            outWriter = new OutputStreamWriter(outStream);
            bufWriter = new BufferedWriter(outWriter);
            bufWriter.write(body);
            bufWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufWriter.close();
                outWriter.close();
                outStream.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder readSrtFromInputStream(InputStream inStream, String encoding) {
        StringBuilder builder = new StringBuilder();
        InputStreamReader inReader = null;
        BufferedReader bufReader = null;
        try {
            String line;
            inReader = new InputStreamReader(inStream, encoding);
            bufReader = new BufferedReader(inReader);
            while ((line = bufReader.readLine()) != null) {
                builder.append(line + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (inReader != null) {
                    inReader.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return builder;
    }
}

