/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.login;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.login.LoginService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.PeripheryApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import message.api.Dto.VerifyCodeDto;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.sms.SmsApi;
import message.api.sms.vo.SmsReq;
import message.api.sms.vo.SmsRsp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.CookiesTool;
import utils.data.SmsUtil;
import utils.data.ValidateUtil;
import utils.date.DateUtils;
import utils.kaptcha.CheckUtils;

@Controller
public class LoginIndexController {
    static final Logger logger = LoggerFactory.getLogger(LoginIndexController.class);
    static final String checkType = "login";
    static final String updatePasswdType = "updatePasswd";
    static final String SESSION_ACCOUNT_CODE = "SESSION_ACCOUNT_CODE";
    @Value(value="${spring.profiles.active}")
    private String profile;
    static final String SESSION_SMS_CODE = "SESSION_SMS_CODE";
    private String smsTestCode = "123456";
    @Value(value="${ctscore.emailsender}")
    private String emailsender;
    @Autowired
    CheckUtils checkUtils;
    @Autowired
    LoginService loginService;
    @MotanReferer
    SmsApi smsApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private MailApi mailApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    PeripheryApi peripheryApi;
    public static final String REDIRECT_SOURCE_URL = "REDIRECT_SOURCE_URL";
    public static final String LOGIN_ERROR_CODE = "LOGIN_ERROR_CODE";
    public static final String LOGIN_ERROR_TIMES = "LOGIN_ERROR_TIMES";
    public static final String MOBILE_SERVICE_ID = "ChengTong_FindPassword";

    @RequestMapping(value={"login"}, method={RequestMethod.GET})
    public String login(Map model, HttpServletRequest request, HttpServletResponse response) {
        Object errorObj;
        logger.info("\u79ef\u5206\u4f1a\u5458\u767b\u5f55");
        Object accountObj = request.getSession().getAttribute("account");
        String account = null;
        if (accountObj == null) {
            Cookie accountCookie = CookiesTool.getCookieByName((HttpServletRequest)request, (String)"account");
            if (accountCookie != null) {
                account = accountCookie.getValue();
            }
        } else {
            account = accountObj.toString();
        }
        if (account != null) {
            Long errCount;
            model.put("account", account);
            request.getSession().removeAttribute("account");
            CoreUserDto coreUser = null;
            long getOrganizationTime = System.currentTimeMillis();
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
            logger.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrganizationTime));
            if (Lang.isEmpty((Object)organizationId)) {
                model.put("accountError", "");
                return "login/login";
            }
            long getCoreUserTime = System.currentTimeMillis();
            coreUser = !ValidateUtil.isEmail((String)account) ? this.loginService.findByPhoneAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false) : this.loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
            if (Lang.isEmpty((Object)coreUser)) {
                coreUser = this.loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY, false);
            }
            logger.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getCoreUserTime));
            if (coreUser != null && (errCount = coreUser.getErrCount()) != null && errCount >= 1L) {
                model.put("validateFlag", 1);
            }
        }
        if ((errorObj = request.getSession().getAttribute(LOGIN_ERROR_CODE)) != null) {
            int errorMsg = Integer.parseInt(errorObj.toString());
            if (errorMsg == 1) {
                Object errorTimesObj = request.getSession().getAttribute(LOGIN_ERROR_TIMES);
                if (errorTimesObj != null) {
                    int errorTimes = Integer.parseInt(errorTimesObj.toString());
                    model.put("passwordError", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u6216\u5bc6\u7801\u6709\u8bef\uff0c\u767b\u5f55\u9519\u8bef" + errorTimes + "\u6b21");
                } else {
                    model.put("passwordError", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u6216\u5bc6\u7801\u6709\u8bef");
                }
            } else if (errorMsg == 2) {
                model.put("accountError", "\u60a8\u5c1a\u672a\u6ce8\u518c\uff0c\u8bf7\u786e\u8ba4\u8d26\u53f7\u662f\u5426\u5f55\u5165\u6b63\u786e");
            } else if (errorMsg == 3) {
                model.put("imageCodeError", "\u60a8\u7684\u9a8c\u8bc1\u7801\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u9a8c\u8bc1\u7801");
            } else if (errorMsg == 4) {
                model.put("imageCodeError", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u9a8c\u8bc1\u7801\u8fdb\u884c\u5237\u65b0");
            } else if (errorMsg == 5) {
                model.put("passwordError", "\u60a8\u8f93\u5165\u5bc6\u7801\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u767b\u5f55");
            } else if (errorMsg == 6) {
                model.put("accountError", "\u8bf7\u8f93\u5165\u767b\u5f55\u8d26\u53f7");
            } else if (errorMsg == 7) {
                model.put("passwordError", "\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
            } else if (errorMsg == 8) {
                model.put("imageCodeError", "\u8bf7\u8f93\u5165\u56fe\u7247\u9a8c\u8bc1\u7801");
            } else {
                model.put("imageCodeError", "\u767b\u5f55\u5931\u8d25");
            }
        } else {
            model.put("accountError", "");
            model.put("passwordError", "");
            model.put("imageCodeError", "");
        }
        request.getSession().removeAttribute(LOGIN_ERROR_CODE);
        request.getSession().removeAttribute(LOGIN_ERROR_TIMES);
        return "login/login";
    }

    @RequestMapping(value={"dologin"}, method={RequestMethod.POST})
    public String login(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        Serializable formatter;
        Comparable<Date> cLoginTime;
        long minute;
        logger.info("\u4f1a\u5458\u767b\u5f55...");
        String account = request.getParameter("account");
        if (Lang.isEmpty((Object)account)) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)6);
            return "redirect:login";
        }
        request.getSession().setAttribute("account", (Object)account);
        CookiesTool.addCookie((HttpServletResponse)response, (String)"account", (String)account, (int)3600);
        String password = request.getParameter("password");
        if (Lang.isEmpty((Object)password)) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)7);
            return "redirect:login";
        }
        String validateFlag = request.getParameter("validateFlag");
        String validateCode = "";
        if (validateFlag != null) {
            validateCode = request.getParameter("validateCode");
            if (Lang.isEmpty((Object)validateCode)) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)8);
                return "redirect:login";
            }
            Object capTextObj = request.getSession().getAttribute("login:code");
            if (Lang.isEmpty((Object)capTextObj)) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)3);
                return "redirect:login";
            }
            String capText = capTextObj.toString();
            if (!capText.equals(validateCode)) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)4);
                return "redirect:login";
            }
            request.getSession().removeAttribute("login:code");
        }
        HttpSession session = request.getSession();
        CoreUserDto coreUser = null;
        long getOrganizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        logger.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrganizationTime));
        if (Lang.isEmpty((Object)organizationId)) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
            return "redirect:login";
        }
        long getCoreUserTime = System.currentTimeMillis();
        CoreUserDto loginCoreUser = new CoreUserDto();
        if (!ValidateUtil.isEmail((String)account)) {
            loginCoreUser.setPhone(account);
            loginCoreUser.setUsername(account);
            coreUser = this.loginService.findByPhoneAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
        } else {
            loginCoreUser.setEmail(account);
            loginCoreUser.setUsername(account);
            coreUser = this.loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
        }
        if (Lang.isEmpty((Object)coreUser)) {
            coreUser = this.loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY, false);
        }
        logger.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getCoreUserTime));
        if (coreUser == null) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)2);
            return "redirect:login";
        }
        String loginTime = DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        Long errorCount = coreUser.getErrCount();
        String currentLoginTime = coreUser.getCurrentLoginTime();
        Boolean disabled = coreUser.getDisabled();
        errorCount = errorCount == null ? 0L : errorCount;
        disabled = disabled == null ? false : disabled;
        String coreUserPassword = coreUser.getPassword();
        String encryptPasswd = this.loginService.encryptPasswd(password);
        if (currentLoginTime != null && disabled.booleanValue() && (minute = DateUtils.differMinute((Date)(cLoginTime = (formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(currentLoginTime)))) >= 60L) {
            logger.info("\u8d85\u8fc71\u5c0f\u65f6\uff0c\u81ea\u52a8\u89e3\u9501");
            coreUser.setCurrentLoginTime(loginTime);
            if (!Lang.isEmpty((Object)coreUserPassword) && !coreUserPassword.equals(encryptPasswd)) {
                errorCount = 1L;
                coreUser.setErrCount(errorCount);
                coreUser.setDisabled(Boolean.valueOf(false));
                request.getSession().setAttribute(LOGIN_ERROR_TIMES, (Object)errorCount);
                long updateCoreUserTime = System.currentTimeMillis();
                CoreUserDto result = this.loginService.updateCoreUser(coreUser);
                logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - updateCoreUserTime));
                logger.info("\u66f4\u65b0\u7528\u6237\u767b\u5f55\u9519\u8bef\u4fe1\u606f\u7ed3\u679c:{}", (Object)result);
                if (result == null) {
                    request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
                    return "redirect:login";
                }
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)1);
                return "redirect:login";
            }
            Long loginCount = coreUser.getLoginCount();
            Long l = loginCount = Long.valueOf(loginCount == null ? 0L : loginCount);
            Long result = loginCount = Long.valueOf(loginCount + 1L);
            errorCount = 0L;
            coreUser.setErrCount(errorCount);
            coreUser.setDisabled(Boolean.valueOf(false));
            coreUser.setLoginCount(loginCount);
            long updateCoreUserTime = System.currentTimeMillis();
            CoreUserDto result2 = this.loginService.updateCoreUser(coreUser);
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - updateCoreUserTime));
            logger.info("\u66f4\u65b0\u7528\u6237\u767b\u5f55\u4fe1\u606f\u7ed3\u679c:{}", (Object)result2);
            if (result2 == null) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
                return "redirect:login";
            }
            long loadMemeberTime = System.currentTimeMillis();
            MemberVo memberVo = this.loginService.loadMemberVo(coreUser);
            logger.info("\u83b7\u53d6 memberVo \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - loadMemeberTime));
            this.loginService.saveInfotoSession(request, memberVo);
            MemberDto member = memberVo.getMember();
            if (member == null) {
                logger.error("\u4f1a\u5458\u672a\u5f55\u5165,\u767b\u5f55\u5931\u8d25");
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
                return "redirect:login";
            }
            Integer isFirstLogin = member.getIsFirstLogin();
            isFirstLogin = isFirstLogin == null ? 0 : isFirstLogin;
            if (isFirstLogin == 0) {
                request.getSession().removeAttribute("account");
                CookiesTool.addCookie((HttpServletResponse)response, (String)"account", (String)"", (int)0);
                return "redirect:../score";
            }
            request.getSession().removeAttribute("account");
            CookiesTool.addCookie((HttpServletResponse)response, (String)"account", (String)"", (int)0);
            Object redirectUrl = request.getSession().getAttribute(REDIRECT_SOURCE_URL);
            if (redirectUrl != null) {
                String url = redirectUrl.toString();
                request.getSession().removeAttribute(REDIRECT_SOURCE_URL);
                return "redirect:" + url;
            }
            redirectUrl = request.getSession().getAttribute("login_back_url_itaiping");
            if (redirectUrl != null) {
                String url = redirectUrl.toString();
                request.getSession().removeAttribute("login_back_url_itaiping");
                return "redirect:" + url;
            }
            return "redirect:index";
        }
        if (errorCount == 5L || disabled.booleanValue()) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)5);
            return "redirect:login";
        }
        if (!coreUserPassword.equals(encryptPasswd)) {
            formatter = errorCount;
            errorCount = errorCount + 1L;
            cLoginTime = errorCount;
            coreUser.setErrCount(errorCount);
            coreUser.setCurrentLoginTime(loginTime);
            if (errorCount == 5L) {
                coreUser.setDisabled(Boolean.valueOf(true));
                long updateCoreUserTime = System.currentTimeMillis();
                CoreUserDto result = this.loginService.updateCoreUser(coreUser);
                logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - updateCoreUserTime));
                logger.info("\u66f4\u65b0\u7528\u6237\u767b\u5f55\u9519\u8bef\u4fe1\u606f\u7ed3\u679c:{}", (Object)result);
                if (result == null) {
                    request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
                    return "redirect:login";
                }
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)5);
                return "redirect:login";
            }
            coreUser.setDisabled(Boolean.valueOf(false));
            request.getSession().setAttribute(LOGIN_ERROR_TIMES, (Object)errorCount);
            long updateCoreUserTime = System.currentTimeMillis();
            CoreUserDto result = this.loginService.updateCoreUser(coreUser);
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - updateCoreUserTime));
            logger.info("\u66f4\u65b0\u7528\u6237\u767b\u5f55\u9519\u8bef\u4fe1\u606f\u7ed3\u679c:{}", (Object)result);
            if (result == null) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
                return "redirect:login";
            }
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)1);
            return "redirect:login";
        }
        Long loginCount = coreUser.getLoginCount();
        loginCount = loginCount == null ? 0L : loginCount;
        cLoginTime = loginCount;
        Long l = loginCount = Long.valueOf(loginCount + 1L);
        errorCount = 0L;
        coreUser.setErrCount(errorCount);
        coreUser.setDisabled(Boolean.valueOf(false));
        coreUser.setLoginCount(loginCount);
        long updateCoreUserTime = System.currentTimeMillis();
        CoreUserDto result = this.loginService.updateCoreUser(coreUser);
        logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - updateCoreUserTime));
        logger.info("\u66f4\u65b0\u7528\u6237\u767b\u5f55\u4fe1\u606f\u7ed3\u679c:{}", (Object)result);
        if (result == null) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
            return "redirect:login";
        }
        long loadMemeberTime = System.currentTimeMillis();
        MemberVo memberVo = this.loginService.loadMemberVo(coreUser);
        logger.info("\u83b7\u53d6 memberVo \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - loadMemeberTime));
        this.loginService.saveInfotoSession(request, memberVo);
        MemberDto member = memberVo.getMember();
        if (member == null) {
            logger.error("\u4f1a\u5458\u672a\u5f55\u5165,\u767b\u5f55\u5931\u8d25");
            request.getSession().setAttribute(LOGIN_ERROR_CODE, (Object)9);
            return "redirect:login";
        }
        CookiesTool.addCookie((HttpServletResponse)response, (String)"account", (String)"", (int)0);
        Integer isFirstLogin = member.getIsFirstLogin();
        isFirstLogin = isFirstLogin == null ? 0 : isFirstLogin;
        if (CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY.equals(memberVo.getUser().getUserType())) {
            return "redirect:../activities-web/control.html";
        }
        if (isFirstLogin == 0) {
            request.getSession().removeAttribute("account");
            CookiesTool.addCookie((HttpServletResponse)response, (String)"account", (String)"", (int)0);
            return "redirect:../score";
        }
        Object redirectUrl = request.getSession().getAttribute(REDIRECT_SOURCE_URL);
        if (redirectUrl != null) {
            String url = redirectUrl.toString();
            request.getSession().removeAttribute(REDIRECT_SOURCE_URL);
            return "redirect:" + url;
        }
        redirectUrl = request.getSession().getAttribute("login_back_url_itaiping");
        if (redirectUrl != null) {
            String url = redirectUrl.toString();
            request.getSession().removeAttribute("login_back_url_itaiping");
            return "redirect:" + url;
        }
        request.getSession().removeAttribute("account");
        return "redirect:../score";
    }

    @RequestMapping(value={"dologout"}, method={RequestMethod.GET})
    public String dologout(HttpServletRequest request, HttpServletResponse response) {
        response.addCookie(new Cookie("user_name_logout_itaiping", (String)request.getSession().getAttribute("user_name_logout_itaiping")));
        this.loginService.removeLoginAttr(request);
        String service = request.getParameter("service");
        service = service == null || "".equals(service) ? request.getHeader("Referer") : service;
        return "redirect:/login";
    }

    @RequestMapping(value={"forget/sendSmsOrEmail"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject updatePasswdSendSms(HttpServletRequest request) {
        logger.info("\u4fee\u6539\u5bc6\u7801 \u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801 \u6216\u8005 \u90ae\u7bb1");
        JSONObject jsonObject = new JSONObject();
        String account = request.getParameter("account");
        String imageValidateCode = request.getParameter("imageValidateCode");
        String verifyCodeType = request.getParameter("verifyCodeType");
        if (Lang.isEmpty((Object)account)) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u8bf7\u586b\u5199\u767b\u5f55\u540d");
            return jsonObject;
        }
        Object capTextObj = request.getSession().getAttribute("updatePasswd:code");
        if (Lang.isEmpty((Object)capTextObj)) {
            jsonObject.put("code", (Object)"-2");
            jsonObject.put("msg", (Object)"\u60a8\u7684\u9a8c\u8bc1\u7801\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u9a8c\u8bc1\u7801");
            return jsonObject;
        }
        String capText = capTextObj.toString();
        if (!capText.equals(imageValidateCode)) {
            jsonObject.put("code", (Object)"-3");
            jsonObject.put("msg", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u9a8c\u8bc1\u7801\u8fdb\u884c\u5237\u65b0");
            return jsonObject;
        }
        request.getSession().removeAttribute("updatePasswd:code");
        CoreUserDto coreUser = null;
        boolean isPhone = true;
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
        if (Lang.isEmpty((Object)organization)) {
            jsonObject.put("code", (Object)"1");
            jsonObject.put("msg", (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
            return jsonObject;
        }
        if (!ValidateUtil.isEmail((String)account)) {
            coreUser = this.loginService.findByPhoneAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);
            isPhone = true;
        } else {
            coreUser = this.loginService.findByEmailAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);
            isPhone = false;
        }
        if (Lang.isEmpty((Object)coreUser)) {
            jsonObject.put("code", (Object)"1");
            jsonObject.put("msg", (Object)"\u767b\u5f55\u540d\u79f0\u4e0d\u5b58\u5728");
            return jsonObject;
        }
        if (!this.profile.contains("product") && !this.profile.contains("prod")) {
            logger.info("\u53d1\u9001\u6d4b\u8bd5\u9a8c\u8bc1\u7801:{} \u81f3\u8d26\u53f7:{}", (Object)this.smsTestCode, (Object)account);
            JSONObject smsContent = SmsUtil.smsCodeJson((String)this.smsTestCode);
            request.getSession().setAttribute(SESSION_ACCOUNT_CODE + account, (Object)smsContent);
            jsonObject.put("code", (Object)"0");
            jsonObject.put("msg", (Object)"\u53d1\u9001\u6d4b\u8bd5\u624b\u673a/\u90ae\u7bb1\u9a8c\u8bc1\u7801\u6210\u529f");
            return jsonObject;
        }
        String smsCode = SmsUtil.smsCode();
        logger.info("\u53d1\u9001\u9a8c\u8bc1\u7801:{} \u81f3\u8d26\u53f7:{}", (Object)smsCode, (Object)account);
        String content = "\u8bda\u610f\u901a\u5546\u57ce\u5fd8\u8bb0\u5bc6\u7801\u624b\u673a\u6821\u9a8c\u7801\uff1a" + smsCode + " ";
        if (isPhone) {
            SmsReq smsReq = new SmsReq();
            smsReq.setContent(content);
            smsReq.setTos(Arrays.asList(account));
            smsReq.setSendTime(new Date());
            int count = this.smsApi.sendVerifyCodeTimes(account, verifyCodeType);
            if (count > 50) {
                jsonObject.put("code", (Object)"2");
                jsonObject.put("msg", (Object)"\u4e00\u5929\u6700\u591a\u53ea\u80fd\u53d1\u900150\u6b21\u77ed\u4fe1");
                return jsonObject;
            }
            smsReq.setMobileServiceId(MOBILE_SERVICE_ID);
            SmsRsp smsRsp = this.smsApi.sendSms(smsReq);
            String sendResultShort = "";
            if (!smsRsp.isSuccessFalg()) {
                jsonObject.put("code", (Object)"2");
                jsonObject.put("msg", (Object)"\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801\u5931\u8d25");
                return jsonObject;
            }
            sendResultShort = "1";
            request.getSession().setAttribute(SESSION_ACCOUNT_CODE + account, (Object)SmsUtil.smsCodeJson((String)smsCode));
            VerifyCodeDto verifyCode = new VerifyCodeDto();
            verifyCode.setType(verifyCodeType);
            String memo = "\u8bda\u901a\u5546\u57ce\u5fd8\u8bb0\u5bc6\u7801\u77ed\u4fe1\u9a8c\u8bc1";
            verifyCode.setMemo(memo);
            verifyCode.setObjId(account);
            verifyCode.setSendResult(sendResultShort);
            verifyCode.setVerifyCode(smsCode.trim());
            VerifyCodeDto verifyCodeDto = (VerifyCodeDto)BeanMapper.map((Object)verifyCode, VerifyCodeDto.class);
            this.smsApi.saveVerifyCode(verifyCodeDto);
            jsonObject.put("code", (Object)"0");
            jsonObject.put("msg", (Object)"\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801\u6210\u529f");
            return jsonObject;
        }
        MailReq mailReq = new MailReq();
        mailReq.setFrom(this.emailsender);
        mailReq.setTo(new String[]{account});
        mailReq.setText(content);
        mailReq.setSubject("\u5fd8\u8bb0\u5bc6\u7801\u9a8c\u8bc1\u7801");
        mailReq.setSentDate(new Date());
        mailReq.setChannel("ct");
        MailRsp mailRsp = this.mailApi.sendMail(mailReq);
        if (!mailRsp.getSuccesFlag().booleanValue()) {
            jsonObject.put("code", (Object)"2");
            jsonObject.put("msg", (Object)"\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\u5931\u8d25");
            return jsonObject;
        }
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\u6210\u529f\uff0c\u8bf7\u767b\u5f55\u90ae\u7bb1\u83b7\u53d6\u9a8c\u8bc1\u7801");
        return jsonObject;
    }

    @RequestMapping(value={"forget/first"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject updatePasswdFirstCheckInfo(HttpServletRequest request) {
        logger.info("\u4fee\u6539\u5bc6\u7801\u7b2c\u4e00\u6b65");
        JSONObject jsonObject = new JSONObject();
        String account = request.getParameter("account");
        String checkCode = request.getParameter("checkCode");
        if (Lang.isEmpty((Object)account)) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u8bf7\u586b\u5199\u767b\u5f55\u540d");
            return jsonObject;
        }
        if (Lang.isEmpty((Object)checkCode)) {
            jsonObject.put("code", (Object)"-2");
            jsonObject.put("msg", (Object)"\u8bf7\u586b\u5199\u6821\u9a8c\u7801");
            return jsonObject;
        }
        Object phoneCodeObj = request.getSession().getAttribute(SESSION_ACCOUNT_CODE + account);
        int result = SmsUtil.checkPhoneCode((String)checkCode, (Object)phoneCodeObj);
        if (result == -2) {
            jsonObject.put("code", (Object)"1");
            jsonObject.put("msg", (Object)"\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
            return jsonObject;
        }
        if (result == -1) {
            jsonObject.put("code", (Object)"2");
            jsonObject.put("msg", (Object)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            return jsonObject;
        }
        if (result == 0) {
            request.getSession().removeAttribute(SESSION_ACCOUNT_CODE + account);
        } else {
            if (result == 1) {
                jsonObject.put("code", (Object)"3");
                jsonObject.put("msg", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
                return jsonObject;
            }
            if (result == 2) {
                jsonObject.put("code", (Object)"1");
                jsonObject.put("msg", (Object)"\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
                return jsonObject;
            }
        }
        request.getSession().setAttribute("UPDATE_PASSWD", (Object)account);
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"\u9a8c\u8bc1\u901a\u8fc7");
        return jsonObject;
    }

    @RequestMapping(value={"forget/second"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject updatePasswdSecondCheckInfo(HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        logger.info("\u4fee\u6539\u767b\u5f55\u5bc6\u7801...");
        Object accountObject = request.getSession().getAttribute("UPDATE_PASSWD");
        if (accountObject == null) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u4e0a\u4e00\u6b65\u91cd\u65b0\u6821\u9a8c");
            return jsonObject;
        }
        String account = accountObject.toString();
        String newPwd = request.getParameter("newPwd");
        String newRePwd = request.getParameter("newRePwd");
        if (Lang.isEmpty((Object)newPwd)) {
            jsonObject.put("code", (Object)"-2");
            jsonObject.put("msg", (Object)"\u65b0\u5bc6\u7801\u4e3a\u7a7a");
            return jsonObject;
        }
        if (Lang.isEmpty((Object)newRePwd)) {
            jsonObject.put("code", (Object)"-3");
            jsonObject.put("msg", (Object)"\u786e\u5b9a\u5bc6\u7801\u4e3a\u7a7a");
            return jsonObject;
        }
        if (!newPwd.equals(newRePwd)) {
            jsonObject.put("code", (Object)"-4");
            jsonObject.put("msg", (Object)"\u5bc6\u7801\u4e0d\u4e00\u81f4");
            return jsonObject;
        }
        CoreUserDto coreUser = null;
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
        if (Lang.isEmpty((Object)organization)) {
            jsonObject.put("code", (Object)"1");
            jsonObject.put("msg", (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
            return jsonObject;
        }
        coreUser = !ValidateUtil.isEmail((String)account) ? this.loginService.findByPhoneAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false) : this.loginService.findByEmailAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);
        MemberDto member = this.loginService.findByCoreUser(coreUser);
        member.setIsFirstLogin(Integer.valueOf(1));
        MemberDto tmpMember = this.loginService.updateMember(member);
        if (Lang.isEmpty((Object)tmpMember)) {
            jsonObject.put("code", (Object)"1");
            jsonObject.put("msg", (Object)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
            return jsonObject;
        }
        String encryptPasswd = this.loginService.encryptPasswd(newPwd);
        coreUser.setPassword(encryptPasswd);
        CoreUserDto user = this.loginService.updateCoreUser(coreUser);
        if (Lang.isEmpty((Object)user)) {
            jsonObject.put("code", (Object)"1");
            jsonObject.put("msg", (Object)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
            return jsonObject;
        }
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"\u4fee\u6539\u5bc6\u7801\u6210\u529f");
        return jsonObject;
    }

    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, HttpServletResponse response) {
        CookiesTool.addCookie((HttpServletResponse)response, (String)"account", (String)"", (int)0);
        return "redirect:../score";
    }

    @RequestMapping(value={"loginValidate"})
    @ResponseBody
    public Boolean loginValidate(HttpServletRequest request) {
        Object memberId = request.getSession().getAttribute("member_id_itaiping");
        if (Lang.isEmpty((Object)memberId)) {
            String currentUrl = request.getParameter("currentUrl");
            if (!StringUtils.isEmpty((Object)currentUrl)) {
                request.getSession().setAttribute("login_back_url_itaiping", (Object)currentUrl);
            }
            return false;
        }
        return true;
    }
}

