/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.login;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"kaptcha"})
@Controller
public class ValidateController {
    @Autowired
    @Qualifier(value="kaptchaProperties")
    private Properties props = new Properties();
    private Producer kaptchaProducer = null;
    private String sessionKeyValue = "LOGIN";
    private String sessionKeyDateValue = "DATE";

    public void setProps(Properties props) {
        this.props = props;
    }

    @PostConstruct
    public void init() throws ServletException {
        ImageIO.setUseCache(false);
        Config config = new Config(this.props);
        this.kaptchaProducer = config.getProducerImpl();
        this.sessionKeyValue = config.getSessionKey();
        this.sessionKeyDateValue = config.getSessionDate();
    }

    @RequestMapping(value={"/image"})
    public void index(HttpServletRequest req, HttpServletResponse resp, String type) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-store, no-cache");
        resp.setContentType("image/jpeg");
        String capText = this.kaptchaProducer.createText();
        if (StringUtils.hasText((String)type)) {
            req.getSession().setAttribute(type + ":code", (Object)capText);
            req.getSession().setAttribute(type + ":date", (Object)new Date());
        } else {
            req.getSession().setAttribute(this.sessionKeyValue, (Object)capText);
            req.getSession().setAttribute(this.sessionKeyDateValue, (Object)new Date());
        }
        BufferedImage bi = this.kaptchaProducer.createImage(capText);
        ServletOutputStream out = resp.getOutputStream();
        ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
    }
}

