/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import member.api.vo.AddressVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.AddressUtils;
import utils.web.Webs;

@Controller
@RequestMapping(value={"/areaCommon"})
public class AddressController {
    @Autowired
    AreaService areaService;
    private static final Log log = Logs.getLog((String)AddressController.class.getName());
    @MotanReferer
    AddressCommonApi addressCommonApi;

    @RequestMapping(value={"/findAllByParent"})
    @ResponseBody
    public Map<String, Object> findAddressByParent(Integer level, String parent, Boolean withChildren, Map model, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("status", "success");
        resData.put("message", "success");
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel((int)level);
        withChildren = withChildren == null ? false : withChildren;
        List apiRes = null;
        apiRes = Lang.isEmpty((Object)parent) ? this.addressCommonApi.addressVoList(addrLevel, null, withChildren) : this.addressCommonApi.addressVoList(addrLevel, parent, withChildren);
        resData.put("data", apiRes);
        return resData;
    }

    @RequestMapping(value={"/findAll"})
    @ResponseBody
    public Map<String, Object> findAddress(String id, Integer level, String parentId, Boolean withChildren, Map model, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("status", "success");
        resData.put("message", "success");
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel((int)level);
        withChildren = withChildren == null ? false : withChildren;
        List apiRes = null;
        if (!Lang.isEmpty((Object)id)) {
            apiRes = new ArrayList<AddressVo>();
            apiRes.add(this.addressCommonApi.findVoById(id, Boolean.valueOf(true)));
        } else if (Lang.isEmpty((Object)parentId)) {
            apiRes = this.addressCommonApi.addressVoList(addrLevel, null, withChildren);
        } else if (parentId.contains(",")) {
            String[] pidArr;
            for (String pid : pidArr = parentId.split(",")) {
                apiRes.addAll(this.addressCommonApi.addressVoList(addrLevel, pid, withChildren));
            }
        } else {
            apiRes = this.addressCommonApi.addressVoList(addrLevel, parentId, withChildren);
        }
        resData.put("data", apiRes);
        return resData;
    }

    @RequestMapping(value={"/ipAddress"})
    @ResponseBody
    public Map<String, Object> findIpAddressIds(Map model, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("status", "success");
        resData.put("message", "success");
        resData.put("data", this.getIpAddressIds(request, response));
        log.info((Object)("reseted session addressId -> proviceId: " + request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID") + "cityId: " + request.getSession().getAttribute("AREA_LEVEL_CITY_ID") + "areaId: " + request.getSession().getAttribute("AREA_LEVEL_AREA_ID") + "townId: " + request.getSession().getAttribute("AREA_LEVEL_TOWN_ID")));
        return resData;
    }

    @RequestMapping(value={"/savedArea"}, method={RequestMethod.GET})
    @ResponseBody
    Map<String, Object> getSavedArea(HttpServletRequest request, HttpServletResponse response) {
        HashMap model = Maps.newHashMap();
        String provinceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        String cityId = (String)request.getSession().getAttribute("AREA_LEVEL_CITY_ID");
        String areaId = (String)request.getSession().getAttribute("AREA_LEVEL_AREA_ID");
        String townId = (String)request.getSession().getAttribute("AREA_LEVEL_TOWN_ID");
        if (!Lang.isEmpty((Object)provinceId)) {
            Map returnAddressIdMap = this.areaService.getAddressIdSByParams(request, provinceId);
            cityId = (String)returnAddressIdMap.get("cityId");
            areaId = (String)returnAddressIdMap.get("areaId");
            townId = (String)returnAddressIdMap.get("townId");
        }
        if (Lang.isEmpty((Object)provinceId)) {
            provinceId = "110000";
            cityId = "110100";
            areaId = "110120";
        }
        model.put("provinceId", provinceId);
        model.put("cityId", cityId);
        model.put("areaId", areaId);
        model.put("townId", townId);
        return model;
    }

    @RequestMapping(value={"changeProvince/{provoiceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map changeProvince(@PathVariable(value="provoiceId") String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        HashMap map = Maps.newHashMap();
        map.put("result", "success");
        this.setAddressId(provoiceId, request, response);
        return map;
    }

    @RequestMapping(value={"changeArea/{areaId}"})
    @ResponseBody
    public Map changeArea(@PathVariable(value="areaId") String areaId, HttpServletRequest request, HttpServletResponse response) {
        HashMap map = Maps.newHashMap();
        map.put("result", "success");
        this.setAddressIdSByParams(request, response, areaId);
        return map;
    }

    @RequestMapping(value={"/cleanAreas"})
    @ResponseBody
    Map<String, Object> cleanSessionAreas(Map model, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("status", "success");
        resData.put("message", "success");
        request.getSession().setAttribute("AREA_LEVEL_PROVINCE_ID", null);
        request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
        request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
        request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
        log.info((Object)("reseted session addressId -> proviceId: " + request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID") + ", cityId: " + request.getSession().getAttribute("AREA_LEVEL_CITY_ID") + ", areaId: " + request.getSession().getAttribute("AREA_LEVEL_AREA_ID") + ", townId: " + request.getSession().getAttribute("AREA_LEVEL_TOWN_ID")));
        return resData;
    }

    public void setAddressId(String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        String cityId = (String)request.getSession().getAttribute("AREA_LEVEL_CITY_ID");
        String areaId = (String)request.getSession().getAttribute("AREA_LEVEL_AREA_ID");
        if (!Lang.isEmpty((Object)sessionProvoiceId)) {
            if (!provoiceId.equals(sessionProvoiceId)) {
                returnProvoiceId = provoiceId;
                request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
            } else {
                returnProvoiceId = sessionProvoiceId;
                request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
            }
        } else {
            returnProvoiceId = provoiceId;
        }
        Map addressMap = this.areaService.getAddressIdSByParams(request, returnProvoiceId);
        returnCityId = (String)addressMap.get("cityId");
        returnAreaId = (String)addressMap.get("areaId");
        String returnTownId = (String)addressMap.get("townId");
        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, returnAddressIdMap);
        log.info((Object)("reseted session addressId -> proviceId: " + request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID") + "cityId: " + request.getSession().getAttribute("AREA_LEVEL_CITY_ID") + "areaId: " + request.getSession().getAttribute("AREA_LEVEL_AREA_ID") + "townId: " + request.getSession().getAttribute("AREA_LEVEL_TOWN_ID")));
    }

    public Map getIpAddressIds(HttpServletRequest request, HttpServletResponse response) {
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        Map returnMap = this.areaService.getAddressIdSByParams(request, sessionProvoiceId);
        return returnMap;
    }

    public void setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if (Lang.isEmpty((Object)areaId)) {
            throw new NullPointerException("areaId not null");
        }
        HashMap addressMap = Maps.newHashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = areaId;
        String returnTownId = null;
        Map areaNodeList = this.addressCommonApi.areaCodeNodeList(areaId);
        if (!Lang.isEmpty((Object)areaNodeList)) {
            returnProvoiceId = (String)areaNodeList.get(1);
            returnCityId = (String)areaNodeList.get(2);
            returnAreaId = (String)areaNodeList.get(3);
            returnTownId = (String)areaNodeList.get(4);
            log.info((Object)("ChangeArea areaNodeList -> returnProvoiceId:" + returnProvoiceId + ",returnCityId" + returnCityId + ",returnAreaId:" + returnAreaId + ",returnTownId:" + returnTownId));
        }
        addressMap.put("provoiceId", returnProvoiceId);
        addressMap.put("cityId", returnCityId);
        addressMap.put("areaId", returnAreaId);
        addressMap.put("townId", returnTownId);
        AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, (Map)addressMap);
        log.info((Object)("reseted session addressId -> proviceId: " + request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID") + "cityId: " + request.getSession().getAttribute("AREA_LEVEL_CITY_ID") + "areaId: " + request.getSession().getAttribute("AREA_LEVEL_AREA_ID") + "townId: " + request.getSession().getAttribute("AREA_LEVEL_TOWN_ID")));
    }

    public Map getCityAndAreaId(String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        AddressDto a = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(true));
        if (a != null) {
            AddressDto c;
            returnCityId = a.getId();
            AddressDto addr = this.addressCommonApi.findFirstChild(returnCityId, Boolean.valueOf(false));
            if (Lang.isEmpty((Object)addr)) {
                returnAreaId = addr.getId();
            }
            if ((c = this.addressCommonApi.findFirstChild(returnAreaId, Boolean.valueOf(true))) != null) {
                returnTownId = c.getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp((HttpServletRequest)request);
        if (!Lang.isEmpty((Object)remoteIp)) {
            Long ipL = IPtoLong.ipToLong((String)remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty((Object)areaId) && !Lang.isEmpty((Object)(currentAaddress = this.addressCommonApi.findAreaByIp(ipL, 3)))) {
                returnAreaId = currentAaddress.getId();
                returnCityId = currentAaddress.getParent().getId();
            }
        }
        if (Lang.isEmpty(returnAreaId)) {
            AddressDto cityAddress = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(true));
            returnCityId = "110100";
            returnAreaId = "110101";
            returnTownId = "d8a15c70-9c8a-44b6-bc34-06b457ecfaaf";
        }
        request.getSession().setAttribute("AREA_LEVEL_CITY_ID", returnCityId);
        request.getSession().setAttribute("AREA_LEVEL_AREA_ID", returnAreaId);
        request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", (Object)returnTownId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }
}

