/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import aftersale.api.AfterSaleApplyApi;
import aftersale.api.Vo.ApplyParamsVo;
import aftersale.api.Vo.OrderAndSkuVO;
import aftersale.api.Vo.WareReturnJdCompVO;
import aftersale.api.dto.MemberAddressDto;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.api.request.aftersale.OrderSkuEntity;
import jd.api.response.aftersale.WareReturnJdCompResp;
import jd.api.service.aftersale.JdAftersaleApi;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AfterSaleApplyController {
    @MotanReferer
    AfterSaleApplyApi afterSaleApplyApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    JdAftersaleApi jdAftersaleApi;
    @Autowired
    MapperFacade mapperFacade;

    @RequestMapping(value={"/afterSaleTest"})
    public String test() {
        return "myMsg/demoTest";
    }

    @RequestMapping(value={"/salesApply"})
    public String afterSaleApplyPage(OrderAndSkuVO orderAndSkuVO, Map<String, Object> map) {
        orderAndSkuVO = this.afterSaleApplyApi.QueryApplyCondition(orderAndSkuVO);
        MemberAddressDto memberAddress = this.afterSaleApplyApi.QueryMemberAddress(orderAndSkuVO.getAddressId());
        OrderSkuEntity orderSkuEntity = new OrderSkuEntity();
        orderSkuEntity.setJdOrderId(orderAndSkuVO.getJdOrderId());
        orderSkuEntity.setSkuId(orderAndSkuVO.getSkuId());
        WareReturnJdCompResp wareReturnJdCompResp = this.jdAftersaleApi.getWareReturnJd(orderSkuEntity);
        if (wareReturnJdCompResp.getSuccess().booleanValue()) {
            ArrayList returnMethodList = new ArrayList();
            Object returnMethodMap = null;
            orderAndSkuVO.setReturnTypes(this.mapperFacade.mapAsList((Iterable)wareReturnJdCompResp.getResult(), WareReturnJdCompVO.class));
        }
        map.put("orderAndSkuVO", orderAndSkuVO);
        map.put("memberAddress", memberAddress);
        this.journal("orderAndSkuVO", (Object)orderAndSkuVO);
        this.journal("memberAddress", (Object)memberAddress);
        return "myMsg/myAfterSalesApply";
    }

    @RequestMapping(value={"/applySuccess"})
    public String returnApplyUI() {
        return "myMsg/myAfterSalesApplySuc";
    }

    @RequestMapping(value={"/returnApplyResult"})
    @ResponseBody
    public Map<String, Boolean> returnApplyResult(ApplyParamsVo applyParamsVo) {
        this.journal("applyParamsVo", (Object)applyParamsVo);
        Map result = this.afterSaleApplyApi.applyAfterSale(applyParamsVo);
        return result;
    }

    @RequestMapping(value={"/getLevelAddressByDb"})
    @ResponseBody
    public Map<String, String> getLevelAddressByDb(Integer level, String addressId) {
        HashMap<String, String> addressList = new HashMap<String, String>();
        List list = null;
        switch (level) {
            case 0: {
                list = this.addressCommonApi.addressList(AddressCommonApi.AddressLevel.PROVINCE, null, Boolean.valueOf(false));
                System.out.print("\u4e00\u7ea7\u5730\u5740 \u7701 \u6570\u636e\u5e93" + list);
                break;
            }
            case 1: {
                list = this.addressCommonApi.addressList(AddressCommonApi.AddressLevel.CITY, addressId, Boolean.valueOf(false));
                System.out.print("\u4e8c\u7ea7\u5730\u5740 \u5e02 \u6570\u636e\u5e93");
                break;
            }
            case 2: {
                list = this.addressCommonApi.addressList(AddressCommonApi.AddressLevel.AREA, addressId, Boolean.valueOf(false));
                System.out.print("\u4e09\u7ea7\u5730\u5740 \u533a\u53bf \u6570\u636e\u5e93");
                break;
            }
            case 3: {
                list = this.addressCommonApi.addressList(AddressCommonApi.AddressLevel.TOWN, addressId, Boolean.valueOf(false));
                System.out.print("\u56db\u7ea7\u5730\u5740 \u9547 ");
            }
        }
        for (AddressDto addressDto : list) {
            addressList.put(addressDto.getName(), addressDto.getId());
        }
        if (addressList.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : addressList.entrySet()) {
            System.out.println((String)entry.getKey() + "--->" + (String)entry.getValue());
        }
        return addressList;
    }

    public void journal(String key, Object o) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            System.out.println(key + "=====" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

