/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

@Controller
@RequestMapping(value={"memberAddress"})
public class MemberAddressController {
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;

    @RequestMapping(value={"list", "list.json"})
    @ResponseBody
    public Map list(Map model, HttpServletRequest request, HttpServletResponse response) {
        MemberVo memberVo = this.findMemberVo(request);
        String noMask = request.getParameter("noMask");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("error", 0);
        try {
            ArrayList memberAddressList = this.memberAddressApi.list(memberVo.getMember().getId());
            if (!Lang.isEmpty((Object)memberAddressList)) {
                for (MemberAddressDto ma : memberAddressList) {
                    StringBuffer sb = new StringBuffer(ma.getPhone());
                    ma.setMember(null);
                    if (!Lang.isEmpty((Object)noMask)) continue;
                    ma.setPhone(sb.replace(3, 8, "*****").toString());
                }
            } else {
                memberAddressList = new ArrayList(1);
            }
            rsMap.put("data", memberAddressList);
            rsMap.put("message", "suc");
        }
        catch (Exception e) {
            rsMap.put("status", "error");
            rsMap.put("error", 1);
            rsMap.put("message", e.getMessage());
            e.printStackTrace();
        }
        return rsMap;
    }

    @RequestMapping(value={"delete", "delete.json"})
    @ResponseBody
    public Map delete(@RequestParam(value="ids[]") String[] ids, Map model, HttpServletRequest request, HttpServletResponse response) {
        MemberVo memberVo = this.findMemberVo(request);
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("error", 0);
        if (!Lang.isEmpty((Object)ids)) {
            ArrayList delResList = new ArrayList();
            try {
                for (String id : ids) {
                    HashMap<String, Object> delRes = new HashMap<String, Object>();
                    delRes.put("id", id);
                    delRes.put("success", this.memberAddressApi.delete(id));
                    delResList.add(delRes);
                }
                rsMap.put("data", delResList);
            }
            catch (Exception e) {
                rsMap.put("status", "error");
                rsMap.put("error", 1);
                rsMap.put("message", e.getMessage());
                e.printStackTrace();
            }
        }
        return rsMap;
    }

    @RequestMapping(value={"update", "update.json"})
    @ResponseBody
    public Map update(MemberAddressDto memberAddress, Map model, HttpServletRequest request, HttpServletResponse response) {
        MemberVo memberVo = this.findMemberVo(request);
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("error", 0);
        try {
            memberAddress.setMember(memberVo.getMember());
            MemberAddressDto res = this.memberAddressApi.saveOrUpdateAddress(memberAddress);
            res.setMember(null);
            rsMap.put("data", res);
        }
        catch (Exception e) {
            e.printStackTrace();
            rsMap.put("status", "error");
            rsMap.put("error", 1);
            rsMap.put("message", e.getLocalizedMessage());
        }
        return rsMap;
    }

    private MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id_itaiping");
        String userId = (String)request.getSession().getAttribute("user_id_itaiping");
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            memberVo = this.memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            memberVo = this.memberApi.getMemberInfoByUserId(userId);
        }
        return memberVo;
    }
}

