/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.vo.AdminScoreIncomeExpenseDetailVo;
import ctscore.web.vo.AdminScoreOverViewVo;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberCredisCheckVo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreIncomeExpenseDetailDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreStatisticsRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ExcelUtil;

@Controller
@RequestMapping(value={"memberCreditsCheck"})
public class MemberCreditsCheckController {
    private static final Logger log = LoggerFactory.getLogger(MemberCreditsCheckController.class);
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberApi memberApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberCreditsTranApi memberCreditsTranApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrganizationApi organizationApi;
    @Autowired
    MemberBatchService memberBatchService;
    @Autowired
    MemberLoginService memberLoginService;
    @MotanReferer
    ScoreApi scoreApi;
    @Value(value="${ctscore.organization.code}")
    String organizationCode;

    @RequestMapping(value={"", "index.do", "index.htm"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model) {
        return "member/manager/adOperaCheckScoreView";
    }

    @ResponseBody
    @RequestMapping(value={"list"}, method={RequestMethod.POST})
    public Map list(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        long methodStartTIme = System.currentTimeMillis();
        log.info("\u79ef\u5206\u6982\u89c8\u67e5\u8be2\u5f00\u59cb...");
        HashMap<String, Object> returnMap = new HashMap<String, Object>(5);
        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        String organizationName = this.organizationApi.findOrganizationNameByOrgCode(this.organizationCode);
        log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - getOrganizationInfoTime) / 1000.0f));
        MemberDto memberDTO = new MemberDto();
        if (!Lang.isEmpty((Object)username)) {
            memberDTO.setRealName(username);
        }
        CoreUserDto coreUserDTO = new CoreUserDto();
        coreUserDTO.setUserType(CoreUserDto.USER_TYPE_MEMBER);
        coreUserDTO.setOrganizationId(organizationId);
        if (!Lang.isEmpty((Object)phone)) {
            coreUserDTO.setPhone(phone);
        }
        if (!Lang.isEmpty((Object)email)) {
            coreUserDTO.setEmail(email);
        }
        memberDTO.setCoreUser(coreUserDTO);
        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, new String[]{"coreUser.username"}));
        ArrayList coreUserIdSort = new ArrayList();
        Map memberDTOMap = this.memberBatchService.findMember(memberDTO, pageable, coreUserIdSort);
        List scoreAccountDTOs = this.memberBatchService.queryScoreAccount(this.organizationCode, memberDTOMap);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList adminScoreOverViewVoList = new ArrayList();
        coreUserIdSort.forEach(coreUserId -> {
            List scoreAccountDTOList = scoreAccountDTOs.stream().filter(scoreAccountDTO -> coreUserId.equals(scoreAccountDTO.getUserId())).collect(Collectors.toList());
            if (scoreAccountDTOList.size() == 1) {
                ScoreAccountDTO scoreAccountDTO2 = (ScoreAccountDTO)scoreAccountDTOList.get(0);
                AdminScoreOverViewVo adminScoreOverViewVo = new AdminScoreOverViewVo();
                if (!Lang.isEmpty((Object)scoreAccountDTO2.getUserId()) && memberDTOMap.containsKey(scoreAccountDTO2.getUserId())) {
                    MemberDto member = (MemberDto)memberDTOMap.get(scoreAccountDTO2.getUserId());
                    adminScoreOverViewVo.setUserName(member.getRealName());
                    adminScoreOverViewVo.setEmail(member.getCoreUser().getEmail());
                    adminScoreOverViewVo.setPhone(member.getCoreUser().getPhone());
                    adminScoreOverViewVo.setIdCard(member.getCoreUser().getIdCard());
                    adminScoreOverViewVo.setMemberId(member.getId());
                    adminScoreOverViewVo.setAdmin(member.getAdmin());
                }
                if (!Lang.isEmpty((Object)scoreAccountDTO2.getLastUpdated())) {
                    adminScoreOverViewVo.setLastUpdated(dateFormat.format(scoreAccountDTO2.getLastUpdated()));
                }
                adminScoreOverViewVo.setOrganizationName(organizationName);
                adminScoreOverViewVo.setScore(scoreAccountDTO2.getIncomeScoreVal().subtract(scoreAccountDTO2.getExpendedScoreVal()).toString());
                adminScoreOverViewVo.setScoreSpent(scoreAccountDTO2.getExpendedScoreVal().toString());
                adminScoreOverViewVoList.add(adminScoreOverViewVo);
            }
        });
        PageImpl adminScoreOverViewPage = new PageImpl(adminScoreOverViewVoList, pageable, (long)this.memberBatchService.getMemberCount(memberDTO));
        returnMap.put("data", adminScoreOverViewPage);
        returnMap.put("orgName", organizationName);
        returnMap.put("totalPages", adminScoreOverViewPage.getTotalPages());
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        log.info("\u79ef\u5206\u6982\u89c8\u67e5\u8be2\u5b8c\u6210, \u603b\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - methodStartTIme) / 1000.0f));
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value={"listExport"})
    public void listExport(String username, String phone, String email, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info("\u79ef\u5206\u6982\u89c8\u5bfc\u51fa\u5f00\u59cb...");
        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        String organizationName = this.organizationApi.findOrganizationNameByOrgCode(this.organizationCode);
        log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - getOrganizationInfoTime) / 1000.0f));
        MemberDto memberDTO = new MemberDto();
        if (!Lang.isEmpty((Object)username)) {
            memberDTO.setRealName(username);
        }
        CoreUserDto coreUserDTO = new CoreUserDto();
        coreUserDTO.setUserType(CoreUserDto.USER_TYPE_MEMBER);
        coreUserDTO.setOrganizationId(organizationId);
        if (!Lang.isEmpty((Object)phone)) {
            coreUserDTO.setPhone(phone);
        }
        if (!Lang.isEmpty((Object)email)) {
            coreUserDTO.setEmail(email);
        }
        memberDTO.setCoreUser(coreUserDTO);
        ArrayList coreUserIdSort = new ArrayList();
        Map memberDTOMap = this.memberBatchService.findMember(memberDTO, new Sort(Sort.Direction.DESC, new String[]{"coreUser.username"}), coreUserIdSort);
        List scoreAccountDTOs = this.memberBatchService.queryScoreAccount(this.organizationCode, memberDTOMap);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("\u59d3\u540d");
        header.add("\u516c\u53f8");
        header.add("\u624b\u673a\u53f7");
        header.add("\u90ae\u7bb1");
        header.add("\u8eab\u4efd\u8bc1");
        header.add("\u53d8\u52a8\u65f6\u95f4");
        header.add("\u53ef\u7528\u79ef\u5206 (Ct)");
        header.add("\u6d88\u8d39\u79ef\u5206 (Ct)");
        rows.add(header);
        coreUserIdSort.forEach(coreUserId -> {
            ScoreAccountDTO scoreAccountDTO2;
            List scoreAccountDTOList = scoreAccountDTOs.stream().filter(scoreAccountDTO -> coreUserId.equals(scoreAccountDTO.getUserId())).collect(Collectors.toList());
            if (scoreAccountDTOList.size() == 1 && !Lang.isEmpty((Object)(scoreAccountDTO2 = (ScoreAccountDTO)scoreAccountDTOList.get(0)).getUserId())) {
                ArrayList<String> row = new ArrayList<String>();
                String memberRealName = "";
                String coreUserPhone = "";
                String coreUserEmail = "";
                String coreUserIdCard = "";
                if (!Lang.isEmpty((Object)scoreAccountDTO2.getUserId()) && memberDTOMap.containsKey(scoreAccountDTO2.getUserId())) {
                    MemberDto member = (MemberDto)memberDTOMap.get(scoreAccountDTO2.getUserId());
                    memberRealName = member.getRealName();
                    coreUserEmail = member.getCoreUser().getEmail();
                    coreUserPhone = member.getCoreUser().getPhone();
                    coreUserIdCard = member.getCoreUser().getIdCard();
                }
                String rowLastUpdated = "";
                if (!Lang.isEmpty((Object)scoreAccountDTO2.getLastUpdated())) {
                    rowLastUpdated = dateFormat.format(scoreAccountDTO2.getLastUpdated());
                }
                row.add(memberRealName);
                row.add(organizationName);
                row.add(coreUserPhone);
                row.add(coreUserEmail);
                row.add(coreUserIdCard);
                row.add(rowLastUpdated);
                row.add(scoreAccountDTO2.getIncomeScoreVal().subtract(scoreAccountDTO2.getExpendedScoreVal()).toString());
                row.add(scoreAccountDTO2.getExpendedScoreVal().toString());
                rows.add(row);
            }
        });
        try {
            response.setHeader("Content-disposition", "attachment; filename=Member.xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, (String)"Member").write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u79ef\u5206\u6982\u89c8\u5bfc\u51fa\u5b8c\u6210, \u5171 {} \u6761\u6570\u636e, \u8017\u65f6 {} \u79d2", (Object)(rows.size() - 1), (Object)Float.valueOf((float)(System.currentTimeMillis() - methodStartTime) / 1000.0f));
    }

    @RequestMapping(value={"exportMember.do"})
    @ResponseBody
    public void exportMember(String username, String phone, String email, HttpServletResponse response, HttpServletRequest request) {
        Object pageable = null;
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto theMember = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUserSession = this.memberLoginService.findById(id);
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUserSession.getOrganizationId());
        CoreUserDto coreUserExp = new CoreUserDto(CoreUserDto.USER_TYPE_MEMBER, organization.getId());
        if (!Lang.isEmpty((Object)username)) {
            coreUserExp.setUsername(username.trim());
        }
        if (!Lang.isEmpty((Object)phone)) {
            coreUserExp.setPhone(phone.trim());
        }
        if (!Lang.isEmpty((Object)email)) {
            coreUserExp.setEmail(email.trim());
        }
        coreUserExp.setErrCount(null);
        coreUserExp.setLoginCount(null);
        coreUserExp.setDisabled(null);
        List coreUsers = this.coreUserApi.findByExample(coreUserExp);
        List members = this.memberApi.findByUsers(coreUsers);
        ArrayList<MemberCredisCheckVo> memberCredisCheckVos = new ArrayList<MemberCredisCheckVo>();
        for (int i = 0; i < members.size(); ++i) {
            MemberDto member = (MemberDto)members.get(i);
            CoreUserDto coreUser = member.getCoreUser();
            MemberCredisCheckVo memberCredisCheckVo = new MemberCredisCheckVo();
            memberCredisCheckVo.setName(coreUser.getUsername());
            memberCredisCheckVo.setCompanyName("\u8bda\u901a\u4eba\u529b\u8d44\u6e90\u6709\u9650\u516c\u53f8");
            memberCredisCheckVo.setPhone(coreUser.getPhone());
            memberCredisCheckVo.setEmail(coreUser.getEmail());
            memberCredisCheckVo.setChangeTime(DateUtils.dateToStrLong((Date)coreUser.getLastUpdated()));
            memberCredisCheckVo.setScore(member.getScore().toString());
            memberCredisCheckVos.add(memberCredisCheckVo);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "Member");
        this.setContentColumnWidth(sheet);
        HSSFCellStyle cellStyle = this.setContentCellStyle(wb);
        this.createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0));
        this.createCellContent(memberCredisCheckVos, cellStyle, sheet);
        try {
            response.setHeader("Content-disposition", "attachment; filename=Member.xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"getMember.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getMember(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        CoreUserDto coreUserExp = new CoreUserDto(CoreUserDto.USER_TYPE_MEMBER, organization.getId());
        if (!Lang.isEmpty((Object)username)) {
            coreUserExp.setUsername(username.trim());
        }
        if (!Lang.isEmpty((Object)phone)) {
            coreUserExp.setPhone(phone.trim());
        }
        if (!Lang.isEmpty((Object)email)) {
            coreUserExp.setEmail(email.trim());
        }
        coreUserExp.setErrCount(null);
        coreUserExp.setLoginCount(null);
        coreUserExp.setDisabled(null);
        Page coreUsers = this.coreUserApi.findByExample(coreUserExp, pageable);
        List members = this.memberApi.findByUsers(coreUsers.getContent());
        PageImpl memberPage = new PageImpl(members, pageable, coreUsers.getTotalElements());
        returnMap.put("data", memberPage);
        returnMap.put("orgName", organization.getOrgName());
        returnMap.put("totalPages", this.getTotalPages((int)memberPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        return returnMap;
    }

    @RequestMapping(value={"memberDetail.do"}, method={RequestMethod.GET})
    public String memberDetail(String memberId, Model model) {
        MemberDto member = this.memberApi.findMemberById(memberId);
        CoreUserDto coreUser = member.getCoreUser();
        OrganizationDto organization = this.organizationApi.findOrganizationById(member.getCoreUser().getOrganizationId());
        ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
        scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
        scoreAccountRequestDTO.setUserId(coreUser.getId());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
        AdminScoreOverViewVo adminScoreOverViewVo = new AdminScoreOverViewVo();
        adminScoreOverViewVo.setMemberId(memberId);
        adminScoreOverViewVo.setUserName(member.getRealName());
        adminScoreOverViewVo.setPhone(coreUser.getPhone());
        adminScoreOverViewVo.setEmail(coreUser.getEmail());
        adminScoreOverViewVo.setOrganizationName(organization.getOrgName());
        adminScoreOverViewVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
        adminScoreOverViewVo.setScoreSpent(scoreAccountDTO.getExpendedScoreVal().toString());
        adminScoreOverViewVo.setScoreGetAll(scoreAccountDTO.getIncomeScoreVal().toString());
        ScoreStatisticsRequestDTO scoreStatisticsRequestDTO = new ScoreStatisticsRequestDTO();
        scoreStatisticsRequestDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
        scoreStatisticsRequestDTO.setOrganizationCode(scoreAccountRequestDTO.getOrganizationCode());
        scoreStatisticsRequestDTO.setScoreAccountId(scoreAccountDTO.getId());
        ScoreStatisticsResponseDTO scoreStatisticsResponseDTO = this.scoreApi.scoreIncomeStatics(scoreStatisticsRequestDTO);
        adminScoreOverViewVo.setScoreGrant(scoreStatisticsResponseDTO.getScoreVal().toString());
        scoreStatisticsRequestDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        scoreStatisticsResponseDTO = this.scoreApi.scoreExpenseStatics(scoreStatisticsRequestDTO);
        adminScoreOverViewVo.setScoreGiveAll(scoreStatisticsResponseDTO.getScoreVal().toString());
        adminScoreOverViewVo.setMemberId(scoreAccountDTO.getId());
        model.addAttribute("adminScoreOverViewVo", (Object)adminScoreOverViewVo);
        return "member/manager/adOperaScoreViewDetail";
    }

    @RequestMapping(value={"detailList"}, method={RequestMethod.POST})
    @ResponseBody
    public Map detailList(String scoreAccountId, Pageable pageable, HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<String> scoreAccountIdList = new ArrayList<String>();
        scoreAccountIdList.add(scoreAccountId);
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setPageSize(Integer.valueOf(pageable.getPageSize()));
        scoreDetailQueryDTO.setPage(Integer.valueOf(pageable.getPageNumber()));
        scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<AdminScoreIncomeExpenseDetailVo> list = new ArrayList<AdminScoreIncomeExpenseDetailVo>();
        PageResponseDTO scoreIncomeExpenseDetailPage = this.scoreApi.queryScoreIncomeExpenseDetails(scoreDetailQueryDTO);
        for (ScoreIncomeExpenseDetailDTO scoreIncomeExpenseDetail : scoreIncomeExpenseDetailPage.getContent()) {
            AdminScoreIncomeExpenseDetailVo scoreIncomeExpense = new AdminScoreIncomeExpenseDetailVo();
            scoreIncomeExpense.setBusiSource(scoreIncomeExpenseDetail.getBusiSource());
            scoreIncomeExpense.setMemo(scoreIncomeExpenseDetail.getMemo());
            if (scoreIncomeExpenseDetail.getScoreVal().intValue() > 0) {
                scoreIncomeExpense.setScoreVal("+" + scoreIncomeExpenseDetail.getScoreVal().toString());
            } else {
                scoreIncomeExpense.setScoreVal(scoreIncomeExpenseDetail.getScoreVal().toString());
            }
            if (!Lang.isEmpty((Object)scoreIncomeExpenseDetail.getTransaTime())) {
                scoreIncomeExpense.setTransaTime(dateFormat.format(scoreIncomeExpenseDetail.getTransaTime()));
            }
            list.add(scoreIncomeExpense);
        }
        PageImpl page = new PageImpl(list, pageable, (long)list.size());
        returnMap.put("data", page);
        returnMap.put("totalPages", scoreIncomeExpenseDetailPage.getTotalPages());
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        return returnMap;
    }

    @RequestMapping(value={"getMemberCreditsTrans.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getMemberCreditsTrans(String memberId, Pageable pageable, HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Page memberCreditsTranPage = this.memberCreditsTranApi.findByMemberIdSendAndTarget(pageable, memberId);
        returnMap.put("data", memberCreditsTranPage);
        returnMap.put("totalPages", this.getTotalPages((int)memberCreditsTranPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        return returnMap;
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellValue("\u59d3\u540d");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(1);
        cell.setCellValue("\u516c\u53f8\u540d");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(2);
        cell.setCellValue("\u624b\u673a");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(3);
        cell.setCellValue("\u90ae\u7bb1");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(4);
        cell.setCellValue("\u53d8\u52a8\u65f6\u95f4");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(5);
        cell.setCellValue("\u73b0\u6709\u79ef\u5206");
        cell.setCellStyle(cellStyle);
    }

    private void createCellContent(List<MemberCredisCheckVo> importVos, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < importVos.size(); ++i) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            MemberCredisCheckVo credisCheckVo = importVos.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisCheckVo.getName()));
            theCell = row.createCell(1);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisCheckVo.getCompanyName()));
            theCell = row.createCell(2);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisCheckVo.getPhone()));
            theCell = row.createCell(3);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisCheckVo.getEmail()));
            theCell = row.createCell(4);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisCheckVo.getChangeTime()));
            theCell = row.createCell(5);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisCheckVo.getScore()));
        }
    }

    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);
        sheet.setColumnWidth(4, 5000);
    }

    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    private String setContentCellValue(String value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value;
    }
}

