/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.api.vo.ScoreFlowDetailVO;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.ScoreUserService;
import ctscore.web.service.member.UserCenterService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.model.repository.member.MemberRepos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreGiveAwayRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import utils.Lang;
import utils.sql.PageVo;

@Controller
@RequestMapping(value={"/credits"})
public class MemberCreditsController {
    static final Logger logger = LoggerFactory.getLogger(MemberCreditsController.class);
    @Autowired
    MemberLoginService memberLoginService;
    @Autowired
    UserCenterService userCenterService;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ScoreApi scoreApi;
    @Value(value="${ctscore.organization.code}")
    String organizationCode;
    @Autowired
    MemberBatchService memberBatchService;
    @Autowired
    ScoreUserService scoreUserService;
    private static final String SEND_SCORE_TOKEN = "SEND_SCORE_TOKEN";
    @MotanReferer
    MemberApi memberApi;
    @Autowired
    MemberRepos memberRepos;

    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, Map model) {
        logger.info("\u79ef\u5206\u6982\u89c8");
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto tmpCoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(tmpCoreUser.getId());
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(queryDTO);
        BigDecimal usableScoreVal = this.scoreUserService.roundScore(scoreAccountDTO.getIncomeScoreVal());
        BigDecimal expendedScoreVal = this.scoreUserService.roundScore(scoreAccountDTO.getExpendedScoreVal());
        BigDecimal canUseScoreVal = this.scoreUserService.roundScore(usableScoreVal.subtract(expendedScoreVal));
        model.put("canUseScore", canUseScoreVal);
        model.put("usableScore", usableScoreVal);
        model.put("expendedScore", expendedScoreVal);
        return "member/score/index";
    }

    @RequestMapping(value={"/index/page"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject indexPage(HttpServletRequest request, int pageIndex, int pageSize, String startDate, String endDate, String type) {
        long methodStartTime = System.currentTimeMillis();
        logger.info("\u79ef\u5206\u6982\u89c8\u5206\u9875\u67e5\u8be2");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        pageSize = pageSize == 0 ? 10 : pageSize;
        Date start = null;
        Date end = null;
        try {
            if (!Lang.isEmpty((Object)startDate)) {
                startDate = startDate + " 00:00:00";
                start = sdf.parse(startDate);
            }
            if (!Lang.isEmpty((Object)endDate)) {
                endDate = endDate + " 23:59:59";
                end = sdf.parse(endDate);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto tmpCoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(tmpCoreUser.getId());
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(queryDTO);
        String scoreAccountId = scoreAccountDTO.getId();
        ScoreDetailQueryDTO scoreDetailsQueryDTO = new ScoreDetailQueryDTO();
        if ("income".equals(type)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(scoreAccountId);
            scoreDetailsQueryDTO.setScoreAccountIds(list);
            scoreDetailsQueryDTO.setPage(Integer.valueOf(pageIndex));
            scoreDetailsQueryDTO.setPageSize(Integer.valueOf(pageSize));
            scoreDetailsQueryDTO.setStartDate(start);
            scoreDetailsQueryDTO.setEndDate(end);
            PageResponseDTO result = this.scoreApi.queryScoreIncomeDetais(scoreDetailsQueryDTO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)"0");
            jsonObject.put("mes", (Object)"\u5206\u9875\u67e5\u8be2\u6536\u5165\u660e\u7ec6\u7ed3\u679c");
            jsonObject.put("totalPage", (Object)result.getTotalPages());
            jsonObject.put("data", (Object)result);
            logger.info(jsonObject.toJSONString());
            logger.info("\u4e2a\u4eba\u79ef\u5206\u6982\u89c8\u6536\u5165\u67e5\u8be2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStartTime));
            return jsonObject;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(scoreAccountId);
        scoreDetailsQueryDTO.setScoreAccountIds(list);
        scoreDetailsQueryDTO.setPage(Integer.valueOf(pageIndex));
        scoreDetailsQueryDTO.setPageSize(Integer.valueOf(pageSize));
        scoreDetailsQueryDTO.setStartDate(start);
        scoreDetailsQueryDTO.setEndDate(end);
        PageResponseDTO result = this.scoreApi.queryScoreExpenseDetails(scoreDetailsQueryDTO);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)"0");
        jsonObject.put("mes", (Object)"\u5206\u9875\u67e5\u8be2\u652f\u51fa\u660e\u7ec6\u7ed3\u679c");
        jsonObject.put("totalPage", (Object)result.getTotalPages());
        jsonObject.put("data", (Object)result);
        logger.info(jsonObject.toJSONString());
        logger.info("\u4e2a\u4eba\u79ef\u5206\u6982\u89c8\u652f\u51fa\u67e5\u8be2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStartTime));
        return jsonObject;
    }

    @RequestMapping(value={"index/detail/{tranId}/{entry}"}, method={RequestMethod.GET})
    public String indexDetail(HttpServletRequest request, Map model, @PathVariable(value="tranId") String tranId, @PathVariable(value="entry") String entry) {
        logger.info("\u79ef\u5206\u6982\u89c8\u8be6\u60c5\u9875id:{}", (Object)tranId);
        MemberCreditsTranDto memberCreditsTran = this.userCenterService.findMemberCreditsTranById(tranId);
        if (memberCreditsTran != null) {
            model.put("memberCreditsTran", memberCreditsTran);
        }
        if (entry.equals("1")) {
            return "member/score/scoreGrantDetail";
        }
        if (entry.equals("2")) {
            return "member/score/scoretranDetail";
        }
        if (entry.equals("3")) {
            return "member/score/recetranDetail";
        }
        return "member/score/scoreGrantDetail";
    }

    @RequestMapping(value={"/give/score"}, method={RequestMethod.GET})
    public String giveAward(HttpServletRequest request, Map model) {
        logger.info("\u79ef\u5206\u8d60\u4e0e");
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto CoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        String email = CoreUser.getEmail();
        model.put("email", email);
        return "member/score/givescore";
    }

    @RequestMapping(value={"other/members"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject otherMembers(HttpServletRequest request, String searchLoginId, String name, Integer pageIndex, Integer pageSize) {
        logger.info("\u79ef\u5206\u8d60\u4e0e\u5206\u9875\u4f1a\u5458\u67e5\u8be2");
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto CoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        String userId = CoreUser.getId();
        pageIndex = pageIndex == null ? 0 : pageIndex;
        pageSize = pageSize == null ? 10 : pageSize;
        PageVo pageVo = this.userCenterService.findMemberPageByUserIdAndName(pageSize.intValue(), pageIndex.intValue(), userId, searchLoginId, name, CoreUser.getOrganizationId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)"0");
        jsonObject.put("mes", (Object)"\u5206\u9875\u67e5\u8be2\u4f1a\u5458\u7ed3\u679c");
        jsonObject.put("data", (Object)pageVo);
        int totalPage = this.getTotalPages(pageVo.getTotalCount().intValue(), pageSize.intValue());
        jsonObject.put("totalPage", (Object)totalPage);
        logger.info(jsonObject.toJSONString());
        return jsonObject;
    }

    @RequestMapping(value={"give/score/first/{userLoginId}"}, method={RequestMethod.GET})
    public String giveScoreFirst(HttpServletRequest request, Map model, @PathVariable(value="userLoginId") String userLoginId) {
        logger.info("\u79ef\u5206\u8d60\u4e0e\u7b2c\u4e00\u6b65");
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto CoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        String email = CoreUser.getEmail();
        if (email.indexOf("CTYSP123.com") > 0) {
            return "redirect:/credits/give/score";
        }
        OrganizationDto organizationByOrgCode = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
        CoreUserDto findCoreUser = this.userCenterService.findByPhoneOrEmail(userLoginId, organizationByOrgCode.getId());
        if (findCoreUser == null) {
            return "redirect:/credits/give/score";
        }
        MemberDto sendmember = this.userCenterService.getMemberInfoByCoreUser(findCoreUser);
        model.put("member", sendmember);
        String uuid = UUID.randomUUID().toString();
        request.getSession().setAttribute(SEND_SCORE_TOKEN, (Object)uuid);
        model.put("SEND_TOKEN", uuid);
        return "member/score/scoreGivingFirst";
    }

    @RequestMapping(value={"give/score/second"}, method={RequestMethod.POST})
    public String giveScoreSecond(HttpServletRequest request, Map model, String targetMemberId, Integer score, String remark, String targetName, String SEND_TOKEN) {
        logger.info("\u79ef\u5206\u8d60\u4e0e\u7b2c\u4e8c\u6b65");
        if (score < 0) {
            return "redirect:/credits/give/score";
        }
        model.put("targetMemberId", targetMemberId);
        model.put("score", score);
        model.put("remark", remark);
        model.put("targetName", targetName);
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto CoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(CoreUser.getId());
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setEmail(CoreUser.getEmail());
        queryDTO.setPhone(CoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(queryDTO);
        BigDecimal myScore = scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal());
        if (myScore != null && myScore.intValue() >= score) {
            if (!Lang.isEmpty((Object)SEND_TOKEN)) {
                model.put("SEND_TOKEN", SEND_TOKEN);
            }
            model.put("isError", 0);
        } else {
            model.put("errorMsg", "\u6ca1\u6709\u5145\u8db3\u7684\u79ef\u5206\uff0c\u79ef\u5206\u9700\u8981\u91cd\u65b0\u8f93\u5165");
            model.put("isError", 1);
        }
        return "member/score/scoreGivingSecond";
    }

    @RequestMapping(value={"give/score/third"}, method={RequestMethod.POST})
    public String giveScoreThird(HttpServletRequest request, Map model, String targetMemberId, String score, String remark, String targetName, String SEND_TOKEN) {
        logger.info("\u7b2c\u4e09\u6b65\u6210\u529f");
        if (Integer.parseInt(score) < 0) {
            return "redirect:/credits/give/score";
        }
        score = score.replace(",", "");
        Object sendScoreToken = request.getSession().getAttribute(SEND_SCORE_TOKEN);
        if (Lang.isEmpty((Object)SEND_TOKEN) || Lang.isEmpty((Object)sendScoreToken) || !SEND_TOKEN.equals(sendScoreToken.toString())) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "\u975e\u6cd5\u8d60\u9001\u5355");
            return "member/score/scoreGivingSecond";
        }
        if (Lang.isEmpty((Object)targetMemberId) || Lang.isEmpty((Object)targetName)) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "\u6388\u4e88\u8005\u4fe1\u606f\u5f02\u5e38");
            return "member/score/scoreGivingSecond";
        }
        if (Lang.isEmpty((Object)score)) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "\u6388\u4e88\u79ef\u5206\u683c\u5f0f\u4e0d\u7b26\u5408");
            return "member/score/scoreGivingSecond";
        }
        if (Lang.isEmpty((Object)remark)) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "\u8bf7\u586b\u5199\u7ed9\u6388\u4e88\u8005\u4e00\u53e5\u8bdd");
            return "member/score/scoreGivingSecond";
        }
        request.getSession().removeAttribute(SEND_SCORE_TOKEN);
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto tmpCoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(tmpCoreUser.getId());
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(queryDTO);
        String giveAccountId = scoreAccountDTO.getId();
        CoreUserDto coreUserReceive = this.memberApi.findMemberById(targetMemberId).getCoreUser();
        queryDTO.setUserId(coreUserReceive.getId());
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        scoreAccountDTO = this.scoreApi.queryScoreAccount(queryDTO);
        String receiveAccountId = scoreAccountDTO.getId();
        ScoreGiveAwayRequestDTO scoreGiveDTO = new ScoreGiveAwayRequestDTO();
        scoreGiveDTO.setGiveAwayScoreAccountId(giveAccountId);
        scoreGiveDTO.setGiveAwayTime(new Date());
        scoreGiveDTO.setMemo(remark);
        scoreGiveDTO.setReceiveScoreAccountId(receiveAccountId);
        scoreGiveDTO.setScoreVal(new BigDecimal(score));
        String status = "";
        ScoreGiveAwayLogDTO result = null;
        try {
            result = this.scoreApi.scoreGiveAway(scoreGiveDTO);
            status = result.getStatus();
        }
        catch (Exception e) {
            logger.error(JSON.toJSONString((Object)e));
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 0);
            model.put("errorMsg", "\u79ef\u5206\u6388\u4e88\u5931\u8d25\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5");
            return "member/score/scoreGivingSecond";
        }
        logger.info("\u79ef\u5206\u6388\u4e88\u7ed3\u679c:{}", (Object)result);
        if ("success".equals(status)) {
            return "member/score/scoreGivingThird";
        }
        model.put("targetMemberId", targetMemberId);
        model.put("score", score);
        model.put("remark", remark);
        model.put("targetName", targetName);
        model.put("isError", 0);
        model.put("errorMsg", "\u79ef\u5206\u6388\u4e88\u5931\u8d25\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5");
        return "member/score/scoreGivingSecond";
    }

    @RequestMapping(value={"send/tran"}, method={RequestMethod.GET, RequestMethod.POST})
    public String sendScoreCreditTran() {
        logger.info("\u79ef\u5206\u6d41\u52a8\u67e5\u8be2");
        return "member/score/sendtran";
    }

    @RequestMapping(value={"send/tran/page"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject sendScoreCreditTranPage(HttpServletRequest request, Integer pageIndex, Integer pageSize) {
        long methodStartTime = System.currentTimeMillis();
        logger.info("\u8d60\u4e0e\u79ef\u5206\u6d41\u52a8\u660e\u7ec6\u5206\u9875\u67e5\u8be2...");
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto tmpCoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO scoreAccountQueryDTO = new ScoreAccountRequestDTO();
        scoreAccountQueryDTO.setPhone(tmpCoreUser.getPhone());
        scoreAccountQueryDTO.setEmail(tmpCoreUser.getEmail());
        scoreAccountQueryDTO.setOrganizationCode(this.organizationCode);
        scoreAccountQueryDTO.setUserId(tmpCoreUser.getId());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountQueryDTO);
        ScoreDetailQueryDTO queryDTO = new ScoreDetailQueryDTO();
        ArrayList<String> list = new ArrayList<String>();
        list.add(scoreAccountDTO.getId());
        queryDTO.setScoreAccountIds(list);
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        queryDTO.setPage(pageIndex);
        queryDTO.setPageSize(pageSize);
        PageResponseDTO scoreExpenseDetailDTOPageResponseDTO = this.scoreApi.queryScoreExpenseDetails(queryDTO);
        List listScoreEDD = scoreExpenseDetailDTOPageResponseDTO.getContent();
        ArrayList<ScoreFlowDetailVO> resultList = new ArrayList<ScoreFlowDetailVO>();
        HashMap codeLogMap = new HashMap();
        Map memberDTOMap = this.memberBatchService.findScoreGiveData(codeLogMap, listScoreEDD.stream().map(ScoreExpenseDetailDTO::getScoreRcptCode).collect(Collectors.toList()));
        for (int i = 0; i < listScoreEDD.size(); ++i) {
            ScoreGiveAwayLogDTO scoreGiveAwayLogDTO = (ScoreGiveAwayLogDTO)codeLogMap.get(((ScoreExpenseDetailDTO)listScoreEDD.get(i)).getScoreRcptCode());
            ScoreFlowDetailVO result = new ScoreFlowDetailVO();
            result.setId(scoreGiveAwayLogDTO.getId());
            result.setReceiveName(((MemberDto)memberDTOMap.get(((ScoreExpenseDetailDTO)listScoreEDD.get(i)).getScoreRcptCode())).getRealName());
            result.setSendDate(scoreGiveAwayLogDTO.getGiveAwayTime());
            result.setRemark(scoreGiveAwayLogDTO.getMemo());
            result.setScore(scoreGiveAwayLogDTO.getScoreVal());
            resultList.add(result);
        }
        PageResponseDTO result = new PageResponseDTO();
        result.setContent(resultList);
        result.setTotalPages(scoreExpenseDetailDTOPageResponseDTO.getTotalPages());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)"0");
        jsonObject.put("mes", (Object)"\u5206\u9875\u67e5\u8be2\u7ed3\u679c");
        jsonObject.put("totalPage", (Object)scoreExpenseDetailDTOPageResponseDTO.getTotalPages());
        jsonObject.put("data", (Object)result);
        logger.info(jsonObject.toJSONString());
        return jsonObject;
    }

    @RequestMapping(value={"rece/tran"}, method={RequestMethod.GET})
    public String receScoreCreditTran() {
        logger.info("\u88ab\u8d60\u4e0e\u79ef\u5206\u6d41\u52a8\u67e5\u8be2");
        return "member/score/recetran";
    }

    @RequestMapping(value={"rece/tran/page"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject receScoreCreditTranPage(HttpServletRequest request, int pageIndex, int pageSize) {
        long methodStartTime = System.currentTimeMillis();
        logger.info("\u83b7\u8d60\u79ef\u5206\u6d41\u52a8\u660e\u7ec6\u5206\u9875\u67e5\u8be2...");
        Object userJson = request.getSession().getAttribute("user_json_itaiping");
        CoreUserDto tmpCoreUser = (CoreUserDto)JSON.parseObject((String)userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO scoreAccountQueryDTO = new ScoreAccountRequestDTO();
        scoreAccountQueryDTO.setPhone(tmpCoreUser.getPhone());
        scoreAccountQueryDTO.setEmail(tmpCoreUser.getEmail());
        scoreAccountQueryDTO.setOrganizationCode(this.organizationCode);
        scoreAccountQueryDTO.setUserId(tmpCoreUser.getId());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountQueryDTO);
        ScoreDetailQueryDTO queryDTO = new ScoreDetailQueryDTO();
        ArrayList<String> list = new ArrayList<String>();
        list.add(scoreAccountDTO.getId());
        queryDTO.setScoreAccountIds(list);
        queryDTO.setOrganizationCode(this.organizationCode);
        queryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_RECEIVE.getBusinessCode());
        queryDTO.setPage(Integer.valueOf(pageIndex));
        queryDTO.setPageSize(Integer.valueOf(pageSize));
        PageResponseDTO scoreIncomeDetailDTOPageResponseDTO = this.scoreApi.queryScoreIncomeDetais(queryDTO);
        List listScoreEDD = scoreIncomeDetailDTOPageResponseDTO.getContent();
        ArrayList<ScoreFlowDetailVO> resultList = new ArrayList<ScoreFlowDetailVO>();
        HashMap codeLogMap = new HashMap();
        Map memberDTOMap = this.memberBatchService.findScoreGetData(codeLogMap, listScoreEDD.stream().map(ScoreIncomeDetailDTO::getScoreRcptCode).collect(Collectors.toList()));
        for (int i = 0; i < listScoreEDD.size(); ++i) {
            ScoreGiveAwayLogDTO scoreGiveAwayLogDTO = (ScoreGiveAwayLogDTO)codeLogMap.get(((ScoreIncomeDetailDTO)listScoreEDD.get(i)).getScoreRcptCode());
            ScoreFlowDetailVO result = new ScoreFlowDetailVO();
            result.setId(scoreGiveAwayLogDTO.getId());
            result.setSendName(((MemberDto)memberDTOMap.get(((ScoreIncomeDetailDTO)listScoreEDD.get(i)).getScoreRcptCode())).getRealName());
            result.setSendDate(scoreGiveAwayLogDTO.getGiveAwayTime());
            result.setRemark(scoreGiveAwayLogDTO.getMemo());
            result.setScore(scoreGiveAwayLogDTO.getScoreVal());
            resultList.add(result);
        }
        PageResponseDTO result = new PageResponseDTO();
        result.setContent(resultList);
        result.setTotalPages(scoreIncomeDetailDTOPageResponseDTO.getTotalPages());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)"0");
        jsonObject.put("mes", (Object)"\u5206\u9875\u67e5\u8be2\u4f1a\u5458\u7ed3\u679c");
        jsonObject.put("totalPage", (Object)scoreIncomeDetailDTOPageResponseDTO.getTotalPages());
        jsonObject.put("data", (Object)result);
        logger.info(jsonObject.toJSONString());
        logger.info("\u83b7\u8d60\u79ef\u5206\u6d41\u52a8\u660e\u7ec6\u5206\u9875\u67e5\u8be2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStartTime));
        return jsonObject;
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }
}

