/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.vo.AdminScoreGetVo;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.CoreUserSerachVo;
import member.api.vo.MemberCredisGetVo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.GetScoreGiveAwayInfoRequestDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.responsedto.PageResponseDTO;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ExcelUtil;

@Controller
@RequestMapping(value={"memberCreditsGet"})
public class MemberCreditsGetController {
    private static final Logger log = LoggerFactory.getLogger(MemberCreditsGetController.class);
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private MemberApi memberApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private MemberCreditsTranApi memberCreditsTranApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private OrganizationApi organizationApi;
    @MotanReferer
    private ScoreApi scoreApi;
    @Value(value="${ctscore.organization.code}")
    private String organizationCode;
    @Autowired
    MemberBatchService memberBatchService;

    @RequestMapping(value={"", "index.do", "index.htm"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model) {
        return "member/manager/adOperaCheckScoreGetNew";
    }

    @ResponseBody
    @RequestMapping(value={"list"}, method={RequestMethod.POST})
    public Map list(String username, String phone, String email, String dateStart, String dateEnd, Pageable pageable) throws ParseException {
        long methodStart = System.currentTimeMillis();
        log.info("\u83b7\u8d60\u79ef\u5206\u6570\u636e\u5217\u8868\u67e5\u8be2\u5f00\u59cb...");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        String organizationName = this.organizationApi.findOrganizationNameByOrgCode(this.organizationCode);
        log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - getOrganizationInfoTime) / 1000.0f));
        List members = null;
        List coreUsers = null;
        boolean emptyResult = false;
        long filterTime = System.currentTimeMillis();
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setPage(Integer.valueOf(pageable.getPageNumber()));
        scoreDetailQueryDTO.setPageSize(Integer.valueOf(pageable.getPageSize()));
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_RECEIVE.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(this.organizationCode);
        if (!Lang.isEmpty((Object)dateStart)) {
            dateStart = dateStart.trim();
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(dateStart));
        }
        if (!Lang.isEmpty((Object)dateEnd)) {
            dateEnd = dateEnd.trim();
            dateEnd = dateEnd + " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(dateEnd));
        }
        if (!(Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email))) {
            ScoreAccountDTO scoreAccountDTO;
            ScoreAccountRequestDTO scoreAccountRequestDTO;
            ArrayList<String> scoreAccountIdList = new ArrayList<String>();
            if (!Lang.isEmpty((Object)username)) {
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                coreUsers = this.coreUserApi.findCoreUser(coreUserSerach);
            }
            if (!Lang.isEmpty(members)) {
                for (MemberDto member : members) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (!Lang.isEmpty(coreUsers)) {
                for (CoreUserDto coreUser : coreUsers) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(coreUser.getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (Lang.isEmpty((Object)username)) {
                emptyResult = true;
            }
            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }
        PageResponseDTO scoreIncomeDetaisPage = !emptyResult ? this.scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO) : new PageResponseDTO(Integer.valueOf(0), Long.valueOf(0L), new ArrayList());
        log.info("\u67e5\u8be2\u53c2\u6570\u8fc7\u6ee4\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - filterTime));
        List coreUserIds = scoreIncomeDetaisPage.getContent().stream().map(ScoreIncomeDetailDTO::getScoreAccount).map(ScoreAccountDTO::getUserId).collect(Collectors.toList());
        List scoreRcptCodes = scoreIncomeDetaisPage.getContent().stream().map(ScoreIncomeDetailDTO::getScoreRcptCode).collect(Collectors.toList());
        Map memberDTOMap = this.memberBatchService.findScoreGetData(coreUserIds, scoreRcptCodes);
        ArrayList scoreGetVoList = new ArrayList();
        scoreIncomeDetaisPage.getContent().forEach(scoreIncomeDetailDTO -> {
            if (memberDTOMap.containsKey(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                AdminScoreGetVo scoreGetVo = new AdminScoreGetVo();
                scoreGetVo.setUserName(memberDTO.getRealName());
                scoreGetVo.setOrganizationName(organizationName);
                scoreGetVo.setPhone(memberDTO.getCoreUser().getPhone());
                scoreGetVo.setEmail(memberDTO.getCoreUser().getEmail());
                scoreGetVo.setScore(scoreIncomeDetailDTO.getScoreVal());
                scoreGetVo.setTradeTime(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                scoreGetVo.setScoreRcptCode(scoreIncomeDetailDTO.getScoreRcptCode());
                if (memberDTOMap.containsKey(scoreIncomeDetailDTO.getScoreRcptCode())) {
                    MemberDto targetMemberDTO = (MemberDto)memberDTOMap.get(scoreIncomeDetailDTO.getScoreRcptCode());
                    scoreGetVo.setTargetUserName(targetMemberDTO.getRealName());
                }
                scoreGetVoList.add(scoreGetVo);
            }
        });
        PageImpl scoreGetPage = new PageImpl(scoreGetVoList, pageable, scoreIncomeDetaisPage.getTotalElements().longValue());
        returnMap.put("data", scoreGetPage);
        returnMap.put("totalPages", scoreGetPage.getTotalPages());
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        log.info("\u83b7\u8d60\u79ef\u5206\u6570\u636e\u5217\u8868\u67e5\u8be2\u5b8c\u6210, \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value={"listExport"})
    public void listExport(String username, String phone, String email, String dateStart, String dateEnd, HttpServletResponse response) throws ParseException {
        PageResponseDTO scoreIncomeDetaisPage;
        int totalPage;
        long methodStart = System.currentTimeMillis();
        log.info("\u83b7\u53d6\u79ef\u5206\u8d60\u6570\u636e\u5bfc\u51fa\u5f00\u59cb...");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        String organizationName = this.organizationApi.findOrganizationNameByOrgCode(this.organizationCode);
        log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrganizationInfoTime));
        int page = 0;
        int pageSize = 200;
        ArrayList scoreIncomeDetailList = new ArrayList();
        List members = null;
        List coreUsers = null;
        boolean emptyResult = false;
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_RECEIVE.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(this.organizationCode);
        if (!Lang.isEmpty((Object)dateStart)) {
            dateStart = dateStart.trim();
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(dateStart));
        }
        if (!Lang.isEmpty((Object)dateEnd)) {
            dateEnd = dateEnd.trim();
            dateEnd = dateEnd + " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(dateEnd));
        }
        if (!(Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email))) {
            ScoreAccountDTO scoreAccountDTO;
            ScoreAccountRequestDTO scoreAccountRequestDTO;
            ArrayList<String> scoreAccountIdList = new ArrayList<String>();
            if (!Lang.isEmpty((Object)username)) {
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                coreUsers = this.coreUserApi.findCoreUser(coreUserSerach);
            }
            if (!Lang.isEmpty(members)) {
                for (MemberDto member : members) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (!Lang.isEmpty(coreUsers)) {
                for (CoreUserDto coreUser : coreUsers) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(coreUser.getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (Lang.isEmpty((Object)username)) {
                emptyResult = true;
            }
            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }
        do {
            if (!emptyResult) {
                scoreDetailQueryDTO.setPage(Integer.valueOf(page));
                scoreDetailQueryDTO.setPageSize(Integer.valueOf(pageSize));
                scoreIncomeDetaisPage = this.scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
            } else {
                scoreIncomeDetaisPage = new PageResponseDTO(Integer.valueOf(0), Long.valueOf(0L), new ArrayList());
            }
            scoreIncomeDetailList.addAll(scoreIncomeDetaisPage.getContent());
        } while (++page < (totalPage = scoreIncomeDetaisPage.getTotalPages().intValue()));
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("\u59d3\u540d");
        header.add("\u516c\u53f8");
        header.add("\u624b\u673a");
        header.add("\u90ae\u7bb1");
        header.add("\u83b7\u8d60\u79ef\u5206 (Ct)");
        header.add("\u8d60\u9001\u4eba");
        header.add("\u65e5\u671f");
        rows.add(header);
        List coreUserIds = scoreIncomeDetailList.stream().map(ScoreIncomeDetailDTO::getScoreAccount).map(ScoreAccountDTO::getUserId).collect(Collectors.toList());
        List scoreRcptCodes = scoreIncomeDetailList.stream().map(ScoreIncomeDetailDTO::getScoreRcptCode).collect(Collectors.toList());
        Map memberDTOMap = this.memberBatchService.findScoreGetData(coreUserIds, scoreRcptCodes);
        scoreIncomeDetailList.forEach(scoreExpenseDetail -> {
            if (memberDTOMap.containsKey(scoreExpenseDetail.getScoreAccount().getUserId())) {
                MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreExpenseDetail.getScoreAccount().getUserId());
                String rowTargetUserName = "";
                ArrayList<String> row = new ArrayList<String>();
                row.add(memberDTO.getRealName());
                row.add(organizationName);
                row.add(memberDTO.getCoreUser().getPhone());
                row.add(memberDTO.getCoreUser().getEmail());
                row.add(scoreExpenseDetail.getScoreVal());
                if (memberDTOMap.containsKey(scoreExpenseDetail.getScoreRcptCode())) {
                    MemberDto targetMemberDTO = (MemberDto)memberDTOMap.get(scoreExpenseDetail.getScoreRcptCode());
                    rowTargetUserName = targetMemberDTO.getRealName();
                }
                row.add(rowTargetUserName);
                row.add(dateFormatSec.format(scoreExpenseDetail.getTransaTime()));
                rows.add(row);
            }
        });
        try {
            response.setHeader("Content-disposition", "attachment; filename=MemberCreditsTranGet.xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, (String)"MemberCreditsTranGet").write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u83b7\u8d60\u79ef\u5206\u6570\u636e\u5bfc\u51fa {} \u6761\u6570\u636e, \u8017\u65f6 {} ms", (Object)(rows.size() - 1), (Object)(System.currentTimeMillis() - methodStart));
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET})
    public String detail(String scoreRcptCode, Map model) {
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO = new GetScoreGiveAwayInfoRequestDTO();
        getScoreGiveAwayInfoRequestDTO.setScoreIncomeRcptCode(scoreRcptCode);
        ScoreGiveAwayLogDTO scoreGiveAwayLog = this.scoreApi.getScoreGiveAwayInfo(getScoreGiveAwayInfoRequestDTO);
        CoreUserDto coreUser = this.coreUserApi.findByIdOnly(scoreGiveAwayLog.getReceiveScoreAccount().getUserId());
        CoreUserDto targetCoreUser = this.coreUserApi.findByIdOnly(scoreGiveAwayLog.getGiveAwayScoreAccount().getUserId());
        AdminScoreGetVo scoreGetVo = new AdminScoreGetVo();
        if (!Lang.isEmpty((Object)coreUser)) {
            List members = this.memberApi.findByCoreUserId(coreUser.getId());
            if (members.size() == 1) {
                scoreGetVo.setUserName(((MemberDto)members.get(0)).getRealName());
            }
            scoreGetVo.setPhone(coreUser.getPhone());
            scoreGetVo.setEmail(coreUser.getEmail());
        }
        if (!Lang.isEmpty((Object)targetCoreUser)) {
            List targetsMembers = this.memberApi.findByCoreUserId(targetCoreUser.getId());
            if (targetsMembers.size() == 1) {
                scoreGetVo.setTargetUserName(((MemberDto)targetsMembers.get(0)).getRealName());
            }
            scoreGetVo.setTargetPhone(targetCoreUser.getPhone());
            scoreGetVo.setTargetEmail(targetCoreUser.getEmail());
            scoreGetVo.setOrganizationName(this.organizationApi.findOrganizationById(targetCoreUser.getOrganizationId()).getOrgName());
        }
        scoreGetVo.setTargetScore(scoreGiveAwayLog.getGiveAwayScoreAccount().getIncomeScoreVal().subtract(scoreGiveAwayLog.getGiveAwayScoreAccount().getExpendedScoreVal()).toString());
        scoreGetVo.setScore(scoreGiveAwayLog.getScoreVal().toString());
        scoreGetVo.setScoreMemo(scoreGiveAwayLog.getMemo());
        scoreGetVo.setTradeTime(dateFormatSec.format(scoreGiveAwayLog.getGiveAwayTime()));
        model.put("scoreGetVo", scoreGetVo);
        return "member/manager/adOperaScoreGetDetail";
    }

    @RequestMapping(value={"exportMemberCreditsGet.do"})
    @ResponseBody
    public void exportMemberCreditsGet(String username, String phone, String email, String dateStart, String dateEnd, HttpServletResponse response) throws ParseException {
        if (dateStart != "" && dateEnd != "") {
            dateStart = dateStart + " 00:00:00";
            dateEnd = dateEnd + " 23:59:59";
        }
        Pageable pageable = null;
        Page memberCreditsTranPage = this.memberCreditsTranApi.findByTargetNameAndTargetMobileAndTargetEmailAndSendDateBetween(username, phone, email, dateStart, dateEnd, pageable);
        List memberCreditsTrans = memberCreditsTranPage.getContent();
        ArrayList<MemberCredisGetVo> memberCredisGetVos = new ArrayList<MemberCredisGetVo>();
        for (int i = 0; i < memberCreditsTrans.size(); ++i) {
            MemberCreditsTranDto memberCreditsTran = (MemberCreditsTranDto)memberCreditsTrans.get(i);
            MemberCredisGetVo memberCredisGetVo = new MemberCredisGetVo();
            memberCredisGetVo.setTargetName(memberCreditsTran.getTargetName());
            memberCredisGetVo.setTargetOrganizationName(memberCreditsTran.getTargetOrganizationName());
            memberCredisGetVo.setTargetMobile(memberCreditsTran.getTargetMobile());
            memberCredisGetVo.setTargetEmail(memberCreditsTran.getTargetEmail());
            memberCredisGetVo.setUseScore(memberCreditsTran.getUseScore());
            memberCredisGetVo.setSendName(memberCreditsTran.getSendName());
            memberCredisGetVo.setSendDate(DateUtils.dateToStrLong((Date)memberCreditsTran.getSendDate()));
            memberCredisGetVos.add(memberCredisGetVo);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "MemberCreditsTranGet");
        this.setContentColumnWidth(sheet);
        HSSFCellStyle cellStyle = this.setContentCellStyle(wb);
        this.createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0));
        this.createCellContent(memberCredisGetVos, cellStyle, sheet);
        try {
            response.setHeader("Content-disposition", "attachment; filename=MemberCreditsTranGet.xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"getMemberCreditsGet.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getMemberCreditsGet(String username, String phone, String email, String dateStart, String dateEnd, Pageable pageable) throws ParseException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (dateStart != "" && dateEnd != "") {
            dateStart = dateStart + " 00:00:00";
            dateEnd = dateEnd + " 23:59:59";
        }
        Page memberCreditsTranPage = this.memberCreditsTranApi.findByTargetNameAndTargetMobileAndTargetEmailAndSendDateBetween(username, phone, email, dateStart, dateEnd, pageable);
        returnMap.put("data", memberCreditsTranPage);
        returnMap.put("totalPages", this.getTotalPages((int)memberCreditsTranPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        return returnMap;
    }

    @RequestMapping(value={"memberCreditsGetDetail.do"}, method={RequestMethod.GET})
    public String memberCreditsGetDetail(String memberCreditsTranId, Model model) {
        MemberCreditsTranDto memberCreditsTran = this.memberCreditsTranApi.findMemberCreditsTranById(memberCreditsTranId);
        model.addAttribute("memberCreditsTran", (Object)memberCreditsTran);
        return "member/manager/adOperaScoreGetDetail";
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellValue("\u59d3\u540d");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(1);
        cell.setCellValue("\u516c\u53f8\u540d");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(2);
        cell.setCellValue("\u624b\u673a");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(3);
        cell.setCellValue("\u90ae\u7bb1");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(4);
        cell.setCellValue("\u8d60\u9001\u79ef\u5206");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(5);
        cell.setCellValue("\u8d60\u9001\u4eba");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(6);
        cell.setCellValue("\u65e5\u671f");
        cell.setCellStyle(cellStyle);
    }

    private void createCellContent(List<MemberCredisGetVo> credisGetVos, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < credisGetVos.size(); ++i) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            MemberCredisGetVo credisGetVo = credisGetVos.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisGetVo.getTargetName()));
            theCell = row.createCell(1);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisGetVo.getTargetOrganizationName()));
            theCell = row.createCell(2);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisGetVo.getTargetMobile()));
            theCell = row.createCell(3);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisGetVo.getTargetEmail()));
            theCell = row.createCell(4);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisGetVo.getUseScore().toString()));
            theCell = row.createCell(5);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(credisGetVo.getSendName()));
            theCell = row.createCell(6);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue2((Object)credisGetVo.getSendDate()));
        }
    }

    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);
        sheet.setColumnWidth(4, 5000);
        sheet.setColumnWidth(5, 5000);
        sheet.setColumnWidth(6, 10000);
    }

    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    private String setContentCellValue(String value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value;
    }

    private String setContentCellValue2(Object value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value.toString();
    }
}

