/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.definition.PrepaidDepositChangeType;
import cms.api.dto.OrganizationBatchOperateLogDTO;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.vo.AdminImportVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.CoreUserApi;
import member.api.LoginApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.CoreUserSerachVo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import score.api.ScoreApi;
import score.api.UniqueSequenceNoApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import utils.Lang;
import utils.excel.ExcelUtil;
import utils.rpc.motan.ApiResponseVo;

@Controller
@RequestMapping(value={"memberImport"})
public class MemberImportController {
    private static final Logger log = LoggerFactory.getLogger(MemberImportController.class);
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberApi memberApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberCreditsTranApi memberCreditsTranApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrganizationApi organizationApi;
    @Autowired
    MemberBatchService memberBatchService;
    @Autowired
    MemberLoginService memberLoginService;
    @MotanReferer
    LoginApi loginApi;
    @Value(value="${ctscore.organization.code}")
    String organizationCode;
    @Value(value="${batchImportFolder}")
    String batchImportFolder;
    @Value(value="${show.updatepassword}")
    private Boolean showUpdatepassword;
    @MotanReferer
    ScoreApi scoreApi;
    @MotanReferer
    UniqueSequenceNoApi uniqueSequenceNoApi;

    @RequestMapping(value={"", "index.do", "index.htm"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, String username, String phone, String email) {
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        model.addAttribute("username", (Object)username);
        model.addAttribute("phone", (Object)phone);
        model.addAttribute("email", (Object)email);
        model.addAttribute("orgScore", (Object)this.organizationApi.findOrganizationById(coreUser.getOrganizationId()).getOrgScore());
        return "member/administrators/addMemberImportInfo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"batchImport"}, method={RequestMethod.POST})
    public String batchImport(RedirectAttributes attributes, @RequestParam MultipartFile[] infoExcel, HttpServletRequest request) throws IOException {
        Map returnMap = new HashMap();
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        for (MultipartFile excel : infoExcel) {
            ArrayList<String> errorList;
            String errorMessage;
            boolean error;
            block11: {
                if (excel.isEmpty()) continue;
                error = false;
                errorMessage = null;
                try {
                    returnMap = this.memberCreditsTranApi.batchImport(organization.getId(), excel.getInputStream(), 0);
                    attributes.addFlashAttribute("isImportSuccess", (Object)true);
                    attributes.addFlashAttribute("isSuccess", returnMap.get("isSuccess"));
                    attributes.addFlashAttribute("message", returnMap.get("message"));
                    attributes.addFlashAttribute("successCount", returnMap.get("successCount"));
                    attributes.addFlashAttribute("failCount", returnMap.get("failCount"));
                    attributes.addFlashAttribute("failRowCount", returnMap.get("failRowCount"));
                    attributes.addFlashAttribute("successRowCount", returnMap.get("successRowCount"));
                    attributes.addFlashAttribute("scoreCount", returnMap.get("scoreCount"));
                    if (!((Boolean)returnMap.get("isSuccess")).booleanValue()) {
                        error = true;
                    }
                    errorList = new ArrayList();
                    if (!returnMap.containsKey("failRowCount")) break block11;
                    errorList.addAll((List)returnMap.get("failRowCount"));
                }
                catch (Exception e) {
                    error = true;
                    errorMessage = e.getMessage();
                    if (Lang.isEmpty((Object)errorMessage)) {
                        errorMessage = e.toString();
                    }
                    log.error("\u5bfc\u5165\u8d26\u53f7\u5f02\u5e38", (Throwable)e);
                    attributes.addFlashAttribute("isImportSuccess", (Object)true);
                    attributes.addFlashAttribute("isSuccess", (Object)false);
                    attributes.addFlashAttribute("message", (Object)errorMessage);
                    continue;
                }
                finally {
                    errorList = new ArrayList<String>();
                    if (returnMap.containsKey("failRowCount")) {
                        errorList.addAll((List)returnMap.get("failRowCount"));
                    }
                    if (!Lang.isEmpty((Object)errorMessage)) {
                        errorList.add(errorMessage);
                        attributes.addFlashAttribute("message", (Object)"\u5bfc\u5165\u5931\u8d25");
                        attributes.addFlashAttribute("failRowCount", errorList);
                    }
                    this.logBatchImport(excel, errorList, error);
                }
            }
            if (!Lang.isEmpty((Object)errorMessage)) {
                errorList.add(errorMessage);
                attributes.addFlashAttribute("message", (Object)"\u5bfc\u5165\u5931\u8d25");
                attributes.addFlashAttribute("failRowCount", errorList);
            }
            this.logBatchImport(excel, errorList, error);
        }
        return "redirect:uploadExcel.do";
    }

    private void logBatchImport(MultipartFile multipartFile, List<String> failList, boolean error) {
        try {
            InputStream inputStream = multipartFile.getInputStream();
            OrganizationBatchOperateLogDTO fileLog = new OrganizationBatchOperateLogDTO();
            fileLog.setBatchNo(UUID.randomUUID().toString());
            SimpleDateFormat format = new SimpleDateFormat("YYYY_MM_DD_HH_mm_ss");
            fileLog.setFilePath(this.batchImportFolder + format.format(new Date()) + "_" + fileLog.getBatchNo() + ".xls");
            ArrayList rows = new ArrayList();
            if (!Lang.isEmpty(failList)) {
                for (int i = 0; i < failList.size(); ++i) {
                    ArrayList<String> cell = new ArrayList<String>();
                    cell.add(failList.get(i));
                    rows.add(cell);
                }
            }
            ExcelUtil.readAndWriteData((InputStream)inputStream, (String)fileLog.getFilePath(), rows, (String)"\u9519\u8bef\u4fe1\u606f");
            fileLog.setOperateStatus("success");
            fileLog.setOperateType(PrepaidDepositChangeType.add.getBusinessCode());
            fileLog.setOperateResult(PrepaidDepositChangeType.add.getBusinessSource() + (error ? "\u5931\u8d25" : "\u6210\u529f"));
            fileLog.setOrganizationCode(this.organizationCode);
            ApiResponseVo apiResponseVo = this.organizationApi.saveOrganizationBatchOperateLog(fileLog);
            log.info("batchImportLog:" + apiResponseVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"uploadExcel.do"})
    public String uploadExcel(HttpServletRequest request, Model model) {
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        model.addAttribute("orgScore", (Object)this.organizationApi.findOrganizationById(coreUser.getOrganizationId()).getOrgScore());
        return "member/administrators/addMemberImportInfo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"listExport"})
    public void listExport(String username, String phone, String email, String startTime, String endTime, HttpServletResponse response, HttpServletRequest request) throws ParseException {
        Object scoreAccountRequestDTO;
        long listExpotTime = System.currentTimeMillis();
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long getOrganizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        String organizationName = this.organizationApi.findOrganizationNameByOrgCode(this.organizationCode);
        log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - getOrganizationTime) / 1000.0f));
        int page = 0;
        int pageSize = 500;
        Vector scoreIncomeDetailList = new Vector();
        List coreUserList = null;
        List members = null;
        boolean emptyResult = false;
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(this.organizationCode);
        if (!Lang.isEmpty((Object)startTime)) {
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(startTime));
        }
        if (!Lang.isEmpty((Object)endTime)) {
            endTime = endTime + " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(endTime));
        }
        if (!(Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email))) {
            ScoreAccountDTO scoreAccountDTO;
            ArrayList<String> scoreAccountIdList = new ArrayList<String>();
            if (!Lang.isEmpty((Object)username)) {
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                long findCoreUserTimer = System.currentTimeMillis();
                coreUserList = this.coreUserApi.findCoreUser(coreUserSerach);
                log.info("\u6761\u4ef6\u5904\u7406\u67e5\u8be2 CoreUserList \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - findCoreUserTimer) / 1000.0f));
            }
            if (!Lang.isEmpty(members)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (MemberDto member : members) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("\u6761\u4ef6\u5904\u7406\u67e5\u8be2 scoreAccountDTO \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - queryScoreAccountTimer) / 1000.0f));
            } else if (!Lang.isEmpty(coreUserList)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (Object cu : coreUserList) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(cu.getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("\u6761\u4ef6\u5904\u7406\u67e5\u8be2 scoreAccountDTO \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - queryScoreAccountTimer) / 1000.0f));
            } else if (Lang.isEmpty((Object)username)) {
                emptyResult = true;
            }
            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }
        long queryScoreIncomeDetaisTime = System.currentTimeMillis();
        if (!emptyResult) {
            scoreDetailQueryDTO.setPage(Integer.valueOf(0));
            scoreDetailQueryDTO.setPageSize(Integer.valueOf(1));
            PageResponseDTO pageForCount = this.scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
            Long totalCount = pageForCount.getTotalElements();
            Long totalPage = totalCount / (long)pageSize;
            if (totalCount % (long)pageSize > 0L) {
                Object cu;
                cu = totalPage;
                totalPage = totalPage + 1L;
                scoreAccountRequestDTO = totalPage;
            }
            log.info("\u5bfc\u51fa\u6570\u636e\u91cf {} \u6761, \u5355\u6279\u6b21\u67e5\u8be2\u6570\u91cf {} \u6761, \u9700\u67e5\u8be2 {} \u6b21", new Object[]{totalCount, pageSize, totalPage});
            log.info("\u5f00\u59cb\u591a\u7ebf\u7a0b\u67e5\u8be2\u79ef\u5206\u6388\u4e88\u6570\u636e...");
            ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
            try {
                threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
                threadPoolTaskExecutor.setCorePoolSize(10);
                threadPoolTaskExecutor.setMaxPoolSize(100);
                threadPoolTaskExecutor.setQueueCapacity(2000);
                threadPoolTaskExecutor.setKeepAliveSeconds(60);
                threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
                threadPoolTaskExecutor.initialize();
                CountDownLatch countDownLatch = new CountDownLatch(totalPage.intValue());
                while ((long)page < totalPage) {
                    ScoreDetailQueryDTO scoreDetailQueryDTOTemp = new ScoreDetailQueryDTO();
                    scoreDetailQueryDTOTemp.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
                    scoreDetailQueryDTOTemp.setOrganizationCode(this.organizationCode);
                    if (!Lang.isEmpty((Object)startTime)) {
                        scoreDetailQueryDTOTemp.setStartDate(dateFormatDay.parse(startTime));
                    }
                    if (!Lang.isEmpty((Object)endTime)) {
                        scoreDetailQueryDTOTemp.setEndDate(dateFormatSec.parse(endTime));
                    }
                    scoreDetailQueryDTOTemp.setPage(Integer.valueOf(page));
                    scoreDetailQueryDTOTemp.setPageSize(Integer.valueOf(pageSize));
                    threadPoolTaskExecutor.execute(() -> {
                        try {
                            PageResponseDTO scoreIncomeDetailDTOPage = this.scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTOTemp);
                            scoreIncomeDetailList.addAll(scoreIncomeDetailDTOPage.getContent());
                        }
                        catch (Exception e) {
                            log.error("\u5206\u9875\u67e5\u8be2\u79ef\u5206\u6388\u4e88\u6570\u636e\u5f02\u5e38", (Throwable)e);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                    ++page;
                }
                countDownLatch.await();
            }
            catch (Exception e) {
                log.error("\u591a\u7ebf\u7a0b\u5206\u9875\u67e5\u8be2\u79ef\u5206\u6388\u4e88\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (!Lang.isEmpty((Object)threadPoolTaskExecutor)) {
                    threadPoolTaskExecutor.shutdown();
                }
            }
            scoreIncomeDetailList.sort((scoreIncomeDetail1, scoreIncomeDetail2) -> {
                if (scoreIncomeDetail1.getTransaTime() == null) {
                    return 1;
                }
                if (scoreIncomeDetail2.getTransaTime() == null) {
                    return -1;
                }
                return scoreIncomeDetail2.getTransaTime().compareTo(scoreIncomeDetail1.getTransaTime());
            });
        }
        log.info("\u5206\u9875\u83b7\u53d6\u5168\u91cf\u79ef\u5206\u6388\u4e88\u6570\u636e\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - queryScoreIncomeDetaisTime) / 1000.0f));
        Map memberDTOMap = new HashMap(1);
        ArrayList coreUserIds = new ArrayList();
        if (!Lang.isEmpty((Object)coreUserList)) {
            coreUserList.forEach(coreUserDto -> {
                if (!Lang.isEmpty((Object)coreUserDto.getId()) && !coreUserIds.contains(coreUserDto.getId())) {
                    coreUserIds.add(coreUserDto.getId());
                }
            });
        } else {
            scoreIncomeDetailList.forEach(scoreIncomeDetailDTO -> {
                if (!Lang.isEmpty((Object)scoreIncomeDetailDTO.getScoreAccount().getUserId()) && !coreUserIds.contains(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                    coreUserIds.add(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                }
            });
        }
        if (!Lang.isEmpty(coreUserIds)) {
            long findMembersByCoreUserIdsTime = System.currentTimeMillis();
            memberDTOMap = this.memberBatchService.findMembersByCoreUserIds(coreUserIds);
            log.info("coreUserIds size {} \u6279\u91cf\u83b7\u53d6 memberDTO \u8017\u65f6 {} \u79d2", (Object)coreUserIds.size(), (Object)Float.valueOf((float)(System.currentTimeMillis() - findMembersByCoreUserIdsTime) / 1000.0f));
        }
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("\u59d3\u540d");
        header.add("\u516c\u53f8");
        header.add("\u624b\u673a\u53f7");
        header.add("\u90ae\u7bb1");
        header.add("\u8eab\u4efd\u8bc1");
        header.add("\u5bfc\u5165\u65f6\u95f4");
        header.add("\u79ef\u5206 (Ct)");
        header.add("\u79ef\u5206\u53d1\u653e\u539f\u56e0");
        rows.add(header);
        block10: for (ScoreIncomeDetailDTO scoreIncomeDetailDTO2 : scoreIncomeDetailList) {
            if (!Lang.isEmpty((Object)members)) {
                for (MemberDto member : members) {
                    CoreUserDto coreUser = member.getCoreUser();
                    if (!scoreIncomeDetailDTO2.getScoreAccount().getUserId().equals(coreUser.getId())) continue;
                    ArrayList<String> row = new ArrayList<String>();
                    row.add(member.getRealName());
                    row.add(organizationName);
                    row.add(coreUser.getPhone());
                    row.add(coreUser.getEmail());
                    row.add(coreUser.getIdCard());
                    row.add(dateFormatSec.format(scoreIncomeDetailDTO2.getTransaTime()));
                    row.add(scoreIncomeDetailDTO2.getScoreVal());
                    row.add(scoreIncomeDetailDTO2.getMemo());
                    rows.add(row);
                    continue block10;
                }
                continue;
            }
            if (!Lang.isEmpty((Object)coreUserList)) {
                for (CoreUserDto coreUser : coreUserList) {
                    if (!coreUser.getId().equals(scoreIncomeDetailDTO2.getScoreAccount().getUserId())) continue;
                    ArrayList<String> row = new ArrayList<String>();
                    String rowUserName = "";
                    if (memberDTOMap.containsKey(coreUser.getId())) {
                        MemberDto member = (MemberDto)memberDTOMap.get(coreUser.getId());
                        rowUserName = member.getRealName();
                    }
                    row.add(rowUserName);
                    row.add(organizationName);
                    row.add(coreUser.getPhone());
                    row.add(coreUser.getEmail());
                    row.add(coreUser.getIdCard());
                    row.add(dateFormatSec.format(scoreIncomeDetailDTO2.getTransaTime()));
                    row.add(scoreIncomeDetailDTO2.getScoreVal());
                    row.add(scoreIncomeDetailDTO2.getMemo());
                    rows.add(row);
                    continue block10;
                }
                continue;
            }
            ArrayList<String> row = new ArrayList<String>();
            String rowUserName = "";
            String rowPhone = "";
            String rowEmail = "";
            String rowIdCard = "";
            if (!Lang.isEmpty((Object)scoreIncomeDetailDTO2.getScoreAccount().getUserId()) && memberDTOMap.containsKey(scoreIncomeDetailDTO2.getScoreAccount().getUserId())) {
                MemberDto member = (MemberDto)memberDTOMap.get(scoreIncomeDetailDTO2.getScoreAccount().getUserId());
                rowUserName = member.getRealName();
                rowPhone = member.getCoreUser().getPhone();
                rowEmail = member.getCoreUser().getEmail();
                rowIdCard = member.getCoreUser().getIdCard();
            }
            row.add(rowUserName);
            row.add(organizationName);
            row.add(rowPhone);
            row.add(rowEmail);
            row.add(rowIdCard);
            row.add(dateFormatSec.format(scoreIncomeDetailDTO2.getTransaTime()));
            row.add(scoreIncomeDetailDTO2.getScoreVal());
            row.add(scoreIncomeDetailDTO2.getMemo());
            rows.add(row);
        }
        try {
            response.setHeader("Content-disposition", "attachment; filename=Member.xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, (String)"Member").write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Error", (Throwable)e);
        }
        log.info("\u79ef\u5206\u6388\u4e88\u5bfc\u51fa {} \u6761\u6570\u636e, \u8017\u65f6 {} \u79d2", (Object)(rows.size() - 1), (Object)Float.valueOf((float)(System.currentTimeMillis() - listExpotTime) / 1000.0f));
    }

    @ResponseBody
    @RequestMapping(value={"list"}, method={RequestMethod.POST})
    public Map list(String username, String phone, String email, String startTime, String endTime, Pageable pageable, HttpServletRequest request) throws ParseException {
        PageResponseDTO scoreIncomeDetailDTOPage;
        Long timeFlag = System.currentTimeMillis();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long getOrganizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        String organizationName = this.organizationApi.findOrganizationNameByOrgCode(this.organizationCode);
        log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - getOrganizationTime) / 1000.0f));
        List coreUserList = null;
        List members = null;
        boolean emptyResult = false;
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setPage(Integer.valueOf(pageable.getPageNumber()));
        scoreDetailQueryDTO.setPageSize(Integer.valueOf(pageable.getPageSize()));
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(this.organizationCode);
        if (!Lang.isEmpty((Object)startTime)) {
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(startTime));
        }
        if (!Lang.isEmpty((Object)endTime)) {
            endTime = endTime + " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(endTime));
        }
        if (!(Lang.isEmpty((Object)username) && Lang.isEmpty((Object)phone) && Lang.isEmpty((Object)email))) {
            Object scoreAccountDTO;
            ScoreAccountRequestDTO scoreAccountRequestDTO;
            ArrayList<String> scoreAccountIdList = new ArrayList<String>();
            if (!Lang.isEmpty((Object)username)) {
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                long findCoreUserTimer = System.currentTimeMillis();
                coreUserList = this.coreUserApi.findCoreUser(coreUserSerach);
                log.info("\u6761\u4ef6\u5904\u7406\u67e5\u8be2 CoreUserList \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - findCoreUserTimer) / 1000.0f));
            }
            if (!Lang.isEmpty(members)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (MemberDto member : members) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("\u6761\u4ef6\u5904\u7406\u67e5\u8be2 scoreAccountDTO \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - queryScoreAccountTimer) / 1000.0f));
            } else if (!Lang.isEmpty(coreUserList)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (Object cu : coreUserList) {
                    scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
                    scoreAccountRequestDTO.setUserId(cu.getId());
                    if (!Lang.isEmpty((Object)phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("\u6761\u4ef6\u5904\u7406\u67e5\u8be2 scoreAccountDTO \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - queryScoreAccountTimer) / 1000.0f));
            } else if (Lang.isEmpty((Object)username)) {
                emptyResult = true;
            }
            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }
        if (!emptyResult) {
            long queryScoreIncomeDetaisTimer = System.currentTimeMillis();
            scoreIncomeDetailDTOPage = this.scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
            log.info("\u5206\u9875\u67e5\u8be2\u67e5\u8be2 scoreIncomeDetailDTOPage \u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - queryScoreIncomeDetaisTimer) / 1000.0f));
        } else {
            scoreIncomeDetailDTOPage = new PageResponseDTO(Integer.valueOf(0), Long.valueOf(0L), new ArrayList());
        }
        Map memberDTOMap = new HashMap(1);
        ArrayList coreUserIds = new ArrayList();
        if (!Lang.isEmpty((Object)coreUserList)) {
            coreUserList.forEach(coreUserDto -> {
                if (!Lang.isEmpty((Object)coreUserDto.getId()) && !coreUserIds.contains(coreUserDto.getId())) {
                    coreUserIds.add(coreUserDto.getId());
                }
            });
        } else {
            scoreIncomeDetailDTOPage.getContent().forEach(scoreIncomeDetailDTO -> {
                if (!Lang.isEmpty((Object)scoreIncomeDetailDTO.getScoreAccount().getUserId()) && !coreUserIds.contains(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                    coreUserIds.add(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                }
            });
        }
        if (!Lang.isEmpty(coreUserIds)) {
            memberDTOMap = this.memberBatchService.findMembersByCoreUserIds(coreUserIds);
        }
        ArrayList<AdminImportVo> adminImportListVoList = new ArrayList<AdminImportVo>();
        block2: for (ScoreIncomeDetailDTO scoreIncomeDetailDTO2 : scoreIncomeDetailDTOPage.getContent()) {
            if (!Lang.isEmpty((Object)members)) {
                for (MemberDto member : members) {
                    CoreUserDto coreUser = member.getCoreUser();
                    if (!scoreIncomeDetailDTO2.getScoreAccount().getUserId().equals(coreUser.getId())) continue;
                    AdminImportVo adminImportVo = new AdminImportVo();
                    adminImportVo.setEmail(coreUser.getEmail());
                    adminImportVo.setPhone(coreUser.getPhone());
                    adminImportVo.setTransaTime(dateFormatSec.format(scoreIncomeDetailDTO2.getTransaTime()));
                    adminImportVo.setOrganizationName(organizationName);
                    adminImportVo.setScore(scoreIncomeDetailDTO2.getScoreVal());
                    adminImportVo.setScoreReason(scoreIncomeDetailDTO2.getMemo());
                    adminImportVo.setAdmin(member.getAdmin());
                    adminImportVo.setMemberId(member.getId());
                    adminImportVo.setUserName(member.getRealName());
                    adminImportListVoList.add(adminImportVo);
                    continue block2;
                }
                continue;
            }
            if (!Lang.isEmpty((Object)coreUserList)) {
                for (CoreUserDto coreUser : coreUserList) {
                    if (!coreUser.getId().equals(scoreIncomeDetailDTO2.getScoreAccount().getUserId())) continue;
                    AdminImportVo adminImportVo = new AdminImportVo();
                    adminImportVo.setEmail(coreUser.getEmail());
                    adminImportVo.setPhone(coreUser.getPhone());
                    adminImportVo.setTransaTime(dateFormatSec.format(scoreIncomeDetailDTO2.getTransaTime()));
                    adminImportVo.setOrganizationName(organizationName);
                    adminImportVo.setScore(scoreIncomeDetailDTO2.getScoreVal());
                    adminImportVo.setScoreReason(scoreIncomeDetailDTO2.getMemo());
                    if (memberDTOMap.containsKey(coreUser.getId())) {
                        MemberDto member = (MemberDto)memberDTOMap.get(coreUser.getId());
                        adminImportVo.setAdmin(member.getAdmin());
                        adminImportVo.setMemberId(member.getId());
                        adminImportVo.setUserName(member.getRealName());
                    }
                    adminImportListVoList.add(adminImportVo);
                    continue block2;
                }
                continue;
            }
            AdminImportVo adminImportVo = new AdminImportVo();
            adminImportVo.setTransaTime(dateFormatSec.format(scoreIncomeDetailDTO2.getTransaTime()));
            adminImportVo.setOrganizationName(organizationName);
            adminImportVo.setScore(scoreIncomeDetailDTO2.getScoreVal());
            adminImportVo.setScoreReason(scoreIncomeDetailDTO2.getMemo());
            String userId = scoreIncomeDetailDTO2.getScoreAccount().getUserId();
            if (!Lang.isEmpty((Object)userId) && memberDTOMap.containsKey(userId)) {
                MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreIncomeDetailDTO2.getScoreAccount().getUserId());
                adminImportVo.setEmail(memberDTO.getCoreUser().getEmail());
                adminImportVo.setPhone(memberDTO.getCoreUser().getPhone());
                adminImportVo.setAdmin(memberDTO.getAdmin());
                adminImportVo.setMemberId(memberDTO.getId());
                adminImportVo.setUserName(memberDTO.getRealName());
            }
            adminImportListVoList.add(adminImportVo);
        }
        PageImpl adminImportVoPage = new PageImpl(adminImportListVoList, pageable, (long)adminImportListVoList.size());
        returnMap.put("data", adminImportVoPage);
        returnMap.put("orgName", organizationName);
        returnMap.put("totalPages", scoreIncomeDetailDTOPage.getTotalPages());
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        log.info("\u79ef\u5206\u6388\u4e88\u67e5\u8be2\u8017\u65f6 {} \u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - timeFlag) / 1000.0f));
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value={"getMember.do"}, method={RequestMethod.POST})
    public Map getMember(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        CoreUserDto coreUserExp = new CoreUserDto(CoreUserDto.USER_TYPE_MEMBER, organization.getId());
        if (!Lang.isEmpty((Object)username)) {
            coreUserExp.setUsername(username.trim());
        }
        if (!Lang.isEmpty((Object)phone)) {
            coreUserExp.setPhone(phone.trim());
        }
        if (!Lang.isEmpty((Object)email)) {
            coreUserExp.setEmail(email.trim());
        }
        coreUserExp.setErrCount(null);
        coreUserExp.setLoginCount(null);
        coreUserExp.setDisabled(null);
        Page coreUsers = this.coreUserApi.findByExample(coreUserExp, pageable);
        List members = this.memberApi.findByUsers(coreUsers.getContent());
        PageImpl memberPage = new PageImpl(members, pageable, coreUsers.getTotalElements());
        returnMap.put("data", memberPage);
        returnMap.put("orgName", organization.getOrgName());
        returnMap.put("totalPages", this.getTotalPages((int)memberPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        return returnMap;
    }

    @RequestMapping(value={"memberDetail.do"}, method={RequestMethod.GET})
    public String memberDetail(String memberId, String username, String phone, String email, HttpServletRequest request, Model model) {
        MemberDto member = this.memberApi.findMemberById(memberId);
        CoreUserDto coreUser = this.memberLoginService.findById(member.getCoreUser().getId());
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
        scoreAccountRequestDTO.setOrganizationCode(this.organizationCode);
        scoreAccountRequestDTO.setUserId(coreUser.getId());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        AdminImportVo adminImportVo = new AdminImportVo();
        adminImportVo.setUserName(coreUser.getUsername());
        adminImportVo.setPhone(coreUser.getPhone());
        adminImportVo.setEmail(coreUser.getEmail());
        adminImportVo.setOrganizationName(organization.getOrgName());
        adminImportVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
        adminImportVo.setIdCard(coreUser.getIdCard());
        ArrayList<String> scoreAccountIdList = new ArrayList<String>();
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreAccountIdList.add(scoreAccountDTO.getId());
        scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        PageResponseDTO scoreIncomeDetailPage = this.scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
        Iterator iterator = scoreIncomeDetailPage.getContent().iterator();
        if (iterator.hasNext()) {
            ScoreIncomeDetailDTO scoreIncomeDetailDTO = (ScoreIncomeDetailDTO)iterator.next();
            adminImportVo.setTransaTime(dateFormat.format(scoreIncomeDetailDTO.getTransaTime()));
            adminImportVo.setScoreReason(scoreIncomeDetailDTO.getMemo());
        }
        model.addAttribute("adminImportVo", (Object)adminImportVo);
        return "member/administrators/adOperaInfoCheck";
    }

    @RequestMapping(value={"memberDelete.do"}, method={RequestMethod.GET})
    public String memberDelete(String memberId, Integer numberOfElements, Integer currentPage, String username, String phone, String email, Model model) {
        MemberDto member = this.memberApi.findMemberById(memberId);
        if (Lang.isEmpty((Object)currentPage)) {
            currentPage = 1;
        } else if (!(numberOfElements != 1 || Lang.isEmpty((Object)member) || Lang.isEmpty((Object)member.getCoreUser()) || member.getCoreUser().getIsDelete().booleanValue())) {
            currentPage = 1;
        }
        model.addAttribute("currentPage", (Object)currentPage);
        if (!Lang.isEmpty((Object)username)) {
            model.addAttribute("username", (Object)username);
        }
        if (!Lang.isEmpty((Object)phone)) {
            model.addAttribute("phone", (Object)phone);
        }
        if (!Lang.isEmpty((Object)email)) {
            model.addAttribute("email", (Object)email);
        }
        if (!(Lang.isEmpty((Object)member) || Lang.isEmpty((Object)member.getCoreUser()) || member.getCoreUser().getIsDelete().booleanValue())) {
            String organizationId = member.getCoreUser().getOrganizationId();
            CoreUserDto coreUser = member.getCoreUser();
            this.coreUserApi.deleteCoreUserById(coreUser.getId());
            model.addAttribute("isDeleteSuccess", (Object)true);
            model.addAttribute("orgScore", (Object)this.organizationApi.findOrganizationById(organizationId).getOrgScore());
            return "member/manager/adOperaCheckScoreView";
        }
        model.addAttribute("isDeleteSuccess", (Object)false);
        return "member/manager/adOperaCheckScoreView";
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u59d3\u540d");
        cell = row.createCell(1);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u516c\u53f8\u540d");
        cell = row.createCell(2);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u624b\u673a");
        cell = row.createCell(3);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u90ae\u7bb1");
        cell = row.createCell(4);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u8eab\u4efd\u8bc1");
        cell = row.createCell(5);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u79ef\u5206");
        cell = row.createCell(6);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u79ef\u5206\u53d1\u653e\u539f\u56e0");
    }

    private void createCellContent(List<AdminImportVo> adminImportVoList, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < adminImportVoList.size(); ++i) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            AdminImportVo AdminImportVo2 = adminImportVoList.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getUserName()));
            theCell = row.createCell(1);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getOrganizationName()));
            theCell = row.createCell(2);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getPhone()));
            theCell = row.createCell(3);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getEmail()));
            theCell = row.createCell(4);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getIdCard()));
            theCell = row.createCell(5);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getScore()));
            theCell = row.createCell(6);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(AdminImportVo2.getScoreReason()));
        }
    }

    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);
        sheet.setColumnWidth(4, 5000);
        sheet.setColumnWidth(5, 5000);
        sheet.setColumnWidth(6, 8000);
    }

    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    private String setContentCellValue(String value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value;
    }

    @RequestMapping(value={"adminSubScore.do"}, method={RequestMethod.GET})
    public String adminSubScore() {
        return "member/administrators/subScore";
    }

    @RequestMapping(value={"/passwordAdmin.html"})
    public String passwordAdmin(Map model) {
        if (!this.showUpdatepassword.booleanValue()) {
            return "redirect:score";
        }
        model.put("showUpdatepassword", this.showUpdatepassword);
        return "member/administrators/updatePassword";
    }

    @RequestMapping(value={"/updatepassword.json"})
    @ResponseBody
    public Map update(HttpServletRequest request, String password, String email) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (email.indexOf("CTYSP123.com") <= 0) {
            returnMap.put("result", "\u4fee\u6539\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u7684\u90ae\u7bb1\u7528\u6237");
            return returnMap;
        }
        if (!this.showUpdatepassword.booleanValue()) {
            returnMap.put("result", "false");
            return returnMap;
        }
        String newPassword = this.loginApi.encryptPasswd(password);
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
        CoreUserDto coreUser = this.coreUserApi.findByPhoneOrEmail(email, organization.getId());
        if (coreUser == null) {
            returnMap.put("result", "\u4fee\u6539\u5931\u8d25\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u7528\u6237");
            return returnMap;
        }
        coreUser.setPassword(newPassword);
        this.coreUserApi.saveCoreUser(coreUser);
        returnMap.put("result", "success");
        return returnMap;
    }

    @RequestMapping(value={"subScore"}, method={RequestMethod.POST})
    @ResponseBody
    public Map subScore(String memberId, String score) {
        if (Integer.parseInt(score) < 0) {
            return null;
        }
        MemberDto member = this.memberApi.findMemberById(memberId);
        BigDecimal scoreVal = new BigDecimal(score);
        CoreUserDto coreUser = member.getCoreUser();
        ScoreAccountRequestDTO queryScoreAccount = new ScoreAccountRequestDTO();
        queryScoreAccount.setUserId(coreUser.getId());
        queryScoreAccount.setOrganizationCode(this.organizationCode);
        queryScoreAccount.setEmail(coreUser.getEmail());
        queryScoreAccount.setPhone(coreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(queryScoreAccount);
        ScoreExpenseDetailRequestDTO request = new ScoreExpenseDetailRequestDTO();
        request.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_ADMIN_DEDUCTION.getBusinessCode());
        request.setBusiSource(ScoreBusinessType.BUSI_EXPENSE_ADMIN_DEDUCTION.getBusinessSource());
        request.setMemo("\u7ba1\u7406\u5458\u6263\u51cf");
        request.setScoreAccountId(scoreAccountDTO.getId());
        request.setScoreVal(scoreVal);
        request.setTransactionNo(this.uniqueSequenceNoApi.generateUniqueSequenceNo());
        request.setTransaTime(new Date());
        TransactionResponseDTO transactionResponseDTO = this.scoreApi.expenseScore(request);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if ("success".equals(transactionResponseDTO.getStatus())) {
            returnMap.put("status", "success");
            returnMap.put("message", "\u79ef\u5206\u6263\u51cf\u6210\u529f");
            return returnMap;
        }
        returnMap.put("status", "error");
        returnMap.put("message", "\u79ef\u5206\u6263\u51cf\u5931\u8d25");
        return returnMap;
    }
}

