/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

@Controller
public class MemberIndexController {
    static final Logger logger = LoggerFactory.getLogger(MemberIndexController.class);
    @Autowired
    MemberLoginService memberLoginService;
    @Autowired
    UserCenterService userCenterService;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    private OrganizationApi organizationApi;

    @RequestMapping(value={"members/index", "members/index.html"})
    public String index(HttpServletRequest request, HttpServletResponse response, Map model) {
        logger.info("\u4f1a\u5458\u4e2d\u5fc3\u9ed8\u8ba4\u9875\u9762");
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        coreUser.setPassword(null);
        coreUser.setOld_password(null);
        model.put("user", coreUser);
        model.put("member", member);
        OrganizationDto organization = null;
        if (!Lang.isEmpty((Object)coreUser)) {
            organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        }
        if (!Lang.isEmpty(organization)) {
            model.put("companyName", organization.getOrgName());
        }
        String memberId = member.getId();
        List memberAddressList = this.userCenterService.getMyMemberAddress(memberId);
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<MemberAddressDto> list0 = new ArrayList<MemberAddressDto>();
        if (!Lang.isEmpty((Object)memberAddressList)) {
            for (MemberAddressDto memberAddress : memberAddressList) {
                if (!Lang.isEmpty((Object)memberAddress.getIsDefault()) && memberAddress.getIsDefault().booleanValue()) {
                    list.add(memberAddress);
                    continue;
                }
                list0.add(memberAddress);
            }
        }
        list.addAll(list0);
        model.put("addressList", list);
        return "member/index";
    }

    @RequestMapping(value={"address/setDefault/{addressId}"}, method={RequestMethod.GET})
    public String setDefaultAddress(HttpServletRequest request, @PathVariable(value="addressId") String addressId) {
        logger.info("\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740...");
        Object memberIdObj = request.getSession().getAttribute("member_id_itaiping");
        String memberId = memberIdObj.toString();
        if (Lang.isEmpty((Object)addressId)) {
            return "redirect:/member/index";
        }
        try {
            MemberAddressDto memberAddress = this.userCenterService.setDefaultAddress(memberId, addressId);
            if (Lang.isEmpty((Object)memberAddress)) {
                return "redirect:/member/index";
            }
        }
        catch (Exception ex) {
            logger.error("ex:" + ex);
        }
        return "redirect:/members/index";
    }

    @RequestMapping(value={"address/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject deleteAddress(HttpServletRequest request, String addressId) {
        logger.info("\u5220\u9664\u9ed8\u8ba4\u5730\u5740...");
        JSONObject jsonObject = new JSONObject();
        if (Lang.isEmpty((Object)addressId)) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"addressId\u4e3a\u7a7a");
            return jsonObject;
        }
        Boolean result = this.userCenterService.deleteAddressById(addressId);
        if (!result.booleanValue()) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"addressId\u4e3a\u7a7a");
        }
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"\u5220\u9664\u5730\u5740\u6210\u529f");
        return jsonObject;
    }

    @RequestMapping(value={"address/add"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject addAddress(HttpServletRequest request, MemberAddressDto address) {
        logger.info("\u6dfb\u52a0\u5730\u5740...");
        JSONObject jsonObject = new JSONObject();
        Object memberIdObj = request.getSession().getAttribute("member_id_itaiping");
        String memberId = memberIdObj.toString();
        MemberDto tmpMember = this.userCenterService.findMenberById(memberId);
        if (Lang.isEmpty((Object)tmpMember)) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u7f51\u7edc\u9519\u8bef");
            return jsonObject;
        }
        logger.info("address:{}", (Object)address.toString());
        address.setMember(tmpMember);
        MemberAddressDto memberAddress = this.userCenterService.addMemberAddress(address);
        if (Lang.isEmpty((Object)memberAddress)) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u6dfb\u52a0\u5730\u5740\u5931\u8d25");
        }
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"\u6dfb\u52a0\u5730\u5740\u6210\u529f");
        return jsonObject;
    }
}

