/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cart.api.CartApi;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.login.LoginService;
import ctscore.web.service.member.UserCenterService;
import goods.api.SalesPriceRateQueryApi;
import goods.model.repository.GoodsRepos;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import member.api.QueryCollectionApi;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.sql.PageVo;

@Controller
@RequestMapping(value={"order"})
public class MyCollectionController {
    private static final Logger log = LoggerFactory.getLogger(MyCollectionController.class);
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    QueryCollectionApi queryCollectionApi;
    @Autowired
    UserCenterService userCenterService;
    @MotanReferer
    CartApi cartApi;
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    @Autowired
    LoginService loginService;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @Autowired
    GoodsRepos goodsRepos;

    @RequestMapping(value={"/myCollections"})
    public String myCollections() {
        return "member/order/mycollection";
    }

    @RequestMapping(value={"/queryCollections"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public PageVo queryCollection(HttpServletRequest request, @RequestParam Map<String, Object> params) {
        Long startTimer = System.currentTimeMillis();
        log.info("### \u52a0\u8f7d\u6211\u7684\u6536\u85cf\u5f00\u59cb... ###");
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        params.put("memberId", memberId);
        long queryFootPrintsTime = System.currentTimeMillis();
        PageVo pageVo = this.queryCollectionApi.queryCollection(params);
        log.info("\u67e5\u8be2\u6536\u85cf\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFootPrintsTime));
        int totalPage = this.getTotalPages(pageVo.getTotalCount().intValue(), pageVo.getPageSize().intValue());
        pageVo.setTotalCount(Integer.valueOf(totalPage));
        long organizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
        ArrayList goodsIds = new ArrayList(pageVo.getResult().size());
        pageVo.getResult().forEach(obj -> {
            Map map = (Map)obj;
            goodsIds.add((String)map.get("GOODID"));
        });
        long batchQuerySalePriceTime = System.currentTimeMillis();
        Map salePriceMap = this.salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsIds(goodsIds, this.storeCode, organizationId);
        log.info("\u6279\u91cf\u67e5\u8be2\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - batchQuerySalePriceTime));
        pageVo.getResult().forEach(obj -> {
            Map map = (Map)obj;
            String goodsId = (String)map.get("GOODID");
            map.put("SALEPRICE", salePriceMap.get(goodsId));
        });
        log.info("### \u52a0\u8f7d\u6211\u7684\u6536\u85cf\u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - startTimer));
        return pageVo;
    }

    @RequestMapping(value={"/deleteCollections"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public String deleteCollections(String id) {
        String deleteCollection = this.queryCollectionApi.deleteCollection(id);
        return null;
    }

    @RequestMapping(value={"/removeAll"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public JSONObject removeAllCollection(HttpServletRequest request) {
        log.info("\u6e05\u7a7a\u6211\u7684\u6536\u85cf");
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        JSONObject jsonObject = new JSONObject();
        MemberDto tmpMember = this.userCenterService.findMenberById(memberId);
        try {
            int n = this.queryCollectionApi.deleteByMember(tmpMember);
        }
        catch (Exception ex) {
            jsonObject.put("code", (Object)"-1");
            return jsonObject;
        }
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"\u6e05\u7a7a\u6211\u7684\u8db3\u8ff9");
        return jsonObject;
    }

    @RequestMapping(value={"/collectionToShop"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Map collectionToShop(@RequestParam Map<String, Object> params) {
        String targetId = "1";
        params.put("targetId", targetId);
        HashMap map = new HashMap();
        return map;
    }

    @RequestMapping(value={"addCart"}, method={RequestMethod.POST})
    @ResponseBody
    public Map addCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        System.out.println("Requesting /addCart");
        HashMap rsMap = new HashMap();
        rsMap.put("status", "success");
        rsMap.put("data", null);
        rsMap.put("error", 0);
        rsMap.put("message", "suc");
        rsMap.put("carts", this.cartApi.getCartSize((String)request.getSession().getAttribute("user_id_itaiping")));
        String userId = (String)request.getSession().getAttribute("user_id_itaiping");
        String idsStr = params.get("id").toString();
        rsMap = this.cartApi.addGoodsToCart(params, userId, rsMap);
        if (rsMap.get("status").equals("success")) {
            try {
                this.queryCollectionApi.deleteCollection(idsStr);
            }
            catch (Exception ex) {
                log.error("ex:{}", (Throwable)ex);
            }
        }
        return rsMap;
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }
}

