/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.login.LoginService;
import ctscore.web.service.member.UserCenterService;
import goods.api.SalesPriceRateQueryApi;
import goods.model.repository.GoodsPictureRepos;
import goods.model.repository.GoodsRepos;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import member.api.QueryFootprintsApi;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.sql.PageVo;

@Controller
@RequestMapping(value={"order"})
public class MyFootprintsController {
    private static final Logger log = LoggerFactory.getLogger(MyFootprintsController.class);
    @MotanReferer
    QueryFootprintsApi queryFootprintsApi;
    @Autowired
    UserCenterService userCenterService;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @Autowired
    LoginService loginService;
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Value(value="${ctscore.storeCode}")
    private String storeCode;
    @Autowired
    GoodsRepos goodsRepos;
    @Autowired
    GoodsPictureRepos goodsPictureRepos;
    @MotanReferer
    OrganizationApi organizationApi;

    @RequestMapping(value={"/myFootprints"})
    public String myFootprints() {
        return "member/order/myFootprints";
    }

    @RequestMapping(value={"/queryFootprints"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public PageVo queryFootprints(HttpServletRequest request, @RequestParam Map<String, Object> params) {
        Long startTimer = System.currentTimeMillis();
        log.info("### \u52a0\u8f7d\u6211\u7684\u8db3\u8ff9\u5f00\u59cb... ###");
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        params.put("memberId", memberId);
        long queryFootPrintsTime = System.currentTimeMillis();
        PageVo pageVo = this.queryFootprintsApi.queryFootPrintsNew(params);
        log.info("\u67e5\u8be2\u8db3\u8ff9\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFootPrintsTime));
        int totalPage = this.getTotalPages(pageVo.getTotalCount().intValue(), pageVo.getPageSize().intValue());
        pageVo.setTotalCount(Integer.valueOf(totalPage));
        long organizationTime = System.currentTimeMillis();
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(this.organizationCode);
        log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
        ArrayList goodsIds = new ArrayList(pageVo.getResult().size());
        pageVo.getResult().forEach(obj -> {
            Map map = (Map)obj;
            goodsIds.add((String)map.get("GOODID"));
        });
        long batchQuerySalePriceTime = System.currentTimeMillis();
        Map salePriceMap = this.salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsIds(goodsIds, this.storeCode, organizationId);
        log.info("\u6279\u91cf\u67e5\u8be2\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - batchQuerySalePriceTime));
        pageVo.getResult().forEach(obj -> {
            Map map = (Map)obj;
            String goodsId = (String)map.get("GOODID");
            map.put("SALEPRICE", salePriceMap.get(goodsId));
        });
        log.info("### \u52a0\u8f7d\u6211\u7684\u8db3\u8ff9\u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - startTimer));
        return pageVo;
    }

    @RequestMapping(value={"/deleteFootPrints"}, method={RequestMethod.POST})
    @ResponseBody
    public String deleteFootPrints(String id) {
        String deleteFootPrint = this.queryFootprintsApi.deletePrints(id);
        return deleteFootPrint;
    }

    @RequestMapping(value={"/footPrintsToShop"}, method={RequestMethod.POST})
    @ResponseBody
    public Map FootprintsToShop(@RequestParam Map<String, Object> params) {
        log.info(params.toString());
        HashMap map = new HashMap();
        return map;
    }

    @RequestMapping(value={"/clearFootPrints"})
    @ResponseBody
    public Map clearFootPrints(HttpSession session) {
        HashMap<String, String> map = new HashMap<String, String>();
        String memberId = (String)session.getAttribute("member_id_itaiping");
        List list = this.userCenterService.getViewHisByMemberId(memberId);
        this.userCenterService.clearFootPrints(list);
        map.put("status", "success");
        map.put("message", "\u8db3\u8ff9\u6e05\u7a7a\u6210\u529f");
        return map;
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }
}

