/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import aftersale.api.DiscussApi;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.api.CtScoreApi;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import ctscore.web.vo.EvaluateVo;
import ctscore.web.vo.SpecificationsVo;
import goods.api.ProductFashionApi;
import goods.model.ProductFashion;
import goods.model.ProductFashionSpecification;
import goods.model.ProductStandard;
import goods.model.repository.ProductFashionRepos;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import member.api.QueryOrderApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.date.DateUtils;

@Controller
@RequestMapping(value={"order"})
public class MyOrderController {
    @MotanReferer
    QueryOrderApi queryOrderApi;
    @MotanReferer
    DiscussApi discussApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @Autowired
    UserCenterService userCenterService;
    @Autowired
    MemberLoginService memberLoginService;
    @MotanReferer
    CtScoreApi ctScoreApi;
    @MotanReferer
    PaymentApi paymentApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    static final Logger logger = LoggerFactory.getLogger(MyOrderController.class);
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    @Autowired
    private ProductFashionRepos productFashionRepos;

    @RequestMapping(value={"/myOrder.html"})
    public String myOrder(Map model) {
        return "member/order/myorder";
    }

    @RequestMapping(value={"/queryOrder"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public JSONObject queryOrder(HttpServletRequest request) {
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        String orderNo = request.getParameter("orderNo");
        String status = request.getParameter("status");
        ArrayList<String> statusList = new ArrayList<String>();
        if (Lang.isEmpty((Object)status) && status.equals("")) {
            for (int i = 1; i <= 8; ++i) {
                statusList.add(i + "");
            }
        } else if (status.equals("1")) {
            statusList.add("1");
        } else if (status.equals("6")) {
            statusList.add("6");
            statusList.add("8");
        } else if (status.equals("2") || status.equals("3")) {
            statusList.add("2");
            statusList.add("3");
        } else {
            statusList.add(status);
        }
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        Date startDate = null;
        Date endDate = null;
        if (!Lang.isEmpty((Object)startTime) && !Lang.isEmpty((Object)endTime)) {
            try {
                startDate = DateUtils.parseToDate((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
                endDate = DateUtils.parseToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            endDate = DateUtils.getNow();
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            cal.add(2, -3);
            startDate = cal.getTime();
        }
        Integer pageIndex = 0;
        Integer pageSize = 10;
        String page = request.getParameter("pageIndex");
        if (!Lang.isEmpty((Object)page)) {
            pageIndex = Integer.parseInt(page);
        }
        String size = request.getParameter("pageSize");
        if (!Lang.isEmpty((Object)page)) {
            pageSize = Integer.parseInt(size);
        }
        ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>();
        Sort.Order order = new Sort.Order(Sort.Direction.DESC, "dateCreated");
        orderList.add(order);
        Sort sort = new Sort(orderList);
        PageRequest pageable = new PageRequest(pageIndex.intValue(), pageSize.intValue(), sort);
        long getOrderInfoTime = System.currentTimeMillis();
        JSONObject jsonObject = this.userCenterService.findUserCenterOrders(orderNo.trim(), statusList, memberId, startDate, endDate, (Pageable)pageable);
        logger.info("\u83b7\u53d6\u8ba2\u5355\u5217\u8868\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrderInfoTime));
        return jsonObject;
    }

    @RequestMapping(value={"/myOrder/detail/{orderNo}"}, method={RequestMethod.GET})
    public String orderDetail(Map map, @PathVariable(value="orderNo") String orderNo, Map<String, Object> model, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id_itaiping");
        if (Lang.isEmpty((Object)orderNo) || Lang.isEmpty((Object)memberId)) {
            return "member/order/myorder";
        }
        model.put("scorePortion", this.scorePortion);
        logger.info("scorePortion:{}", (Object)this.scorePortion);
        long getOrderInfoTime = System.currentTimeMillis();
        JSONObject jsonObject = this.userCenterService.findOrderDetailByOrderNo(orderNo, memberId);
        logger.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrderInfoTime));
        model.put("orderInfo", jsonObject);
        return "member/order/myOrderDetails";
    }

    @RequestMapping(value={"/myOrder/detail/items/page"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public JSONObject oderItemsPage(HttpServletRequest request, int pageIndex, int pageSize) {
        long methodStar = System.currentTimeMillis();
        logger.info("### \u5f00\u59cb\u52a0\u8f7d\u8ba2\u5355\u8be6\u60c5\u6570\u636e... ###");
        JSONObject jsonObject = new JSONObject();
        pageSize = pageSize == 0 ? 10 : pageSize;
        String orderNo = request.getParameter("orderNo");
        if (Lang.isEmpty((Object)orderNo)) {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("mes", (Object)"\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        PageRequest pageable = new PageRequest(pageIndex, pageSize);
        long getOrderInfoTime = System.currentTimeMillis();
        jsonObject = this.userCenterService.findOrderItemsPageByOrderNo((Pageable)pageable, orderNo);
        logger.info("\u83b7\u53d6\u8ba2\u5355\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrderInfoTime));
        long getProductSpecifications = System.currentTimeMillis();
        HashMap specificationsMap = new HashMap();
        List orderList = (List)jsonObject.get((Object)"orderList");
        for (Map oneOrder : orderList) {
            List tmpList = (List)oneOrder.get("tmpList");
            for (Map tem : tmpList) {
                OrderItemDto orderItem = (OrderItemDto)tem.get("ITEM");
                ProductFashion productFashion = (ProductFashion)this.productFashionRepos.findOne((Serializable)((Object)orderItem.getProductFashId()));
                if (Lang.isEmpty((Object)productFashion.getProductFashionSpecifications())) continue;
                ArrayList<SpecificationsVo> specificationsVos = new ArrayList<SpecificationsVo>();
                if (!Lang.isEmpty((Object)productFashion.getProduct()) && !Lang.isEmpty((Object)productFashion.getProduct().getProductStandards())) {
                    productFashion.getProduct().getProductStandards().sort((productStandard1, productStandard2) -> {
                        if (Lang.isEmpty((Object)productStandard1) || Lang.isEmpty((Object)productStandard1.getShowIndex())) {
                            return -1;
                        }
                        if (Lang.isEmpty((Object)productStandard2) || Lang.isEmpty((Object)productStandard2.getShowIndex())) {
                            return 1;
                        }
                        return productStandard1.getShowIndex() > productStandard2.getShowIndex() ? 1 : -1;
                    });
                    block2: for (ProductStandard productStandard : productFashion.getProduct().getProductStandards()) {
                        for (ProductFashionSpecification productFashionSpecification : productFashion.getProductFashionSpecifications()) {
                            if (productStandard.getIsDelete().booleanValue() || !productStandard.getStandardCode().equals(productFashionSpecification.getStandardCode()) || Lang.isEmpty((Object)productFashionSpecification.getIsDelete()) || productFashionSpecification.getIsDelete().booleanValue()) continue;
                            SpecificationsVo specificationsVo = new SpecificationsVo(productStandard.getName(), productFashionSpecification.getValue());
                            specificationsVos.add(specificationsVo);
                            continue block2;
                        }
                    }
                }
                specificationsMap.put(orderItem.getGoodsId(), specificationsVos);
            }
        }
        logger.info("\u83b7\u53d6\u5546\u54c1\u89c4\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getProductSpecifications));
        jsonObject.put("specificationsMap", specificationsMap);
        logger.info("### \u52a0\u8f7d\u8ba2\u5355\u8be6\u60c5\u6570\u636e\u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStar));
        return jsonObject;
    }

    @RequestMapping(value={"/myOrder/evaluate/discuss"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject discuss(HttpServletRequest request, @RequestBody EvaluateVo[] evaluateVos) {
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        String organizationId = coreUser.getOrganizationId();
        String realName = member.getRealName();
        Boolean result = this.userCenterService.saveDisscuccs(evaluateVos, memberId, organizationId, realName);
        JSONObject jsonObject = new JSONObject();
        if (result.booleanValue()) {
            String orderNo;
            OrderMainDto orderMain;
            jsonObject.put("code", (Object)"0");
            jsonObject.put("msg", (Object)"\u8bc4\u8bba\u6210\u529f");
            if (evaluateVos.length > 0 && !Lang.isEmpty((Object)(orderMain = this.orderMainApi.findByOrderNo(orderNo = evaluateVos[0].getOrderNo())))) {
                orderMain.setStatus("5");
                this.orderMainApi.saveOrder(orderMain);
            }
        } else {
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u8bc4\u8bba\u5931\u8d25");
        }
        return jsonObject;
    }

    @RequestMapping(value={"/myOrder/evaluate/{orderNo}"})
    public String toDiscuss(@PathVariable(value="orderNo") String orderNo, Map map) {
        map.put("orderNo", orderNo);
        try {
            JSONObject jsonObject = this.userCenterService.findDisscussByOrderNo(orderNo);
            map.put("orderInfo", jsonObject);
        }
        catch (Exception ex) {
            logger.error("ex:+" + ex);
        }
        return "member/order/myOrderEvaluate";
    }

    @RequestMapping(value={"/sureGet"})
    @ResponseBody
    public String sureGet(String orderId) {
        try {
            this.queryOrderApi.sureGetService(orderId);
        }
        catch (Exception ex) {
            logger.info("ex" + ex);
            return "faile";
        }
        return "success";
    }

    @RequestMapping(value={"/cancelOrder"})
    @ResponseBody
    public JSONObject cancelOrder(String orderNo) {
        JSONObject jsonObject = new JSONObject();
        try {
            this.orderMainApi.cancelOrder(orderNo, OrderMainApi.CancelOrderType.USER);
            jsonObject.put("code", (Object)"0");
            jsonObject.put("msg", (Object)"\u53d6\u6d88\u8ba2\u5355\u6210\u529f");
        }
        catch (Exception ex) {
            logger.error("\u53d6\u6d88\u8ba2\u5355\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)ex);
            jsonObject.put("code", (Object)"-1");
            jsonObject.put("msg", (Object)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
        }
        return jsonObject;
    }
}

