/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.member;

import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.model.order.OrderMain;
import cart.model.order.specification.OrderMainSpecification;
import cart.model.payment.Payment;
import cart.model.repository.order.OrderRepos;
import cart.model.repository.payment.PaymentRepos;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import ctscore.web.vo.OrderQueryVo;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.model.repository.member.MemberRepos;
import member.model.shop.Member;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ExcelUtil;
import utils.lang.Copys;

@Controller
@RequestMapping(value={"orderQuery"})
public class OrderQueryController {
    private static final Logger log = LoggerFactory.getLogger(OrderQueryController.class);
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrderMainApi orderMainApi;
    @Autowired
    OrderRepos orderRepos;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberApi memberApi;
    @Autowired
    MemberRepos memberRepos;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrganizationApi organizationApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    PaymentApi paymentApi;
    @Autowired
    PaymentRepos paymentRepos;
    @Autowired
    UserCenterService userCenterService;
    @Autowired
    MemberLoginService memberLoginService;
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    private static Map<String, String> ORDER_STATUS = new /* Unavailable Anonymous Inner Class!! */;
    private static Map<String, String> ORDER_STATUS_STRING = new /* Unavailable Anonymous Inner Class!! */;

    @RequestMapping(value={"", "index.do", "index.htm"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, String orderName, String orderNo, String status, String startTime, String endTime) {
        Object memberJson = request.getSession().getAttribute("member_json_itaiping");
        MemberDto member = (MemberDto)JSON.parseObject((String)memberJson.toString(), MemberDto.class);
        model.addAttribute("orderName", (Object)orderName);
        model.addAttribute("orderNo", (Object)orderNo);
        model.addAttribute("status", (Object)status);
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        return "member/administrators/adOperaCheckOrder";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportOrder.do"})
    @ResponseBody
    public void exportOrder(String orderName, String orderNo, String status, String startTime, String endTime, Pageable pageable, HttpServletRequest request, HttpServletResponse response) {
        int start;
        log.info("\u7ba1\u7406\u5458-\u8ba2\u5355\u5217\u8868\u5bfc\u51fa\u5f00\u59cb...");
        long methodStart = System.currentTimeMillis();
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        long getCoreUserTime = System.currentTimeMillis();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        log.info("\u83b7\u53d6 coreUser \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getCoreUserTime));
        long getOrganizationTime = System.currentTimeMillis();
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        log.info("\u83b7\u53d6 organization \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrganizationTime));
        ArrayList<String> statusList = new ArrayList<String>();
        ArrayList<String> memberIdsList = new ArrayList<String>();
        if (!Lang.isEmpty((Object)orderName)) {
            long memberListTime = System.currentTimeMillis();
            List memberList = this.memberApi.findByRealNameLikeAndOrganization("%" + orderName + "%", organization.getId());
            log.info("\u6761\u4ef6\u5904\u7406 [\u4e0b\u5355\u4eba] \u67e5\u8be2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - memberListTime));
            if (memberList.size() > 0) {
                for (int i = 0; i < memberList.size(); ++i) {
                    MemberDto theMember = (MemberDto)memberList.get(i);
                    if (Lang.isEmpty((Object)theMember)) continue;
                    memberIdsList.add(theMember.getId());
                }
            } else {
                memberIdsList.add("0");
            }
        } else {
            memberIdsList = null;
        }
        if ("0".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("1");
            statusList.add("2");
            statusList.add("3");
            statusList.add("4");
            statusList.add("5");
            statusList.add("6");
            statusList.add("7");
            statusList.add("8");
        } else if ("6".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("6");
            statusList.add("8");
        } else if ("2".equals(ORDER_STATUS_STRING.get(status)) || "3".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("2");
            statusList.add("3");
        } else if ("5".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("4");
            statusList.add("5");
        } else if (!Lang.isEmpty(ORDER_STATUS_STRING.get(status))) {
            statusList.add((String)ORDER_STATUS_STRING.get(status));
        }
        if (Lang.isEmpty(statusList)) {
            statusList.add("0000");
        }
        Date startTimeDate = Lang.isEmpty((Object)startTime) ? DateUtils.strToDateLong((String)"2000-01-01 00:00:00") : DateUtils.strToDateLong((String)(startTime + " 00:00:00"));
        Date endTimeDate = Lang.isEmpty((Object)endTime) ? DateUtils.strToDateLong((String)(DateUtils.getNowDateString() + " 23:59:59")) : DateUtils.strToDateLong((String)(endTime + " 23:59:59"));
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("\u4e0b\u5355\u4eba");
        header.add("\u516c\u53f8");
        header.add("\u8ba2\u5355\u53f7");
        header.add("\u4e0b\u5355\u79ef\u5206 (Ct)");
        header.add("\u4e0b\u5355\u91d1\u989d (\u5143)");
        header.add("\u8ba2\u5355\u72b6\u6001");
        header.add("\u4e0b\u5355\u65f6\u95f4");
        rows.add(header);
        Long queryOrderTimer = System.currentTimeMillis();
        OrderMain orderMainQuery = new OrderMain();
        orderMainQuery.setOrganizationId(coreUser.getOrganizationId());
        orderMainQuery.setOrderNo(Lang.isEmpty((Object)orderNo) ? orderNo : orderNo.trim());
        OrderMainSpecification orderMainSpecification = new OrderMainSpecification(orderMainQuery);
        orderMainSpecification.setCreateTiemStart(startTimeDate);
        orderMainSpecification.setCreateTiemEnd(endTimeDate);
        orderMainSpecification.setMemberIds(memberIdsList);
        orderMainSpecification.setStatus(statusList);
        ArrayList orderMainDTOs = new ArrayList();
        int page = 0;
        int pageSize = 100;
        long countTime = System.currentTimeMillis();
        Long total = this.orderRepos.count((Specification)orderMainSpecification);
        log.info("\u83b7\u53d6\u5168\u91cf\u6570\u636e\u6761\u6570\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - countTime));
        int totalPage = total.intValue() / pageSize;
        if (total.intValue() % pageSize > 0) {
            ++totalPage;
        }
        ConcurrentHashMap pageOrderMainMap = new ConcurrentHashMap();
        ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
        try {
            threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(10);
            threadPoolTaskExecutor.setMaxPoolSize(100);
            threadPoolTaskExecutor.setQueueCapacity(2000);
            threadPoolTaskExecutor.setKeepAliveSeconds(60);
            threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            threadPoolTaskExecutor.initialize();
            CountDownLatch countDownLatch = new CountDownLatch(totalPage);
            Sort sort = new Sort(Sort.Direction.DESC, new String[]{"createTime"});
            while (page < totalPage) {
                int currentPage = page++;
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        PageRequest thisPage = new PageRequest(currentPage, pageSize, sort);
                        Page orderMainPage = this.orderRepos.findAll((Specification)orderMainSpecification, (Pageable)thisPage);
                        pageOrderMainMap.put(currentPage, orderMainPage.getContent());
                    }
                    catch (Exception e) {
                        log.error("\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            log.error("\u591a\u7ebf\u7a0b\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (!Lang.isEmpty((Object)threadPoolTaskExecutor)) {
                threadPoolTaskExecutor.shutdown();
            }
        }
        ArrayList orderMainPOs = new ArrayList();
        for (int i = 0; i < pageOrderMainMap.size(); ++i) {
            orderMainPOs.addAll((Collection)pageOrderMainMap.get(i));
        }
        Copys copys = Copys.create();
        orderMainPOs.forEach(orderMainPO -> {
            OrderMainDto orderMainDTO = new OrderMainDto();
            orderMainPO.setSubOrders(null);
            orderMainPO.setOrderGifts(null);
            orderMainPO.setOrderAttrs(null);
            orderMainPO.setOrderMainCoupons(null);
            copys.from(orderMainPO).excludes(new String[]{"orderItems", "subOrders", "orderGifts", "orderAttrs"}).to(new Object[]{orderMainDTO}).clear();
            orderMainDTOs.add(orderMainDTO);
        });
        log.info("\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u8017\u65f6 {} ms", (Object)((double)(System.currentTimeMillis() - queryOrderTimer) / 1000.0));
        int batchSize = 500;
        int end = 0;
        ArrayList idsList = new ArrayList();
        long memberFindOneTime = System.currentTimeMillis();
        List memberIds = orderMainDTOs.stream().map(OrderMainDto::getMemberId).distinct().collect(Collectors.toList());
        int allSize = memberIds.size();
        int allPage = allSize / batchSize;
        if (allSize % batchSize > 0) {
            ++allPage;
        }
        for (int i = 0; i < allPage; ++i) {
            start = i * batchSize;
            end = end + batchSize > memberIds.size() ? memberIds.size() : end + batchSize;
            idsList.add(memberIds.subList(start, end));
        }
        Vector memberVector = new Vector();
        idsList.parallelStream().forEach(ids -> {
            List memberPOs = this.memberRepos.findByIdIn(ids);
            memberVector.addAll(memberPOs);
        });
        Map<String, String> memberIdNameMap = memberVector.stream().collect(Collectors.toMap(Member::getId, Member::getRealName));
        log.info("\u83b7\u53d6\u4e0b\u5355\u4eba\u540d\u79f0 {} \u6761\u6570\u636e, \u8017\u65f6 {} ms", (Object)memberIdNameMap.size(), (Object)(System.currentTimeMillis() - memberFindOneTime));
        long findPaymentTime = System.currentTimeMillis();
        List paymentIds = orderMainDTOs.stream().map(OrderMainDto::getPaymentId).distinct().collect(Collectors.toList());
        idsList.clear();
        allSize = paymentIds.size();
        allPage = allSize / batchSize;
        if (allSize % batchSize > 0) {
            ++allPage;
        }
        end = 0;
        for (int i = 0; i < allPage; ++i) {
            start = i * batchSize;
            end = end + batchSize > paymentIds.size() ? paymentIds.size() : end + batchSize;
            idsList.add(paymentIds.subList(start, end));
        }
        Vector vector = new Vector();
        idsList.parallelStream().forEach(ids -> {
            List paymentPOs = this.paymentRepos.findByIdIn(ids);
            vector.addAll(paymentPOs);
        });
        Map<String, Payment> paymentIdMap = vector.stream().collect(Collectors.toMap(Payment::getId, payment -> payment));
        log.info("\u67e5\u8be2 payment {} \u6761\u6570\u636e, \u8017\u65f6 {} ms", (Object)paymentIdMap.size(), (Object)(System.currentTimeMillis() - findPaymentTime));
        for (OrderMainDto orderMainDTO : orderMainDTOs) {
            ArrayList<String> row = new ArrayList<String>();
            String rowRealName = "";
            if (!Lang.isEmpty((Object)memberIdNameMap.get(orderMainDTO.getMemberId()))) {
                rowRealName = memberIdNameMap.get(orderMainDTO.getMemberId());
            }
            row.add(rowRealName);
            row.add(organization.getOrgName());
            row.add(orderMainDTO.getOrderNo());
            String orderPrice = "0";
            String orderScore = "0";
            if (!(Lang.isEmpty((Object)orderMainDTO.getScore()) && Lang.isEmpty((Object)orderMainDTO.getPaymentId()) || Lang.isEmpty((Object)orderMainDTO.getPaymentId()))) {
                if (!Lang.isEmpty((Object)paymentIdMap.get(orderMainDTO.getPaymentId()).getScore())) {
                    orderScore = paymentIdMap.get(orderMainDTO.getPaymentId()).getScore().toString();
                }
                orderPrice = paymentIdMap.get(orderMainDTO.getPaymentId()).getMoney().toString();
            }
            row.add(orderScore);
            row.add(orderPrice);
            row.add((String)OrderMainDto.order_status.get(orderMainDTO.getStatus()));
            row.add(DateUtils.dateToStrLong((Date)orderMainDTO.getDateCreated()));
            rows.add(row);
        }
        try {
            response.setHeader("Content-disposition", "attachment; filename=Order.xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, (String)"Order").write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Error", (Throwable)e);
        }
        log.info("\u7ba1\u7406\u5458-\u8ba2\u5355\u5bfc\u51fa {} \u6761\u6570\u636e, \u8017\u65f6 {} ms", (Object)orderMainDTOs.size(), (Object)(System.currentTimeMillis() - methodStart));
    }

    @RequestMapping(value={"getOrder.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getOrder(String orderName, String orderNo, String status, String startTime, String endTime, Pageable pageable, HttpServletRequest request) {
        log.info("\u7ba1\u7406\u5458-\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5f00\u59cb...");
        long methodStart = System.currentTimeMillis();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, new String[]{"createTime"}));
        Object userId = request.getSession().getAttribute("user_id_itaiping");
        String id = userId.toString();
        long getCoreUserTime = System.currentTimeMillis();
        CoreUserDto coreUser = this.memberLoginService.findById(id);
        log.info("\u83b7\u53d6 coreUser \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getCoreUserTime));
        long getOrganizationTime = System.currentTimeMillis();
        OrganizationDto organization = this.organizationApi.findOrganizationById(coreUser.getOrganizationId());
        log.info("\u83b7\u53d6 organization \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getOrganizationTime));
        ArrayList<String> statusList = new ArrayList<String>();
        ArrayList<String> memberIdsList = new ArrayList<String>();
        if (!Lang.isEmpty((Object)orderName)) {
            long memberListTime = System.currentTimeMillis();
            List memberList = this.memberApi.findByRealNameLikeAndOrganization("%" + orderName + "%", organization.getId());
            log.info("\u6761\u4ef6\u5904\u7406 [\u4e0b\u5355\u4eba] \u67e5\u8be2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - memberListTime));
            if (memberList.size() > 0) {
                for (int i = 0; i < memberList.size(); ++i) {
                    MemberDto theMember = (MemberDto)memberList.get(i);
                    if (Lang.isEmpty((Object)theMember)) continue;
                    memberIdsList.add(theMember.getId());
                }
            } else {
                memberIdsList.add("0");
            }
        } else {
            memberIdsList = null;
        }
        if ("0".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("1");
            statusList.add("2");
            statusList.add("3");
            statusList.add("4");
            statusList.add("5");
            statusList.add("6");
            statusList.add("7");
            statusList.add("8");
        } else if ("6".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("6");
            statusList.add("8");
        } else if ("2".equals(ORDER_STATUS_STRING.get(status)) || "3".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("2");
            statusList.add("3");
        } else if ("5".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("4");
            statusList.add("5");
        } else if (!Lang.isEmpty(ORDER_STATUS_STRING.get(status))) {
            statusList.add((String)ORDER_STATUS_STRING.get(status));
        }
        if (Lang.isEmpty(statusList)) {
            statusList.add("0000");
        }
        Date startTimeDate = Lang.isEmpty((Object)startTime) ? DateUtils.strToDateLong((String)"2000-01-01 00:00:00") : DateUtils.strToDateLong((String)(startTime + " 00:00:00"));
        Date endTimeDate = Lang.isEmpty((Object)endTime) ? DateUtils.strToDateLong((String)(DateUtils.getNowDateString() + " 23:59:59")) : DateUtils.strToDateLong((String)(endTime + " 23:59:59"));
        Long queryOrderTimer = System.currentTimeMillis();
        OrderMain orderMainQuery = new OrderMain();
        orderMainQuery.setOrganizationId(coreUser.getOrganizationId());
        orderMainQuery.setOrderNo(orderNo.trim());
        OrderMainSpecification orderMainSpecification = new OrderMainSpecification(orderMainQuery);
        orderMainSpecification.setCreateTiemStart(startTimeDate);
        orderMainSpecification.setCreateTiemEnd(endTimeDate);
        orderMainSpecification.setMemberIds(memberIdsList);
        orderMainSpecification.setStatus(statusList);
        ArrayList orderMainDTOs = new ArrayList();
        Page orderMainPOPage = this.orderRepos.findAll((Specification)orderMainSpecification, pageable);
        Copys copys = Copys.create();
        orderMainPOPage.forEach(orderMainPO -> {
            OrderMainDto orderMainDTO = new OrderMainDto();
            copys.from(orderMainPO).excludes(new String[]{"orderItems", "subOrders", "orderGifts", "orderAttrs"}).to(new Object[]{orderMainDTO}).clear();
            orderMainDTOs.add(orderMainDTO);
        });
        PageImpl orderPage = new PageImpl(orderMainDTOs, pageable, orderMainPOPage.getTotalElements());
        log.info("\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryOrderTimer));
        long memberFindOneTime = System.currentTimeMillis();
        List memberIds = orderMainDTOs.stream().map(OrderMainDto::getMemberId).distinct().collect(Collectors.toList());
        List memberPOs = this.memberRepos.findByIdIn(memberIds);
        Map<String, String> memberIdNameMap = memberPOs.stream().collect(Collectors.toMap(Member::getId, Member::getRealName));
        log.info("\u83b7\u53d6\u4e0b\u5355\u4eba\u540d\u79f0 {} \u6761\u6570\u636e, \u8017\u65f6 {} ms", (Object)memberIdNameMap.size(), (Object)(System.currentTimeMillis() - memberFindOneTime));
        long findPaymentTime = System.currentTimeMillis();
        List paymentIds = orderMainDTOs.stream().map(OrderMainDto::getPaymentId).distinct().collect(Collectors.toList());
        List paymentPOs = this.paymentRepos.findByIdIn(paymentIds);
        Map<String, Payment> paymentIdMap = paymentPOs.stream().collect(Collectors.toMap(Payment::getId, payment -> payment));
        log.info("\u67e5\u8be2 payment {} \u6761\u6570\u636e, \u8017\u65f6 {} ms", (Object)paymentIdMap.size(), (Object)(System.currentTimeMillis() - findPaymentTime));
        List orders = orderPage.getContent();
        ArrayList<OrderQueryVo> orderQuerys = new ArrayList<OrderQueryVo>();
        for (int i = 0; i < orders.size(); ++i) {
            OrderQueryVo orderQueryVo = new OrderQueryVo();
            orderQueryVo.setOrderName(memberIdNameMap.get(((OrderMainDto)orders.get(i)).getMemberId()));
            orderQueryVo.setOrderId(((OrderMainDto)orders.get(i)).getId());
            orderQueryVo.setOrgName(organization.getOrgName());
            orderQueryVo.setOrderNo(((OrderMainDto)orders.get(i)).getOrderNo());
            orderQueryVo.setOrderStatus((String)OrderMainDto.order_status.get(((OrderMainDto)orders.get(i)).getStatus()));
            orderQueryVo.setOrderTime(DateUtils.dateToStrLong((Date)((OrderMainDto)orders.get(i)).getDateCreated()));
            String orderPrice = "0";
            String orderScore = "0";
            if (!(Lang.isEmpty((Object)((OrderMainDto)orders.get(i)).getScore()) && Lang.isEmpty((Object)((OrderMainDto)orders.get(i)).getPaymentId()) || Lang.isEmpty((Object)((OrderMainDto)orders.get(i)).getPaymentId()))) {
                if (!Lang.isEmpty((Object)paymentIdMap.get(((OrderMainDto)orders.get(i)).getPaymentId()).getScore())) {
                    orderScore = paymentIdMap.get(((OrderMainDto)orders.get(i)).getPaymentId()).getScore().toString();
                }
                orderPrice = paymentIdMap.get(((OrderMainDto)orders.get(i)).getPaymentId()).getMoney().toString();
            }
            orderQueryVo.setOrderScore(orderScore);
            orderQueryVo.setOrderPrice(orderPrice);
            orderQuerys.add(orderQueryVo);
        }
        returnMap.put("data", orderQuerys);
        returnMap.put("totalPages", this.getTotalPages((int)orderPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put("status", "success");
        returnMap.put("message", "\u6570\u636e\u83b7\u53d6\u6210\u529f");
        log.info("\u7ba1\u7406\u5458-\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5b8c\u6210, \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return returnMap;
    }

    @RequestMapping(value={"orderDetail.do"}, method={RequestMethod.GET})
    public String orderDetail(String orderId, String orderName, String orderNo, String status, String startTime, String endTime, HttpServletRequest request, Model model) {
        OrderMainDto order = this.orderMainApi.findById(orderId);
        Integer price = 0;
        for (OrderItemDto item : order.getOrderItems()) {
            price = price + item.getCount() * Integer.valueOf(item.getFinalPrice().toString());
        }
        model.addAttribute("orderName", (Object)orderName);
        model.addAttribute("orderNo", (Object)orderNo);
        model.addAttribute("status", (Object)status);
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("price", (Object)price);
        model.addAttribute("order", (Object)order);
        model.addAttribute("orderItems", (Object)order.getOrderItems());
        model.addAttribute("orderStatus", (Object)ORDER_STATUS);
        return "member/administrators/adOperaCheckOrderDetail";
    }

    @RequestMapping(value={"/orderDetail/{orderNo}"})
    public String orderDetail(Map map, @PathVariable(value="orderNo") String orderNo, Map<String, Object> model, HttpServletRequest request) {
        JSONObject jsonObject = this.userCenterService.findOrderDetailByOrderNo(orderNo, null);
        model.put("orderInfo", jsonObject);
        model.put("scorePortion", this.scorePortion);
        return "member/administrators/myOrderDetails";
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u4e0b\u5355\u4eba");
        cell = row.createCell(1);
        cell.setCellValue("\u516c\u53f8\u540d");
        cell = row.createCell(2);
        cell.setCellValue("\u8ba2\u5355\u53f7");
        cell = row.createCell(3);
        cell.setCellValue("\u4e0b\u5355\u91d1\u989d");
        cell = row.createCell(4);
        cell.setCellValue("\u8ba2\u5355\u72b6\u6001");
        cell = row.createCell(5);
        cell.setCellValue("\u4e0b\u5355\u65e5\u671f");
    }

    private void createCellContent(List<OrderQueryVo> queryVos, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < queryVos.size(); ++i) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            OrderQueryVo queryVo = queryVos.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue(queryVo.getOrderName()));
            theCell = row.createCell(1);
            theCell.setCellValue(this.setContentCellValue(queryVo.getOrgName()));
            theCell = row.createCell(2);
            theCell.setCellValue(this.setContentCellValue(queryVo.getOrderNo()));
            theCell = row.createCell(3);
            theCell.setCellValue(this.setContentCellValue(queryVo.getOrderPrice()));
            theCell = row.createCell(4);
            theCell.setCellValue(this.setContentCellValue(queryVo.getOrderStatus()));
            theCell = row.createCell(5);
            theCell.setCellValue(this.setContentCellValue(queryVo.getOrderTime()));
        }
    }

    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);
        sheet.setColumnWidth(4, 5000);
        sheet.setColumnWidth(5, 5000);
    }

    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    private String setContentCellValue(String value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value;
    }
}

