/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.controller.payment.controller.product;

import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import payment.api.TpPaymentApi;
import payment.api.vo.PayMentInfoVo;
import payment.api.vo.PrePayRequestVo;
import payment.api.vo.PrePayResultVo;
import utils.Lang;
import utils.picture.MatrixToImageWriter;

@Controller
public class PaymentController {
    @MotanReferer
    TpPaymentApi tpPaymentApi;
    @Value(value="${pay.partnerUrl}")
    private String payPartnerUrl;
    @Value(value="${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;
    @Value(value="${itaiping.usercenter.order}")
    private String itaipingUserCenterOrder;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    PaymentApi paymentApi;

    @RequestMapping(value={"/showPayGateWay"})
    public String showPayGateWay(String orderNo, Map map, HttpSession session) {
        map.put("orderNo", orderNo);
        String payUid = UUID.randomUUID().toString();
        map.put("payUid", payUid);
        session.setAttribute("payUid", (Object)payUid);
        String memberId = (String)session.getAttribute("member_id_itaiping");
        PayMentInfoVo payMentInfo = this.tpPaymentApi.getPayMentInfo(orderNo, memberId);
        map.put("payMoney", payMentInfo.getSumPrice());
        map.put("payLogId", payMentInfo.getPayLodId());
        return "payment/wechatPay";
    }

    @RequestMapping(value={"/paymentQRCode"})
    public void getQRCode(String payUid, String orderNo, HttpSession session, HttpServletResponse response) {
        String memberId = (String)session.getAttribute("member_id_itaiping");
        PrePayRequestVo prePayRequestVo = new PrePayRequestVo();
        prePayRequestVo.setPayPartnerUrl(this.payPartnerUrl);
        prePayRequestVo.setOrderNos(orderNo);
        prePayRequestVo.setMemberId(memberId);
        PrePayResultVo prePayResultVo = null;
        Object sessionPayUid = session.getAttribute("payUid");
        this.logger.info("===payUid={}", (Object)payUid);
        this.logger.info("===sessionPayUid={}", sessionPayUid);
        this.logger.info("===orderNo={}", (Object)orderNo);
        try {
            if (!StringUtils.isEmpty((Object)sessionPayUid) && ((String)sessionPayUid).equals(payUid)) {
                prePayResultVo = this.tpPaymentApi.prePayment(prePayRequestVo);
                String payUrl = prePayResultVo.getPayUrl();
                payUrl = payUrl.indexOf("?") > 0 ? payUrl + "&payUid=" + payUid : payUrl + "?payUid=" + payUid;
                this.logger.info("getQRCode pay url :{}", (Object)payUrl);
                String content = payUrl;
                MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
                HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
                hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
                response.setContentType("image/png");
                ServletOutputStream os = response.getOutputStream();
                MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)os);
                os.flush();
                os.close();
                this.logger.info("\u83b7\u53d6\u652f\u4ed8\u4e8c\u7ef4\u7801\u6210\u529f");
            } else {
                response.getWriter().println("\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u652f\u4ed8\u4e8c\u7ef4\u7801");
            }
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u652f\u4ed8\u4e8c\u7ef4\u7801\u5931\u8d25");
            this.logger.error("==prePayRequestVo={}", (Object)JSON.toJSONString((Object)prePayRequestVo));
            this.logger.error("==prePayResultVo={}", (Object)JSON.toJSONString((Object)prePayResultVo));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/judgePayLogState.json"})
    @ResponseBody
    public Map judgePayLogState(Integer payLogId) {
        return this.tpPaymentApi.judgePayLogState(payLogId);
    }

    @RequestMapping(value={"/paySuccess"})
    public String paySuccess(String payLogId) {
        System.out.println("\u652f\u4ed8\u7f16\u53f7PayLogId" + payLogId + "=====paySuccess=====");
        return "cart/payment/phonePayResult";
    }

    @RequestMapping(value={"/pcPaySuccess.html"})
    public String sd(Map map, String orderNos) {
        if (!Lang.isEmpty((Object)orderNos)) {
            String[] orderNoArray = orderNos.split(",");
            LinkedList<OrderMainDto> list = new LinkedList<OrderMainDto>();
            for (String no : orderNoArray) {
                OrderMainDto orderMain = this.orderMainApi.findByOrderNo(no);
                list.add(orderMain);
                map.put("data", list);
            }
        }
        map.put("itaipingUserCenterOrder", this.itaipingUserCenterOrder);
        map.put("itaipingUserCenterGoods", this.itaipingUserCenterGoods);
        return "cart/order/orderSubmitResult";
    }
}

