/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.area;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import org.springframework.stereotype.Component;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.Webs;

@Component
public class AreaService {
    @MotanReferer
    AddressCommonApi addressCommonApi;
    private static final Log log = Logs.getLog((String)AreaService.class.getName());

    public Map<String, Object> getAddressIdSByParams(HttpServletRequest request, String proviceId) {
        HashMap<String, Object> returnAddressIdMap = new HashMap<String, Object>();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        String cityId = (String)request.getSession().getAttribute("AREA_LEVEL_CITY_ID");
        String areaId = (String)request.getSession().getAttribute("AREA_LEVEL_AREA_ID");
        String townId = (String)request.getSession().getAttribute("AREA_LEVEL_TOWN_ID");
        if (Lang.isEmpty((Object)proviceId)) {
            if (!Lang.isEmpty((Object)sessionProvoiceId)) {
                returnProvoiceId = sessionProvoiceId;
            } else {
                String remoteIp = Webs.getIp((HttpServletRequest)request);
                log.info((Object)("getAddressIdsByParams -> remoteIp: " + remoteIp));
                if (!Lang.isEmpty((Object)remoteIp)) {
                    Long ipL = IPtoLong.ipToLong((String)remoteIp);
                    AddressDto currentAaddress = null;
                    currentAaddress = this.addressCommonApi.findAreaByIp(ipL, 1);
                    if (!Lang.isEmpty((Object)currentAaddress)) {
                        returnProvoiceId = currentAaddress.getId();
                    } else {
                        returnProvoiceId = "110000";
                        request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
                        request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
                        request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
                    }
                } else {
                    returnProvoiceId = "110000";
                    request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
                    request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
                    request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
                }
            }
        } else if (!Lang.isEmpty((Object)sessionProvoiceId)) {
            if (!proviceId.equals(sessionProvoiceId)) {
                returnProvoiceId = proviceId;
                request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
                request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
            } else {
                returnProvoiceId = sessionProvoiceId;
            }
        } else {
            returnProvoiceId = proviceId;
            request.getSession().setAttribute("AREA_LEVEL_CITY_ID", null);
            request.getSession().setAttribute("AREA_LEVEL_AREA_ID", null);
            request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", null);
        }
        if (Lang.isEmpty((Object)areaId)) {
            Map areaMap = this.getAddressId(request, areaId, returnProvoiceId);
            returnCityId = (String)areaMap.get("cityId");
            returnAreaId = (String)areaMap.get("areaId");
            returnTownId = (String)areaMap.get("townId");
        } else {
            returnCityId = cityId;
            returnAreaId = areaId;
            returnTownId = townId;
        }
        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    private Map<String, Object> getAddressId(HttpServletRequest request, String areaId, String provoiceId) {
        AddressDto townAddress;
        AddressDto areaAddress;
        AddressDto cityAddress;
        HashMap<String, Object> returnAddressIdMap = new HashMap<String, Object>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp((HttpServletRequest)request);
        if (!Lang.isEmpty((Object)remoteIp)) {
            Long ipL = IPtoLong.ipToLong((String)remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty((Object)areaId) && !Lang.isEmpty((Object)(currentAaddress = this.addressCommonApi.findAreaByIp(ipL, 3)))) {
                returnAreaId = currentAaddress.getId();
                returnCityId = currentAaddress.getParent().getId();
            }
        }
        if (Lang.isEmpty(returnAreaId) && !Lang.isEmpty((Object)(cityAddress = this.addressCommonApi.findFirstChild(provoiceId, Boolean.valueOf(true)))) && !Lang.isEmpty((Object)(areaAddress = this.addressCommonApi.findFirstChild(returnCityId = cityAddress.getId(), Boolean.valueOf(true)))) && !Lang.isEmpty((Object)(townAddress = this.addressCommonApi.findFirstChild(returnAreaId = areaAddress.getId(), Boolean.valueOf(false))))) {
            returnTownId = townAddress.getId();
        }
        request.getSession().setAttribute("AREA_LEVEL_PROVINCE_ID", (Object)provoiceId);
        request.getSession().setAttribute("AREA_LEVEL_CITY_ID", returnCityId);
        request.getSession().setAttribute("AREA_LEVEL_AREA_ID", returnAreaId);
        request.getSession().setAttribute("AREA_LEVEL_TOWN_ID", returnTownId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }
}

