/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.cart.service;

import cart.api.CartApi;
import cart.api.CartItemApi;
import cart.api.dto.cart.CartDto;
import cart.api.dto.cart.CartItemDto;
import cart.api.dto.goods.ProductFashionDto;
import cart.api.dto.store.StoreExtDto;
import cart.api.vo.CartItemGroupVo;
import cart.api.vo.CartItemVo;
import cart.api.vo.CartStoreInfoVo;
import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.ProductApi;
import goods.api.ProductFashionApi;
import goods.api.SalesPriceRateApi;
import goods.api.ShareApi;
import goods.dto.goods.GoodsDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.MemberApi;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.lang.Copys;

@Component
public class CartWebService {
    Logger log = Logger.getLogger(CartWebService.class);
    @Value(value="${ctscore.score.proportion}")
    private BigDecimal scorePortion;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    CartApi cartApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    StoreApi storeApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    ProductApi productApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    CartItemApi cartItemApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    ShareApi shareApi;
    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;
    @MotanReferer
    OrganizationApi organizationApi;

    public Map<String, CartStoreInfoVo> findCartItemInfoGroupByStrore(String cartId) {
        HashMap<String, CartStoreInfoVo> cartItemInfoMap = new HashMap<String, CartStoreInfoVo>();
        if (StringUtils.isBlank((CharSequence)cartId)) {
            return cartItemInfoMap;
        }
        return this.findCartItemInfoGroupByStrore(this.cartApi.get(cartId));
    }

    public Map<String, CartStoreInfoVo> findCartItemInfoGroupByStrore(CartDto cart) {
        HashMap<String, CartStoreInfoVo> cartItemInfoMap = new HashMap<String, CartStoreInfoVo>();
        if (cart == null) {
            return cartItemInfoMap;
        }
        Copys copys = Copys.create();
        CartStoreInfoVo cartStoreInfo = null;
        for (CartItemDto item : cart.getCartItems()) {
            cartStoreInfo = (CartStoreInfoVo)cartItemInfoMap.get(item.getStoreId());
            if (cartStoreInfo == null) {
                cartStoreInfo = new CartStoreInfoVo();
                StoreDto s = this.storeApi.getStoreInfo(item.getStoreId());
                if (s != null) {
                    copys.from((Object)s).excludes(new String[]{"cartItems"}).to(new Object[]{cartStoreInfo}).clear();
                }
                cartStoreInfo.setCartItems(new ArrayList());
                cartStoreInfo.setStoreExt((StoreExtDto)this.mapperFacade.map((Object)s.getStoreExt(), StoreExtDto.class));
            }
            CartItemVo cartItemVo = new CartItemVo();
            copys.from((Object)item).to(new Object[]{cartItemVo}).clear();
            GoodsDto goods = this.goodsApi.findById(item.getGoodsId());
            cartItemVo.setGoods((cart.api.dto.goods.GoodsDto)this.mapperFacade.map((Object)goods, cart.api.dto.goods.GoodsDto.class));
            cartItemVo.setProductFashion((ProductFashionDto)this.mapperFacade.map((Object)this.productFashionApi.findDtoById(item.getProductFashId()), ProductFashionDto.class));
            cartItemVo.getProductFashion();
            cartStoreInfo.getCartItems().add(cartItemVo);
            cartItemInfoMap.put(item.getStoreId(), cartStoreInfo);
        }
        return cartItemInfoMap;
    }

    public List<CartItemGroupVo> findCartItemGroups(HttpServletRequest request, CartDto cart) {
        return this.findCartItemGroups(request, cart, "1");
    }

    public List<CartItemGroupVo> findCartItemGroups(HttpServletRequest request, CartDto cart, String groupType) {
        return this.findCartItemGroups(request, cart, groupType, Boolean.valueOf(true), Boolean.valueOf(false), null, null);
    }

    public List<CartItemGroupVo> findCartItemGroups(HttpServletRequest request, CartDto cart, String groupType, Boolean withStoreDetail, Boolean refreshStatus, String areaCode, List<String> cartItemIds) {
        List<Object> cartItemGroups = new ArrayList<CartItemGroupVo>();
        if (cart == null) {
            return cartItemGroups;
        }
        List tmpCartItems = null;
        HashMap ordersTmpMap = (HashMap)request.getSession().getAttribute("ORDER_CARTITEM_TMPS");
        if (!Lang.isEmpty((Object)ordersTmpMap)) {
            tmpCartItems = (List)ordersTmpMap.get("tmpCartItems");
        }
        cartItemGroups = this.cartApi.getCartItemGroups(cart.getId(), groupType, withStoreDetail, refreshStatus, areaCode, cartItemIds, tmpCartItems, this.organizationCode, null);
        return cartItemGroups;
    }

    public List<CartItemGroupVo> genBuyCounts(List<CartItemGroupVo> cartItemGroups, List<Map<String, Object>> tmpCartItems) {
        for (CartItemGroupVo g : cartItemGroups) {
            for (CartItemVo it : g.getCartItems()) {
                for (Map<String, Object> m : tmpCartItems) {
                    if (!it.getId().equals((String)m.get("id"))) continue;
                    it.setCount((Integer)m.get("counts"));
                }
            }
        }
        return cartItemGroups;
    }

    public CartItemVo genBuyCounts(CartItemVo cartItemVo, List<Map<String, Object>> tmpCartItems) {
        if (!Lang.isEmpty(tmpCartItems) && cartItemVo != null) {
            for (Map<String, Object> m : tmpCartItems) {
                if (!cartItemVo.getId().equals((String)m.get("id"))) continue;
                cartItemVo.setCount((Integer)m.get("counts"));
            }
        }
        return cartItemVo;
    }

    public void recalCartItemGroupSumPrice(List<CartItemGroupVo> cartItemGroups) {
        Double groupSumPrice = 0.0;
        for (CartItemGroupVo group : cartItemGroups) {
            if (group == null || group.getStore() == null) continue;
            for (CartItemVo itemVo : group.getCartItems()) {
                if (itemVo.getIsDelete() != null && itemVo.getIsDelete().booleanValue()) continue;
                groupSumPrice = groupSumPrice + itemVo.getProductFashion().getSalePrice().setScale(0, 2).doubleValue() * (double)itemVo.getCount().intValue() * this.scorePortion.doubleValue();
            }
            group.setSumPrice(new BigDecimal(groupSumPrice));
        }
    }

    public BigDecimal findStoreSumPrice(List<CartItemGroupVo> cartItemGroups, String storeId) {
        return this.findStoreSumPrice(cartItemGroups, storeId, true);
    }

    public BigDecimal findStoreSumPrice(List<CartItemGroupVo> cartItemGroups, String storeId, boolean recal) {
        if (StringUtils.isBlank((CharSequence)storeId)) {
            return null;
        }
        if (recal) {
            this.recalCartItemGroupSumPrice(cartItemGroups);
        }
        for (CartItemGroupVo group : cartItemGroups) {
            if (group == null || group.getStore() == null || !group.getStore().getId().equals(storeId)) continue;
            return group.getSumPrice();
        }
        return null;
    }

    public Double calSumCartPrice(List<CartItemGroupVo> cartItemGroups) {
        Double sumCartPrice = 0.0;
        for (CartItemGroupVo group : cartItemGroups) {
            for (CartItemVo item : group.getCartItems()) {
                if (!item.getStatus().equals(CartItemVo.statusMap.get("NORMAL")) || item.getIsDelete().booleanValue() || Lang.isEmpty((Object)item.getProductFashion()) || Lang.isEmpty((Object)item.getProductFashion().getSalePrice())) continue;
                sumCartPrice = sumCartPrice + item.getProductFashion().getSalePrice().setScale(0, 2).doubleValue() * (double)item.getCount().intValue() * this.scorePortion.doubleValue();
            }
        }
        return sumCartPrice;
    }

    public Double calSumMarketCartPrice(List<CartItemGroupVo> cartItemGroups) {
        Double sumMarketCartPrice = 0.0;
        for (CartItemGroupVo group : cartItemGroups) {
            for (CartItemVo item : group.getCartItems()) {
                if (!item.getStatus().equals(CartItemVo.statusMap.get("NORMAL")) || item.getIsDelete().booleanValue() || Lang.isEmpty((Object)item.getProductFashion()) || Lang.isEmpty((Object)item.getProductFashion().getMarketPrice())) continue;
                sumMarketCartPrice = sumMarketCartPrice + item.getProductFashion().getMarketPrice().doubleValue() * (double)item.getCount().intValue();
            }
        }
        return sumMarketCartPrice;
    }

    public Integer calSumGoodsCount(List<CartItemGroupVo> cartItemGroups) {
        int sumGoodsCount = 0;
        for (CartItemGroupVo g : cartItemGroups) {
            sumGoodsCount += g.getAllItemCounts().intValue();
        }
        return sumGoodsCount;
    }

    public Integer calSumCartItemCounts(List<CartItemGroupVo> cartItemGroups) {
        int sumGoodsCount = 0;
        for (int i = 0; i < cartItemGroups.size(); ++i) {
            for (CartItemVo cartItemVo : cartItemGroups.get(i).getCartItems()) {
                if (cartItemVo.getIsDelete() != null && cartItemVo.getIsDelete().booleanValue()) continue;
                sumGoodsCount += cartItemVo.getCount() > 0 ? cartItemVo.getCount() : 1;
            }
        }
        return sumGoodsCount;
    }

    public CartItemGroupVo findCartItemGroupInListByStore(List<CartItemGroupVo> cartItemGroupVoList, String storeId) {
        for (CartItemGroupVo i : cartItemGroupVoList) {
            if (i.getStore() == null || !i.getStore().getId().equals(storeId)) continue;
            return i;
        }
        return null;
    }

    public Map<String, Object> deleteInvalidItems(String userId) {
        CartDto cart = this.cartApi.getUserCart(userId);
        if (cart == null) {
            return null;
        }
        ArrayList<String> delIds = new ArrayList<String>();
        for (CartItemDto item : cart.getCartItems()) {
            GoodsDto goods;
            if (!Lang.isEmpty((Object)item.getGoodsId()) && !Lang.isEmpty((Object)(goods = this.goodsApi.findById(item.getGoodsId()))) && goods.getState() != 1) {
                delIds.add(item.getId());
            }
            if (delIds.contains(item.getId())) continue;
            goods.dto.product.ProductFashionDto fashion = this.productFashionApi.findById(item.getProductFashId());
            if (fashion == null) {
                delIds.add(item.getId());
                continue;
            }
            if (fashion.getOnSale() == null || fashion.getOnSale().booleanValue()) continue;
            delIds.add(item.getId());
        }
        return this.cartApi.deleteItem(cart.getId(), delIds.toArray(new String[delIds.size()]));
    }

    public BigDecimal getScorePortion() {
        return this.scorePortion;
    }

    public void setScorePortion(BigDecimal scorePortion) {
        this.scorePortion = scorePortion;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
}

