/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.goods;

import activities.api.ActivityGoodsApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.model.Goods;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsRepos;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import member.api.MemberApi;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import search.vo.CommonDoc;
import store.api.StoreApi;
import utils.Lang;

@Component
public class GoodWebService {
    @Resource(name="redisTemplate")
    private ZSetOperations<String, String> zSetOperations;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    StoreApi storeApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;
    Logger log = LoggerFactory.getLogger(this.getClass());

    public MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id_itaiping");
        String userId = (String)request.getSession().getAttribute("user_id_itaiping");
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            System.out.println("memberId" + memberId);
            memberVo = this.memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            System.out.println("userId" + userId);
            memberVo = this.memberApi.getMemberInfoByUserId(userId);
        }
        return memberVo;
    }

    @Transactional(readOnly=true)
    public List<CommonDoc> setCommonDocList(List<String> goodsIds) {
        long time2 = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        List goodses = this.findGoodsByIds(goodsIds);
        this.log.info("\u52a0\u8f7dgoodsDto\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        ArrayList<CommonDoc> returnCommonDocs = new ArrayList<CommonDoc>();
        time2 = System.currentTimeMillis();
        for (Goods goods : goodses) {
            CommonDoc commonDoc = new CommonDoc();
            commonDoc.setId(goods.getId());
            if (!Lang.isEmpty((Object)goods)) {
                List goodsPictures = goods.getGoodsPictures();
                for (int i = 0; i < goodsPictures.size(); ++i) {
                    if (((GoodsPicture)goodsPictures.get(i)).getShowIndex() != 0) continue;
                    commonDoc.setLogoUrl(((GoodsPicture)goodsPictures.get(i)).getBigPicturePath());
                }
                if (Lang.isEmpty((Object)commonDoc.getLogoUrl()) && !Lang.isEmpty((Object)goodsPictures)) {
                    commonDoc.setLogoUrl(((GoodsPicture)goodsPictures.get(0)).getBigPicturePath());
                }
                String storeCode = this.storeApi.getStoreCode(goods.getStoreId());
                start = System.currentTimeMillis();
                BigDecimal price = this.activityGoodsApi.getActivityPrice(goods.getId(), this.organizationCode, storeCode);
                this.log.info("\u83b7\u53d6\u6d3b\u52a8\u4ef7price\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
                price = new BigDecimal(price.toString()).setScale(2, 0);
                commonDoc.setPrice(Double.valueOf(price.doubleValue()));
                commonDoc.setTitle(goods.getName());
            }
            returnCommonDocs.add(commonDoc);
        }
        return returnCommonDocs;
    }

    public List<Goods> findGoodsByIds(List<String> idList) {
        return this.goodsRepos.findByIdIn(idList);
    }

    public void putKeyWords(String type, String keyWord) {
        this.zSetOperations.incrementScore((Object)type, (Object)keyWord, 1.0);
    }
}

