/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.goods.excel;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.util.CellRangeAddressList;

public class ExcelReader {
    private POIFSFileSystem fs;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private HSSFRow row;
    public static String SPLIT = "----";

    public String[] readExcelTitle(InputStream is) {
        try {
            this.fs = new POIFSFileSystem(is);
            this.wb = new HSSFWorkbook(this.fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sheet = this.wb.getSheetAt(0);
        this.row = this.sheet.getRow(0);
        int colNum = this.row.getPhysicalNumberOfCells();
        System.out.println("colNum:" + colNum);
        String[] title = new String[colNum];
        for (int i = 0; i < colNum; ++i) {
            title[i] = this.getCellFormatValue(this.row.getCell(i));
        }
        return title;
    }

    public Map<Integer, String> readExcelContent(InputStream is) {
        HashMap<Integer, String> content = new HashMap<Integer, String>();
        String str = "";
        try {
            this.fs = new POIFSFileSystem(is);
            this.wb = new HSSFWorkbook(this.fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sheet = this.wb.getSheetAt(0);
        int rowNum = this.sheet.getLastRowNum();
        this.row = this.sheet.getRow(0);
        int colNum = this.row.getPhysicalNumberOfCells();
        for (int i = 1; i <= rowNum; ++i) {
            this.row = this.sheet.getRow(i);
            for (int j = 0; j < colNum; ++j) {
                str = str + this.getCellFormatValue(this.row.getCell(j)).trim() + SPLIT;
            }
            content.put(i, str);
            str = "";
        }
        return content;
    }

    private String getStringCellValue(HSSFCell cell) {
        String strCell = "";
        switch (cell.getCellType()) {
            case 1: {
                strCell = cell.getStringCellValue();
                break;
            }
            case 0: {
                strCell = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case 4: {
                strCell = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                strCell = "";
                break;
            }
            default: {
                strCell = "";
            }
        }
        if (strCell.equals("") || strCell == null) {
            return "";
        }
        if (cell == null) {
            return "";
        }
        return strCell;
    }

    private String getDateCellValue(HSSFCell cell) {
        String result = "";
        try {
            int cellType = cell.getCellType();
            if (cellType == 0) {
                Date date = cell.getDateCellValue();
                result = date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
            } else if (cellType == 1) {
                String date = this.getStringCellValue(cell);
                result = date.replaceAll("[\u5e74\u6708]", "-").replace("\u65e5", "").trim();
            } else if (cellType == 3) {
                result = "";
            }
        }
        catch (Exception e) {
            System.out.println("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e!");
            e.printStackTrace();
        }
        return result;
    }

    private String getCellFormatValue(HSSFCell cell) {
        String cellvalue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: 
                case 2: {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellvalue = sdf.format(date);
                        break;
                    }
                    cellvalue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellvalue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellvalue = " ";
                    break;
                }
            }
        } else {
            cellvalue = "";
        }
        return cellvalue;
    }

    public static HSSFDataValidation createListBox(String[] list, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])list);
        HSSFDataValidation data_validation = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        return data_validation;
    }
}

