/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.goods.excel;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class ExcelService {
    public String getCellFormatValue(HSSFCell cell) {
        String cellvalue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: 
                case 2: {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellvalue = sdf.format(date);
                        break;
                    }
                    cellvalue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellvalue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellvalue = " ";
                    break;
                }
            }
        } else {
            cellvalue = "";
        }
        return cellvalue;
    }
}

