/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.goods.excel;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.goods.excel.ExcelReader;
import ctscore.web.service.goods.excel.ExcelService;
import goods.api.SalesPriceRateApi;
import goods.dto.goods.SalesPriceRateDto;
import goods.vo.SalesPriceRateQueryVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Component
@Transactional(readOnly=true)
public class RateExcelService {
    private static final String[] titleEns = new String[]{"organizationId", "storeId", "rangeUpper", "rangeLower", "rangeUpperOpertor", "rangeLowerOpertor", "rateNumerator", "rateDenominator", "mode", "expression", "remark"};
    private static final String[] titles = new String[]{"\u673a\u6784", "\u5e97\u94fa", "\u8d39\u7387\u9002\u7528\u533a\u95f4\u4e0a\u9650", "\u8d39\u7387\u9002\u7528\u533a\u95f4\u4e0b\u9650", "\u8d39\u7387\u9002\u7528\u533a\u95f4\u4e0a\u9650\u8fb9\u754c", "\u8d39\u7387\u9002\u7528\u533a\u95f4\u4e0b\u9650\u8fb9\u754c", "\u8d39\u7387\u5206\u5b50", "\u8d39\u7387\u5206\u6bcd", "\u8d39\u7387\u914d\u7f6e\u6a21\u5f0f", "\u8d39\u7387\u8868\u8fbe\u5f0f", "\u5907\u6ce8"};
    private static final Log log = Logs.getLog();
    private HSSFWorkbook hwb;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    StoreApi storeApi;
    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;
    @Autowired
    ExcelService excelService;

    public void officeExcelOut(OutputStream out) {
        try {
            this.hwb = new HSSFWorkbook();
            this.hwb = this.rateDown();
            this.hwb.write(out);
            out.flush();
            out.close();
            this.hwb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HSSFWorkbook rateDown() {
        HSSFWorkbook hwb = new HSSFWorkbook();
        HSSFSheet sheet = hwb.createSheet("\u8d39\u7387\u8868");
        HSSFRow firstrow = sheet.createRow(0);
        int countColumnNum = titles.length;
        for (int i = 0; i < countColumnNum; ++i) {
            HSSFCell firstcell = firstrow.createCell(i);
            HSSFCellStyle style = hwb.createCellStyle();
            style.setAlignment((short)2);
            style.setVerticalAlignment((short)1);
            style.setWrapText(true);
            firstcell.setCellStyle(style);
            try {
                sheet.setColumnWidth(i, titles[i].getBytes("utf-8").length * 256);
            }
            catch (UnsupportedEncodingException e) {
                sheet.setColumnWidth(i, titles[i].getBytes().length * 256);
            }
            sheet.setDefaultColumnStyle(i, (CellStyle)style);
            firstcell.setCellValue((RichTextString)new HSSFRichTextString(titles[i]));
        }
        ArrayList organizationMapList = new ArrayList(this.organizationApi.listToMap().values());
        String[] organizationMapArray = new String[organizationMapList.size()];
        organizationMapList.toArray(organizationMapArray);
        HSSFDataValidation organizationMapValidation = ExcelReader.createListBox((String[])organizationMapArray, (int)1, (int)10000, (int)0, (int)0);
        sheet.addValidationData((DataValidation)organizationMapValidation);
        ArrayList storeMapList = new ArrayList(this.storeApi.listToMap().values());
        String[] storeMapArray = new String[storeMapList.size()];
        storeMapList.toArray(storeMapArray);
        HSSFDataValidation storeMapValidation = ExcelReader.createListBox((String[])storeMapArray, (int)1, (int)10000, (int)1, (int)1);
        sheet.addValidationData((DataValidation)storeMapValidation);
        ArrayList RangeUpperOpertorMapList = new ArrayList(SalesPriceRateDto.RangeUpperOpertorMap.values());
        String[] RangeUpperOpertorMapArray = new String[RangeUpperOpertorMapList.size()];
        RangeUpperOpertorMapList.toArray(RangeUpperOpertorMapArray);
        HSSFDataValidation RangeUpperOpertorMapValidation = ExcelReader.createListBox((String[])RangeUpperOpertorMapArray, (int)1, (int)1000, (int)4, (int)4);
        sheet.addValidationData((DataValidation)RangeUpperOpertorMapValidation);
        ArrayList RangeLowerOpertorMapList = new ArrayList(SalesPriceRateDto.RangeLowerOpertorMap.values());
        String[] RangeLowerOpertorMapArray = new String[RangeLowerOpertorMapList.size()];
        RangeLowerOpertorMapList.toArray(RangeLowerOpertorMapArray);
        HSSFDataValidation RangeLowerOpertorMapValidation = ExcelReader.createListBox((String[])RangeLowerOpertorMapArray, (int)1, (int)1000, (int)5, (int)5);
        sheet.addValidationData((DataValidation)RangeLowerOpertorMapValidation);
        ArrayList RateDenominatorMapList = new ArrayList(SalesPriceRateDto.RateDenominatorMap.values());
        String[] RateDenominatorMapArray = new String[RateDenominatorMapList.size()];
        RateDenominatorMapList.toArray(RateDenominatorMapArray);
        HSSFDataValidation RateDenominatorMapValidation = ExcelReader.createListBox((String[])RateDenominatorMapArray, (int)1, (int)1000, (int)7, (int)7);
        sheet.addValidationData((DataValidation)RateDenominatorMapValidation);
        ArrayList ModeMapList = new ArrayList(SalesPriceRateDto.ModelMap.values());
        String[] ModeMapArray = new String[ModeMapList.size()];
        ModeMapList.toArray(ModeMapArray);
        HSSFDataValidation ModeMapValidation = ExcelReader.createListBox((String[])ModeMapArray, (int)1, (int)1000, (int)8, (int)8);
        sheet.addValidationData((DataValidation)ModeMapValidation);
        ArrayList ExpressionMapList = new ArrayList(SalesPriceRateDto.ExpressionMap.values());
        String[] ExpressionMapArray = new String[ExpressionMapList.size()];
        ExpressionMapList.toArray(ExpressionMapArray);
        HSSFDataValidation ExpressionMapValidation = ExcelReader.createListBox((String[])ExpressionMapArray, (int)1, (int)1000, (int)9, (int)9);
        sheet.addValidationData((DataValidation)ExpressionMapValidation);
        return hwb;
    }

    public void officeExcelRead(InputStream inputStream) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(new POIFSFileSystem(inputStream));
        HSSFSheet sheet = wb.getSheetAt(0);
        int rowNum = sheet.getLastRowNum();
        HSSFRow row = sheet.getRow(0);
        String message = "";
        int colNum = titles.length;
        ArrayList<SalesPriceRateDto> salesPriceRates = new ArrayList<SalesPriceRateDto>();
        Map organizationApiMaps = this.organizationApi.listToMap();
        String[] organizationMaps = new String[organizationApiMaps.size()];
        organizationApiMaps.values().toArray(organizationMaps);
        String[] organizationMapEns = new String[organizationApiMaps.size()];
        organizationApiMaps.keySet().toArray(organizationMapEns);
        Map storeServiceMaps = this.storeApi.listToMap();
        String[] storeMaps = new String[storeServiceMaps.size()];
        storeServiceMaps.values().toArray(storeMaps);
        String[] storeMapEns = new String[storeServiceMaps.size()];
        storeServiceMaps.keySet().toArray(storeMapEns);
        String[] RangeUpperOpertorMaps = new String[SalesPriceRateDto.RangeUpperOpertorMap.size()];
        SalesPriceRateDto.RangeUpperOpertorMap.values().toArray(RangeUpperOpertorMaps);
        String[] RangeUpperOpertorMapEns = new String[SalesPriceRateDto.RangeUpperOpertorMap.size()];
        SalesPriceRateDto.RangeUpperOpertorMap.keySet().toArray(RangeUpperOpertorMapEns);
        String[] RangeLowerOpertorMaps = new String[SalesPriceRateDto.RangeLowerOpertorMap.size()];
        SalesPriceRateDto.RangeLowerOpertorMap.values().toArray(RangeLowerOpertorMaps);
        String[] RangeLowerOpertorMapEns = new String[SalesPriceRateDto.RangeLowerOpertorMap.size()];
        SalesPriceRateDto.RangeLowerOpertorMap.keySet().toArray(RangeLowerOpertorMapEns);
        String[] RateDenominatorMaps = new String[SalesPriceRateDto.RateDenominatorMap.size()];
        SalesPriceRateDto.RateDenominatorMap.values().toArray(RateDenominatorMaps);
        String[] RateDenominatorMapEns = new String[SalesPriceRateDto.RateDenominatorMap.size()];
        SalesPriceRateDto.RateDenominatorMap.keySet().toArray(RateDenominatorMapEns);
        String[] ModelMaps = new String[SalesPriceRateDto.ModelMap.size()];
        SalesPriceRateDto.ModelMap.values().toArray(ModelMaps);
        String[] ModelMapEns = new String[SalesPriceRateDto.ModelMap.size()];
        SalesPriceRateDto.ModelMap.keySet().toArray(ModelMapEns);
        String[] ExpressionMaps = new String[SalesPriceRateDto.ExpressionMap.size()];
        SalesPriceRateDto.ExpressionMap.values().toArray(ExpressionMaps);
        String[] ExpressionMapEns = new String[SalesPriceRateDto.ExpressionMap.size()];
        SalesPriceRateDto.ExpressionMap.keySet().toArray(ExpressionMapEns);
        ArrayList<SalesPriceRateDto> salesPriceRatesTemp = new ArrayList<SalesPriceRateDto>();
        if (row.getPhysicalNumberOfCells() == colNum) {
            for (int i = 1; i <= rowNum; ++i) {
                row = sheet.getRow(i);
                SalesPriceRateDto salesPriceRate = new SalesPriceRateDto();
                block27: for (int j = 0; j < colNum; ++j) {
                    String value = String.valueOf(this.excelService.getCellFormatValue(row.getCell(j)));
                    if (j != 10 && Lang.isEmpty((Object)value)) {
                        throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    switch (titleEns[j]) {
                        case "organizationId": {
                            boolean flagOrganizationId = false;
                            for (int k = 0; k < organizationMaps.length; ++k) {
                                if (!organizationMaps[k].equals(value)) continue;
                                salesPriceRate.setOrganizationId(organizationMapEns[k]);
                                flagOrganizationId = true;
                                break;
                            }
                            if (flagOrganizationId) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u673a\u6784\u503c\u4e0d\u5bf9");
                        }
                        case "storeId": {
                            boolean flagStoreId = false;
                            for (int k = 0; k < storeMaps.length; ++k) {
                                if (!storeMaps[k].equals(value)) continue;
                                salesPriceRate.setStoreId(storeMapEns[k]);
                                log.info((Object)("\u5e97\u94faID=" + storeMapEns[k]));
                                StoreDto store = this.storeApi.getStoreInfo(storeMapEns[k]);
                                if (!Lang.isEmpty((Object)store)) {
                                    salesPriceRate.setStoreCode(store.getStoreExt().getCode());
                                }
                                flagStoreId = true;
                                break;
                            }
                            if (flagStoreId) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u5e97\u94fa\u503c\u4e0d\u5bf9");
                        }
                        case "rangeUpper": {
                            salesPriceRate.setRangeUpper(new BigDecimal(value));
                            continue block27;
                        }
                        case "rangeLower": {
                            salesPriceRate.setRangeLower(new BigDecimal(value));
                            continue block27;
                        }
                        case "rangeUpperOpertor": {
                            boolean flag1 = false;
                            for (int k = 0; k < RangeUpperOpertorMaps.length; ++k) {
                                if (!RangeUpperOpertorMaps[k].equals(value)) continue;
                                salesPriceRate.setRangeUpperOpertor(RangeUpperOpertorMapEns[k]);
                                flag1 = true;
                                break;
                            }
                            if (flag1) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u8d39\u7387\u9002\u7528\u533a\u95f4\u4e0a\u9650\u8fb9\u754c\u503c\u4e0d\u5bf9");
                        }
                        case "rangeLowerOpertor": {
                            boolean flag2 = false;
                            for (int k = 0; k < RangeLowerOpertorMaps.length; ++k) {
                                if (!RangeLowerOpertorMaps[k].equals(value)) continue;
                                salesPriceRate.setRangeLowerOpertor(RangeLowerOpertorMapEns[k]);
                                flag2 = true;
                                break;
                            }
                            if (flag2) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u8d39\u7387\u9002\u7528\u533a\u95f4\u4e0b\u9650\u8fb9\u754c\u503c\u4e0d\u5bf9");
                        }
                        case "rateNumerator": {
                            salesPriceRate.setRateNumerator(new BigDecimal(value));
                            continue block27;
                        }
                        case "rateDenominator": {
                            value = value.substring(0, value.length() - 2);
                            boolean flag3 = false;
                            for (int k = 0; k < RateDenominatorMaps.length; ++k) {
                                if (!RateDenominatorMaps[k].equals(value)) continue;
                                salesPriceRate.setRateDenominator(Integer.valueOf(Integer.parseInt(RateDenominatorMapEns[k])));
                                flag3 = true;
                                break;
                            }
                            if (flag3) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u8d39\u7387\u5206\u6bcd\u503c\u4e0d\u5bf9");
                        }
                        case "mode": {
                            boolean flag4 = false;
                            for (int k = 0; k < ModelMaps.length; ++k) {
                                if (!ModelMaps[k].equals(value)) continue;
                                salesPriceRate.setMode(ModelMapEns[k]);
                                flag4 = true;
                                break;
                            }
                            if (flag4) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u8d39\u7387\u914d\u7f6e\u6a21\u5f0f\u503c\u4e0d\u5bf9");
                        }
                        case "expression": {
                            boolean flag5 = false;
                            for (int k = 0; k < ExpressionMaps.length; ++k) {
                                if (!ExpressionMaps[k].equals(value)) continue;
                                salesPriceRate.setExpression(ExpressionMapEns[k]);
                                flag5 = true;
                                break;
                            }
                            if (flag5) continue block27;
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u7b2c" + (j + 1) + "\u5217\u8d39\u7387\u8868\u8fbe\u5f0f\u503c\u4e0d\u5bf9");
                        }
                        case "remark": {
                            salesPriceRate.setRemark(value);
                        }
                    }
                }
                SalesPriceRateQueryVo salesPriceRateQueryVo = new SalesPriceRateQueryVo(salesPriceRate.getStoreCode(), salesPriceRate.getStoreId(), salesPriceRate.getOrganizationId());
                List salesPriceRateList = this.salesPriceRateApi.getSalesPriceRate(salesPriceRateQueryVo);
                for (SalesPriceRateDto salesPrice : salesPriceRateList) {
                    salesPrice.setEnabled(false);
                    salesPrice.setIsDelete(Boolean.valueOf(true));
                    salesPriceRatesTemp.add(salesPrice);
                }
                salesPriceRates.add(salesPriceRate);
            }
        } else {
            message = "\u683c\u5f0f\u4e0d\u5bf9,\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u7248";
        }
        wb.close();
        if (message != null & !"".equals(message)) {
            throw new Exception(message);
        }
        if (salesPriceRates.size() <= 0) {
            throw new Exception("\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.salesPriceRateApi.saveSalesPriceRateList(salesPriceRatesTemp);
        this.salesPriceRateApi.saveSalesPriceRateList(salesPriceRates);
    }
}

