/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.login;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import javax.servlet.http.HttpServletRequest;
import member.api.CoreUserApi;
import member.api.LoginApi;
import member.api.MemberApi;
import member.api.PeripheryApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import utils.Lang;

@Component
public class LoginService {
    @MotanReferer(basicReferer="motanClientBasicConfig")
    LoginApi loginApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    PeripheryApi peripheryApi;
    @MotanReferer
    CoreUserApi coreUserApi;
    @Value(value="${ctscore.orgCode}")
    private String organizationCode;

    public CoreUserDto findById(String id) {
        return this.loginApi.findById(id);
    }

    public MemberDto findByCoreUser(CoreUserDto coreUser) {
        return this.loginApi.findByCoreUser(coreUser);
    }

    public CoreUserDto updateCoreUser(CoreUserDto coreUser) {
        return this.loginApi.updateCoreUser(coreUser);
    }

    public MemberDto updateMember(MemberDto member) {
        return this.loginApi.updateMember(member);
    }

    public String encryptPasswd(String orginPasswd) {
        return this.loginApi.encryptPasswd(orginPasswd);
    }

    public MemberVo loadMemberVo(CoreUserDto coreUser) {
        return this.loginApi.loadMemberVo(coreUser);
    }

    public CoreUserDto findByPhoneAndOrganizationIdAndUserType(String account, String id, String userTypeMember, boolean b) {
        return this.loginApi.findByPhoneAndOrganizationIdAndUserType(account, id, userTypeMember, b);
    }

    public CoreUserDto findByEmailAndOrganizationIdAndUserType(String account, String id, String userTypeMember, boolean b) {
        return this.loginApi.findByEmailAndOrganizationIdAndUserType(account, id, userTypeMember, b);
    }

    public CoreUserDto findByUsernameAndIsDeleteAndOrganizationIdAndUserType(String account, boolean b, String id, String userTypeMember) {
        return this.loginApi.findByUsernameAndIsDeleteAndOrganizationIdAndUserType(account, b, id, userTypeMember);
    }

    public MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id_itaiping");
        String userId = (String)request.getSession().getAttribute("user_id_itaiping");
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            System.out.println("memberId" + memberId);
            memberVo = this.memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            System.out.println("userId" + userId);
            memberVo = this.memberApi.getMemberInfoByUserId(userId);
        }
        return memberVo;
    }

    public boolean saveInfotoSession(HttpServletRequest request, MemberVo memberVo) {
        request.getSession().invalidate();
        request.getSession().setAttribute("member_id_itaiping", (Object)memberVo.getMember().getId());
        request.getSession().setAttribute("user_id_itaiping", (Object)memberVo.getUser().getId());
        if (!Lang.isEmpty((Object)memberVo.getUser().getUsername())) {
            request.getSession().setAttribute("user_name_itaiping", (Object)memberVo.getUser().getUsername());
        } else if (!Lang.isEmpty((Object)memberVo.getUser().getPhone())) {
            request.getSession().setAttribute("user_name_itaiping", (Object)memberVo.getUser().getPhone());
        } else if (!Lang.isEmpty((Object)memberVo.getUser().getEmail())) {
            request.getSession().setAttribute("user_name_itaiping", (Object)memberVo.getUser().getEmail());
        }
        request.getSession().setAttribute("member_vo_json_itaiping", (Object)JSON.toJSONString((Object)memberVo));
        MemberDto member = memberVo.getMember();
        CoreUserDto coreUser = memberVo.getUser();
        request.getSession().setAttribute("member_json_itaiping", (Object)JSON.toJSONString((Object)member));
        request.getSession().setAttribute("user_json_itaiping", (Object)JSON.toJSONString((Object)coreUser));
        Boolean isAdmin = memberVo.getMember().getAdmin();
        if (!Lang.isEmpty((Object)isAdmin)) {
            request.getSession().setAttribute("member_role_itaiping", (Object)isAdmin);
        } else {
            request.getSession().setAttribute("member_role_itaiping", (Object)false);
        }
        return true;
    }

    public CoreUserDto changeUserInfo(CoreUserDto coreUser, CoreUserDto incomeCoreUser) {
        if (incomeCoreUser.getUsername() != null && !incomeCoreUser.getUsername().equals(coreUser.getUsername()) || incomeCoreUser.getPhone() != null && !incomeCoreUser.getPhone().equals(coreUser.getPhone()) || incomeCoreUser.getEmail() != null && !incomeCoreUser.getEmail().equals(coreUser.getEmail())) {
            return this.coreUserApi.updateUserInfo(incomeCoreUser);
        }
        return coreUser;
    }

    public void removeLoginAttr(HttpServletRequest request) {
        request.getSession().removeAttribute("member_id_itaiping");
        request.getSession().removeAttribute("PERIPHERY_THIRD_USER_ID");
        request.getSession().removeAttribute("user_id_itaiping");
        request.getSession().removeAttribute("user_name_itaiping");
        request.getSession().removeAttribute("member_vo_json_itaiping");
        request.getSession().removeAttribute("user_name_logout_itaiping");
    }

    public CoreUserDto getSessionCoreUser(HttpServletRequest request) {
        Object coreUserObj = request.getSession().getAttribute("user_json_itaiping");
        return (CoreUserDto)JSON.parseObject((String)coreUserObj.toString(), CoreUserDto.class);
    }
}

