/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.member;

import ctscore.web.service.member.MemberBatchTransactionalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.model.core.CoreUser;
import member.model.repository.core.UserRepos;
import member.model.repository.member.MemberRepos;
import member.model.shop.Member;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.model.ScoreAccount;
import score.model.ScoreGiveAwayLog;
import score.model.repository.ScoreAccountRepos;
import score.model.repository.ScoreGiveAwayLogRepos;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.Copys;
import utils.lock.RedisLockUtil;

@Service
public class MemberBatchService {
    private static final Logger log = LoggerFactory.getLogger(MemberBatchService.class);
    @Autowired
    MemberRepos memberRepos;
    @Autowired
    UserRepos userRepos;
    @Autowired
    ScoreAccountRepos scoreAccountRepos;
    @Autowired
    MemberBatchTransactionalService memberBatchTransactionalService;
    @Autowired
    ScoreGiveAwayLogRepos scoreGiveAwayLogRepos;
    @Autowired
    RedisLockUtil redisLockUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MemberDto> findMembersByCoreUserIds(List<String> coreUserIds) {
        long findMembersByCoreUserIdsTime = System.currentTimeMillis();
        ConcurrentHashMap<String, MemberDto> memberDTOMap = new ConcurrentHashMap<String, MemberDto>(1);
        int page = 0;
        int pageSize = 500;
        int totalPage = coreUserIds.size() / pageSize;
        if (coreUserIds.size() % pageSize > 0) {
            ++totalPage;
        }
        log.info("member \u6279\u67e5\u8be2\u6570\u91cf {} \u6761, \u5355\u6279\u6b21\u67e5\u8be2\u6570\u91cf {} \u6761, \u9700\u67e5\u8be2 {} \u6b21", new Object[]{coreUserIds.size(), pageSize, totalPage});
        log.info("\u5f00\u59cb\u591a\u7ebf\u7a0b\u67e5\u8be2\u79ef member \u6570\u636e...");
        ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
        try {
            threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(10);
            threadPoolTaskExecutor.setMaxPoolSize(100);
            threadPoolTaskExecutor.setQueueCapacity(2000);
            threadPoolTaskExecutor.setKeepAliveSeconds(60);
            threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            threadPoolTaskExecutor.initialize();
            CountDownLatch countDownLatch = new CountDownLatch(totalPage);
            while (page < totalPage) {
                int startIndex = pageSize * page;
                int endIndexTemp = pageSize * (page + 1);
                if (endIndexTemp > coreUserIds.size()) {
                    endIndexTemp = coreUserIds.size();
                }
                int endIndex = endIndexTemp;
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        List memberPOs = this.memberRepos.findByCoreUserIdIn(coreUserIds.subList(startIndex, endIndex));
                        this.getCoreUserMemberMap(memberPOs, memberDTOMap);
                    }
                    catch (Exception e) {
                        log.error("\u5206\u9875\u67e5\u8be2 member \u6570\u636e\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
                ++page;
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            log.error("\u591a\u7ebf\u7a0b\u5206\u9875\u67e5\u8be2 member \u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (!Lang.isEmpty((Object)threadPoolTaskExecutor)) {
                threadPoolTaskExecutor.shutdown();
            }
        }
        log.info("\u591a\u7ebf\u7a0b\u83b7\u53d6 member {} \u6761\u6570\u636e, \u8017\u65f6 {} \u79d2", (Object)memberDTOMap.size(), (Object)Float.valueOf((float)(System.currentTimeMillis() - findMembersByCoreUserIdsTime) / 1000.0f));
        return memberDTOMap;
    }

    private Map<String, MemberDto> getCoreUserMemberMap(List<Member> memberPOs, Map<String, MemberDto> memberDTOMap) {
        Copys copys = Copys.create();
        memberPOs.forEach(memberPO -> {
            if (!memberDTOMap.containsKey(memberPO.getCoreUser().getId())) {
                MemberDto memberDTO = new MemberDto();
                copys.from(memberPO).excludes(new String[]{"coreUser", "memberGroup", "addresses", "contactses", "creditses", "coupons", "moneys", "viewHises", "favorites", "favorites", "roles"}).to(new Object[]{memberDTO}).clear();
                CoreUserDto coreUserDTO = new CoreUserDto();
                copys.from((Object)memberPO.getCoreUser()).excludes(new String[]{"coreUserExt"}).to(new Object[]{coreUserDTO}).clear();
                memberDTO.setCoreUser(coreUserDTO);
                memberDTOMap.put(memberPO.getCoreUser().getId(), memberDTO);
            }
        });
        return memberDTOMap;
    }

    public int getMemberCount(MemberDto member) {
        Specification memberSpecification = this.findMemberSpecification(member);
        return (int)this.memberRepos.count(memberSpecification);
    }

    public Map<String, MemberDto> findMember(MemberDto member, Pageable pageable, List<String> coreUserIdSort) {
        long methodStartTime = System.currentTimeMillis();
        HashMap<String, MemberDto> memberDTOMap = new HashMap<String, MemberDto>(1);
        Specification memberSpecification = this.findMemberSpecification(member);
        Page memberPage = this.memberRepos.findAll(memberSpecification, pageable);
        coreUserIdSort.addAll(memberPage.getContent().stream().map(Member::getCoreUser).map(CoreUser::getId).distinct().collect(Collectors.toList()));
        this.getCoreUserMemberMap(memberPage.getContent(), memberDTOMap);
        log.info("\u4e00\u6b21\u6027\u83b7\u53d6 member {} \u6761\u6570\u636e, \u8017\u65f6 {} \u79d2", (Object)memberPage.getContent().size(), (Object)Float.valueOf((float)(System.currentTimeMillis() - methodStartTime) / 1000.0f));
        return memberDTOMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MemberDto> findMember(MemberDto member, Sort sort, List<String> coreUserIdSort) {
        long methodStartTime = System.currentTimeMillis();
        ConcurrentHashMap<String, MemberDto> memberDTOMap = new ConcurrentHashMap<String, MemberDto>(1);
        ConcurrentHashMap coreUserIdPageMap = new ConcurrentHashMap(1);
        Specification memberSpecification = this.findMemberSpecification(member);
        int page = 0;
        int pageSize = 500;
        int total = (int)this.memberRepos.count(memberSpecification);
        int totalPage = total / pageSize;
        if (total % pageSize > 0) {
            ++totalPage;
        }
        ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
        try {
            threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(10);
            threadPoolTaskExecutor.setMaxPoolSize(100);
            threadPoolTaskExecutor.setQueueCapacity(2000);
            threadPoolTaskExecutor.setKeepAliveSeconds(60);
            threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            threadPoolTaskExecutor.initialize();
            CountDownLatch countDownLatch = new CountDownLatch(totalPage);
            while (page < totalPage) {
                int currentPage = page++;
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        PageRequest pageable = new PageRequest(currentPage, pageSize, sort);
                        Page memberPage = this.memberRepos.findAll(memberSpecification, (Pageable)pageable);
                        coreUserIdPageMap.put(currentPage, memberPage.getContent().stream().map(Member::getCoreUser).map(CoreUser::getId).distinct().collect(Collectors.toList()));
                        this.getCoreUserMemberMap(memberPage.getContent(), memberDTOMap);
                    }
                    catch (Exception e) {
                        log.error("\u5206\u9875\u67e5\u8be2 member \u6570\u636e\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            log.error("\u591a\u7ebf\u7a0b\u5206\u9875\u67e5\u8be2 member \u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (!Lang.isEmpty((Object)threadPoolTaskExecutor)) {
                threadPoolTaskExecutor.shutdown();
            }
        }
        for (int i = 0; i < coreUserIdPageMap.size(); ++i) {
            coreUserIdSort.addAll((Collection)coreUserIdPageMap.get(i));
        }
        log.info("\u591a\u7ebf\u7a0b\u83b7\u53d6 member {} \u6761\u6570\u636e, \u8017\u65f6 {} \u79d2", (Object)coreUserIdSort.size(), (Object)(System.currentTimeMillis() - methodStartTime));
        return memberDTOMap;
    }

    private Specification<Member> findMemberSpecification(MemberDto member) {
        return (root, query, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!Lang.isEmpty((Object)member)) {
                if (!Lang.isEmpty((Object)member.getRealName())) {
                    predicates.add(criteriaBuilder.like((Expression)root.get("realName"), "%" + member.getRealName() + "%"));
                }
                if (!Lang.isEmpty((Object)member.getCoreUser())) {
                    if (!Lang.isEmpty((Object)member.getCoreUser().getOrganizationId())) {
                        predicates.add(criteriaBuilder.equal((Expression)root.get("coreUser").get("organizationId"), (Object)member.getCoreUser().getOrganizationId()));
                    }
                    if (!Lang.isEmpty((Object)member.getCoreUser().getUserType())) {
                        predicates.add(criteriaBuilder.equal((Expression)root.get("coreUser").get("userType"), (Object)member.getCoreUser().getUserType()));
                    }
                    if (!Lang.isEmpty((Object)member.getCoreUser().getPhone())) {
                        predicates.add(criteriaBuilder.like((Expression)root.get("coreUser").get("phone"), "%" + member.getCoreUser().getPhone() + "%"));
                    }
                    if (!Lang.isEmpty((Object)member.getCoreUser().getEmail())) {
                        predicates.add(criteriaBuilder.like((Expression)root.get("coreUser").get("email"), "%" + member.getCoreUser().getEmail() + "%"));
                    }
                    if (!Lang.isEmpty((Object)member.getCoreUser().getIsDelete())) {
                        predicates.add(criteriaBuilder.equal((Expression)root.get("coreUser").get("isDelete"), (Object)member.getCoreUser().getIsDelete()));
                    }
                }
            }
            return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScoreAccountDTO> queryScoreAccount(String organizationCode, Map<String, MemberDto> memberDTOMap) {
        long methodStartTime = System.currentTimeMillis();
        Vector<ScoreAccountDTO> scoreAccountDTOs = new Vector<ScoreAccountDTO>();
        int page = 0;
        int pageSize = 500;
        ArrayList<String> coreUserIds = new ArrayList<String>(memberDTOMap.keySet());
        int totalPage = coreUserIds.size() / pageSize;
        if (coreUserIds.size() % pageSize > 0) {
            ++totalPage;
        }
        log.info("scoreAccount \u6279\u67e5\u8be2\u6570\u91cf {} \u6761, \u5355\u6279\u6b21\u67e5\u8be2\u6570\u91cf {} \u6761, \u9700\u67e5\u8be2 {} \u6b21", new Object[]{memberDTOMap.size(), pageSize, totalPage});
        log.info("\u5f00\u59cb\u591a\u7ebf\u7a0b\u67e5\u8be2\u79ef scoreAccount \u6570\u636e...");
        ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
        try {
            threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(10);
            threadPoolTaskExecutor.setMaxPoolSize(100);
            threadPoolTaskExecutor.setQueueCapacity(2000);
            threadPoolTaskExecutor.setKeepAliveSeconds(60);
            threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            threadPoolTaskExecutor.initialize();
            CountDownLatch countDownLatch = new CountDownLatch(totalPage);
            while (page < totalPage) {
                int startIndex = pageSize * page;
                int endIndexTemp = pageSize * (page + 1);
                if (endIndexTemp > coreUserIds.size()) {
                    endIndexTemp = coreUserIds.size();
                }
                int endIndex = endIndexTemp;
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        List scoreAccountPOs = this.scoreAccountRepos.findByOrganizationCodeAndUserIdIn(organizationCode, coreUserIds.subList(startIndex, endIndex));
                        scoreAccountDTOs.addAll(BeanMapper.mapList((Iterable)scoreAccountPOs, ScoreAccount.class, ScoreAccountDTO.class));
                    }
                    catch (Exception e) {
                        log.error("\u5206\u9875\u67e5\u8be2 scoreAccount \u6570\u636e\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
                ++page;
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            log.error("\u591a\u7ebf\u7a0b\u5206\u9875\u67e5\u8be2 scoreAccount \u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (!Lang.isEmpty((Object)threadPoolTaskExecutor)) {
                threadPoolTaskExecutor.shutdown();
            }
        }
        log.info("\u591a\u7ebf\u7a0b\u83b7\u53d6 scoreAccount {} \u6761\u6570\u636e, \u8017\u65f6 {} \u79d2", (Object)scoreAccountDTOs.size(), (Object)Float.valueOf((float)(System.currentTimeMillis() - methodStartTime) / 1000.0f));
        return scoreAccountDTOs;
    }

    public Map<String, MemberDto> findScoreGiveData(List<String> coreUserIds, List<String> scoreRcptCodes) {
        long methodStart = System.currentTimeMillis();
        int page = 0;
        int pageSize = 1000;
        int totalPage = scoreRcptCodes.size() / pageSize;
        if (scoreRcptCodes.size() % pageSize > 0) {
            ++totalPage;
        }
        ArrayList scoreGiveAwayLogs = new ArrayList();
        while (page < totalPage) {
            int startIndex = pageSize * page;
            int endIndex = pageSize * (page + 1);
            if (endIndex > scoreRcptCodes.size()) {
                endIndex = scoreRcptCodes.size();
            }
            scoreGiveAwayLogs.addAll(this.scoreGiveAwayLogRepos.findScoreGiveAwayByExpenseCodes(scoreRcptCodes.subList(startIndex, endIndex)));
            ++page;
        }
        coreUserIds.addAll(scoreGiveAwayLogs.stream().map(ScoreGiveAwayLog::getReceiveScoreAccount).map(ScoreAccount::getUserId).collect(Collectors.toList()));
        coreUserIds = coreUserIds.stream().distinct().collect(Collectors.toList());
        Map memberDTOMap = this.findMembersByCoreUserIds(coreUserIds);
        scoreGiveAwayLogs.forEach(scoreGiveAwayLog -> {
            MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreGiveAwayLog.getReceiveScoreAccount().getUserId());
            memberDTOMap.put(scoreGiveAwayLog.getScoreExpenseRcptCode(), memberDTO);
        });
        log.info("\u67e5\u8be2\u8f6c\u8d60\u79ef\u5206\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return memberDTOMap;
    }

    public Map<String, MemberDto> findScoreGiveData(Map<String, ScoreGiveAwayLogDTO> codeLogMap, List<String> scoreRcptCodes) {
        long methodStart = System.currentTimeMillis();
        int page = 0;
        int pageSize = 1000;
        int totalPage = scoreRcptCodes.size() / pageSize;
        if (scoreRcptCodes.size() % pageSize > 0) {
            ++totalPage;
        }
        ArrayList scoreGiveAwayLogs = new ArrayList();
        while (page < totalPage) {
            int startIndex = pageSize * page;
            int endIndex = pageSize * (page + 1);
            if (endIndex > scoreRcptCodes.size()) {
                endIndex = scoreRcptCodes.size();
            }
            scoreGiveAwayLogs.addAll(this.scoreGiveAwayLogRepos.findScoreGiveAwayByExpenseCodes(scoreRcptCodes.subList(startIndex, endIndex)));
            ++page;
        }
        DefaultMapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
        mapperFactory.classMap(ScoreGiveAwayLog.class, ScoreGiveAwayLogDTO.class).exclude("giveAwayScoreAccount").exclude("receiveScoreAccount").byDefault(new DefaultFieldMapper[0]).register();
        block1: for (ScoreGiveAwayLog scoreGiveAwayLog2 : scoreGiveAwayLogs) {
            for (String scoreRcptCode : scoreRcptCodes) {
                if (!scoreRcptCode.equals(scoreGiveAwayLog2.getScoreExpenseRcptCode())) continue;
                codeLogMap.put(scoreRcptCode, (ScoreGiveAwayLogDTO)mapperFactory.getMapperFacade().map((Object)scoreGiveAwayLog2, ScoreGiveAwayLogDTO.class));
                continue block1;
            }
        }
        List<Object> coreUserIds = new ArrayList();
        coreUserIds.addAll(scoreGiveAwayLogs.stream().map(ScoreGiveAwayLog::getReceiveScoreAccount).map(ScoreAccount::getUserId).collect(Collectors.toList()));
        coreUserIds = coreUserIds.stream().distinct().collect(Collectors.toList());
        Map memberDTOMap = this.findMembersByCoreUserIds(coreUserIds);
        scoreGiveAwayLogs.forEach(scoreGiveAwayLog -> {
            MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreGiveAwayLog.getReceiveScoreAccount().getUserId());
            memberDTOMap.put(scoreGiveAwayLog.getScoreExpenseRcptCode(), memberDTO);
        });
        log.info("\u67e5\u8be2\u8f6c\u8d60\u79ef\u5206\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return memberDTOMap;
    }

    public Map<String, MemberDto> findScoreGetData(List<String> coreUserIds, List<String> scoreRcptCodes) {
        long methodStart = System.currentTimeMillis();
        int page = 0;
        int pageSize = 1000;
        int totalPage = scoreRcptCodes.size() / pageSize;
        if (scoreRcptCodes.size() % pageSize > 0) {
            ++totalPage;
        }
        ArrayList scoreGiveAwayLogs = new ArrayList();
        while (page < totalPage) {
            int startIndex = pageSize * page;
            int endIndex = pageSize * (page + 1);
            if (endIndex > scoreRcptCodes.size()) {
                endIndex = coreUserIds.size();
            }
            scoreGiveAwayLogs.addAll(this.scoreGiveAwayLogRepos.findScoreGiveAwayByIncomeCodes(scoreRcptCodes.subList(startIndex, endIndex)));
            ++page;
        }
        coreUserIds.addAll(scoreGiveAwayLogs.stream().map(ScoreGiveAwayLog::getGiveAwayScoreAccount).map(ScoreAccount::getUserId).collect(Collectors.toList()));
        coreUserIds = coreUserIds.stream().distinct().collect(Collectors.toList());
        Map memberDTOMap = this.findMembersByCoreUserIds(coreUserIds);
        scoreGiveAwayLogs.forEach(scoreGiveAwayLog -> {
            MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreGiveAwayLog.getGiveAwayScoreAccount().getUserId());
            memberDTOMap.put(scoreGiveAwayLog.getScoreIncomeRcptCode(), memberDTO);
        });
        log.info("\u67e5\u8be2\u83b7\u8d60\u79ef\u5206\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return memberDTOMap;
    }

    public Map<String, MemberDto> findScoreGetData(Map<String, ScoreGiveAwayLogDTO> codeLogMap, List<String> scoreRcptCodes) {
        long methodStart = System.currentTimeMillis();
        int page = 0;
        int pageSize = 1000;
        int totalPage = scoreRcptCodes.size() / pageSize;
        if (scoreRcptCodes.size() % pageSize > 0) {
            ++totalPage;
        }
        ArrayList scoreGiveAwayLogs = new ArrayList();
        while (page < totalPage) {
            int startIndex = pageSize * page;
            int endIndex = pageSize * (page + 1);
            if (endIndex > scoreRcptCodes.size()) {
                endIndex = scoreRcptCodes.size();
            }
            scoreGiveAwayLogs.addAll(this.scoreGiveAwayLogRepos.findScoreGiveAwayByIncomeCodes(scoreRcptCodes.subList(startIndex, endIndex)));
            ++page;
        }
        DefaultMapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
        mapperFactory.classMap(ScoreGiveAwayLog.class, ScoreGiveAwayLogDTO.class).exclude("giveAwayScoreAccount").exclude("receiveScoreAccount").byDefault(new DefaultFieldMapper[0]).register();
        block1: for (ScoreGiveAwayLog scoreGiveAwayLog2 : scoreGiveAwayLogs) {
            for (String scoreRcptCode : scoreRcptCodes) {
                if (!scoreRcptCode.equals(scoreGiveAwayLog2.getScoreIncomeRcptCode())) continue;
                codeLogMap.put(scoreRcptCode, (ScoreGiveAwayLogDTO)mapperFactory.getMapperFacade().map((Object)scoreGiveAwayLog2, ScoreGiveAwayLogDTO.class));
                continue block1;
            }
        }
        List<Object> coreUserIds = new ArrayList();
        coreUserIds.addAll(scoreGiveAwayLogs.stream().map(ScoreGiveAwayLog::getGiveAwayScoreAccount).map(ScoreAccount::getUserId).collect(Collectors.toList()));
        coreUserIds = coreUserIds.stream().distinct().collect(Collectors.toList());
        Map memberDTOMap = this.findMembersByCoreUserIds(coreUserIds);
        scoreGiveAwayLogs.forEach(scoreGiveAwayLog -> {
            MemberDto memberDTO = (MemberDto)memberDTOMap.get(scoreGiveAwayLog.getGiveAwayScoreAccount().getUserId());
            memberDTOMap.put(scoreGiveAwayLog.getScoreIncomeRcptCode(), memberDTO);
        });
        log.info("\u67e5\u8be2\u8f6c\u8d60\u79ef\u5206\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return memberDTOMap;
    }
}

