/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.member;

import java.util.List;
import java.util.Map;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import score.model.ScoreAccount;
import score.model.repository.ScoreAccountRepos;
import utils.Lang;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
public class MemberBatchTransactionalService {
    private static final Logger log = LoggerFactory.getLogger(MemberBatchTransactionalService.class);
    @Autowired
    ScoreAccountRepos scoreAccountRepos;

    public void updateScoreAccountIfNeed(List<ScoreAccount> scoreAccountPOs, Map<String, MemberDto> memberDTOMap) {
        try {
            scoreAccountPOs.forEach(scoreAccountPO -> {
                String userId = scoreAccountPO.getUserId();
                if (!Lang.isEmpty((Object)userId)) {
                    MemberDto memberDTO = (MemberDto)memberDTOMap.get(userId);
                    CoreUserDto coreUserDTO = memberDTO.getCoreUser();
                    String nickName = memberDTO.getRealName();
                    String phone = coreUserDTO.getPhone();
                    String email = coreUserDTO.getEmail();
                    boolean update = false;
                    if (!Lang.isEmpty((Object)nickName) && !nickName.equals(scoreAccountPO.getNickName())) {
                        update = true;
                        scoreAccountPO.setNickName(nickName);
                    }
                    if (!Lang.isEmpty((Object)phone) && !phone.equals(scoreAccountPO.getPhone())) {
                        update = true;
                        scoreAccountPO.setPhone(phone);
                    }
                    if (!Lang.isEmpty((Object)email) && !email.equals(scoreAccountPO.getEmail())) {
                        update = true;
                        scoreAccountPO.setEmail(email);
                    }
                    if (update) {
                        log.info("\u66f4\u65b0\u79ef\u5206\u8d26\u53f7 UserId : {}", (Object)scoreAccountPO.getUserId());
                        this.scoreAccountRepos.saveAndFlush(scoreAccountPO);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u79ef\u5206\u8d26\u53f7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }
}

