/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.member;

import aftersale.api.DiscussApi;
import aftersale.api.dto.DiscussDto;
import cart.api.CartApi;
import cart.api.OrderMainApi;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.vo.EvaluateVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import member.api.CoreUserApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.ViewHistoryApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.api.dto.shop.MemberViewHisDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import utils.sql.PageVo;

@Component
public class UserCenterService {
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberAddressApi memberAddressApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberCreditsTranApi memberCreditsTranApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    MemberApi memberApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrganizationApi organizationApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    OrderMainApi orderMainApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    CartApi cartApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    ViewHistoryApi viewHistoryApi;
    @MotanReferer(basicReferer="motanClientBasicConfig")
    DiscussApi discussApi;

    public List<MemberAddressDto> getMyMemberAddress(String memberId) {
        return this.memberAddressApi.list(memberId);
    }

    public MemberDto findMenberById(String id) {
        return this.memberApi.findMemberById(id);
    }

    public MemberDto getMemberInfoByCoreUser(CoreUserDto coreUser) {
        return this.memberApi.getMemberInfoByCoreUser(coreUser);
    }

    public CoreUserDto findByPhoneOrEmail(String userLoginId, String organizationId) {
        return this.coreUserApi.findByPhoneOrEmail(userLoginId, organizationId);
    }

    public MemberAddressDto setDefaultAddress(String memberId, String addressId) {
        return this.memberAddressApi.setDefaultAddress(memberId, addressId);
    }

    public Boolean deleteAddressById(String addressId) {
        return this.memberAddressApi.delete(addressId);
    }

    public MemberAddressDto addMemberAddress(MemberAddressDto address) {
        return this.memberAddressApi.saveOrUpdateAddress(address);
    }

    public MemberCreditsTranDto findMemberCreditsTranById(String id) {
        return this.memberCreditsTranApi.findMemberCreditsTranById(id);
    }

    public PageVo findMemberPageByUserIdAndName(int pageSize, int pageNum, String userId, String searchLoginId, String memberName, String organizationId) {
        return this.memberApi.findMemberPageByUserIdAndName(pageSize, pageNum, userId, searchLoginId, memberName, organizationId);
    }

    public JSONObject findUserCenterOrders(String orderNo, List<String> status, String memberId, Date startDate, Date endDate, Pageable pageable) {
        return this.orderMainApi.findUserCenterOrders(orderNo, status, memberId, startDate, endDate, pageable);
    }

    public JSONObject findOrderDetailByOrderNo(String orderNo, String memberId) {
        return this.orderMainApi.findOrderDetail(orderNo, memberId);
    }

    public JSONObject findOrderItemsPageByOrderNo(Pageable pageable, String orderNo) {
        return this.orderMainApi.findOrderItemsPageByOrderNo(pageable, orderNo);
    }

    public JSONObject findDisscussByOrderNo(String orderNo) {
        return this.orderMainApi.findDisscussByOrderNo(orderNo);
    }

    public List<MemberViewHisDto> getViewHisByMemberId(String memberId) {
        return this.viewHistoryApi.getViewHisByMemberId(memberId);
    }

    public void clearFootPrints(List<MemberViewHisDto> list) {
        this.viewHistoryApi.clearFootPrints(list);
    }

    public Boolean saveDisscuccs(EvaluateVo[] evaluateVos, String memberId, String organizationId, String realName) {
        ArrayList<DiscussDto> discussList = new ArrayList<DiscussDto>();
        DiscussDto discuss = null;
        EvaluateVo eva = null;
        for (int i = 0; i < evaluateVos.length; ++i) {
            discuss = new DiscussDto();
            eva = evaluateVos[i];
            discuss.setOrganizationId(organizationId);
            discuss.setMemberId(memberId);
            discuss.setStoreId(eva.getStoreId());
            discuss.setProductId(eva.getProductId());
            discuss.setProductName(eva.getProductName());
            discuss.setOrderItemId(eva.getOrderItemId());
            discuss.setGoodsId(eva.getGoodsId());
            discuss.setType(eva.getType());
            discuss.setDiscussPerson(realName);
            discuss.setOrderNo(eva.getOrderNo());
            discuss.setProductName(eva.getProductName());
            discuss.setContent(eva.getContent());
            String marks = eva.getMarks();
            if (marks == null || marks.equals("")) {
                marks = "0";
            }
            int startLevel = Integer.parseInt(marks);
            discuss.setStarLevel(Integer.valueOf(startLevel));
            discussList.add(discuss);
        }
        return this.discussApi.saveDisscuccs(discussList);
    }
}

