/*
 * Decompiled with CFR 0.152.
 */
package ctscore.web.service.member.impl;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.ScoreUserService;
import java.math.BigDecimal;
import member.api.dto.core.CoreUserDto;
import org.springframework.stereotype.Service;
import score.api.ScoreApi;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import utils.Lang;

@Service
public class ScoreUserServiceImpl
implements ScoreUserService {
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ScoreApi scoreApi;

    public ScoreAccountRequestDTO getScoreAccountRequestDto(CoreUserDto coreUser) {
        String organizationCode = this.organizationApi.findOrganizationCodeById(coreUser.getOrganizationId());
        return new ScoreAccountRequestDTO(organizationCode, coreUser.getId(), coreUser.getPhone(), coreUser.getEmail());
    }

    public BigDecimal getUsebleScore(CoreUserDto coreUser) {
        ScoreAccountDTO scoreAccountDTO = this.getScoreAccount(coreUser);
        return this.roundScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()));
    }

    public ScoreAccountDTO getScoreAccount(CoreUserDto coreUser) {
        return this.scoreApi.queryScoreAccount(this.getScoreAccountRequestDto(coreUser));
    }

    public BigDecimal roundScore(BigDecimal score) {
        if (!Lang.isEmpty((Object)score)) {
            return score.setScale(2, 4);
        }
        return new BigDecimal("0.00").setScale(2, 4);
    }
}

