<!DOCTYPE html>
<#-- 订单确认页面 -->
<html lang="en">
<head>
    <#include "/include/meta.ftl">
    <#include "/include/head.ftl">
    <#include "/include/ie8fix.ftl">
        <!-- 样式 -->
    <link rel="stylesheet" href="${p_static}${_v('/public/css/global.css" type="text/css')}"/>
    <title>订单确认</title>
</head>
<body>
<#include "/include/header.ftl">
<#--<header>-->
    <#--<!--# include file="/caigou/top" &ndash;&gt;-->
<#--</header>-->
<div class="pageWidth">
    <form id="order-submit-form">
        <div class="shoppingTit clearfix">
            配送地址...
            <#if memberAddressList??>
                <#list memberAddressList as addr>
                    <div><input type="radio" name="selectAddress" value="${addr.id}"></input>
                        <span>${addr.username}</span>
                        <span>${addr.displayAddress}</span>
                    </div>
                </#list>
            </#if>
        </div>
    <#if error != 0>
        <span>该页面已失效，请返回购物车重新提交订单!</span>
        <#--<span class="error">${error}:${message!}</span>-->
    </#if>
    <#if cartItemGroups??>
        <#list cartItemGroups as group>
            <#if group.store??>
                <#if group.store.storeExt??>
                    <#if group.displayCounts gt 0>
                        <div class="orderStore" data-group-id="${group.storeId!group.store.id!}">
                            <div class="row modelList">
                                <div class="col-xs-2 modelItem text-left">

                                    <span class="shopName">${group.groupName!group.store.storeExt.storeName!}</span>
                                </div>
                                <div class="col-xs-4 modelItem text-left">

                                </div>
                                <div class="col-xs-1 modelItem">

                                </div>
                                <div class="col-xs-2 modelItem">
                                </div>
                                <div class="col-xs-1 modelItem">
                                    <span class="totalMoney">小计: ${(group.sumPrice!0)?string(',##0.00')}</span>
                                </div>
                                <div class="col-xs-2 modelItem">
                                </div>
                            </div>
                            <div class="orderList">
                                <#if group.cartItems??>
                                    <#list group.cartItems as cartItem>
                                        <#if cartItem??>
                                            <#if !cartItem.isDelete?exists || cartItem.isDelete != true>
                                                <#if cartItem.productFashion??>
                                                    <div class="row modelList <#if cartItem.status != '0'>invalidList</#if>" data-cart-item-id="${cartItem.id}">
                                                        <div class="col-xs-2 modelItem text-left">
                                                            <a class="shopImg">
                                                                <img src="${cartItem.productFashion.fashionPic!"/imgNotFound.gif"}" width="88" height="88" border="0">
                                                            </a>
                                                        </div>
                                                        <div class="col-xs-4 modelItem text-left" >
                                                            <#if cartItem.goods??>
                                                                <div class="modelItemCon row">
                                                    <span class="col-xs-8">
                                                        <a class="goodsType">${(cartItem.goods.title!cartItem.goods.name)?if_exists?html}</a>
                                                    </span>
                                                                    <#if cartItem.productFashion.fashionColor??>
                                                                        <span class="col-xs-4">颜色：${cartItem.productFashion.fashionColor}</span>
                                                                    </#if>
                                                                    <#if cartItem.productFashion.fashionSize??>
                                                                        <span class="col-xs-4">大小：${cartItem.productFashion.fashionSize}</span>
                                                                    </#if>
                                                                    <#if cartItem.productFashion.fashionStyle??>
                                                                        <span class="col-xs-4">样式：${cartItem.productFashion.fashionStyle}</span>
                                                                    </#if>
                                                                </div>
                                                            </#if>
                                                        </div>
                                                        <div class="col-xs-1 modelItem">
                                                            <div class="modelItemCon">
                                                                <#if cartItem.productFashion.costPrice == cartItem.productFashion.salePrice>
                                                                    <#if cartItem.productFashion.marketPrice != cartItem.productFashion.salePrice>
                                                                        <p class="originalPrice">${(cartItem.productFashion.marketPrice!0)?string(',##0.00')}</p>
                                                                    </#if>
                                                                    <p>${(cartItem.productFashion.salePrice!0)?string('0.00')}</p>
                                                                <#else>
                                                                    <p class="originalPrice">${(cartItem.productFashion.costPrice!0)?string(',##0.00')}</p>
                                                                    <p>${(cartItem.productFashion.salePrice!0)?string('0.00')}</p>
                                                                </#if>
                                                            </div>
                                                        </div>
                                                        <div class="col-xs-2 modelItem">
                                                            <div class="modelItemCon">
                                                                <p>
                                                                <span class="numChoose">
                                                                    x${cartItem.count!0}
                                                                    <input type="hidden" name="counts" value="${cartItem.count!0}" class="cart-item-counts" />
                                                                </span>
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="col-xs-1 modelItem">
                                                            <div class="modelItemCon">
                                                                <#if cartItem.productFashion.stockCount lte 0 || cartItem.productFashion.stockCount lt cartItem.count>
                                                                    <p class="textWarning lack-flag">无货</p>
                                                                <#elseif cartItem.productFashion.lackRemind gt 0>
                                                                    <#if cartItem.productFashion.stockCount lte cartItem.productFashion.lackRemind>
                                                                        <p class="textWarning lack-flag">库存紧张</p>
                                                                    <#else>
                                                                        <p class="lack-flag">有货</p>
                                                                    </#if>
                                                                <#else>
                                                                    <p class="lack-flag">有货</p>
                                                                </#if>
                                                            </div>
                                                        </div>

                                                        <div class="col-xs-1 modelItem">
                                                            <div class="modelItemCon">
                                                                <span class="totalMoneyItem">${(cartItem.count * cartItem.productFashion.salePrice)?string(',##0.00')}</span>
                                                                <p></p>
                                                            </div>
                                                        </div>
                                                        <div class="col-xs-2 modelItem">
                                                            <div class="modelItemCon goodsOperation">
                                                                <p class="text-left"><span class="delItem" rel="${cartItem.id}">删除</span></p>
                                                                <p class="text-left"><span class="removeItem removeOneItem" rel="${cartItem.id}">移入收藏夹</span></p>
                                                            </div>
                                                        </div>
                                                        <#if cartItem.status != '0'>
                                                            <span class="invalidTips">
                                                        失效
                                                    </span>
                                                        </#if>

                                                    </div>
                                                </#if>
                                            </#if>
                                        </#if>
                                    </#list>
                                </#if>
                            </div>
                        </div>
                    </#if>
                </#if>
            </#if>

        </#list>
    </#if>
    </form>
</div>
<!-- 测试支付方式 -->
<div class="payMethodBox">
    <div class="payMethodSelect">
        <#if userType == USER_TYPE_BUYER>
            <span><label>后付费</label><input type="radio" name="payMethodCode" value="1" /></span>
        </#if>
            <span><label>在线支付</label><input type="radio" name="payMethodCode" value="2" /></span>
            <span><label>公司转账</label><input type="radio" name="payMethodCode" value="3" /></span>
        <input type="radio" />
    </div>
    <div class="payMethodCon">
        <div class="invoice">
            <span class="needInvoiceChoice">
                <input type="checkbox" name="needInvoice" value="1" />
            </span>
        </div>

    </div>
</div>
<div class="accountsBox">
    <!--合计-->
    <div class="pageWidth">
        <div class="row modelList">
            <div class="col-xs-2 modelItem">
                <span>商品件数<span class="color01" id="sum-cart-item-counts">${(sumCartItemCounts!0)?string(",##0")}</span>件 </span>
            </div>
            <div class="col-xs-2 modelItem moneyList">
                <span class="text-right">合计：<span class="color01">￥</span><span class="color01" id="sum-cart-price">${(sumCartPrice!0.00)?string(",##0.00")}</span></span>
                <p class="text-right">运费：<span class="color01">￥</span><span class="color01" id="sum-cart-price-save">${(shippingFee!0.00)?string(",##0.00")}</span></p>
            </div>
            <div class="col-xs-2 modelItem">
                <a class="accountsBtn order-comfirm-submit">提交订单</a>
            </div>
        </div>
    </div>
</div>
<!--删除弹窗-->
<div class="coverLayer delLayer deletLayer">
    <div class="coverCon">
        <header>
            删除提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon">！</span></span>
                <div class="col-xs-9">
                    <span class="insuredInfo">删除商品？</span>
                    <p class="insuredTips">您可以删除商品或者移到收藏夹</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn01 doCartItemDel">删除</span>
            <span class="btn02 doCartItemMove">移到我的收藏</span>
        </div>
        <span class="msg msg-info" style="display:none;">删除成功</span>
        <span class="msg msg-error" style="display:none;">删除失败，请稍后再试！</span>
    </div>
</div>
<#--删除多个-->
<div class="coverLayer delLayer deletAllLayer">
    <div class="coverCon">
        <header>
            删除提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon">！</span></span>
                <div class="col-xs-9">
                    <span class="insuredInfo">删除商品？</span>
                    <p class="insuredTips">您可以删除商品或者移到收藏夹</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn01 doCartItemDel">删除</span>
            <span class="btn02 doCartItemMove" >移到我的收藏</span>
        </div>
        <span class="msg msg-info" style="display:none;">删除成功</span>
        <span class="msg msg-error" style="display:none;">删除失败，请稍后再试！</span>
    </div>
</div>

<!--移入收藏夹-->
<div class="coverLayer delLayer removeLayer">
    <div class="coverCon">
        <header>
            收藏提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox"> <span class="tipsIcon">！</span></span>
                <div class="col-xs-9">
                    <span class="insuredInfo">移到收藏</span>
                    <p class="insuredTips">移动后选中商品将不在购物车列表中显示。</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02 doMoveToFav">确定</span>
            <span class="btn01" rel="close">取消</span>
        </div>
        <span class="msg msg-info" style="display:none;">移入收藏夹成功</span>
        <span class="msg msg-error" style="display:none;">处理失败，请稍后再试！</span>
    </div>
</div>

<!--下架提示-->
<div class="coverLayer delLayer invalidLayer" >
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-3 text-right tipsIconBox orders-gap"> <span class="iconfont icon tipsIcon">&#xe60f;</span></span>
                <div class="col-xs-9 orders-gap">
                    <span class="insuredInfo">下手慢了，有商品被抢空了</span>
                    <p class="insuredTips">请确认您的购物清单！</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02">确定</span>

        </div>
    </div>
</div>

<!--至少选一种商品-->
<div class="coverLayer delLayer leastLayer" >
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-4 text-right tipsIconBox"> <span class="iconfont icon tipsIcon">！</span></span>
                <div class="col-xs-8">
                    <p class="insuredTips">请至少选择一件商品！</p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02" rel="close">确定</span>

        </div>
    </div>
</div>
<!--提示信息-->
<div class="coverLayer delLayer alertLayer" >
    <div class="coverCon">
        <header>
            温馨提示
            <span class="icon iconfont fr closeTips">&#xe61d;</span>
        </header>
        <div class="delTips">
            <div class="delTipsCon row">
                <span class="col-xs-4 text-right tipsIconBox"> <span class="iconfont icon tipsIcon">！</span></span>
                <div class="col-xs-8">
                    <p class="insuredTips"></p>
                </div>
            </div>
        </div>
        <div class="delBtnBox">
            <span class="btn02" rel="close">确定</span>

        </div>
    </div>
</div>
<#include "/include/footer.ftl">
<#--<footer>-->
    <#--<!--# include file="/caigou/footer" &ndash;&gt;-->
<#--</footer>-->
<#include "/include/resource.ftl">
</body>
</html>