<!DOCTYPE html>
<html lang="en">
<head>
<#include "/include/meta.ftl">
<#include "/include/head.ftl">
<#include "/include/ie8fix.ftl">
    <link href="${p_static}${_v('/cms/css/global.css')}" rel="stylesheet" type="text/css"/>
    <link href="${p_static}${_v('/cms/css/notice.css')}" rel="stylesheet" type="text/css"/>

    <title>栏目文章</title>
</head>
<body>

<#include "/include/header.ftl">
<#--<header>-->
    <#--<!--# include file="/score/top" &ndash;&gt;-->
<#--</header>-->
<div class="pageWidth scrollTopH">
    <div class="span6">
        <ul class="breadcrumb navItem articleNav">

            <li>
                <a href="/score">首页</a> <span class="divider">></span>
            </li>
            <li>${channelName!}</li>
        </ul>
    </div>
    <div class="noticeBg">
        <img src="${p_static}/cms/image/noticeBg.png">
    </div>
    <div class="noticeCon clearfix">
        <form class="queryList">
            <input type="text" placeholder="请输入查询关键字" value="${queryKey!}" class="queryValue" maxlength="20" id="title"/>
            <input type="button" value="查询" class="queryBtn" onclick="searchArticle();"/>
        </form>
        <table class="table table-striped noticeList">
            <thead>
            <tr>
                <th>序号</th>
                <th>标题</th>
                <th>发布者</th>
                <th>发布时间</th>
            </tr>
            </thead>
            <tbody id="articles">
            </tbody>
        </table>
        <div id="divId" align="center" style="color: #FF2F2F"></div>
        <ul class="pagination paging fr" id="articlePage">
           <#-- <li><a href="#">上一页</a></li>
            <li class="active"><a href="#">1</a></li>
            <li><a href="#">2</a></li>
            <li><a href="#">3</a></li>
            <li><a href="#">4</a></li>
            <li><a href="#">5</a></li>
            <li><a class="pageMore">···</a></li>
            <li><a href="#">下一页</a></li>-->
        </ul>
    </div>
</div>
<div class="coverLayer" hidden>
    <div class="coverCon">
        <header>
            提示
            <span class="icon iconfont fr closeTips"></span>
        </header>
        <div class="tipsCon">
            <p id="tipContent"></p>
        </div>
        <div class="suredBtn">
            <span onclick="closeBox();">确定</span>
        </div>
    </div>
</div>
<#include "/include/footer.ftl">
    <#--<footer>-->
        <#--<!--# include file="/score/footer" &ndash;&gt;-->
    <#--</footer>-->
</body>
<#include "/include/resource.ftl">
<script src="${p_static}${_v('/cms/js/notice.js')}"></script>
<script>

    function getArticles(current,title) {
        if((title==undefined||title==null||title=="")&&$("#title").val()!=""){
            title =$("#title").val();
        }
        var page=0;
        if(current){
            page=current-1;
        }else{
            page=0;
        }
        $.ajax({
            url: "/score/channelArticle/getArticles.do",
            type: "POST",
            data: {
                channelId :'${channelId!}',
                title :title,
                page:  page,
                size: 20
            },
            success: function(res) {
                var articleContent=convertArticle(res.data,res.title);  //拼装显示的页面代码
                $("#articles").html(articleContent);
                $("#divId").html("");
                //显示分页
                laypage({
                    cont: 'articlePage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
                    pages: res.totalPages, //通过后台拿到的总页数
                    curr: current || 1, //当前页
                    skin: '#d12a3e',//皮肤
                    jump: function(obj, first){ //触发分页后的回调
                        if(!first){ //点击跳页触发函数自身，并传递当前页：obj.curr
                            getArticles(obj.curr);
                        }
                    }
                });
                if(title!=undefined&&title!=null&&title!="") {
                    if (articleContent == undefined || articleContent == null || articleContent == "") {
//                        $("#tipContent").html("很抱歉，系统找不到您的记录，换个词试试！");
//                        $(".coverLayer").show();
                        $("#divId").html("很抱歉，系统找不到您的记录，换个词试试！");
                    }else{
                        $("#divId").html("");
                    }
                }
            }
        });
    }
    getArticles();

    //查询文章
    function searchArticle(){
        var title =$("#title").val();
        /*if(title==undefined||title==null||title.trim()==""){
            $("#tipContent").html("请输入您的查询条件！");
            $(".coverLayer").show();
            return;
        }*/
        getArticles(0,title);
    }

    //转化文章列表
    function convertArticle(content,queryKey){
        var length =0;
        var articleTable="";
        if(content!=undefined&&content!=""){
            length =content.length;
            for(var i=0;i<length;i++){
                var fullTitle =content[i].title;
                if(queryKey!=undefined&&queryKey!=null&&queryKey!=""){
                    var index =content[i].title.indexOf(queryKey);
                    if(index>-1){
                        var prefix =fullTitle.substr(0,index);
                        var suffix =fullTitle.substr(index+queryKey.length);
                        fullTitle = prefix+"<span style='color:red'>"+queryKey+"</span>"+suffix;
                    }
                }
                articleTable+="<tr><td>"+(i+1)+"</td>";
                if(content[i].url!=undefined&&content[i].url!=null&&content[i].url!=""){
                    articleTable+="<td><a href='"+content[i].url+"' target='_blank'>";
                }else{
                    articleTable+="<td><a href='${ctx}/channelArticle/detail.do?articleId="+content[i].id+"&key="+queryKey+"'>";
                }
                articleTable+=fullTitle+"</a></td>";
                articleTable+="<td>"+(content[i].publisher)+"</td>";
                articleTable+="<td>"+timeFormat(content[i].publishDate)+"</td></tr>";
            }
        }
        return articleTable;
    }
    //关闭弹窗
    function closeBox(){
        $(".coverLayer").hide();
    }
    //禁止回车触发搜素
    $('#title').keydown(function(e){
        if(e.keyCode==13){
            return false;
        }
    });

</script>
</html>